/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AbstractVariableFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.util.StringUtilities;
import java.math.BigInteger;
import java.util.ArrayList;

public class VariableCommentFieldFactory
extends AbstractVariableFieldFactory {
    public static final String FIELD_NAME = "Variable Comment";

    public VariableCommentFieldFactory() {
        super(FIELD_NAME);
    }

    private VariableCommentFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Variable)) {
            return null;
        }
        Variable sv = (Variable)obj;
        String comment = sv.getComment();
        String[] comments = StringUtilities.toLines((String)comment);
        if (comments != null && comments.length > 0) {
            ArrayList<FieldElement> elements = new ArrayList<FieldElement>(comments.length);
            for (int i = 0; i < comments.length; ++i) {
                AttributedString as = new AttributedString(comments[i], this.getColor(sv), this.getMetrics(sv));
                elements.add((FieldElement)new TextFieldElement(as, i, 0));
            }
            return ListingTextField.createMultilineTextField(this, proxy, elements, this.startX + varWidth, this.width, this.hlProvider);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxy;
            Variable sv = variableProxy.getObject();
            ListingTextField btf = (ListingTextField)bf;
            String cmt = sv.getComment();
            int pos = 0;
            int tmp = 0;
            for (int i = 0; i <= row; ++i) {
                String str = btf.getFieldElement(i, 0).getText();
                int len = 0;
                len = i < row ? str.length() : col;
                pos += len;
                int index = cmt.indexOf(str, tmp);
                if (tmp != 0) {
                    pos += index - tmp;
                }
                tmp = index + len;
            }
            return new VariableCommentFieldLocation(sv.getProgram(), variableProxy.getLocationAddress(), sv, pos);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Variable sv;
        VariableCommentFieldLocation varCommentLoc;
        if (!(loc instanceof VariableCommentFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Variable && (varCommentLoc = (VariableCommentFieldLocation)loc).isLocationFor(sv = (Variable)obj)) {
            FieldElement element;
            int row;
            int len;
            int col = varCommentLoc.getCharOffset();
            ListingTextField btf = (ListingTextField)bf;
            for (row = 0; row < btf.getNumRows() && (len = (element = ((ListingTextField)bf).getFieldElement(row, 0)).length()) <= col; col -= len, ++row) {
            }
            return new FieldLocation(index, fieldNum, row, col);
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Variable.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 3;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new VariableCommentFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

