/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.handler;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.features.base.replace.items.RenameCategoryQuickFix;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utility.function.ExceptionalConsumer;

public class DatatypeCategorySearchAndReplaceHandler
extends SearchAndReplaceHandler {
    public DatatypeCategorySearchAndReplaceHandler() {
        this.addType(new SearchType(this, "Datatype Categories", "Search and replace datatype category names"));
    }

    @Override
    public void findAll(Program program, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        int categoryCount = program.getDataTypeManager().getCategoryCount();
        monitor.initialize((long)categoryCount, "Searching Datatype categories...");
        Pattern pattern = query.getSearchPattern();
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        Category rootCategory = dtm.getRootCategory();
        this.visitRecursively(rootCategory, (ExceptionalConsumer<Category, CancelledException>)((ExceptionalConsumer)category -> {
            monitor.increment();
            Matcher matcher = pattern.matcher(category.getName());
            if (matcher.find()) {
                String newName = matcher.replaceAll(query.getReplacementText());
                RenameCategoryQuickFix item = new RenameCategoryQuickFix(program, (Category)category, newName);
                accumulator.add((Object)item);
                if (accumulator.size() >= query.getSearchLimit()) {
                    return;
                }
            }
        }));
    }

    private void visitRecursively(Category category, ExceptionalConsumer<Category, CancelledException> callback) throws CancelledException {
        Category[] categories;
        callback.accept((Object)category);
        for (Category childCategory : categories = category.getCategories()) {
            this.visitRecursively(childCategory, callback);
        }
    }
}

