/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionsDialog;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class LoadLibrariesOptionsDialog
extends OptionsDialog {
    public static final String TITLE = "Load Libraries";
    private ByteProvider provider;
    private Program program;
    private PluginTool tool;
    private LoadSpec loadSpec;

    public LoadLibrariesOptionsDialog(ByteProvider provider, Program program, PluginTool tool, LoadSpec loadSpec, AddressFactoryService addressFactoryService) {
        super(LoadLibrariesOptionsDialog.getLoadLibraryOptions(provider, loadSpec), optionList -> loadSpec.getLoader().validateOptions(provider, loadSpec, optionList, null), addressFactoryService);
        this.setTitle(TITLE);
        this.provider = provider;
        this.program = program;
        this.tool = tool;
        this.loadSpec = loadSpec;
    }

    @Override
    protected void okCallback() {
        TaskLauncher.launchNonModal((String)TITLE, monitor -> {
            super.okCallback();
            Object consumer = new Object();
            MessageLog log = new MessageLog();
            Loader.ImporterSettings settings = new Loader.ImporterSettings(this.provider, this.program.getDomainFile().getName(), this.tool.getProject(), this.program.getDomainFile().getParent().getPathname(), false, this.loadSpec, this.getOptions(), consumer, log, monitor);
            try (LoadResults<? extends DomainObject> loadResults2 = this.loadSpec.getLoader().load(settings);){
                loadResults2.save(monitor);
                String importMessages = log.toString();
                if (!importMessages.isEmpty()) {
                    if (!Loader.loggingDisabled) {
                        Msg.info(ImporterUtilities.class, (Object)("Load Libraries:\n" + importMessages));
                    }
                    MultiLineMessageDialog.showModalMessageDialog(null, (String)TITLE, (String)"Results", (String)importMessages, (int)1);
                } else {
                    Msg.showInfo((Object)this, null, (String)TITLE, (Object)"The program has no libraries.");
                }
            }
            catch (CancelledException loadResults2) {
            }
            catch (Exception e) {
                Msg.showError(LoadLibrariesOptionsDialog.class, (Component)this.tool.getActiveWindow(), (String)TITLE, (Object)("Error loading libraries for: " + this.program.getName()), (Throwable)e);
            }
        });
    }

    private static List<Option> getLoadLibraryOptions(ByteProvider provider, LoadSpec loadSpec) {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Option option : loadSpec.getLoader().getDefaultOptions(provider, loadSpec, null, false, false)) {
            switch (option.getName()) {
                case "Only Load Libraries": 
                case "Load Libraries From Disk": {
                    option.setValue(true);
                }
                case "Link Existing Project Libraries": 
                case "Project Library Search Folder": 
                case "Library Search Paths": 
                case "Library Destination Folder": 
                case "Mirror Library Disk Layout": {
                    options.add(option);
                    break;
                }
            }
        }
        return options;
    }
}

