/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.FSBNode;
import java.util.List;

public class OpenFsFSBFileHandler
implements FSBFileHandler {
    private static final String FSB_OPEN_ROOT_FS = "FSB Open My Computer";
    public static final String FSB_OPEN_FILE_SYSTEM_CHOOSER = "FSB Open File System Chooser";
    public static final String FSB_OPEN_FILE_SYSTEM_IN_NEW_WINDOW = "FSB Open File System In New Window";
    public static final String FSB_OPEN_DIR_IN_NEW_WINDOW = "FSB Open Directory In New Window";
    public static final String FSB_OPEN_FILE_SYSTEM_NESTED = "FSB Open File System Nested";
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder(FSB_OPEN_FILE_SYSTEM_NESTED, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> {
            FSBFileNode fileNode;
            FSBNode patt0$temp;
            return ac.notBusy() && (patt0$temp = ac.getSelectedNode()) instanceof FSBFileNode && (fileNode = (FSBFileNode)patt0$temp).isLeaf() && !fileNode.isSymlink();
        }).popupMenuIcon(FSBIcons.OPEN_FILE_SYSTEM).popupMenuPath(new String[]{"Open File System"}).popupMenuGroup("C").onAction(ac -> ac.getComponentProvider().openFileSystem(ac.getSelectedNode(), true)).build(), (DockingAction)new ActionBuilder(FSB_OPEN_FILE_SYSTEM_IN_NEW_WINDOW, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> {
            FSBFileNode fileNode;
            FSBNode patt0$temp;
            return ac.notBusy() && (patt0$temp = ac.getSelectedNode()) instanceof FSBFileNode && (fileNode = (FSBFileNode)patt0$temp).isLeaf() && !fileNode.isSymlink();
        }).popupMenuIcon(FSBIcons.OPEN_FILE_SYSTEM).popupMenuPath(new String[]{"Open File System [new window]"}).popupMenuGroup("C").onAction(ac -> ac.getComponentProvider().openFileSystem(ac.getSelectedNode(), false)).build(), (DockingAction)new ActionBuilder(FSB_OPEN_DIR_IN_NEW_WINDOW, this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> {
            FSBDirNode dirNode;
            FSBNode patt0$temp;
            return ac.notBusy() && (patt0$temp = ac.getSelectedNode()) instanceof FSBDirNode && !(dirNode = (FSBDirNode)patt0$temp).isSymlink();
        }).popupMenuIcon(FSBIcons.OPEN_FILE_SYSTEM).popupMenuPath(new String[]{"Open Directory [new window]"}).popupMenuGroup("C").onAction(ac -> ac.getComponentProvider().openFileSystem(ac.getSelectedNode(), false)).build(), ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(FSB_OPEN_ROOT_FS, this.context.plugin().getName()).description("Show the 'My Computer' location")).enabledWhen(ac -> !this.context.fsbComponent().getGTree().isBusy())).toolBarIcon(FSBIcons.MY_COMPUTER)).toolBarGroup("B")).onAction(ac -> {
            FileSystemService fsService = this.context.fsService();
            this.context.plugin().createNewFileSystemBrowser(fsService.getLocalFS().getRefManager().create(), null, true);
        })).build(), ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(FSB_OPEN_FILE_SYSTEM_CHOOSER, this.context.plugin().getName()).description("Open File System Chooser")).enabledWhen(ac -> !this.context.fsbComponent().getGTree().isBusy())).toolBarIcon(FSBIcons.OPEN_FILE_SYSTEM)).toolBarGroup("B")).onAction(ac -> this.context.plugin().openFileSystem())).build());
    }
}

