/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.SystemUtilities;

public class MemoryBlockDiff {
    public static final int NAME = 1;
    public static final int START_ADDRESS = 2;
    public static final int END_ADDRESS = 4;
    public static final int SIZE = 8;
    public static final int READ = 16;
    public static final int WRITE = 32;
    public static final int EXECUTE = 64;
    public static final int VOLATILE = 128;
    public static final int ARTIFICIAL = 256;
    public static final int TYPE = 512;
    public static final int INIT = 1024;
    public static final int SOURCE = 2048;
    public static final int COMMENT = 4096;
    public static final int ALL = 8191;
    private MemoryBlock block1;
    private MemoryBlock block2;
    private int diffFlags;

    public MemoryBlockDiff(MemoryBlock block1, MemoryBlock block2) {
        this.block1 = block1;
        this.block2 = block2;
        this.diffFlags = this.getDiffFlags();
    }

    MemoryBlock getBlock1() {
        return this.block1;
    }

    MemoryBlock getBlock2() {
        return this.block2;
    }

    public boolean isNameDifferent() {
        return (this.diffFlags & 1) != 0;
    }

    public boolean isStartAddressDifferent() {
        return (this.diffFlags & 2) != 0;
    }

    public boolean isEndAddressDifferent() {
        return (this.diffFlags & 4) != 0;
    }

    public boolean isSizeDifferent() {
        return (this.diffFlags & 8) != 0;
    }

    public boolean isReadDifferent() {
        return (this.diffFlags & 0x10) != 0;
    }

    public boolean isWriteDifferent() {
        return (this.diffFlags & 0x20) != 0;
    }

    public boolean isExecDifferent() {
        return (this.diffFlags & 0x40) != 0;
    }

    public boolean isVolatileDifferent() {
        return (this.diffFlags & 0x80) != 0;
    }

    public boolean isArtificialDifferent() {
        return (this.diffFlags & 0x100) != 0;
    }

    public boolean isTypeDifferent() {
        return (this.diffFlags & 0x200) != 0;
    }

    public boolean isInitDifferent() {
        return (this.diffFlags & 0x400) != 0;
    }

    public boolean isSourceDifferent() {
        return (this.diffFlags & 0x800) != 0;
    }

    public boolean isCommentDifferent() {
        return (this.diffFlags & 0x1000) != 0;
    }

    public String getDifferencesAsString() {
        StringBuffer buf = new StringBuffer();
        if ((this.diffFlags & 1) != 0) {
            buf.append("Name ");
        }
        if ((this.diffFlags & 2) != 0) {
            buf.append("StartAddress ");
        }
        if ((this.diffFlags & 4) != 0) {
            buf.append("EndAddress ");
        }
        if ((this.diffFlags & 8) != 0) {
            buf.append("Size ");
        }
        if ((this.diffFlags & 0x10) != 0) {
            buf.append("R ");
        }
        if ((this.diffFlags & 0x20) != 0) {
            buf.append("W ");
        }
        if ((this.diffFlags & 0x40) != 0) {
            buf.append("X ");
        }
        if ((this.diffFlags & 0x80) != 0) {
            buf.append("Volatile ");
        }
        if ((this.diffFlags & 0x100) != 0) {
            buf.append("Artificial ");
        }
        if ((this.diffFlags & 0x200) != 0) {
            buf.append("Type ");
        }
        if ((this.diffFlags & 0x400) != 0) {
            buf.append("Initialized ");
        }
        if ((this.diffFlags & 0x800) != 0) {
            buf.append("Source ");
        }
        if ((this.diffFlags & 0x1000) != 0) {
            buf.append("Comment ");
        }
        return buf.toString();
    }

    private int getDiffFlags() {
        if (this.block1 == null) {
            if (this.block2 == null) {
                return 0;
            }
            return 8191;
        }
        if (this.block2 == null) {
            return 8191;
        }
        int flags = 0;
        if (!this.block1.getName().equals(this.block2.getName())) {
            flags |= 1;
        }
        if (!this.block1.getStart().equals((Object)this.block2.getStart())) {
            flags |= 2;
        }
        if (!this.block1.getEnd().equals((Object)this.block2.getEnd())) {
            flags |= 4;
        }
        if (this.block1.getSize() != this.block2.getSize()) {
            flags |= 8;
        }
        if (this.block1.isRead() != this.block2.isRead()) {
            flags |= 0x10;
        }
        if (this.block1.isWrite() != this.block2.isWrite()) {
            flags |= 0x20;
        }
        if (this.block1.isExecute() != this.block2.isExecute()) {
            flags |= 0x40;
        }
        if (this.block1.isVolatile() != this.block2.isVolatile()) {
            flags |= 0x80;
        }
        if (this.block1.isArtificial() != this.block2.isArtificial()) {
            flags |= 0x100;
        }
        if (!this.block1.getType().equals((Object)this.block2.getType())) {
            flags |= 0x200;
        }
        if (this.block1.isInitialized() != this.block2.isInitialized()) {
            flags |= 0x400;
        }
        if (!SystemUtilities.isEqual((Object)this.block1.getSourceName(), (Object)this.block2.getSourceName())) {
            flags |= 0x800;
        }
        if (!SystemUtilities.isEqual((Object)this.block1.getComment(), (Object)this.block2.getComment())) {
            flags |= 0x1000;
        }
        return flags;
    }
}

