/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.program.model.listing.Function;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LazyMap;

public class UserHighlights {
    private Map<Function, List<DecompilerHighlighter>> secondaryHighlightersByFunction = LazyMap.lazyMap(new HashMap(), f -> new ArrayList());
    private Set<DecompilerHighlighter> secondaryHighlighters = new HashSet<DecompilerHighlighter>();
    private Map<DecompilerHighlighter, TokenHighlights> allHighlighterHighlights = new HashMap<DecompilerHighlighter, TokenHighlights>();
    private TokenHighlightColors secondaryHighlightColors = new TokenHighlightColors();

    Color getSecondaryColor(String text) {
        return this.secondaryHighlightColors.getColor(text);
    }

    String getAppliedColorsString() {
        return this.secondaryHighlightColors.getAppliedColorsString();
    }

    boolean hasSecondaryHighlights(Function function) {
        return !this.secondaryHighlightersByFunction.get(function).isEmpty();
    }

    Color getSecondaryHighlight(ClangToken token) {
        DecompilerHighlighter highlighter = this.getSecondaryHighlighter(token);
        if (highlighter != null) {
            TokenHighlights highlights = this.allHighlighterHighlights.get(highlighter);
            HighlightToken hlToken = highlights.get(token);
            return hlToken.getColor();
        }
        return null;
    }

    TokenHighlightColors getSecondaryHighlightColors() {
        return this.secondaryHighlightColors;
    }

    Set<DecompilerHighlighter> getSecondaryHighlighters(Function function) {
        return new HashSet<DecompilerHighlighter>((Collection)this.secondaryHighlightersByFunction.get(function));
    }

    Set<DecompilerHighlighter> getServiceHighlighters() {
        Set<DecompilerHighlighter> allHighlighters = this.allHighlighterHighlights.keySet();
        HashSet<DecompilerHighlighter> results = new HashSet<DecompilerHighlighter>(allHighlighters);
        results.removeAll(this.secondaryHighlighters);
        return results;
    }

    List<DecompilerHighlighter> getSecondaryHighlightersByFunction(Function f) {
        return this.secondaryHighlightersByFunction.get(f);
    }

    TokenHighlights getHighlights(DecompilerHighlighter highlighter) {
        return this.allHighlighterHighlights.get(highlighter);
    }

    DecompilerHighlighter getSecondaryHighlighter(ClangToken token) {
        for (DecompilerHighlighter highlighter : this.secondaryHighlighters) {
            TokenHighlights highlights = this.allHighlighterHighlights.get(highlighter);
            HighlightToken hlToken = highlights.get(token);
            if (hlToken == null) continue;
            return highlighter;
        }
        return null;
    }

    void addSecondaryHighlighter(Function function, DecompilerHighlighter highlighter) {
        this.secondaryHighlightersByFunction.get(function).add(highlighter);
        this.secondaryHighlighters.add(highlighter);
        this.allHighlighterHighlights.putIfAbsent(highlighter, new TokenHighlights());
    }

    TokenHighlights add(DecompilerHighlighter highlighter) {
        this.allHighlighterHighlights.putIfAbsent(highlighter, new TokenHighlights());
        return this.allHighlighterHighlights.get(highlighter);
    }

    void remove(DecompilerHighlighter highlighter) {
        this.allHighlighterHighlights.remove(highlighter);
        this.secondaryHighlighters.remove(highlighter);
        Collection<List<DecompilerHighlighter>> lists = this.secondaryHighlightersByFunction.values();
        for (List<DecompilerHighlighter> highlighters : lists) {
            if (highlighters.remove(highlighter)) break;
        }
    }

    TokenHighlights get(DecompilerHighlighter highlighter) {
        return this.allHighlighterHighlights.get(highlighter);
    }

    void dispose() {
        this.secondaryHighlighters.clear();
        this.secondaryHighlightersByFunction.clear();
        this.allHighlighterHighlights.clear();
    }
}

