/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.signature;

import ghidra.app.decompiler.signature.DebugSignature;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;

public class BlockSignature
extends DebugSignature {
    public Address blockSeq;
    public int index;
    public SequenceNumber opSeq;
    public String opcode;
    public SequenceNumber previousOpSeq;
    public String previousOpcode;

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int subel;
        this.opSeq = null;
        this.opcode = null;
        this.previousOpcode = null;
        this.previousOpSeq = null;
        int pos = 0;
        int el = decoder.openElement();
        this.hash = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_HASH);
        this.index = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
        this.blockSeq = AddressXML.decode((Decoder)decoder);
        while ((subel = decoder.openElement()) != 0) {
            int opc = (int)decoder.readSignedInteger(AttributeId.ATTRIB_CODE);
            String currentOpcode = PcodeOp.getMnemonic((int)opc);
            SequenceNumber currentOpSeq = SequenceNumber.decode((Decoder)decoder);
            decoder.closeElementSkipping(subel);
            if (pos == 0) {
                this.opSeq = currentOpSeq;
                this.opcode = currentOpcode;
            } else {
                this.previousOpSeq = currentOpSeq;
                this.previousOpcode = currentOpcode;
            }
            ++pos;
        }
        decoder.closeElement(el);
    }

    @Override
    public void printRaw(Language language, StringBuffer buf) {
        buf.append(Integer.toHexString(this.hash));
        buf.append(" - block ");
        buf.append(this.blockSeq.toString());
        if (this.previousOpcode != null) {
            buf.append(" - op=");
            buf.append(this.previousOpcode).append(" ").append(this.previousOpSeq.toString());
        }
        if (this.opcode != null) {
            buf.append(" - op=");
            buf.append(this.opcode).append(" ").append(this.opSeq.toString());
        }
    }
}

