/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cms.jcajce;

import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.python.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.python.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.python.bouncycastle.cms.KEMKeyWrapper;
import org.python.bouncycastle.cms.KEMRecipientInfoGenerator;
import org.python.bouncycastle.cms.jcajce.JceCMSKEMKeyWrapper;

public class JceKEMRecipientInfoGenerator
extends KEMRecipientInfoGenerator {
    public JceKEMRecipientInfoGenerator(X509Certificate x509Certificate, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).toASN1Structure()), (KEMKeyWrapper)new JceCMSKEMKeyWrapper(x509Certificate.getPublicKey(), aSN1ObjectIdentifier));
    }

    public JceKEMRecipientInfoGenerator(byte[] byArray, PublicKey publicKey, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(byArray, (KEMKeyWrapper)new JceCMSKEMKeyWrapper(publicKey, aSN1ObjectIdentifier));
    }

    public JceKEMRecipientInfoGenerator setProvider(String string2) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(string2);
        return this;
    }

    public JceKEMRecipientInfoGenerator setProvider(Provider provider) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }

    public JceKEMRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setSecureRandom(secureRandom);
        return this;
    }

    public JceKEMRecipientInfoGenerator setKDF(AlgorithmIdentifier algorithmIdentifier) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setKDF(algorithmIdentifier);
        return this;
    }

    public JceKEMRecipientInfoGenerator setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setAlgorithmMapping(aSN1ObjectIdentifier, string2);
        return this;
    }
}

