/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.widgets.OptionDialog;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableHeaderRenderer;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.GetDomainObjectTask;
import ghidra.framework.main.datatree.VersionHistoryTableModel;
import ghidra.framework.main.datatree.VersionInfoTransferable;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.util.DateUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VersionHistoryPanel
extends JPanel
implements Draggable {
    private static final HelpLocation HELP = new HelpLocation("VersionControl", "Show History");
    private PluginTool tool;
    private DomainFile domainFile;
    private String domainFilePath;
    private VersionHistoryTableModel tableModel;
    private GTable table;
    private DragSource dragSource;
    private DragGestureAdapter dragGestureAdapter;
    private DragSrcAdapter dragSourceAdapter;
    private int dragAction = 3;

    public VersionHistoryPanel(PluginTool tool, DomainFile domainFile) throws IOException {
        this(tool, domainFile, false);
    }

    VersionHistoryPanel(PluginTool tool, DomainFile domainFile, boolean enableUserInteraction) {
        super(new BorderLayout());
        this.tool = tool;
        this.create();
        if (enableUserInteraction) {
            this.setUpDragSite();
            this.table.addMouseListener((MouseListener)new MyMouseListener());
        }
        this.setDomainFile(domainFile);
    }

    public void setDomainFile(DomainFile domainFile) {
        this.domainFile = domainFile;
        this.domainFilePath = domainFile != null ? domainFile.getPathname() : null;
        try {
            this.refresh();
        }
        catch (FileNotFoundException e) {
            this.domainFile = null;
            this.domainFilePath = null;
        }
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public String getDomainFilePath() {
        return this.domainFilePath;
    }

    public void addListSelectionListener(ListSelectionListener selectionListener) {
        this.table.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener selectionListener) {
        this.table.getSelectionModel().removeListSelectionListener(selectionListener);
    }

    public Version getSelectedVersion() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            return this.tableModel.getVersionAt(row);
        }
        return null;
    }

    public boolean isVersionSelected() {
        return !this.table.getSelectionModel().isSelectionEmpty();
    }

    public int getSelectedVersionNumber() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            Version version = this.tableModel.getVersionAt(row);
            return version.getVersion();
        }
        return -1;
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public Transferable getTransferable(Point p) {
        int row = this.table.rowAtPoint(p);
        if (row >= 0) {
            Version version = this.tableModel.getVersionAt(row);
            return new VersionInfoTransferable(this.domainFile.getPathname(), version.getVersion());
        }
        return null;
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        int row = this.table.rowAtPoint(e.getDragOrigin());
        return row >= 0;
    }

    VersionHistoryTableModel getVersionHistoryTableModel() {
        return this.tableModel;
    }

    private void create() {
        this.tableModel = new VersionHistoryTableModel(new Version[0]);
        this.table = new GTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane((Component)this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 120));
        this.table.setSelectionMode(0);
        this.add((Component)sp, "Center");
        TableColumnModel columnModel = this.table.getColumnModel();
        MyCellRenderer cellRenderer = new MyCellRenderer();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            GTableHeaderRenderer headRenderer = new GTableHeaderRenderer();
            column.setHeaderRenderer((TableCellRenderer)headRenderer);
            column.setCellRenderer((TableCellRenderer)((Object)cellRenderer));
            String name = (String)column.getIdentifier();
            if (name.equals("Version")) {
                column.setPreferredWidth(80);
                continue;
            }
            if (name.equals("Version Date")) {
                column.setPreferredWidth(210);
                continue;
            }
            if (name.equals("Comments")) {
                column.setPreferredWidth(250);
                continue;
            }
            if (!name.equals("User")) continue;
            column.setPreferredWidth(125);
        }
    }

    private void setUpDragSite() {
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)this.table, this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    private DomainObject getVersionedObject(Object consumer, int versionNumber, boolean immutable) {
        GetDomainObjectTask task = new GetDomainObjectTask(consumer, this.domainFile, versionNumber, immutable);
        this.tool.execute(task, 1000);
        return task.getDomainObject();
    }

    private void delete() {
        int row = this.table.getSelectedRow();
        if (row != 0 && row != this.tableModel.getRowCount() - 1) {
            Msg.showError((Object)this, (Component)this, (String)"Cannot Delete Version", (Object)"Only first and last version may be deleted.");
            return;
        }
        Version version = this.tableModel.getVersionAt(row);
        try {
            for (ItemCheckoutStatus status : this.domainFile.getCheckouts()) {
                if (status.getCheckoutVersion() != version.getVersion()) continue;
                Msg.showError((Object)this, (Component)this, (String)"Cannot Delete Version", (Object)"File version has one or more checkouts.");
                return;
            }
            if (this.confirmDelete()) {
                DeleteTask task = new DeleteTask(version.getVersion());
                new TaskLauncher((Task)task, (Component)this);
            }
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)this.tool.getProject().getRepository(), (Exception)e, (String)"Delete Version", (Component)this);
        }
    }

    private boolean confirmDelete() {
        int messageType;
        String message;
        if (this.tableModel.getRowCount() == 1) {
            message = "Deleting the only version will permanently delete the file.\nAre you sure you want to continue?";
            messageType = 2;
        } else {
            message = "Are you sure you want to delete the selected version?";
            messageType = 3;
        }
        return OptionDialog.showOptionDialog((Component)this.table, (String)"Delete Version", (String)message, (String)"Delete", (int)messageType) == 1;
    }

    void refresh() throws FileNotFoundException {
        try {
            Version[] history = null;
            if (this.domainFile != null) {
                history = this.domainFile.getVersionHistory();
            }
            if (history == null) {
                history = new Version[]{};
            }
            this.tableModel.refresh(history);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)this.tool.getProject().getRepository(), (Exception)e, (String)"Get Version History", (Component)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openWith(String toolName) {
        int row = this.table.getSelectedRow();
        Version version = this.tableModel.getVersionAt(row);
        DomainObject versionedObj = this.getVersionedObject(this, version.getVersion(), true);
        if (versionedObj != null) {
            try {
                if (toolName != null) {
                    this.tool.getToolServices().launchTool(toolName, List.of(versionedObj.getDomainFile()));
                } else {
                    this.tool.getToolServices().launchDefaultTool(List.of(versionedObj.getDomainFile()));
                }
            }
            finally {
                versionedObj.release(this);
            }
        }
    }

    private void open() {
        this.openWith(null);
    }

    public List<DockingActionIf> createPopupActions() {
        ArrayList<DockingActionIf> list = new ArrayList<DockingActionIf>();
        list.add((DockingActionIf)new DeleteAction());
        Project project = this.tool.getProject();
        ToolChest toolChest = project.getLocalToolChest();
        if (toolChest == null) {
            return list;
        }
        ToolTemplate[] templates = toolChest.getToolTemplates();
        if (templates.length == 0) {
            return list;
        }
        list.add((DockingActionIf)new OpenDefaultAction());
        for (ToolTemplate toolTemplate : templates) {
            list.add((DockingActionIf)new OpenWithAction(toolTemplate.getName()));
        }
        return list;
    }

    GTable getTable() {
        return this.table;
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handleMouseClick(e);
        }

        private void handleMouseClick(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = VersionHistoryPanel.this.table.rowAtPoint(e.getPoint());
                if (row < 0) {
                    return;
                }
                VersionHistoryPanel.this.open();
            }
        }
    }

    private class MyCellRenderer
    extends GTableCellRenderer {
        private MyCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            int row = data.getRowViewIndex();
            int col = data.getColumnModelIndex();
            if (value instanceof Date) {
                this.setText(DateUtils.formatDateTimestamp((Date)((Date)value)));
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            String toolTipText = null;
            Version version = VersionHistoryPanel.this.tableModel.getVersionAt(row);
            if (col == 3) {
                String comments = version.getComment();
                if (comments != null) {
                    toolTipText = HTMLUtilities.toHTML((String)comments);
                }
            } else if (col == 1) {
                toolTipText = "Date when version was created";
            }
            this.setToolTipText(toolTipText);
            return this;
        }
    }

    private class DeleteTask
    extends Task {
        private int versionNumber;

        DeleteTask(int versionNumber) {
            super("Delete Version", false, false, true);
            this.versionNumber = versionNumber;
        }

        public void run(TaskMonitor monitor) {
            try {
                VersionHistoryPanel.this.domainFile.delete(this.versionNumber);
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)VersionHistoryPanel.this.tool.getProject().getRepository(), (Exception)e, (String)"Delete Version", (Component)VersionHistoryPanel.this);
            }
        }
    }

    private class DeleteAction
    extends HistoryTableAction {
        DeleteAction() {
            super("Delete Version");
            this.setDescription("Deletes the selected version (Only first and last version can be deleted)");
            this.setPopupMenuData(new MenuData(new String[]{"Delete"}, "AAA"));
        }

        public void actionPerformed(ActionContext context) {
            VersionHistoryPanel.this.delete();
        }
    }

    private class OpenDefaultAction
    extends HistoryTableAction {
        OpenDefaultAction() {
            super("Open In Default Tool");
            this.setDescription("Opens the selected version in the default tool.");
            MenuData data = new MenuData(new String[]{"Open in Default Tool"}, "AAB");
            data.setMenuSubGroup("1");
            this.setPopupMenuData(data);
        }

        public void actionPerformed(ActionContext context) {
            VersionHistoryPanel.this.open();
        }
    }

    private class OpenWithAction
    extends HistoryTableAction {
        private String toolName;

        OpenWithAction(String toolName) {
            super("Open With " + toolName);
            this.toolName = toolName;
            this.setDescription("Opens the version using the " + toolName + " tool.");
            MenuData data = new MenuData(new String[]{"Open With", toolName}, "AAB");
            this.setPopupMenuData(data);
        }

        public void actionPerformed(ActionContext context) {
            VersionHistoryPanel.this.openWith(this.toolName);
        }
    }

    private abstract class HistoryTableAction
    extends DockingAction {
        HistoryTableAction(String name) {
            super(name, "Version History Panel", false);
            this.setHelpLocation(HELP);
        }

        public boolean isEnabledForContext(ActionContext context) {
            MouseEvent mouseEvent = context.getMouseEvent();
            if (mouseEvent == null) {
                return false;
            }
            if (context.getSourceComponent() != VersionHistoryPanel.this.table) {
                return false;
            }
            if (VersionHistoryPanel.this.domainFile == null) {
                return false;
            }
            int rowAtPoint = VersionHistoryPanel.this.table.rowAtPoint(mouseEvent.getPoint());
            return rowAtPoint >= 0;
        }
    }
}

