/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.symbols;

import ghidra.program.database.symbol.ClassSymbol;
import ghidra.program.database.symbol.LibrarySymbol;
import ghidra.program.database.symbol.NamespaceSymbol;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;

public class ExtSymbol
implements IsfObject {
    String name;
    String location;
    Boolean namespaceIsClass;
    String kind;
    String type;
    String sourceType;
    boolean primary;
    boolean pinned;

    public ExtSymbol(Symbol symbol) {
        this.name = symbol.getName();
        this.location = this.getNamespace(symbol);
        this.kind = this.checkGlobal(symbol) ? "global" : "local";
        this.sourceType = symbol.getSource().toString();
        this.primary = symbol.isPrimary();
        this.pinned = symbol.isPinned();
        if (symbol instanceof ClassSymbol) {
            this.type = "class";
        } else if (symbol instanceof LibrarySymbol) {
            this.type = "library";
        } else if (symbol instanceof NamespaceSymbol) {
            this.type = "namespace";
        }
    }

    private String getNamespace(Symbol symbol) {
        StringBuffer buffer = new StringBuffer();
        Namespace namespace = symbol.getParentNamespace();
        while (!namespace.isGlobal()) {
            buffer.insert(0, namespace.getName() + "::");
            if (namespace instanceof GhidraClass) {
                this.namespaceIsClass = true;
            }
            namespace = namespace.getParentNamespace();
        }
        return buffer.toString();
    }

    private boolean checkGlobal(Symbol symbol) {
        if (symbol.isGlobal()) {
            return true;
        }
        Namespace parent = symbol.getParentNamespace();
        return parent instanceof Library;
    }
}

