/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import ghidra.util.Msg;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.naming.MDNameModifier;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDReusableName;
import mdemangler.naming.MDSpecialName;
import mdemangler.object.MDObjectCPP;
import mdemangler.template.MDTemplateNameAndArguments;

public class MDBasicName
extends MDParsableItem {
    MDSpecialName specialName;
    MDTemplateNameAndArguments templateNameAndArguments;
    MDReusableName reusableName;
    MDObjectCPP embeddedObject;
    MDQualification embeddedObjectQualification;
    MDNameModifier nameModifier;

    public MDBasicName(MDMang dmang) {
        super(dmang);
    }

    public void setNameModifier(MDNameModifier nameModifier) {
        this.nameModifier = nameModifier;
    }

    public boolean isConstructor() {
        if (this.specialName != null) {
            return this.specialName.isConstructor();
        }
        if (this.templateNameAndArguments != null) {
            return this.templateNameAndArguments.isConstructor();
        }
        return false;
    }

    public boolean isDestructor() {
        if (this.specialName != null) {
            return this.specialName.isDestructor();
        }
        if (this.templateNameAndArguments != null) {
            return this.templateNameAndArguments.isDestructor();
        }
        return false;
    }

    public boolean isTypeCast() {
        if (this.specialName != null) {
            return this.specialName.isTypeCast();
        }
        if (this.templateNameAndArguments != null) {
            return this.templateNameAndArguments.isTypeCast();
        }
        return false;
    }

    public int getRTTINumber() {
        if (this.specialName != null) {
            return this.specialName.getRTTINumber();
        }
        return -1;
    }

    public boolean isString() {
        if (this.specialName != null) {
            return this.specialName.isString();
        }
        return false;
    }

    public MDString getMDString() {
        if (this.specialName != null && this.specialName.isString()) {
            return this.specialName.getMDString();
        }
        return null;
    }

    public String getName() {
        if (this.specialName != null) {
            return this.specialName.getName();
        }
        if (this.templateNameAndArguments != null) {
            return this.templateNameAndArguments.getName();
        }
        if (this.reusableName != null) {
            return this.reusableName.getName();
        }
        return "";
    }

    public MDObjectCPP getEmbeddedObject() {
        return this.embeddedObject;
    }

    public void setName(String name) {
        if (this.specialName != null) {
            this.specialName.setName(name);
        } else if (this.templateNameAndArguments != null) {
            this.templateNameAndArguments.setName(name);
        } else {
            Msg.warn((Object)this, (Object)"name cannot be set");
        }
    }

    public void setCastTypeString(String castTypeString) {
        if (this.specialName != null) {
            this.specialName.setCastTypeString(castTypeString);
        } else if (this.templateNameAndArguments != null) {
            this.templateNameAndArguments.setCastTypeString(castTypeString);
        } else {
            Msg.warn((Object)this, (Object)"castTypeString cannot be set");
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.reusableName != null) {
            this.reusableName.insert(builder);
        } else if (this.specialName != null) {
            this.specialName.insert(builder);
        } else if (this.embeddedObject != null) {
            this.embeddedObject.insert(builder);
        } else {
            this.templateNameAndArguments.insert(builder);
        }
        if (this.nameModifier != null) {
            builder.append(this.nameModifier.getModifier());
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() == '?') {
            if (this.dmang.peek(1) == '$') {
                this.templateNameAndArguments = new MDTemplateNameAndArguments(this.dmang);
                this.templateNameAndArguments.parse();
            } else if (this.dmang.peek(1) == '?') {
                this.embeddedObject = new MDObjectCPP(this.dmang);
                this.embeddedObject.parse();
                this.embeddedObjectQualification = new MDQualification(this.dmang);
                this.embeddedObjectQualification.parse();
            } else {
                this.dmang.increment();
                this.specialName = new MDSpecialName(this.dmang, 1);
                this.specialName.parse();
            }
        } else {
            this.reusableName = new MDReusableName(this.dmang);
            this.reusableName.parse();
        }
    }
}

