/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;

public class PropertyBoolean
extends JCheckBox
implements ItemListener {
    private PropertyEditor editor;
    private boolean notifyEditorOfChanges = true;

    public PropertyBoolean(PropertyEditor pe) {
        this.editor = pe;
        this.setSelected((Boolean)pe.getValue());
        this.addItemListener(this);
        this.editor.addPropertyChangeListener(evt -> {
            Object value = this.editor.getValue();
            if (value instanceof Boolean && !value.equals(this.getText())) {
                this.notifyEditorOfChanges = false;
                try {
                    this.setSelected((Boolean)value);
                }
                finally {
                    this.notifyEditorOfChanges = true;
                }
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.notifyEditorOfChanges) {
            this.editor.setValue(this.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }
}

