/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.geom.Point2D;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.VertexSupport;

public class SimpleVertexSupport<V, E>
implements VertexSupport<V, E> {
    protected Supplier<V> vertexFactory;

    public SimpleVertexSupport(Supplier<V> vertexFactory) {
        this.vertexFactory = vertexFactory;
    }

    @Override
    public void startVertexCreate(VisualizationServer<V, E> vv, Point2D point) {
        Objects.requireNonNull(Boolean.valueOf(vv.getVisualizationModel().getGraph().getType().isModifiable()), "graph must be mutable");
        if (this.vertexFactory != null) {
            V newVertex = this.vertexFactory.get();
            VisualizationModel<V, E> visualizationModel = vv.getVisualizationModel();
            Graph<V, E> graph = visualizationModel.getGraph();
            graph.addVertex(newVertex);
            Point2D p2d = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(point);
            visualizationModel.getLayoutModel().set(newVertex, p2d.getX(), p2d.getY());
            vv.repaint();
        }
    }

    @Override
    public void midVertexCreate(VisualizationServer<V, E> vv, Point2D point) {
    }

    @Override
    public void endVertexCreate(VisualizationServer<V, E> vv, Point2D point) {
    }

    public Supplier<V> getVertexFactory() {
        return this.vertexFactory;
    }

    public void setVertexFactory(Supplier<V> vertexFactory) {
        this.vertexFactory = vertexFactory;
    }
}

