/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpAddressObject;
import ghidra.file.formats.dump.DumpData;
import ghidra.file.formats.dump.DumpFile;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.cmd.ModuleToPeHelper;
import ghidra.file.formats.dump.mdmp.CommentStreamA;
import ghidra.file.formats.dump.mdmp.CommentStreamW;
import ghidra.file.formats.dump.mdmp.CvRecord;
import ghidra.file.formats.dump.mdmp.Directory;
import ghidra.file.formats.dump.mdmp.ExceptionStream;
import ghidra.file.formats.dump.mdmp.FunctionTableStream;
import ghidra.file.formats.dump.mdmp.Handle;
import ghidra.file.formats.dump.mdmp.HandleDataStream;
import ghidra.file.formats.dump.mdmp.HandleOperationListStream;
import ghidra.file.formats.dump.mdmp.MdmpFileHeader;
import ghidra.file.formats.dump.mdmp.Memory64ListStream;
import ghidra.file.formats.dump.mdmp.MemoryInfo;
import ghidra.file.formats.dump.mdmp.MemoryInfoListStream;
import ghidra.file.formats.dump.mdmp.MemoryListStream;
import ghidra.file.formats.dump.mdmp.MemoryRange;
import ghidra.file.formats.dump.mdmp.MemoryRange64;
import ghidra.file.formats.dump.mdmp.MiscInfoStream;
import ghidra.file.formats.dump.mdmp.Module;
import ghidra.file.formats.dump.mdmp.ModuleListStream;
import ghidra.file.formats.dump.mdmp.ProcessVmCountersStream;
import ghidra.file.formats.dump.mdmp.SystemInfoStream;
import ghidra.file.formats.dump.mdmp.SystemMemoryInfoStream;
import ghidra.file.formats.dump.mdmp.Thread;
import ghidra.file.formats.dump.mdmp.ThreadEx;
import ghidra.file.formats.dump.mdmp.ThreadExListStream;
import ghidra.file.formats.dump.mdmp.ThreadInfoListStream;
import ghidra.file.formats.dump.mdmp.ThreadListStream;
import ghidra.file.formats.dump.mdmp.TokenListStream;
import ghidra.file.formats.dump.mdmp.UnloadedModule;
import ghidra.file.formats.dump.mdmp.UnloadedModuleListStream;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Minidump
extends DumpFile {
    public static final int SIGNATURE = 1347241037;
    MdmpFileHeader header;
    Directory[] dirs;
    HashMap<Integer, StructConverter> streams = new HashMap();
    private boolean createBlocks;

    public Minidump(DumpFileReader reader, ProgramBasedDataTypeManager dtm, List<Option> options, TaskMonitor monitor) {
        super(reader, dtm, options, monitor);
        this.program.setExecutableFormat("Portable Executable (PE)");
        this.initManagerList(null);
        this.createBlocks = OptionUtils.getBooleanOptionValue((String)"Create Memory Blocks", options, (boolean)true);
        try {
            this.header = new MdmpFileHeader(reader, 0L);
            this.data.add(new DumpData(0L, this.header.toDataType()));
            this.dirs = new Directory[this.header.getNumberOfStreams()];
            for (int i = 0; i < this.dirs.length; ++i) {
                this.dirs[i] = new Directory(reader, reader.getPointerIndex());
            }
            for (Directory dir : this.dirs) {
                long rva = dir.getRVA();
                Object sv = null;
                switch (dir.getStreamType()) {
                    case 3: {
                        sv = new ThreadListStream(reader, rva);
                        break;
                    }
                    case 4: {
                        sv = new ModuleListStream(reader, rva);
                        break;
                    }
                    case 5: {
                        sv = new MemoryListStream(reader, rva);
                        break;
                    }
                    case 6: {
                        sv = new ExceptionStream(reader, rva);
                        break;
                    }
                    case 7: {
                        sv = new SystemInfoStream(reader, rva);
                        break;
                    }
                    case 8: {
                        sv = new ThreadExListStream(reader, rva);
                        break;
                    }
                    case 9: {
                        sv = new Memory64ListStream(reader, rva);
                        break;
                    }
                    case 10: {
                        sv = new CommentStreamA(reader, rva);
                        break;
                    }
                    case 11: {
                        sv = new CommentStreamW(reader, rva);
                        break;
                    }
                    case 12: {
                        sv = new HandleDataStream(reader, rva);
                        break;
                    }
                    case 13: {
                        sv = new FunctionTableStream(reader, rva);
                        break;
                    }
                    case 14: {
                        sv = new UnloadedModuleListStream(reader, rva);
                        break;
                    }
                    case 15: {
                        sv = new MiscInfoStream(reader, rva);
                        break;
                    }
                    case 16: {
                        sv = new MemoryInfoListStream(reader, rva);
                        break;
                    }
                    case 17: {
                        sv = new ThreadInfoListStream(reader, rva);
                        break;
                    }
                    case 18: {
                        sv = new HandleOperationListStream(reader, rva);
                        break;
                    }
                    case 19: {
                        sv = new TokenListStream(reader, rva);
                        break;
                    }
                    case 20: {
                        break;
                    }
                    case 21: {
                        sv = new SystemMemoryInfoStream(reader, rva);
                        break;
                    }
                    case 22: {
                        sv = new ProcessVmCountersStream(reader, rva);
                        break;
                    }
                    case 23: {
                        break;
                    }
                }
                if (sv == null) continue;
                this.streams.put(dir.getStreamType(), (StructConverter)sv);
            }
            this.buildStructures();
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
    }

    private void buildStructures() throws Exception {
        CategoryPath path;
        Object t;
        Object tstr;
        String moduleName;
        DumpData dd;
        int len;
        Object mod;
        Object modstr;
        Object memoryRange;
        int i;
        Object memstr;
        int i2;
        long offset;
        long headerMax = offset = (long)this.header.toDataType().getLength();
        DataType dt = this.dirs[0].toDataType();
        this.data.add(new DumpData(offset, "DIRECTORIES", dt.getLength() * this.dirs.length));
        for (i2 = 0; i2 < this.dirs.length; ++i2) {
            offset = this.header.getStreamDirectoryRVA() + (long)(i2 * dt.getLength());
            this.data.add(new DumpData(offset, this.dirs[i2].toDataType(), "", false, false));
            if (offset + (long)(i2 * dt.getLength()) <= headerMax) continue;
            headerMax = offset + (long)(i2 * dt.getLength());
        }
        for (i2 = 0; i2 < this.dirs.length; ++i2) {
            StructConverter stream;
            offset = this.dirs[i2].getRVA();
            if (offset <= 0L || (stream = this.getStreamByDir(i2)) == null) continue;
            dt = stream.toDataType();
            this.data.add(new DumpData(offset, dt, this.dirs[i2].getReadableName(), false, true));
            if (offset + (long)dt.getLength() <= headerMax) continue;
            headerMax = offset + (long)dt.getLength();
        }
        StructConverter sv = this.getStreamByType(5);
        if (sv != null) {
            memstr = (MemoryListStream)sv;
            for (i = 0; i < ((MemoryListStream)memstr).getNumberOfMemoryRanges(); ++i) {
                memoryRange = ((MemoryListStream)memstr).getMemoryRange(i);
                if (((MemoryRange)memoryRange).getStartOfMemoryRange() >= headerMax) continue;
                headerMax = ((MemoryRange)memoryRange).getStartOfMemoryRange();
            }
        }
        if ((sv = this.getStreamByType(9)) != null) {
            memstr = (Memory64ListStream)sv;
            i = 0;
            while ((long)i < ((Memory64ListStream)memstr).getNumberOfMemoryRanges()) {
                memoryRange = ((Memory64ListStream)memstr).getMemoryRange(i);
                if (((MemoryRange64)memoryRange).getStartOfMemoryRange() < headerMax) {
                    headerMax = ((MemoryRange64)memoryRange).getStartOfMemoryRange();
                }
                ++i;
            }
        }
        this.addInteriorAddressObject("DumpHeader", 0L, 0L, headerMax);
        sv = this.getStreamByType(4);
        if (sv != null) {
            modstr = (ModuleListStream)sv;
            for (i = 0; i < ((ModuleListStream)modstr).getNumberOfModules(); ++i) {
                mod = ((ModuleListStream)modstr).getModule(i);
                offset = ((Module)mod).getModuleNameRVA();
                this.data.add(new DumpData(offset, StructConverter.DWORD, "", false, false));
                len = this.reader.readInt(offset);
                dd = new DumpData(offset += 4L, (DataType)new TerminatedUnicodeDataType(), "", false, false);
                dd.setSize(len + 2);
                this.data.add(dd);
                moduleName = this.reader.readUnicodeString(offset, len / 2);
                this.addModule(moduleName, ((Module)mod).getBaseOfImage(), i, ((Module)mod).getSizeOfImage());
                this.addExteriorAddressObject(moduleName, 0L, ((Module)mod).getBaseOfImage(), ((Module)mod).getSizeOfImage());
                CvRecord cvRecord = ((Module)mod).getCvRecord();
                offset = ((Module)mod).getCvRecordRVA();
                dt = cvRecord.toDataType();
                this.data.add(new DumpData(offset, dt, "", false, false));
                this.data.add(new DumpData(offset += (long)dt.getLength(), (DataType)new StringDataType(), "", false, false));
            }
        }
        if ((sv = this.getStreamByType(14)) != null) {
            modstr = (UnloadedModuleListStream)sv;
            for (i = 0; i < ((UnloadedModuleListStream)modstr).getNumberOfEntries(); ++i) {
                mod = ((UnloadedModuleListStream)modstr).getEntry(i);
                offset = ((UnloadedModule)mod).getModuleNameRVA();
                this.data.add(new DumpData(offset, StructConverter.DWORD, "", false, false));
                len = this.reader.readInt(offset);
                dd = new DumpData(offset += 4L, (DataType)new TerminatedUnicodeDataType(), "", false, false);
                dd.setSize(len + 2);
                this.data.add(dd);
                moduleName = this.reader.readUnicodeString(offset, len / 2);
                this.addModule(moduleName, ((UnloadedModule)mod).getBaseOfImage(), i, ((UnloadedModule)mod).getSizeOfImage());
                this.addExteriorAddressObject(moduleName, 0L, ((UnloadedModule)mod).getBaseOfImage(), ((UnloadedModule)mod).getSizeOfImage());
            }
        }
        if (this.createBlocks) {
            sv = this.getStreamByType(5);
            if (sv != null) {
                memstr = (MemoryListStream)sv;
                for (i = 0; i < ((MemoryListStream)memstr).getNumberOfMemoryRanges(); ++i) {
                    memoryRange = ((MemoryListStream)memstr).getMemoryRange(i);
                    offset = ((MemoryRange)memoryRange).getRVA();
                    this.addInteriorAddressObject("Memory", ((MemoryRange)memoryRange).getRVA(), ((MemoryRange)memoryRange).getStartOfMemoryRange(), ((MemoryRange)memoryRange).getDataSize());
                }
            }
            if ((sv = this.getStreamByType(9)) != null) {
                memstr = (Memory64ListStream)sv;
                offset = (int)((Memory64ListStream)memstr).getBaseRVA();
                i = 0;
                while ((long)i < ((Memory64ListStream)memstr).getNumberOfMemoryRanges()) {
                    memoryRange = ((Memory64ListStream)memstr).getMemoryRange(i);
                    this.addInteriorAddressObject("Memory", offset, ((MemoryRange64)memoryRange).getStartOfMemoryRange(), ((MemoryRange64)memoryRange).getDataSize());
                    offset += ((MemoryRange64)memoryRange).getDataSize();
                    ++i;
                }
            }
        }
        if ((sv = this.getStreamByType(16)) != null) {
            MemoryInfoListStream meminfostr = (MemoryInfoListStream)sv;
            i = 0;
            while ((long)i < meminfostr.getNumberOfEntries()) {
                MemoryInfo memoryInfo = meminfostr.getMemoryInfo(i);
                DumpAddressObject dao = this.getInteriorAddressObject(memoryInfo.getBaseAddress());
                if (dao != null) {
                    dao.setRead((memoryInfo.getProtect() & 0x66) > 0);
                    dao.setWrite((memoryInfo.getProtect() & 0xCC) > 0);
                    dao.setExec((memoryInfo.getProtect() & 0xF0) > 0);
                    dao.setComment(memoryInfo.getComment());
                }
                ++i;
            }
        }
        if ((sv = this.getStreamByType(3)) != null) {
            tstr = (ThreadListStream)sv;
            for (i = 0; i < ((ThreadListStream)tstr).getNumberOfThreads(); ++i) {
                t = ((ThreadListStream)tstr).getThread(i);
                String tid = Integer.toHexString(((Thread)t).getThreadId());
                offset = ((Thread)t).getContextRVA();
                if (offset != 0L) {
                    if (this.contextOffset == 0L) {
                        this.contextOffset = offset;
                    }
                    if ((dt = this.getTypeFromArchive(path = new CategoryPath("/winnt.h"), "CONTEXT")) != null) {
                        this.data.add(new DumpData(offset, dt, "ThreadContext_" + tid, false, true));
                        this.setProgramContext(offset, dt, tid);
                    }
                }
                offset = ((Thread)t).getStackRVA();
                if (!this.createBlocks || offset == 0L) continue;
                this.addInteriorAddressObject("ThreadStack_" + tid, offset, ((Thread)t).getStackStartOfMemoryRange(), ((Thread)t).getStackDataSize());
            }
        }
        if ((sv = this.getStreamByType(8)) != null) {
            tstr = (ThreadExListStream)sv;
            for (i = 0; i < ((ThreadExListStream)tstr).getNumberOfThreads(); ++i) {
                t = ((ThreadExListStream)tstr).getThread(i);
                String tid = Integer.toHexString(((ThreadEx)t).getThreadId());
                offset = ((ThreadEx)t).getContextRVA();
                if (offset != 0L && (dt = this.getTypeFromArchive(path = new CategoryPath("/winnt.h"), "CONTEXT")) != null) {
                    this.data.add(new DumpData(offset, dt, "ThreadContext_" + tid, false, true));
                    this.setProgramContext(offset, dt, tid);
                }
                offset = ((ThreadEx)t).getStackRVA();
                if (!this.createBlocks || offset == 0L) continue;
                this.addInteriorAddressObject("ThreadStack_" + tid, offset, ((ThreadEx)t).getStackStartOfMemoryRange(), ((ThreadEx)t).getStackDataSize());
            }
        }
        if ((sv = this.getStreamByType(12)) != null) {
            HandleDataStream handles = (HandleDataStream)sv;
            for (i = 0; i < handles.getNumberOfHandles(); ++i) {
                int len2;
                Handle handle = handles.getHandle(i);
                offset = handle.getTypeNameRVA();
                if (offset > 0L) {
                    this.data.add(new DumpData(offset, StructConverter.DWORD, "", false, false));
                    len2 = this.reader.readInt(offset);
                    DumpData ddType = new DumpData(offset += 4L, (DataType)new TerminatedUnicodeDataType(), "", false, false);
                    ddType.setSize(len2 + 2);
                    this.data.add(ddType);
                }
                if ((offset = (long)handle.getObjectNameRVA()) <= 0L) continue;
                this.data.add(new DumpData(offset, StructConverter.DWORD, "", false, false));
                len2 = this.reader.readInt(offset);
                DumpData ddObj = new DumpData(offset += 4L, (DataType)new TerminatedUnicodeDataType(), "", false, false);
                ddObj.setSize(len2 + 2);
                this.data.add(ddObj);
            }
        }
        if ((sv = this.getStreamByType(7)) != null) {
            SystemInfoStream sistr = (SystemInfoStream)sv;
            offset = sistr.getCSDVersionRVA();
            this.data.add(new DumpData(offset, StructConverter.DWORD, "", false, false));
            int len3 = this.reader.readInt(offset);
            DumpData dd2 = new DumpData(offset += 4L, (DataType)new TerminatedUnicodeDataType(), "", false, false);
            dd2.setSize(len3 + 2);
            this.data.add(dd2);
        }
        if ((sv = this.getStreamByType(15)) != null) {
            MiscInfoStream mistr = (MiscInfoStream)sv;
            this.processId = mistr.getProcessId();
            this.addProcess(this.processId, "TARGET", 0);
        }
        if ((sv = this.getStreamByType(6)) != null) {
            ExceptionStream xstr = (ExceptionStream)sv;
            this.contextOffset = offset = (long)xstr.getContextRVA();
            dt = xstr.getDefaultContext();
            this.data.add(new DumpData(offset, dt));
            this.threadId = xstr.getThreadId();
            this.addThread(this.processId, this.threadId, 0);
        }
    }

    public MdmpFileHeader getFileHeader() {
        return this.header;
    }

    public Directory[] getDirectories() {
        return this.dirs;
    }

    public StructConverter getStreamByType(int type) {
        return this.streams.get(type);
    }

    public StructConverter getStreamByDir(int dirIndex) {
        return this.streams.get(this.dirs[dirIndex].getStreamType());
    }

    public static String getMachineType(DumpFileReader reader) throws IOException {
        MdmpFileHeader header = new MdmpFileHeader(reader, 0L);
        Directory[] dirs = new Directory[header.getNumberOfStreams()];
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i] = new Directory(reader, reader.getPointerIndex());
        }
        for (Directory dir : dirs) {
            long rva = dir.getRVA();
            switch (dir.getStreamType()) {
                case 7: {
                    SystemInfoStream sv = new SystemInfoStream(reader, rva);
                    return Integer.toString(sv.getProcessorArchitecture());
                }
            }
        }
        return "0";
    }

    @Override
    public void analyze(TaskMonitor monitor) {
        boolean analyzeEmbeddedObjects = OptionUtils.getBooleanOptionValue((String)"Analyze Embedded Executables (interactive)", (List)this.options, (boolean)ANALYZE_EMBEDDED_OBJECTS_OPTION_DEFAULT);
        if (analyzeEmbeddedObjects) {
            ModuleToPeHelper.queryModules(this.program, monitor);
        }
    }

    public static Collection<? extends Option> getDefaultOptions(DumpFileReader reader) {
        return DumpFile.getDefaultOptions(reader);
    }
}

