/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import generic.stl.Pair;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.pagedump.Pagedump;
import ghidra.file.formats.dump.pagedump.PhysicalMemoryDescriptor;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PagedumpFileHeader
implements StructConverter {
    public static final String NAME = "PAGEDUMP_HEADER";
    public static final int HEADER_SIZE = 4096;
    public static final int DMP_PHYSICAL_MEMORY_BLOCK_SIZE_32 = 700;
    public static final int DMP_PHYSICAL_MEMORY_BLOCK_SIZE_64 = 700;
    public static final int DMP_CONTEXT_RECORD_SIZE_32 = 1200;
    public static final int DMP_CONTEXT_RECORD_SIZE_64 = 3000;
    public static final int DMP_HEADER_COMMENT_SIZE = 128;
    public static final int DMP_RESERVED_0_SIZE_32 = 1760;
    public static final int DMP_RESERVED_2_SIZE_32 = 16;
    public static final int DMP_RESERVED_3_SIZE_32 = 56;
    public static final int DMP_RESERVED_0_SIZE_64 = 4008;
    public static int OFFSET_DUMP_TYPE = 3976;
    private int signature;
    private int validDump;
    private int majorVersion;
    private int minorVersion;
    private long directoryTableBase;
    private long pfnTableBase;
    private long psLoadedModuleList;
    private long psActiveProcessHead;
    private int machineImageType;
    private int numberOfProcessors;
    private int bugCheckCode;
    private long bugCheckParameter1;
    private long bugCheckParameter2;
    private long bugCheckParameter3;
    private long bugCheckParameter4;
    private byte[] versionUser = new byte[32];
    private long kdDebuggerDataBlock;
    protected PhysicalMemoryDescriptor pmd;
    private int dumpType;
    private int miniDumpFields;
    private int secondaryDataState;
    private int productType;
    private int suiteMask;
    private int writerStatus;
    private int paeEnabled;
    private int kdSecondaryVersion;
    private int attributes;
    private int bootId;
    private long requiredDumpSpace;
    private long systemUpTime;
    private long systemTime;
    protected List<Pair<Integer, DataType>> delayedAdds = new ArrayList<Pair<Integer, DataType>>();
    protected DumpFileReader reader;
    protected long index;
    private Pagedump pd;
    private int psz;
    private int pad = 1162297680;
    private int padSize = 4;
    private boolean is32Bit;
    private long contextOffset;

    PagedumpFileHeader(DumpFileReader reader, long index, Pagedump pd) throws IOException {
        this.reader = reader;
        this.index = index;
        this.pd = pd;
        this.psz = reader.getPointerSize();
        this.is32Bit = this.psz == 4;
        this.parse();
    }

    PagedumpFileHeader(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parseLight();
    }

    private void parseLight() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSignature(this.reader.readNextInt());
        this.setValidDump(this.reader.readNextInt());
        int valid = this.getValidDump();
        this.psz = valid == 1347245124 ? 32 : 64;
        this.reader.setPointerSize(this.psz);
        this.setMajorVersion(this.reader.readNextInt());
        this.setMinorVersion(this.reader.readNextInt());
        this.setDirectoryTableBase(this.reader.readNextPointer());
        this.setPfnTableBase(this.reader.readNextPointer());
        this.setPsLoadedModuleList(this.reader.readNextPointer());
        this.setPsActiveProcessHead(this.reader.readNextPointer());
        this.setMachineImageType(this.reader.readNextInt());
    }

    private void parse() throws IOException {
        int val;
        this.reader.setPointerIndex(this.index);
        this.setSignature(this.reader.readNextInt());
        this.setValidDump(this.reader.readNextInt());
        this.setMajorVersion(this.reader.readNextInt());
        this.setMinorVersion(this.reader.readNextInt());
        this.setDirectoryTableBase(this.reader.readNextPointer());
        this.setPfnTableBase(this.reader.readNextPointer());
        this.setPsLoadedModuleList(this.reader.readNextPointer());
        this.setPsActiveProcessHead(this.reader.readNextPointer());
        this.setMachineImageType(this.reader.readNextInt());
        this.setNumberOfProcessors(this.reader.readNextInt());
        this.setBugCheckCode(this.reader.readNextInt());
        this.reader.readNextInt();
        this.setBugCheckParameter1(this.reader.readNextPointer());
        this.setBugCheckParameter2(this.reader.readNextPointer());
        this.setBugCheckParameter3(this.reader.readNextPointer());
        this.setBugCheckParameter4(this.reader.readNextPointer());
        for (int i = 0; i < this.versionUser.length; ++i) {
            this.versionUser[i] = this.reader.readNextByte();
        }
        if (this.is32Bit()) {
            this.setPaeEnabled(this.reader.readNextByte());
            this.setKdSecondaryVersion(this.reader.readNextByte());
            this.reader.readNextByte();
            this.reader.readNextByte();
        }
        this.setKdDebuggerDataBlock(this.reader.readNextPointer());
        long offsetPMD = this.reader.getPointerIndex();
        long pmdSize = this.is32Bit() ? 700L : 700L;
        long ctxtSize = this.is32Bit() ? 1200L : 3000L;
        long offset = offsetPMD + pmdSize + (long)this.padSize + ctxtSize;
        CategoryPath path = new CategoryPath("/winnt.h");
        DataType dt = this.pd.getTypeFromArchive(path, this.is32Bit() ? "EXCEPTION_RECORD32" : "EXCEPTION_RECORD64");
        offset = dt != null ? (offset += (long)dt.getLength()) : (offset += this.is32Bit() ? 84L : 152L);
        if (this.is32Bit()) {
            this.reader.setPointerIndex(offset += 128L);
            val = this.reader.readNextInt();
            if (val != this.pad) {
                this.setAttributes(val);
            }
            if ((val = this.reader.readNextInt()) != this.pad) {
                this.setAttributes(val);
            }
            offset = this.reader.getPointerIndex();
            offset += 1200L;
        }
        this.reader.setPointerIndex(offset);
        OFFSET_DUMP_TYPE = (int)offset;
        this.setDumpType(this.reader.readNextInt());
        this.reader.readNextInt();
        if (!this.is32Bit()) {
            this.setRequiredDumpSpace(this.reader.readNextLong());
            this.setSystemTime(this.reader.readNextLong());
            for (int i = 0; i < 128; ++i) {
                this.reader.readNextByte();
            }
            this.setSystemUpTime(this.reader.readNextLong());
        }
        if ((val = this.reader.readNextInt()) != this.pad) {
            this.setMiniDumpFields(val);
        }
        if ((val = this.reader.readNextInt()) != this.pad) {
            this.setSecondaryDataState(val);
        }
        if ((val = this.reader.readNextInt()) != this.pad) {
            this.setProductType(val);
        }
        if ((val = this.reader.readNextInt()) != this.pad) {
            this.setSuiteMask(val);
        }
        if ((val = this.reader.readNextInt()) != this.pad) {
            this.setWriterStatus(val);
        }
        if (this.is32Bit()) {
            int i;
            this.setRequiredDumpSpace(this.reader.readNextLong());
            for (i = 0; i < 1760; ++i) {
                this.reader.readNextByte();
            }
            this.setSystemUpTime(this.reader.readNextLong());
            this.setSystemTime(this.reader.readNextLong());
            for (i = 0; i < 1760; ++i) {
                this.reader.readNextByte();
            }
        } else {
            val = this.reader.readNextInt();
            if (val != this.pad) {
                this.setKdSecondaryVersion(val);
            }
            if ((val = this.reader.readNextInt()) != this.pad) {
                this.setAttributes(val);
            }
            if ((val = this.reader.readNextInt()) != this.pad) {
                this.setBootId(val);
            }
            for (int i = 0; i < 4008; ++i) {
                this.reader.readNextByte();
            }
        }
        if ((this.dumpType != 4 || (this.miniDumpFields & 0x800) > 0) && (val = this.reader.readInt(offsetPMD)) != this.pad) {
            this.pmd = new PhysicalMemoryDescriptor(this.reader, offsetPMD);
        }
    }

    public long getContextOffset() {
        return this.contextOffset;
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(STRING, 4, "Signature", null);
        struct.add(STRING, 4, "ValidDump", null);
        struct.add(DWORD, 4, "MajorVersion", null);
        struct.add(DWORD, 4, "MinorVersion", null);
        struct.add(POINTER, this.psz, "DirectoryTableBase", null);
        struct.add(POINTER, this.psz, "PfnTableBase", null);
        struct.add(POINTER, this.psz, "PsLoadedModuleList", null);
        struct.add(POINTER, this.psz, "PsActiveProcessHead", null);
        struct.add(DWORD, 4, "MachineImageType", null);
        struct.add(DWORD, 4, "NumberOfProcessors", null);
        struct.add(DWORD, 4, "BugCheckCode", null);
        struct.add(STRING, 4, "__unusedAlignment", null);
        struct.add(POINTER, this.psz, "BugCheckParameter1", null);
        struct.add(POINTER, this.psz, "BugCheckParameter2", null);
        struct.add(POINTER, this.psz, "BugCheckParameter3", null);
        struct.add(POINTER, this.psz, "BugCheckParameter4", null);
        struct.add(STRING, this.versionUser.length, "VersionUser", null);
        if (this.is32Bit()) {
            struct.add(BYTE, 1, "PaeEnabled", null);
            struct.add(BYTE, 1, "KdSecondaryVersion", null);
            struct.add(BYTE, 1, "", null);
            struct.add(BYTE, 1, "", null);
        }
        struct.add(POINTER, this.psz, "KdDebuggerDataBlock", null);
        long pmdSize = this.is32Bit() ? 700L : 700L;
        struct.add(STRING, (int)pmdSize, "PhysicalMemoryBlock", null);
        struct.add(STRING, 4, "__unusedAlignment", null);
        CategoryPath path = new CategoryPath("/winnt.h");
        long ctxtSize = this.is32Bit() ? 1200L : 3000L;
        DataType dt = this.pd.getTypeFromArchive(path, "CONTEXT");
        if (dt != null) {
            this.contextOffset = struct.getLength();
            struct.add(dt, dt.getLength(), "ContextRecord", null);
            struct.add(STRING, (int)ctxtSize - dt.getLength(), "__unusedAlignment", null);
        }
        if ((dt = this.pd.getTypeFromArchive(path, this.is32Bit() ? "EXCEPTION_RECORD32" : "EXCEPTION_RECORD64")) != null) {
            struct.add(dt, dt.getLength(), "ExceptionRecord", null);
        } else {
            struct.add(DWORD, 4, "ExceptionCode", null);
            struct.add(DWORD, 4, "ExceptionFlags", null);
            struct.add(POINTER, this.psz, "ExceptionRecord", null);
            struct.add(POINTER, this.psz, "ExceptionAddress", null);
            struct.add(DWORD, 4, "NumberParameters", null);
            struct.add(STRING, 4, "__unusedAlignment", null);
            ArrayDataType eiDt = new ArrayDataType(POINTER, 15, this.psz);
            struct.add((DataType)eiDt, eiDt.getLength(), "ExceptionInformation", null);
        }
        if (this.is32Bit()) {
            struct.add(STRING, 128, "Comment", null);
            dt = this.getAttributes() == 0 ? STRING : DWORD;
            struct.add(QWORD, 8, "Attributes", null);
            dt = this.getBootId() == 0 ? STRING : DWORD;
            struct.add(DWORD, 4, "BootId", null);
            struct.add(STRING, 1760, "_reserved0", null);
        }
        struct.growStructure(OFFSET_DUMP_TYPE - struct.getLength());
        struct.add(DWORD, 4, "DumpType", null);
        struct.add(STRING, 4, "__unusedAlignment", null);
        if (!this.is32Bit()) {
            struct.add(QWORD, 8, "RequiredDumpSpace", null);
            struct.add(QWORD, 8, "SystemTime", null);
            struct.add(STRING, 128, "Comment", null);
            struct.add(QWORD, 8, "SystemUpTime", null);
        }
        dt = this.miniDumpFields == 0 ? STRING : DWORD;
        struct.add(dt, 4, "MiniDumpFields", null);
        dt = this.secondaryDataState == 0 ? STRING : DWORD;
        struct.add(dt, 4, "SecondaryDataState", null);
        dt = this.productType == 0 ? STRING : DWORD;
        struct.add(dt, 4, "ProductType", null);
        dt = this.suiteMask == 0 ? STRING : DWORD;
        struct.add(dt, 4, "SuiteMask", null);
        dt = this.getWriterStatus() == 0 ? STRING : DWORD;
        struct.add(dt, 4, "WriterStatus", null);
        if (this.is32Bit()) {
            struct.add(QWORD, 8, "RequiredDumpSpace", null);
            struct.add(STRING, 16, "_reserved2", null);
            struct.add(QWORD, 8, "SystemUpTime", null);
            struct.add(QWORD, 8, "SystemTime", null);
            struct.add(STRING, 56, "_reserved3", null);
        } else {
            dt = this.getKdSecondaryVersion() == 0 ? STRING : DWORD;
            struct.add(dt, 4, "KdSecondaryVersion", null);
            dt = this.getAttributes() == 0 ? STRING : DWORD;
            struct.add(dt, 4, "Attributes", null);
            dt = this.getBootId() == 0 ? STRING : DWORD;
            struct.add(dt, 4, "BootId", null);
            struct.add(STRING, 4008, "_reserved0", null);
        }
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public void addToDataType(DataType dt, long offset) {
        this.delayedAdds.add((Pair<Integer, DataType>)new Pair((Object)((int)offset), (Object)dt));
    }

    public int getSignature() {
        return this.signature;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getValidDump() {
        return this.validDump;
    }

    public void setValidDump(int validDump) {
        this.validDump = validDump;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public long getDirectoryTableBase() {
        return this.directoryTableBase;
    }

    public void setDirectoryTableBase(long directoryTableBase) {
        this.directoryTableBase = directoryTableBase;
    }

    public long getPfnTableBase() {
        return this.pfnTableBase;
    }

    public void setPfnTableBase(long pfnTableBase) {
        this.pfnTableBase = pfnTableBase;
    }

    public long getPsLoadedModuleList() {
        return this.psLoadedModuleList;
    }

    public void setPsLoadedModuleList(long psLoadedModuleList) {
        this.psLoadedModuleList = psLoadedModuleList;
    }

    public long getPsActiveProcessHead() {
        return this.psActiveProcessHead;
    }

    public void setPsActiveProcessHead(long psActiveProcessHead) {
        this.psActiveProcessHead = psActiveProcessHead;
    }

    public int getMachineImageType() {
        return this.machineImageType;
    }

    public void setMachineImageType(int machineImageType) {
        this.machineImageType = machineImageType;
    }

    public int getNumberOfProcessors() {
        return this.numberOfProcessors;
    }

    public void setNumberOfProcessors(int numberOfProcessors) {
        this.numberOfProcessors = numberOfProcessors;
    }

    public PhysicalMemoryDescriptor getPhysicalMemoryBlockBuffer() {
        return this.pmd;
    }

    public void setPhysicalMemoryBlockBuffer(PhysicalMemoryDescriptor pmd) {
        this.pmd = pmd;
    }

    public int getDumpType() {
        return this.dumpType;
    }

    public void setDumpType(int dumpType) {
        this.dumpType = dumpType;
    }

    public long getRequiredDumpSpace() {
        return this.requiredDumpSpace;
    }

    public void setRequiredDumpSpace(long requiredDumpSpace) {
        this.requiredDumpSpace = requiredDumpSpace;
    }

    public long getSystemUpTime() {
        return this.systemUpTime;
    }

    public void setSystemUpTime(long systemUpTime) {
        this.systemUpTime = systemUpTime;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    public int getBugCheckCode() {
        return this.bugCheckCode;
    }

    public void setBugCheckCode(int bugCheckCode) {
        this.bugCheckCode = bugCheckCode;
    }

    public long getBugCheckParameter1() {
        return this.bugCheckParameter1;
    }

    public void setBugCheckParameter1(long bugCheckParameter1) {
        this.bugCheckParameter1 = bugCheckParameter1;
    }

    public long getBugCheckParameter2() {
        return this.bugCheckParameter2;
    }

    public void setBugCheckParameter2(long bugCheckParameter2) {
        this.bugCheckParameter2 = bugCheckParameter2;
    }

    public long getBugCheckParameter3() {
        return this.bugCheckParameter3;
    }

    public void setBugCheckParameter3(long bugCheckParameter3) {
        this.bugCheckParameter3 = bugCheckParameter3;
    }

    public long getBugCheckParameter4() {
        return this.bugCheckParameter4;
    }

    public void setBugCheckParameter4(long bugCheckParameter4) {
        this.bugCheckParameter4 = bugCheckParameter4;
    }

    public long getKdDebuggerDataBlock() {
        return this.kdDebuggerDataBlock;
    }

    public void setKdDebuggerDataBlock(long kdDebuggerDataBlock) {
        this.kdDebuggerDataBlock = kdDebuggerDataBlock;
    }

    public int getMiniDumpFields() {
        return this.miniDumpFields;
    }

    public void setMiniDumpFields(int miniDumpFields) {
        this.miniDumpFields = miniDumpFields;
    }

    public int getSecondaryDataState() {
        return this.secondaryDataState;
    }

    public void setSecondaryDataState(int secondaryDataState) {
        this.secondaryDataState = secondaryDataState;
    }

    public int getProductType() {
        return this.productType;
    }

    public void setProductType(int productType) {
        this.productType = productType;
    }

    public int getSuiteMask() {
        return this.suiteMask;
    }

    public void setSuiteMask(int suiteMask) {
        this.suiteMask = suiteMask;
    }

    public int getWriterStatus() {
        return this.writerStatus;
    }

    public void setWriterStatus(int writerStatus) {
        this.writerStatus = writerStatus;
    }

    public int getKdSecondaryVersion() {
        return this.kdSecondaryVersion;
    }

    public void setKdSecondaryVersion(int kdSecondaryVersion) {
        this.kdSecondaryVersion = kdSecondaryVersion;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public void setAttributes(int attributes) {
        this.attributes = attributes;
    }

    public int getBootId() {
        return this.bootId;
    }

    public void setBootId(int bootId) {
        this.bootId = bootId;
    }

    public boolean is32Bit() {
        return this.is32Bit;
    }

    public int getPaeEnabled() {
        return this.paeEnabled;
    }

    public void setPaeEnabled(int paeEnabled) {
        this.paeEnabled = paeEnabled;
    }
}

