/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.io.IOException;
import java.io.Writer;

public class FrameDataRecord {
    private long rvaStart;
    private long numBlockBytes;
    private long numLocalBytes;
    private long numParamBytes;
    private long maxStackBytes;
    private long frameFunc;
    private int numPrologBytes;
    private int numSavedRegBytes;
    private boolean hasSEH;
    private boolean hasEH;
    private boolean isFunctionStart;
    private long reserved;

    public long getRvaStart() {
        return this.rvaStart;
    }

    public long getNumberBlockBytes() {
        return this.numBlockBytes;
    }

    public long getNumberLocalBytes() {
        return this.numLocalBytes;
    }

    public long getNumberParameterBytes() {
        return this.numParamBytes;
    }

    public long getMaxStackBytes() {
        return this.maxStackBytes;
    }

    public long getFrameFunc() {
        return this.frameFunc;
    }

    public int getNumberFunctionPrologBytes() {
        return this.numPrologBytes;
    }

    public int getNumberSavedRegisterBytes() {
        return this.numSavedRegBytes;
    }

    public boolean hasSEH() {
        return this.hasSEH;
    }

    public boolean hasEH() {
        return this.hasEH;
    }

    public boolean isFunctionStart() {
        return this.isFunctionStart;
    }

    public long reserved() {
        return this.reserved;
    }

    public void parse(PdbByteReader reader) throws PdbException {
        if (reader.numRemaining() < 32) {
            throw new PdbException("Not enough data for FrameDataRecord");
        }
        this.rvaStart = reader.parseUnsignedIntVal();
        this.numBlockBytes = reader.parseUnsignedIntVal();
        this.numLocalBytes = reader.parseUnsignedIntVal();
        this.numParamBytes = reader.parseUnsignedIntVal();
        this.maxStackBytes = reader.parseUnsignedIntVal();
        this.frameFunc = reader.parseUnsignedIntVal();
        this.numPrologBytes = reader.parseUnsignedShortVal();
        this.numSavedRegBytes = reader.parseUnsignedShortVal();
        this.reserved = reader.parseUnsignedIntVal();
        this.hasSEH = (this.reserved & 1L) == 1L;
        this.reserved >>= 1;
        this.hasEH = (this.reserved & 1L) == 1L;
        this.reserved >>= 1;
        this.isFunctionStart = (this.reserved & 1L) == 1L;
        this.reserved >>= 1;
        this.reserved &= 0x1FFFFFFL;
    }

    void dump(Writer writer) throws IOException {
        writer.write("FrameDataRecord---------------------------------------------\n");
        writer.write(String.format("rvaStart: 0X%08X\n", this.rvaStart));
        writer.write(String.format("numBlockBytes: 0X%08X\n", this.numBlockBytes));
        writer.write(String.format("numLocalBytes: 0X%08X\n", this.numLocalBytes));
        writer.write(String.format("numParamBytes: 0X%08X\n", this.numParamBytes));
        writer.write(String.format("maxStackBytes: 0X%08X\n", this.maxStackBytes));
        writer.write(String.format("frameFunc: 0X%08X\n", this.frameFunc));
        writer.write(String.format("numPrologBytes: 0X%04X\n", this.numPrologBytes));
        writer.write(String.format("numSavedRegBytes: 0X%04X\n", this.numSavedRegBytes));
        writer.write(String.format("hasStructuedExceptionHandling: %s\n", Boolean.toString(this.hasSEH)));
        writer.write(String.format("hasExceptionHandling: %s\n", Boolean.toString(this.hasEH)));
        writer.write(String.format("isFunctionStart: %s\n", Boolean.toString(this.isFunctionStart)));
        writer.write("End FrameDataRecord-----------------------------------------\n");
    }
}

