/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;

public class EnregisteredSymbolRelativeDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    public static final int PDB_ID = 4421;
    private int baseRegister;
    private RegisterName baseRegisterName;
    private boolean isSpilledUserDefinedTypeMember;
    private int offsetInParent;
    private int offsetToBaseRegister;

    public EnregisteredSymbolRelativeDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.baseRegister = reader.parseUnsignedShortVal();
        this.baseRegisterName = new RegisterName(pdb, this.baseRegister);
        int fields = reader.parseUnsignedShortVal();
        this.isSpilledUserDefinedTypeMember = (fields & 1) == 1;
        this.offsetInParent = (fields >>= 4) & 0xFFF;
        this.offsetToBaseRegister = reader.parseInt();
        this.parseRangeAndGaps(reader);
    }

    @Override
    public int getPdbId() {
        return 4421;
    }

    @Override
    protected String getSymbolTypeName() {
        return "DEFRANGE_REGISTER_REL";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(String.format(": [%s + %04X]", this.baseRegisterName.toString(), this.offsetToBaseRegister));
        if (this.isSpilledUserDefinedTypeMember) {
            builder.append(String.format(" spilledUserDefinedTypeMember offset at %d", this.offsetInParent));
        }
        this.emitRangeAndGaps(builder);
    }
}

