/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.DockingWindowManager;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.ui.SymbolFileRow;
import pdb.symbolserver.ui.SymbolFileTableModel;

class SymbolFilePanel
extends JPanel {
    static final String SEARCH_OPTIONS_HELP_ANCHOR = "PDB_Search_Search_Options";
    private SymbolFileTableModel tableModel;
    private GhidraTable table;
    private JPanel tablePanel;
    private JPanel welcomePanel;
    private JButton searchLocalButton;
    private JButton searchAllButton;
    private GCheckBox ignorePdbUid;
    private GCheckBox ignorePdbAge;

    SymbolFilePanel(SearchCallback searchButtonsCallback) {
        super(new BorderLayout());
        this.build();
        this.setEnablement(false, false);
        this.searchLocalButton.addActionListener(e -> searchButtonsCallback.searchForPdbs(false));
        this.searchAllButton.addActionListener(e -> searchButtonsCallback.searchForPdbs(true));
    }

    SymbolFileTableModel getTableModel() {
        return this.tableModel;
    }

    GhidraTable getTable() {
        return this.table;
    }

    Set<FindOption> getFindOptions() {
        EnumSet<FindOption> findOptions = EnumSet.noneOf(FindOption.class);
        if (this.ignorePdbAge.isSelected()) {
            findOptions.add(FindOption.ANY_AGE);
        }
        if (this.ignorePdbUid.isSelected()) {
            findOptions.add(FindOption.ANY_ID);
        }
        return findOptions;
    }

    void setFindOptions(Set<FindOption> findOptions) {
        this.ignorePdbAge.setSelected(findOptions.contains((Object)FindOption.ANY_AGE));
        this.ignorePdbUid.setSelected(findOptions.contains((Object)FindOption.ANY_ID));
    }

    void setEnablement(boolean hasSymbolServerService, boolean isSearchable) {
        this.searchLocalButton.setEnabled(hasSymbolServerService && isSearchable);
        this.searchAllButton.setEnabled(hasSymbolServerService && isSearchable);
        if (this.welcomePanel != null && hasSymbolServerService) {
            this.remove(this.welcomePanel);
            this.welcomePanel = null;
            this.add((Component)this.tablePanel, "Center");
            this.revalidate();
        }
    }

    SymbolFileRow getSelectedRow() {
        return this.table.getSelectedRow() != -1 ? (SymbolFileRow)this.tableModel.getRowObject(this.table.getSelectedRow()) : null;
    }

    int getSelectedRowIndex() {
        return this.table.getSelectedRow();
    }

    private void build() {
        this.setBorder(BorderFactory.createTitledBorder("PDB Search"));
        this.add((Component)this.buildButtonPanel(), "North");
        this.buildTable();
        this.add((Component)this.buildWelcomePanel(), "Center");
    }

    private JPanel buildWelcomePanel() {
        this.welcomePanel = new JPanel();
        this.welcomePanel.add((Component)new GHtmlLabel("<html><br><center><font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">Configuration must be set first!"));
        this.welcomePanel.setPreferredSize(this.tablePanel.getPreferredSize());
        return this.welcomePanel;
    }

    private JPanel buildTable() {
        this.tableModel = new SymbolFileTableModel();
        this.table = new GhidraTable((TableModel)((Object)this.tableModel));
        this.table.setSelectionMode(0);
        TableColumn isMatchColumn = this.table.getColumnModel().getColumn(0);
        isMatchColumn.setResizable(false);
        isMatchColumn.setPreferredWidth(32);
        isMatchColumn.setMaxWidth(32);
        isMatchColumn.setMinWidth(32);
        this.table.setVisibleRowCount(8);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.tablePanel = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)new JScrollPane((Component)this.table), "Center");
        return this.tablePanel;
    }

    private JPanel buildButtonPanel() {
        this.searchLocalButton = new JButton("Search");
        this.searchLocalButton.setToolTipText("Search trusted symbol servers only.");
        this.searchAllButton = new JButton("Search All");
        this.searchAllButton.setToolTipText("Search trusted and untrusted symbol servers.");
        this.ignorePdbUid = new GCheckBox("Ignore GUID/ID");
        this.ignorePdbUid.setToolTipText("Find any PDB with same name (local locations only).  Age ignored also.");
        this.ignorePdbUid.addChangeListener(l -> this.updateSearchOptionEnablement());
        this.ignorePdbAge = new GCheckBox("Ignore Age");
        this.ignorePdbAge.setToolTipText("Find PDB with any age value (local locations only).");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add((Component)new GLabel("Search Options:"));
        panel.add(Box.createHorizontalStrut(10));
        panel.add((Component)this.ignorePdbAge);
        panel.add(Box.createHorizontalStrut(10));
        panel.add((Component)this.ignorePdbUid);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.searchLocalButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.searchAllButton);
        DockingWindowManager.getHelpService().registerHelp((Object)panel, new HelpLocation("Pdb", SEARCH_OPTIONS_HELP_ANCHOR));
        return panel;
    }

    private void updateSearchOptionEnablement() {
        this.ignorePdbAge.setEnabled(!this.ignorePdbUid.isSelected());
    }

    static interface SearchCallback {
        public void searchForPdbs(boolean var1);
    }
}

