/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.ColumnSortState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class TableSortState
implements Iterable<ColumnSortState> {
    private static final String XML_TABLE_SORT_STATE = "TABLE_SORT_STATE";
    private List<ColumnSortState> columnSortStates = new ArrayList<ColumnSortState>();

    public static TableSortState createUnsortedSortState() {
        return new TableSortState();
    }

    public static TableSortState createDefaultSortState(int columnModelIndex) {
        return new TableSortState(new ColumnSortState(columnModelIndex, ColumnSortState.SortDirection.ASCENDING, 1));
    }

    public static TableSortState createDefaultSortState(int columnModelIndex, boolean isAscending) {
        ColumnSortState.SortDirection sortDirection = isAscending ? ColumnSortState.SortDirection.ASCENDING : ColumnSortState.SortDirection.DESCENDING;
        return new TableSortState(new ColumnSortState(columnModelIndex, sortDirection, 1));
    }

    public TableSortState() {
    }

    public TableSortState(List<ColumnSortState> sortStates) {
        ArrayList<Integer> sortOrders = new ArrayList<Integer>();
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        for (ColumnSortState state : sortStates) {
            int sortOrder = state.getSortOrder();
            if (sortOrders.contains(sortOrder)) {
                throw new IllegalArgumentException("Attempt to set table sort columns with duplicate sort order: " + sortOrder);
            }
            int columnModelIndex = state.getColumnModelIndex();
            if (columnIndices.contains(columnModelIndex)) {
                throw new IllegalArgumentException("Attempt to set table sort columns with duplicate columns specified: " + columnModelIndex);
            }
            sortOrders.add(sortOrder);
            columnIndices.add(columnModelIndex);
        }
        this.columnSortStates = new ArrayList<ColumnSortState>(sortStates);
    }

    public TableSortState(ColumnSortState columnSortState) {
        this.columnSortStates.add(columnSortState);
    }

    @Override
    public Iterator<ColumnSortState> iterator() {
        return Collections.unmodifiableList(this.columnSortStates).iterator();
    }

    public int getSortedColumnCount() {
        return this.columnSortStates.size();
    }

    public boolean isUnsorted() {
        return this.columnSortStates.isEmpty();
    }

    public ColumnSortState getColumnSortState(int columnModelIndex) {
        for (ColumnSortState sortState : this.columnSortStates) {
            if (sortState.getColumnModelIndex() != columnModelIndex) continue;
            return sortState;
        }
        return null;
    }

    public List<ColumnSortState> getAllSortStates() {
        return new ArrayList<ColumnSortState>(this.columnSortStates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableSortState)) {
            return false;
        }
        TableSortState other = (TableSortState)obj;
        return this.columnSortStates.equals(other.columnSortStates);
    }

    public int hashCode() {
        return this.columnSortStates.hashCode();
    }

    public static TableSortState restoreFromXML(Element element) {
        List tableSortStateElementList = element.getChildren(XML_TABLE_SORT_STATE);
        if (tableSortStateElementList == null || tableSortStateElementList.size() == 0) {
            return null;
        }
        Element sortStateElement = (Element)tableSortStateElementList.get(0);
        List children = sortStateElement.getChildren("COLUMN_SORT_STATE");
        ArrayList<ColumnSortState> columnStates = new ArrayList<ColumnSortState>(children.size());
        for (Object object : children) {
            columnStates.add(ColumnSortState.restoreFromXML((Element)object));
        }
        return new TableSortState(columnStates);
    }

    public Element writeToXML() {
        Element element = new Element(XML_TABLE_SORT_STATE);
        for (ColumnSortState sortState : this.columnSortStates) {
            Element sortStateElement = sortState.writeToXML();
            element.addContent((Content)sortStateElement);
        }
        return element;
    }

    public String toString() {
        return this.columnSortStates.toString();
    }
}

