/*
 * Decompiled with CFR 0.152.
 */
package docking.wizard;

import docking.wizard.WizardModel;
import ghidra.util.HelpLocation;
import java.awt.Component;
import javax.swing.JComponent;

public abstract class WizardStep<T> {
    private String title;
    private HelpLocation helpLocation;
    private WizardModel<T> model;
    private String statusMessage;

    protected WizardStep(WizardModel<T> model, String title, HelpLocation help) {
        this.model = model;
        this.title = title;
        this.helpLocation = help;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setHelpLocation(HelpLocation help) {
        this.helpLocation = help;
    }

    public abstract void initialize(T var1);

    public abstract boolean isValid();

    public abstract boolean canFinish(T var1);

    public abstract void populateData(T var1);

    public abstract boolean apply(T var1);

    public boolean isApplicable(T data) {
        return true;
    }

    public abstract JComponent getComponent();

    public String getTitle() {
        return this.title;
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    public Component getDefaultFocusComponent() {
        return null;
    }

    protected String getStatusMessage() {
        return this.statusMessage;
    }

    protected void setStatusMessage(String message) {
        this.statusMessage = message;
    }

    protected void clearStatus() {
        this.statusMessage = null;
    }

    protected void notifyStatusChanged() {
        this.model.statusChanged(this);
    }

    protected void dispose(T data) {
    }
}

