/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class FloatingPointPrecisionSettingsDefinition
implements EnumSettingsDefinition {
    private static final String PRECISION_DIGITS = "Precision digits";
    public static final FloatingPointPrecisionSettingsDefinition DEF = new FloatingPointPrecisionSettingsDefinition();
    private static final String[] choices = new String[]{"default", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private static final int DEFAULT_PRECISION = 3;
    public static final int MAX_PRECISION = choices.length - 2;

    private FloatingPointPrecisionSettingsDefinition() {
    }

    public int getPrecision(Settings settings) {
        return this.getChoice(settings) - 1;
    }

    public void setPrecision(Settings settings, int digits) {
        this.setChoice(settings, digits + 1);
    }

    @Override
    public int getChoice(Settings settings) {
        Long value = 4L;
        if (settings != null && (value = settings.getLong(PRECISION_DIGITS)) == null) {
            value = 4L;
        }
        return value.intValue();
    }

    @Override
    public String getValueString(Settings settings) {
        return Integer.toString(this.getPrecision(settings));
    }

    @Override
    public void setChoice(Settings settings, int valueIndex) {
        if (valueIndex < 0) {
            settings.clearSetting(PRECISION_DIGITS);
        } else {
            if (valueIndex == 0) {
                valueIndex = 4;
            }
            if (valueIndex > MAX_PRECISION + 1) {
                valueIndex = MAX_PRECISION + 1;
            }
            settings.setLong(PRECISION_DIGITS, valueIndex);
        }
    }

    @Override
    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    @Override
    public String getName() {
        return PRECISION_DIGITS;
    }

    @Override
    public String getStorageKey() {
        return PRECISION_DIGITS;
    }

    @Override
    public String getDescription() {
        return "Selects the number of digits of precision to display";
    }

    public int getChoice(String displayChoice, Settings settings) {
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(displayChoice)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    @Override
    public void clear(Settings settings) {
        settings.clearSetting(PRECISION_DIGITS);
    }

    @Override
    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(PRECISION_DIGITS);
        if (l == null) {
            destSettings.clearSetting(PRECISION_DIGITS);
        } else {
            destSettings.setLong(PRECISION_DIGITS, l);
        }
    }

    @Override
    public boolean hasValue(Settings setting) {
        return setting.getValue(PRECISION_DIGITS) != null;
    }
}

