/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.properties.effects.GradientProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.batik.ext.awt.LinearGradientPaint;

public class LinearGradientPainter
implements Painter {
    private GradientProperty m_gradient_prop;
    private Paint m_cached_paint;
    private Rectangle m_last_rect = new Rectangle();
    private LookAndFeel m_look_and_feel;

    public LinearGradientPainter() {
    }

    public LinearGradientPainter(GradientProperty gradientProperty) {
        this.m_gradient_prop = gradientProperty;
    }

    private Paint createPaint(Rectangle rectangle, GradientProperty gradientProperty) {
        Color color = gradientProperty.getStartColor().getColor();
        Color color2 = gradientProperty.getEndColor().getColor();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x;
        int n4 = rectangle.y + (int)((float)rectangle.height * gradientProperty.getMagnitude());
        if (color == null) {
            color = Color.white;
        }
        if (color2 == null) {
            color2 = Color.white;
        }
        if (gradientProperty.getDirection() == 0) {
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.x;
            n4 = rectangle.y + (int)((float)rectangle.height * gradientProperty.getMagnitude());
        } else if (gradientProperty.getDirection() == 1) {
            n = rectangle.x;
            n4 = rectangle.y;
            n3 = rectangle.x;
            n2 = rectangle.y + (int)((float)rectangle.height * gradientProperty.getMagnitude());
        } else if (gradientProperty.getDirection() == 2) {
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.x + (int)((float)rectangle.width * gradientProperty.getMagnitude());
            n4 = rectangle.y;
        } else if (gradientProperty.getDirection() == 3) {
            n3 = rectangle.x;
            n2 = rectangle.y;
            n = rectangle.x + (int)((float)rectangle.width * gradientProperty.getMagnitude());
            n4 = rectangle.y;
        } else if (gradientProperty.getDirection() == 5) {
            n = rectangle.x;
            n2 = rectangle.y + (int)((float)rectangle.height * gradientProperty.getMagnitude());
            n3 = rectangle.x + (int)((float)rectangle.width * gradientProperty.getMagnitude());
            n4 = rectangle.y;
        } else {
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.x + (int)((float)rectangle.width * gradientProperty.getMagnitude());
            n4 = rectangle.y + (int)((float)rectangle.height * gradientProperty.getMagnitude());
        }
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{color, color2};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(n, n2, n3, n4, fArray, colorArray);
        return linearGradientPaint;
    }

    public void paint(Component component, Graphics graphics, Rectangle rectangle) {
        if (rectangle == null || this.m_gradient_prop == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (this.m_look_and_feel != lookAndFeel) {
            this.m_cached_paint = null;
            this.m_look_and_feel = lookAndFeel;
        }
        if (this.m_cached_paint == null || !rectangle.equals(this.m_last_rect)) {
            this.m_last_rect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.m_cached_paint = this.createPaint(rectangle, this.m_gradient_prop);
        }
        graphics2D.setPaint(this.m_cached_paint);
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle.intersects(rectangle2)) {
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics2D.setPaint(paint);
        }
    }

    public void setGradientProperty(GradientProperty gradientProperty) {
        this.m_cached_paint = null;
        this.m_gradient_prop = gradientProperty;
    }
}

