/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.decode;

import ghidra.app.util.PseudoInstruction;
import ghidra.pcode.emu.InstructionDecoder;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.decode.DecoderForOnePassage;
import ghidra.pcode.emu.jit.decode.DecoderUseropLibrary;
import ghidra.pcode.exec.DecodePcodeExecutionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ProgramContext;

public class JitPassageDecoder {
    final JitPcodeThread thread;
    final InstructionDecoder decoder;
    final ProgramContext defaultContext;
    final Register contextreg;
    final DecoderUseropLibrary library;

    public JitPassageDecoder(JitPcodeThread thread) {
        this.thread = thread;
        this.decoder = thread.getDecoder();
        this.defaultContext = thread.getDefaultContext();
        this.contextreg = this.defaultContext == null ? Register.NO_CONTEXT : this.defaultContext.getBaseContextRegister();
        this.library = new DecoderUseropLibrary(thread.getUseropLibrary());
    }

    public JitPassage decodePassage(Address seed, RegisterValue ctxIn, int maxOps) {
        return this.decodePassage(new JitPassage.AddrCtx(ctxIn, seed), maxOps);
    }

    public JitPassage decodePassage(JitPassage.AddrCtx seed, int maxOps) {
        DecoderForOnePassage forOne = new DecoderForOnePassage(this, seed, maxOps);
        forOne.decodePassage();
        return forOne.finish();
    }

    PseudoInstruction decodeInstruction(Address address, RegisterValue ctx) {
        try {
            return this.decoder.decodeInstruction(address, ctx);
        }
        catch (DecodePcodeExecutionException e) {
            return JitPassage.decodeError(this.decoder.getLanguage(), address, ctx, e.getMessage());
        }
    }
}

