/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntUnOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitInt2CompOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.SequencedCollection;
import org.objectweb.asm.MethodVisitor;

public enum Int2CompOpGen implements IntUnOpGen<JitInt2CompOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    private void generateMpIntLeg2Cmp(int idx, JitType.IntJitType type, boolean givesCarry, MethodVisitor mv) {
        mv.visitVarInsn(21, idx);
        mv.visitLdcInsn((Object)(-1 >>> 32 - type.size() * 8));
        mv.visitInsn(130);
        TypeConversions.generateIntToLong(type, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
        mv.visitInsn(97);
        if (givesCarry) {
            mv.visitInsn(92);
            TypeConversions.generateLongToInt(JitType.LongJitType.I8, type, TypeConversions.Ext.ZERO, mv);
            mv.visitVarInsn(54, idx);
            mv.visitLdcInsn((Object)32);
            mv.visitInsn(125);
        } else {
            TypeConversions.generateLongToInt(JitType.LongJitType.I8, type, TypeConversions.Ext.ZERO, mv);
            mv.visitVarInsn(54, idx);
        }
    }

    private void generateMpInt2Comp(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int legCount = type.legsAlloc();
        try (JitAllocationModel.JvmTempAlloc result = gen.getAllocationModel().allocateTemp(mv, "result", legCount);){
            OpGen.generateMpLegsIntoTemp(result, legCount, mv);
            SequencedCollection types = type.legTypes().reversed();
            mv.visitLdcInsn((Object)1L);
            for (int i = 0; i < legCount; ++i) {
                boolean isLast = i == legCount - 1;
                this.generateMpIntLeg2Cmp(result.idx(i), (JitType.IntJitType)types.get(i), !isLast, mv);
            }
            OpGen.generateMpLegsFromTemp(result, legCount, mv);
        }
    }

    @Override
    public JitType generateUnOpRunCode(JitCodeGenerator gen, JitInt2CompOp op, JitControlFlowModel.JitBlock block, JitType uType, MethodVisitor rv) {
        JitType jitType = uType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                rv.visitInsn(116);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                rv.visitInsn(117);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                this.generateMpInt2Comp(gen, t, rv);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return uType;
    }
}

