/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitSubPieceOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum SubPieceOpGen implements OpGen<JitSubPieceOp>
{
    GEN;


    private static void generateShiftWithPrevLeg(MethodVisitor rv, int bitShift, int index) {
        rv.visitLdcInsn((Object)(32 - bitShift));
        rv.visitInsn(120);
        rv.visitVarInsn(21, index);
        rv.visitInsn(90);
        rv.visitLdcInsn((Object)bitShift);
        rv.visitInsn(124);
        rv.visitInsn(128);
        rv.visitVarInsn(54, index);
    }

    private static JitType.MpIntJitType generateMpIntSubPiece(JitCodeGenerator gen, JitSubPieceOp op, JitType.MpIntJitType type, MethodVisitor mv) {
        JitType.MpIntJitType outMpType = JitType.MpIntJitType.forSize(op.out().size());
        int outLegCount = outMpType.legsAlloc();
        int legsLeft = type.legsAlloc();
        int popCount = op.offset() / 4;
        int byteShift = op.offset() % 4;
        for (int i = 0; i < popCount; ++i) {
            mv.visitInsn(87);
            --legsLeft;
        }
        JitAllocationModel am = gen.getAllocationModel();
        try (JitAllocationModel.JvmTempAlloc subpieces = am.allocateTemp(mv, "subpiece", outLegCount);){
            int i;
            for (i = 0; i < outLegCount; ++i) {
                mv.visitVarInsn(54, subpieces.idx(i));
                --legsLeft;
            }
            if (byteShift > 0) {
                int curLeg = outLegCount - 1;
                if (legsLeft > 0) {
                    SubPieceOpGen.generateShiftWithPrevLeg(mv, byteShift * 8, subpieces.idx(curLeg));
                    --legsLeft;
                    --curLeg;
                } else {
                    mv.visitVarInsn(21, subpieces.idx(curLeg));
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)(byteShift * 8));
                    mv.visitInsn(124);
                    mv.visitVarInsn(54, subpieces.idx(curLeg));
                    --curLeg;
                }
                while (curLeg >= 0) {
                    SubPieceOpGen.generateShiftWithPrevLeg(mv, byteShift * 8, subpieces.idx(curLeg));
                    --legsLeft;
                    --curLeg;
                }
            }
            while (legsLeft > 0) {
                mv.visitInsn(87);
                --legsLeft;
            }
            for (i = outLegCount - 1; i >= 0; --i) {
                mv.visitVarInsn(21, subpieces.idx(i));
            }
        }
        return outMpType;
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitSubPieceOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        JitType vType;
        JitType jitType = vType = gen.generateValReadCode(op.u(), op.uType(), TypeConversions.Ext.ZERO);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        JitType.MpIntJitType outType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType vIType = (JitType.IntJitType)jitType2;
                rv.visitLdcInsn((Object)(op.offset() * 8));
                rv.visitInsn(124);
                yield vIType;
            }
            case 1 -> {
                JitType.LongJitType vLType = (JitType.LongJitType)jitType2;
                rv.visitLdcInsn((Object)(op.offset() * 8));
                rv.visitInsn(125);
                yield vLType;
            }
            case 2 -> {
                JitType.MpIntJitType vMpType = (JitType.MpIntJitType)jitType2;
                yield SubPieceOpGen.generateMpIntSubPiece(gen, op, vMpType, rv);
            }
            default -> throw new AssertionError();
        };
        gen.generateVarWriteCode(op.out(), outType, TypeConversions.Ext.ZERO);
    }
}

