/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public interface TypeConversions
extends Opcodes {
    public static void checkGenIntExt(JitType from, JitType.IntJitType to, Ext ext, MethodVisitor mv) {
        if (to.size() < from.size() && to.size() < 4) {
            int shamt = 32 - to.size() * 8;
            switch (ext.ordinal()) {
                case 0: {
                    mv.visitLdcInsn((Object)(-1 >>> shamt));
                    mv.visitInsn(126);
                    break;
                }
                case 1: {
                    mv.visitLdcInsn((Object)shamt);
                    mv.visitInsn(120);
                    mv.visitLdcInsn((Object)shamt);
                    mv.visitInsn(122);
                }
            }
        }
    }

    public static JitType.IntJitType generateIntToInt(JitType.IntJitType from, JitType.IntJitType to, Ext ext, MethodVisitor mv) {
        TypeConversions.checkGenIntExt(from, to, ext, mv);
        return to;
    }

    public static JitType.IntJitType generateLongToInt(JitType.LongJitType from, JitType.IntJitType to, Ext ext, MethodVisitor mv) {
        mv.visitInsn(136);
        TypeConversions.checkGenIntExt(from, to, ext, mv);
        return to;
    }

    public static JitType.IntJitType generateFloatToInt(JitType.FloatJitType from, JitType.IntJitType to, MethodVisitor mv) {
        if (to.size() != from.size()) {
            throw new AssertionError((Object)"Size mismatch");
        }
        mv.visitMethodInsn(184, GenConsts.NAME_FLOAT, "floatToRawIntBits", GenConsts.MDESC_FLOAT__FLOAT_TO_RAW_INT_BITS, false);
        return to;
    }

    public static JitType.IntJitType generateMpIntToInt(JitType.MpIntJitType from, JitType.IntJitType to, Ext ext, MethodVisitor mv) {
        if (to.size() == from.size()) {
            return to;
        }
        for (int i = 1; i < from.legsAlloc(); ++i) {
            mv.visitInsn(95);
            mv.visitInsn(87);
        }
        TypeConversions.checkGenIntExt(from, to, ext, mv);
        return to;
    }

    public static JitType.IntJitType generateToInt(JitType from, JitType.IntJitType to, Ext ext, MethodVisitor mv) {
        JitType jitType = from;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType iFrom = (JitType.IntJitType)jitType2;
                yield TypeConversions.generateIntToInt(iFrom, to, ext, mv);
            }
            case 1 -> {
                JitType.LongJitType lFrom = (JitType.LongJitType)jitType2;
                yield TypeConversions.generateLongToInt(lFrom, to, ext, mv);
            }
            case 2 -> {
                JitType.FloatJitType fFrom = (JitType.FloatJitType)jitType2;
                yield TypeConversions.generateFloatToInt(fFrom, to, mv);
            }
            case 3 -> {
                JitType.DoubleJitType dFrom = (JitType.DoubleJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 4 -> {
                JitType.MpIntJitType mpFrom = (JitType.MpIntJitType)jitType2;
                yield TypeConversions.generateMpIntToInt(mpFrom, to, ext, mv);
            }
            default -> throw new AssertionError();
        };
    }

    public static void checkGenLongExt(JitType from, JitType.LongJitType to, Ext ext, MethodVisitor mv) {
        if (to.size() < from.size()) {
            int shamt = 64 - to.size() * 8;
            switch (ext.ordinal()) {
                case 0: {
                    mv.visitLdcInsn((Object)(-1L >>> shamt));
                    mv.visitInsn(127);
                    break;
                }
                case 1: {
                    mv.visitLdcInsn((Object)shamt);
                    mv.visitInsn(89);
                    mv.visitInsn(121);
                    mv.visitInsn(123);
                }
            }
        }
    }

    public static JitType.LongJitType generateIntToLong(JitType.IntJitType from, JitType.LongJitType to, Ext ext, MethodVisitor mv) {
        switch (ext.ordinal()) {
            case 0: {
                mv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "toUnsignedLong", GenConsts.MDESC_INTEGER__TO_UNSIGNED_LONG, false);
                break;
            }
            case 1: {
                TypeConversions.generateSExt(from, mv);
                mv.visitInsn(133);
            }
        }
        TypeConversions.checkGenLongExt(from, to, ext, mv);
        return to;
    }

    public static JitType.LongJitType generateLongToLong(JitType.LongJitType from, JitType.LongJitType to, Ext ext, MethodVisitor mv) {
        TypeConversions.checkGenLongExt(from, to, ext, mv);
        return to;
    }

    public static JitType.LongJitType generateDoubleToLong(JitType.DoubleJitType from, JitType.LongJitType to, MethodVisitor mv) {
        if (to.size() != from.size()) {
            throw new AssertionError((Object)"Size mismatch");
        }
        mv.visitMethodInsn(184, GenConsts.NAME_DOUBLE, "doubleToRawLongBits", GenConsts.MDESC_DOUBLE__DOUBLE_TO_RAW_LONG_BITS, false);
        return to;
    }

    public static JitType.LongJitType generateMpIntToLong(JitType.MpIntJitType from, JitType.LongJitType to, Ext ext, MethodVisitor mv) {
        if (from.legsAlloc() == 1) {
            TypeConversions.generateIntToLong(JitType.IntJitType.forSize(from.size()), to, ext, mv);
            return to;
        }
        for (int i = 2; i < from.legsAlloc(); ++i) {
            mv.visitInsn(93);
            mv.visitInsn(88);
            mv.visitInsn(87);
        }
        mv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "conv2IntToLong", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CONV_OFFSET2_TO_LONG, true);
        return to;
    }

    public static JitType.LongJitType generateToLong(JitType from, JitType.LongJitType to, Ext ext, MethodVisitor mv) {
        JitType jitType = from;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType iFrom = (JitType.IntJitType)jitType2;
                yield TypeConversions.generateIntToLong(iFrom, to, ext, mv);
            }
            case 1 -> {
                JitType.LongJitType lFrom = (JitType.LongJitType)jitType2;
                yield TypeConversions.generateLongToLong(lFrom, to, ext, mv);
            }
            case 2 -> {
                JitType.FloatJitType fFrom = (JitType.FloatJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 3 -> {
                JitType.DoubleJitType dFrom = (JitType.DoubleJitType)jitType2;
                yield TypeConversions.generateDoubleToLong(dFrom, to, mv);
            }
            case 4 -> {
                JitType.MpIntJitType mpFrom = (JitType.MpIntJitType)jitType2;
                yield TypeConversions.generateMpIntToLong(mpFrom, to, ext, mv);
            }
            default -> throw new AssertionError();
        };
    }

    public static JitType.FloatJitType generateIntToFloat(JitType.IntJitType from, JitType.FloatJitType to, MethodVisitor mv) {
        if (to.size() != from.size()) {
            throw new AssertionError((Object)"Size mismatch");
        }
        mv.visitMethodInsn(184, GenConsts.NAME_FLOAT, "intBitsToFloat", GenConsts.MDESC_FLOAT__INT_BITS_TO_FLOAT, false);
        return to;
    }

    public static JitType.FloatJitType generateToFloat(JitType from, JitType.FloatJitType to, MethodVisitor mv) {
        JitType jitType = from;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType iFrom = (JitType.IntJitType)jitType2;
                yield TypeConversions.generateIntToFloat(iFrom, to, mv);
            }
            case 1 -> {
                JitType.LongJitType lFrom = (JitType.LongJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 2 -> {
                JitType.FloatJitType fFrom = (JitType.FloatJitType)jitType2;
                yield to;
            }
            case 3 -> {
                JitType.DoubleJitType dFrom = (JitType.DoubleJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 4 -> {
                JitType.MpIntJitType mpFrom = (JitType.MpIntJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            default -> throw new AssertionError();
        };
    }

    public static JitType.DoubleJitType generateLongToDouble(JitType.LongJitType from, JitType.DoubleJitType to, MethodVisitor mv) {
        if (to.size() != from.size()) {
            throw new AssertionError((Object)"Size mismatch");
        }
        mv.visitMethodInsn(184, GenConsts.NAME_DOUBLE, "longBitsToDouble", GenConsts.MDESC_DOUBLE__LONG_BITS_TO_DOUBLE, false);
        return to;
    }

    public static JitType.DoubleJitType generateToDouble(JitType from, JitType.DoubleJitType to, MethodVisitor mv) {
        JitType jitType = from;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType iFrom = (JitType.IntJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 1 -> {
                JitType.LongJitType lFrom = (JitType.LongJitType)jitType2;
                yield TypeConversions.generateLongToDouble(lFrom, to, mv);
            }
            case 2 -> {
                JitType.FloatJitType fFrom = (JitType.FloatJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 3 -> {
                JitType.DoubleJitType dFrom = (JitType.DoubleJitType)jitType2;
                yield to;
            }
            case 4 -> {
                JitType.MpIntJitType mpFrom = (JitType.MpIntJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            default -> throw new AssertionError();
        };
    }

    public static JitType.MpIntJitType generateIntToMpInt(JitType.IntJitType from, JitType.MpIntJitType to, Ext ext, MethodVisitor mv) {
        if (to.legsAlloc() == 1) {
            TypeConversions.checkGenIntExt(from, JitType.IntJitType.forSize(to.size()), ext, mv);
            return to;
        }
        switch (ext.ordinal()) {
            case 0: {
                mv.visitLdcInsn((Object)0);
                break;
            }
            case 1: {
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)31);
                mv.visitInsn(122);
            }
        }
        for (int i = 1; i < to.legsAlloc() - 1; ++i) {
            mv.visitInsn(90);
        }
        mv.visitInsn(95);
        return to;
    }

    public static JitType.MpIntJitType generateLongToMpInt(JitCodeGenerator gen, JitType.LongJitType from, JitType.MpIntJitType to, Ext ext, MethodVisitor mv) {
        if (to.legsAlloc() == 1) {
            mv.visitInsn(136);
            TypeConversions.checkGenIntExt(from, JitType.IntJitType.forSize(to.size()), ext, mv);
            return to;
        }
        if (from.size() <= 4) {
            mv.visitInsn(136);
            TypeConversions.generateIntToMpInt(JitType.IntJitType.forSize(from.size()), to, ext, mv);
            return to;
        }
        mv.visitInsn(92);
        mv.visitLdcInsn((Object)32);
        mv.visitInsn(125);
        mv.visitInsn(136);
        if (to.size() < 8) {
            TypeConversions.checkGenIntExt(JitType.IntJitType.forSize(from.size() - 4), JitType.IntJitType.forSize(to.size() - 4), ext, mv);
        }
        int tempCount = switch (ext.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0;
            case 1 -> 1;
        };
        try (JitAllocationModel.JvmTempAlloc sign = gen.getAllocationModel().allocateTemp(mv, "sign", tempCount);){
            switch (ext.ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)31);
                    mv.visitInsn(122);
                    mv.visitVarInsn(54, sign.idx(0));
                }
            }
            mv.visitInsn(91);
            mv.visitInsn(87);
            mv.visitInsn(136);
            if (to.legsAlloc() > 2) {
                switch (ext.ordinal()) {
                    case 0: {
                        mv.visitLdcInsn((Object)0);
                        break;
                    }
                    case 1: {
                        mv.visitVarInsn(21, sign.idx(0));
                    }
                }
                for (int i = 2; i < to.legsAlloc(); ++i) {
                    mv.visitInsn(91);
                }
                mv.visitInsn(87);
            }
        }
        return to;
    }

    public static JitType.MpIntJitType generateMpIntToMpInt(JitCodeGenerator gen, JitType.MpIntJitType from, JitType.MpIntJitType to, Ext ext, MethodVisitor mv) {
        if (to.size() == from.size()) {
            return to;
        }
        if (to.legsAlloc() == 1) {
            TypeConversions.generateMpIntToInt(from, JitType.IntJitType.forSize(to.size()), ext, mv);
            return to;
        }
        if (from.legsAlloc() == 1) {
            TypeConversions.generateIntToMpInt(JitType.IntJitType.forSize(from.size()), to, ext, mv);
            return to;
        }
        int legsIn = from.legsAlloc();
        int legsOut = to.legsAlloc();
        int localsCount = Integer.min(legsIn, legsOut);
        try (JitAllocationModel.JvmTempAlloc temp = gen.getAllocationModel().allocateTemp(mv, "temp", localsCount);){
            int i;
            for (int i2 = 0; i2 < localsCount; ++i2) {
                mv.visitVarInsn(54, temp.idx(i2));
            }
            int toAdd = legsOut - legsIn;
            if (toAdd >= 1) {
                switch (ext.ordinal()) {
                    case 0: {
                        mv.visitLdcInsn((Object)0);
                        break;
                    }
                    case 1: {
                        mv.visitVarInsn(21, temp.idx(localsCount - 1));
                        mv.visitLdcInsn((Object)31);
                        mv.visitInsn(122);
                    }
                }
            }
            for (int i3 = 1; i3 < toAdd; ++i3) {
                mv.visitInsn(89);
            }
            int toRemove = -toAdd;
            for (i = 0; i < toRemove; ++i) {
                mv.visitInsn(87);
            }
            mv.visitVarInsn(21, temp.idx(localsCount - 1));
            if (to.size() < from.size()) {
                TypeConversions.checkGenIntExt(from, JitType.IntJitType.forSize(to.partialSize()), ext, mv);
            }
            for (i = 1; i < localsCount; ++i) {
                mv.visitVarInsn(21, temp.idx(localsCount - i - 1));
            }
        }
        return to;
    }

    public static JitType.MpIntJitType generateToMpInt(JitCodeGenerator gen, JitType from, JitType.MpIntJitType to, Ext ext, MethodVisitor mv) {
        JitType jitType = from;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType iFrom = (JitType.IntJitType)jitType2;
                yield TypeConversions.generateIntToMpInt(iFrom, to, ext, mv);
            }
            case 1 -> {
                JitType.LongJitType lFrom = (JitType.LongJitType)jitType2;
                yield TypeConversions.generateLongToMpInt(gen, lFrom, to, ext, mv);
            }
            case 2 -> {
                JitType.FloatJitType fFrom = (JitType.FloatJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 3 -> {
                JitType.DoubleJitType dFrom = (JitType.DoubleJitType)jitType2;
                throw new AssertionError((Object)"Size mismatch");
            }
            case 4 -> {
                JitType.MpIntJitType mpFrom = (JitType.MpIntJitType)jitType2;
                yield TypeConversions.generateMpIntToMpInt(gen, mpFrom, to, ext, mv);
            }
            default -> throw new AssertionError();
        };
    }

    public static JitType generate(JitCodeGenerator gen, JitType from, JitType to, Ext ext, MethodVisitor mv) {
        JitType jitType = to;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType iTo = (JitType.IntJitType)jitType2;
                yield TypeConversions.generateToInt(from, iTo, ext, mv);
            }
            case 1 -> {
                JitType.LongJitType lTo = (JitType.LongJitType)jitType2;
                yield TypeConversions.generateToLong(from, lTo, ext, mv);
            }
            case 2 -> {
                JitType.FloatJitType fTo = (JitType.FloatJitType)jitType2;
                yield TypeConversions.generateToFloat(from, fTo, mv);
            }
            case 3 -> {
                JitType.DoubleJitType dTo = (JitType.DoubleJitType)jitType2;
                yield TypeConversions.generateToDouble(from, dTo, mv);
            }
            case 4 -> {
                JitType.MpIntJitType mpTo = (JitType.MpIntJitType)jitType2;
                yield TypeConversions.generateToMpInt(gen, from, mpTo, ext, mv);
            }
            default -> throw new AssertionError();
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateIntToBool(JitType from, MethodVisitor mv) {
        JitType jitType = from;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType iFrom = (JitType.IntJitType)jitType2;
                return;
            }
            case 1: {
                JitType.LongJitType lFrom = (JitType.LongJitType)jitType2;
                mv.visitLdcInsn((Object)0L);
                mv.visitInsn(148);
                return;
            }
            case 2: {
                int i;
                int size;
                JitType.MpIntJitType mpIntJitType = (JitType.MpIntJitType)jitType2;
                try {
                    int n2;
                    size = n2 = mpIntJitType.size();
                    i = 0;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (i < size - 4) {
                    mv.visitInsn(128);
                    i += 4;
                }
                return;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generatePop(JitType type, MethodVisitor mv) {
        JitType jitType = type;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class, JitType.MpFloatJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType iType = (JitType.IntJitType)jitType2;
                mv.visitInsn(87);
                return;
            }
            case 1: {
                JitType.LongJitType lType = (JitType.LongJitType)jitType2;
                mv.visitInsn(88);
                return;
            }
            case 2: {
                JitType.FloatJitType fType = (JitType.FloatJitType)jitType2;
                mv.visitInsn(87);
                return;
            }
            case 3: {
                JitType.DoubleJitType dType = (JitType.DoubleJitType)jitType2;
                mv.visitInsn(88);
                return;
            }
            case 4: {
                int i;
                int size;
                JitType.MpIntJitType mpIntJitType = (JitType.MpIntJitType)jitType2;
                try {
                    int n2;
                    size = n2 = mpIntJitType.size();
                    i = 0;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (i < size) {
                    mv.visitInsn(87);
                    i += 4;
                }
                return;
            }
            case 5: {
                JitType.MpFloatJitType mpFloatJitType = (JitType.MpFloatJitType)jitType2;
                {
                    int n3;
                    int size = n3 = mpFloatJitType.size();
                }
                Unfinished.TODO((String)"MpFloat", (Object[])new Object[0]);
                return;
            }
        }
        throw new AssertionError();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateLdcTrue(JitType type, MethodVisitor mv) {
        JitType jitType = type;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType iType = (JitType.IntJitType)jitType2;
                mv.visitLdcInsn((Object)1);
                return;
            }
            case 1: {
                JitType.LongJitType lType = (JitType.LongJitType)jitType2;
                mv.visitLdcInsn((Object)1L);
                return;
            }
            case 2: {
                int i;
                int size;
                JitType.MpIntJitType mpIntJitType = (JitType.MpIntJitType)jitType2;
                try {
                    int n2;
                    size = n2 = mpIntJitType.size();
                    i = 0;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (true) {
                    if (i >= size - 4) {
                        mv.visitLdcInsn((Object)1);
                        return;
                    }
                    mv.visitLdcInsn((Object)0);
                    i += 4;
                }
            }
        }
        throw new AssertionError();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateLdcFalse(JitType type, MethodVisitor mv) {
        JitType jitType = type;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType iType = (JitType.IntJitType)jitType2;
                mv.visitLdcInsn((Object)0);
                return;
            }
            case 1: {
                JitType.LongJitType lType = (JitType.LongJitType)jitType2;
                mv.visitLdcInsn((Object)0L);
                return;
            }
            case 2: {
                int i;
                int size;
                JitType.MpIntJitType mpIntJitType = (JitType.MpIntJitType)jitType2;
                try {
                    int n2;
                    size = n2 = mpIntJitType.size();
                    i = 0;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (i < size) {
                    mv.visitLdcInsn((Object)0);
                    i += 4;
                }
                return;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JitType generateSExt(JitType type, MethodVisitor mv) {
        JitType jitType = type;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class}, (Object)jitType2, n)) {
            case 0: {
                int shamt;
                JitType.IntJitType intJitType = (JitType.IntJitType)jitType2;
                try {
                    int n2;
                    int size = n2 = intJitType.size();
                    shamt = 32 - size * 8;
                    if (shamt == 0) return type.ext();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                mv.visitLdcInsn((Object)shamt);
                mv.visitInsn(120);
                mv.visitLdcInsn((Object)shamt);
                mv.visitInsn(122);
                return type.ext();
            }
            case 1: {
                int shamt;
                JitType.LongJitType longJitType = (JitType.LongJitType)jitType2;
                {
                    int n3;
                    int size = n3 = longJitType.size();
                    shamt = 64 - size * 8;
                    if (shamt == 0) return type.ext();
                }
                mv.visitLdcInsn((Object)shamt);
                mv.visitInsn(121);
                mv.visitLdcInsn((Object)shamt);
                mv.visitInsn(123);
                return type.ext();
            }
        }
        throw new AssertionError();
    }

    public static JitType forceUniform(JitCodeGenerator gen, JitType myType, JitType otherType, Ext ext, MethodVisitor mv) {
        JitType jitType = myType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0 -> {
                JitType.IntJitType mt = (JitType.IntJitType)jitType2;
                JitType v1 = otherType;
                Objects.requireNonNull(v1);
                JitType var11_8 = v1;
                int var12_10 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var11_8, var12_10)) {
                    case 0: {
                        JitType.IntJitType ot = (JitType.IntJitType)var11_8;
                        yield mt;
                    }
                    case 1: {
                        JitType.LongJitType ot = (JitType.LongJitType)var11_8;
                        yield TypeConversions.generateIntToLong(mt, ot, ext, mv);
                    }
                    case 2: {
                        JitType.MpIntJitType ot = (JitType.MpIntJitType)var11_8;
                        yield TypeConversions.generateIntToMpInt(mt, ot, ext, mv);
                    }
                }
                throw new AssertionError();
            }
            case 1 -> {
                JitType.LongJitType mt = (JitType.LongJitType)jitType2;
                JitType v3 = otherType;
                Objects.requireNonNull(v3);
                JitType var15_15 = v3;
                int var16_17 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var15_15, var16_17)) {
                    case 0: {
                        JitType.IntJitType ot = (JitType.IntJitType)var15_15;
                        yield mt;
                    }
                    case 1: {
                        JitType.LongJitType ot = (JitType.LongJitType)var15_15;
                        yield mt;
                    }
                    case 2: {
                        JitType.MpIntJitType ot = (JitType.MpIntJitType)var15_15;
                        yield TypeConversions.generateLongToMpInt(gen, mt, ot, ext, mv);
                    }
                }
                throw new AssertionError();
            }
            case 2 -> {
                JitType.MpIntJitType mt = (JitType.MpIntJitType)jitType2;
                JitType v4 = otherType;
                Objects.requireNonNull(v4);
                JitType var19_21 = v4;
                int var20_22 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var19_21, var20_22)) {
                    case 0: {
                        JitType.IntJitType ot = (JitType.IntJitType)var19_21;
                        yield mt;
                    }
                    case 1: {
                        JitType.LongJitType ot = (JitType.LongJitType)var19_21;
                        yield mt;
                    }
                    case 2: {
                        JitType.MpIntJitType ot = (JitType.MpIntJitType)var19_21;
                        yield TypeConversions.generateMpIntToMpInt(gen, mt, ot, ext, mv);
                    }
                }
                throw new AssertionError();
            }
            default -> throw new AssertionError();
        };
    }

    public static enum Ext {
        ZERO,
        SIGN;


        public static Ext forSigned(boolean signed) {
            return signed ? SIGN : ZERO;
        }
    }
}

