/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.pcode.Varnode;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeUtils;
import utilities.util.AnnotationUtilities;

public abstract class AnnotatedPcodeUseropLibrary<T>
implements PcodeUseropLibrary<T> {
    private static final Map<Class<?>, Set<Method>> CACHE_BY_CLASS = new HashMap();
    protected Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> ops = new HashMap<String, PcodeUseropLibrary.PcodeUseropDefinition<T>>();
    private Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> unmodifiableOps = Collections.unmodifiableMap(this.ops);

    private static Set<Method> collectDefinitions(Class<? extends AnnotatedPcodeUseropLibrary<?>> cls) {
        return AnnotationUtilities.collectAnnotatedMethods(PcodeUserop.class, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotatedPcodeUseropLibrary() {
        Set methods;
        MethodHandles.Lookup lookup = this.getMethodLookup();
        Type opType = this.getOperandType();
        Class<?> cls = this.getClass();
        Map<Class<?>, Set<Method>> map = CACHE_BY_CLASS;
        synchronized (map) {
            methods = CACHE_BY_CLASS.computeIfAbsent(cls, __ -> AnnotatedPcodeUseropLibrary.collectDefinitions(cls));
        }
        for (Method m : methods) {
            this.ops.put(m.getName(), AnnotatedPcodeUseropDefinition.create(m.getAnnotation(PcodeUserop.class), this, opType, lookup, m));
        }
    }

    protected Type getOperandType() {
        return PcodeUseropLibrary.getOperandType(this.getClass());
    }

    protected MethodHandles.Lookup getMethodLookup() {
        return MethodHandles.lookup();
    }

    @Override
    public Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> getUserops() {
        return this.unmodifiableOps;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PcodeUserop {
        public boolean variadic() default false;

        public boolean functional() default false;

        public boolean hasSideEffects() default true;

        public boolean modifiesContext() default false;

        public boolean canInline() default false;
    }

    protected static abstract class AnnotatedPcodeUseropDefinition<T>
    implements PcodeUseropLibrary.PcodeUseropDefinition<T> {
        protected final Method method;
        private final AnnotatedPcodeUseropLibrary<T> library;
        private final boolean isFunctional;
        private final boolean hasSideEffects;
        private final boolean modifiesContext;
        private final boolean canInline;
        private final MethodHandle handle;
        private int posExecutor = -1;
        private int posState = -1;
        private int posLib = -1;
        private int posOut = -1;

        protected static boolean isPrimitive(Type type) {
            Class cls;
            return type instanceof Class && (cls = (Class)type).isPrimitive();
        }

        protected static <T> AnnotatedPcodeUseropDefinition<T> create(PcodeUserop annot, AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method) {
            if (annot.variadic()) {
                return new VariadicAnnotatedPcodeUseropDefinition<T>(library, opType, lookup, method, annot);
            }
            return new FixedArgsAnnotatedPcodeUseropDefinition<T>(library, opType, lookup, method, annot);
        }

        protected static <T> T fromPrimitive(Object value, int size, PcodeArithmetic<T> arithmetic) {
            Object object = value;
            int n = 0;
            return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class}, (Object)object, n)) {
                case -1 -> null;
                case 0 -> {
                    Byte v = (Byte)object;
                    yield arithmetic.fromConst(v, size);
                }
                case 1 -> {
                    Short v = (Short)object;
                    yield arithmetic.fromConst(v, size);
                }
                case 2 -> {
                    Integer v = (Integer)object;
                    yield arithmetic.fromConst(v, size);
                }
                case 3 -> {
                    Long v = (Long)object;
                    yield arithmetic.fromConst(v, size);
                }
                case 4 -> {
                    Float v = (Float)object;
                    yield arithmetic.fromConst(v.floatValue(), size);
                }
                case 5 -> {
                    Double v = (Double)object;
                    yield arithmetic.fromConst(v, size);
                }
                case 6 -> {
                    Boolean v = (Boolean)object;
                    yield arithmetic.fromConst(v, size);
                }
                default -> value;
            });
        }

        public AnnotatedPcodeUseropDefinition(AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method, PcodeUserop annot) {
            this.initStarting();
            this.method = method;
            this.library = library;
            try {
                this.handle = lookup.unreflect(method).bindTo(library);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access " + String.valueOf(method) + " having @" + PcodeUserop.class.getSimpleName() + " annotation. Override getMethodLookup()");
            }
            Type declClsOpType = PcodeUseropLibrary.getOperandType(method.getDeclaringClass());
            Type rType = method.getGenericReturnType();
            if (!AnnotatedPcodeUseropDefinition.isPrimitive(rType) && !TypeUtils.isAssignable((Type)rType, (Type)declClsOpType) || rType == Character.TYPE) {
                throw new IllegalArgumentException("Method %s with @%s annotation must return a non-char primitive type, void, or a type assignable to %s.".formatted(method.getName(), PcodeUserop.class.getSimpleName(), declClsOpType));
            }
            Parameter[] params = method.getParameters();
            for (int i = 0; i < params.length; ++i) {
                Parameter p = params[i];
                boolean processed = ParamAnnotProc.processParameter(this, declClsOpType, i, p);
                if (processed) continue;
                this.processNonAnnotatedParameter(declClsOpType, opType, i, p);
            }
            this.initFinished();
            this.isFunctional = annot.functional();
            this.hasSideEffects = annot.hasSideEffects();
            this.modifiesContext = annot.modifiesContext();
            this.canInline = annot.canInline();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library, Varnode outVar, List<Varnode> inVars) {
            this.validateInputs(inVars);
            PcodeExecutorState<T> state = executor.getState();
            List<Object> args = Arrays.asList(new Object[this.method.getParameterCount()]);
            if (this.posExecutor != -1) {
                args.set(this.posExecutor, executor);
            }
            if (this.posState != -1) {
                args.set(this.posState, state);
            }
            if (this.posLib != -1) {
                args.set(this.posLib, library);
            }
            if (this.posOut != -1) {
                args.set(this.posOut, outVar);
            }
            this.placeInputs(executor, args, inVars);
            try {
                Object result = this.handle.invokeWithArguments(args);
                if (result != null && outVar != null) {
                    state.setVar(outVar, AnnotatedPcodeUseropDefinition.fromPrimitive(result, outVar.getSize(), executor.getArithmetic()));
                }
            }
            catch (PcodeExecutionException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new PcodeExecutionException("Error executing userop", null, e);
            }
        }

        @Override
        public boolean isFunctional() {
            return this.isFunctional;
        }

        @Override
        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        @Override
        public boolean modifiesContext() {
            return this.modifiesContext;
        }

        @Override
        public boolean canInlinePcode() {
            return this.canInline;
        }

        @Override
        public Class<?> getOutputType() {
            if (this.posOut == -1) {
                return this.method.getReturnType();
            }
            return this.method.getParameterTypes()[this.posOut];
        }

        @Override
        public Method getJavaMethod() {
            return this.method;
        }

        @Override
        public PcodeUseropLibrary<T> getDefiningLibrary() {
            return this.library;
        }

        protected void initStarting() {
        }

        protected abstract void processNonAnnotatedParameter(Type var1, Type var2, int var3, Parameter var4);

        protected void initFinished() {
        }

        protected void validateInputs(List<Varnode> inVars) throws PcodeExecutionException {
        }

        protected abstract void placeInputs(PcodeExecutor<T> var1, List<Object> var2, List<Varnode> var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpOutput {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpLibrary {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpState {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface OpExecutor {
    }

    protected static class VariadicAnnotatedPcodeUseropDefinition<T>
    extends AnnotatedPcodeUseropDefinition<T> {
        private int posIns;
        private Class<?> opRawType;

        public VariadicAnnotatedPcodeUseropDefinition(AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method, PcodeUserop annot) {
            super(library, opType, lookup, method, annot);
        }

        @Override
        protected void initStarting() {
            this.posIns = -1;
            this.opRawType = null;
        }

        @Override
        protected void processNonAnnotatedParameter(Type declClsOpType, Type opType, int i, Parameter p) {
            if (this.posIns != -1) {
                throw new IllegalArgumentException("Only one non-annotated parameter is allowed to receive the inputs");
            }
            Type pType = p.getParameterizedType();
            Type eType = TypeUtils.getArrayComponentType((Type)pType);
            if (eType == null) {
                throw new IllegalArgumentException("Variadic userop must receive inputs as " + String.valueOf(declClsOpType) + "[] or " + Varnode.class.getSimpleName() + "[]");
            }
            if (!pType.equals(Varnode[].class)) {
                if (TypeUtils.isAssignable((Type)declClsOpType, (Type)eType)) {
                    this.opRawType = TypeUtils.getRawType((Type)opType, this.getClass());
                } else {
                    throw new IllegalArgumentException("Variadic userop must receive inputs as " + String.valueOf(declClsOpType) + "[] or " + Varnode.class.getSimpleName() + "[]");
                }
            }
            this.posIns = i;
        }

        @Override
        protected void initFinished() {
            if (this.posIns == -1) {
                throw new IllegalArgumentException("Variadic userop must have a parameter for the inputs");
            }
        }

        protected Object[] readVars(PcodeExecutorState<T> state, List<Varnode> vars, PcodeExecutorStatePiece.Reason reason) {
            Object[] vals = (Object[])Array.newInstance(this.opRawType, vars.size());
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = state.getVar(vars.get(i), reason);
            }
            return vals;
        }

        @Override
        protected void placeInputs(PcodeExecutor<T> executor, List<Object> args, List<Varnode> inVars) {
            if (this.opRawType != null) {
                args.set(this.posIns, this.readVars(executor.getState(), inVars, executor.getReason()));
            } else {
                args.set(this.posIns, inVars.toArray(Varnode[]::new));
            }
        }

        @Override
        public int getInputCount() {
            return -1;
        }
    }

    protected static class FixedArgsAnnotatedPcodeUseropDefinition<T>
    extends AnnotatedPcodeUseropDefinition<T> {
        private List<UseropInputParam> paramsIn;

        public FixedArgsAnnotatedPcodeUseropDefinition(AnnotatedPcodeUseropLibrary<T> library, Type opType, MethodHandles.Lookup lookup, Method method, PcodeUserop annot) {
            super(library, opType, lookup, method, annot);
        }

        @Override
        protected void initStarting() {
            this.paramsIn = new ArrayList<UseropInputParam>();
        }

        @Override
        protected void processNonAnnotatedParameter(Type declClsOpType, Type opType, int i, Parameter p) {
            Type pType = p.getParameterizedType();
            if (TypeUtils.isAssignable(Varnode.class, (Type)pType)) {
                this.paramsIn.add(new VarnodeUseropInputParam(i));
            } else if (TypeUtils.isAssignable((Type)declClsOpType, (Type)pType)) {
                this.paramsIn.add(new TValUseropInputParam(i));
            } else if (pType == Byte.TYPE) {
                this.paramsIn.add(new ByteUseropInputParam(i));
            } else if (pType == Short.TYPE) {
                this.paramsIn.add(new ShortUseropInputParam(i));
            } else if (pType == Integer.TYPE) {
                this.paramsIn.add(new IntUseropInputParam(i));
            } else if (pType == Long.TYPE) {
                this.paramsIn.add(new LongUseropInputParam(i));
            } else if (pType == int[].class) {
                this.paramsIn.add(new IntArrayUseropInputParam(i));
            } else if (pType == Float.TYPE) {
                this.paramsIn.add(new FloatUseropInputParam(i));
            } else if (pType == Double.TYPE) {
                this.paramsIn.add(new DoubleUseropInputParam(i));
            } else if (pType == Boolean.TYPE) {
                this.paramsIn.add(new BooleanUseropInputParam(i));
            } else {
                throw new IllegalArgumentException("Input parameter %s of userop %s must be non-char primitive type, %s, or accept %s. Was %s.\n".formatted(p.getName(), this.method.getName(), Varnode.class.getSimpleName(), declClsOpType, pType));
            }
        }

        @Override
        protected void validateInputs(List<Varnode> inVars) throws PcodeExecutionException {
            if (inVars.size() != this.paramsIn.size()) {
                throw new PcodeExecutionException("Incorrect input parameter count for userop " + this.method.getName() + ". Expected " + this.paramsIn.size() + " but got " + inVars.size());
            }
        }

        @Override
        protected void placeInputs(PcodeExecutor<T> executor, List<Object> args, List<Varnode> inVars) {
            for (int i = 0; i < this.paramsIn.size(); ++i) {
                UseropInputParam ip = this.paramsIn.get(i);
                args.set(ip.position(), ip.convert(inVars.get(i), executor));
            }
        }

        @Override
        public int getInputCount() {
            return this.paramsIn.size();
        }

        record VarnodeUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                return vn;
            }
        }

        record TValUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                return state.getVar(vn, executor.getReason());
            }
        }

        record ByteUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return (byte)arithmetic.toLong(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
            }
        }

        record ShortUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return (short)arithmetic.toLong(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
            }
        }

        record IntUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return (int)arithmetic.toLong(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
            }
        }

        record LongUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return arithmetic.toLong(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
            }
        }

        record IntArrayUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                BigInteger value = arithmetic.toBigInteger(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
                int[] result = new int[(vn.getSize() + 3) / 4];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = value.intValue();
                    value = value.shiftRight(32);
                }
                return result;
            }
        }

        record FloatUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return Float.valueOf(arithmetic.toFloat(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER));
            }
        }

        record DoubleUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return arithmetic.toDouble(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
            }
        }

        record BooleanUseropInputParam(int position) implements UseropInputParam
        {
            @Override
            public <T> Object convert(Varnode vn, PcodeExecutor<T> executor) {
                PcodeExecutorState<T> state = executor.getState();
                PcodeArithmetic arithmetic = executor.getArithmetic();
                return arithmetic.isTrue(state.getVar(vn, executor.getReason()), PcodeArithmetic.Purpose.OTHER);
            }
        }

        static interface UseropInputParam {
            public int position();

            public <T> Object convert(Varnode var1, PcodeExecutor<T> var2);
        }
    }

    private static enum ParamAnnotProc {
        EXECUTOR(OpExecutor.class, new Class[]{PcodeExecutor.class}){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posExecutor;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posExecutor = pos;
            }
        }
        ,
        STATE(OpState.class, new Class[]{PcodeExecutorState.class}){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posState;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posState = pos;
            }
        }
        ,
        LIBRARY(OpLibrary.class, new Class[]{PcodeUseropLibrary.class}){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posLib;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posLib = pos;
            }
        }
        ,
        OUTPUT(OpOutput.class, new Class[]{Varnode.class, int[].class}){

            @Override
            int getPos(AnnotatedPcodeUseropDefinition<?> opdef) {
                return opdef.posOut;
            }

            @Override
            void setPos(AnnotatedPcodeUseropDefinition<?> opdef, int pos) {
                opdef.posOut = pos;
            }
        };

        private final Class<? extends Annotation> annotCls;
        private final List<Class<?>> allowedClsList;

        static boolean processParameter(AnnotatedPcodeUseropDefinition<?> opdef, Type declClsOpType, int i, Parameter p) {
            ParamAnnotProc only = null;
            for (ParamAnnotProc proc : ParamAnnotProc.values()) {
                if (!proc.hasAnnot(p)) continue;
                if (only != null) {
                    throw new IllegalArgumentException("Parameter can have at most one of " + String.valueOf(Stream.of(ParamAnnotProc.values()).map(pr -> "@" + pr.annotCls.getSimpleName()).collect(Collectors.toList())));
                }
                only = proc;
            }
            if (only == null) {
                return false;
            }
            only.processParameterPerAnnot(opdef, declClsOpType, i, p);
            return true;
        }

        private ParamAnnotProc(Class<? extends Annotation> annotCls, Class<?> ... paramCls) {
            this.annotCls = annotCls;
            this.allowedClsList = List.of(paramCls);
        }

        abstract int getPos(AnnotatedPcodeUseropDefinition<?> var1);

        abstract void setPos(AnnotatedPcodeUseropDefinition<?> var1, int var2);

        boolean hasAnnot(Parameter p) {
            return p.getAnnotation(this.annotCls) != null;
        }

        static Type parameterize(Class<?> paramCls, Type opType) {
            TypeVariable<Class<?>>[] typeParams = paramCls.getTypeParameters();
            if (typeParams.length == 0) {
                return paramCls;
            }
            if (typeParams.length == 1) {
                return TypeUtils.parameterize(paramCls, (Type[])new Type[]{opType});
            }
            throw new AssertionError();
        }

        String nameAllowedArgumentTypes(Type opType) {
            return this.allowedClsList.stream().map(cls -> ParamAnnotProc.parameterize(cls, opType).toString()).collect(Collectors.joining(","));
        }

        void processParameterPerAnnot(AnnotatedPcodeUseropDefinition<?> opdef, Type declClsOpType, int i, Parameter p) {
            if (this.getPos(opdef) != -1) {
                throw new IllegalArgumentException("Can only have one parameter with @" + this.annotCls.getSimpleName());
            }
            Type pType = p.getParameterizedType();
            MatchedClassWithArgs match = MatchedClassWithArgs.find(pType, this.allowedClsList);
            if (match == null) {
                throw new IllegalArgumentException("Parameter " + p.getName() + " with @" + this.annotCls.getSimpleName() + " must acccept " + this.nameAllowedArgumentTypes(declClsOpType));
            }
            if (!match.typeArgs.isEmpty()) {
                if (match.typeArgs.size() == 1) {
                    Type declMthOpType = match.typeArgs.get(match.paramCls.getTypeParameters()[0]);
                    if (!Objects.equals(declClsOpType, declMthOpType)) {
                        throw new IllegalArgumentException("Parameter " + p.getName() + " with @" + this.annotCls.getSimpleName() + " must acccept " + this.nameAllowedArgumentTypes(declClsOpType));
                    }
                } else {
                    throw new AssertionError((Object)("Internal: paramCls for @" + this.annotCls.getSimpleName() + "should only have one type parameter <T>"));
                }
            }
            this.setPos(opdef, i);
        }

        record MatchedClassWithArgs(Class<?> paramCls, Map<TypeVariable<?>, Type> typeArgs) {
            static MatchedClassWithArgs find(Type paramType, List<Class<?>> allowed) {
                for (Class<?> cls : allowed) {
                    Map typeArgs = TypeUtils.getTypeArguments((Type)paramType, cls);
                    if (typeArgs == null) continue;
                    return new MatchedClassWithArgs(cls, typeArgs);
                }
                return null;
            }
        }
    }
}

