/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class PairedPcodeExecutorStatePiece<A, L, R>
implements PcodeExecutorStatePiece<A, Pair<L, R>> {
    private final PcodeExecutorStatePiece<A, L> left;
    private final PcodeExecutorStatePiece<A, R> right;
    private final PcodeArithmetic<A> addressArithmetic;
    private final PcodeArithmetic<Pair<L, R>> arithmetic;

    public PairedPcodeExecutorStatePiece(PcodeExecutorStatePiece<A, L> left, PcodeExecutorStatePiece<A, R> right, PcodeArithmetic<A> addressArithmetic, PcodeArithmetic<Pair<L, R>> arithmetic) {
        this.left = left;
        this.right = right;
        this.addressArithmetic = addressArithmetic;
        this.arithmetic = arithmetic;
    }

    public PairedPcodeExecutorStatePiece(PcodeExecutorStatePiece<A, L> left, PcodeExecutorStatePiece<A, R> right) {
        this(left, right, left.getAddressArithmetic(), new PairedPcodeArithmetic<L, R>(left.getArithmetic(), right.getArithmetic()));
    }

    @Override
    public Language getLanguage() {
        return this.left.getLanguage();
    }

    @Override
    public PcodeArithmetic<A> getAddressArithmetic() {
        return this.addressArithmetic;
    }

    @Override
    public PcodeArithmetic<Pair<L, R>> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return Stream.of(this.left, this.right).flatMap(p -> p.streamPieces());
    }

    @Override
    public Map<Register, Pair<L, R>> getRegisterValues() {
        Map<Register, L> leftRVs = this.left.getRegisterValues();
        Map<Register, R> rightRVs = this.right.getRegisterValues();
        HashSet<Register> union = new HashSet<Register>();
        union.addAll(leftRVs.keySet());
        union.addAll(rightRVs.keySet());
        HashMap<Register, Pair<L, R>> result = new HashMap<Register, Pair<L, R>>();
        for (Register k : union) {
            result.put(k, Pair.of(leftRVs.get(k), rightRVs.get(k)));
        }
        return result;
    }

    public PairedPcodeExecutorStatePiece<A, L, R> fork(PcodeStateCallbacks cb) {
        return new PairedPcodeExecutorStatePiece<A, L, R>(this.left.fork(cb), this.right.fork(cb), this.addressArithmetic, this.arithmetic);
    }

    @Override
    public void setVar(AddressSpace space, A offset, int size, boolean quantize, Pair<L, R> val) {
        this.left.setVar(space, offset, size, quantize, val.getLeft());
        this.right.setVar(space, offset, size, quantize, val.getRight());
    }

    @Override
    public void setVarInternal(AddressSpace space, A offset, int size, Pair<L, R> val) {
        this.left.setVarInternal(space, offset, size, val.getLeft());
        this.right.setVarInternal(space, offset, size, val.getRight());
    }

    @Override
    public void setVar(AddressSpace space, long offset, int size, boolean quantize, Pair<L, R> val) {
        this.left.setVar(space, offset, size, quantize, val.getLeft());
        this.right.setVar(space, offset, size, quantize, val.getRight());
    }

    @Override
    public void setVarInternal(AddressSpace space, long offset, int size, Pair<L, R> val) {
        this.left.setVarInternal(space, offset, size, val.getLeft());
        this.right.setVarInternal(space, offset, size, val.getRight());
    }

    @Override
    public Pair<L, R> getVar(AddressSpace space, A offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return Pair.of(this.left.getVar(space, offset, size, quantize, reason), this.right.getVar(space, offset, size, quantize, reason));
    }

    @Override
    public Pair<L, R> getVarInternal(AddressSpace space, A offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return Pair.of(this.left.getVarInternal(space, offset, size, reason), this.right.getVarInternal(space, offset, size, reason));
    }

    @Override
    public Pair<L, R> getVar(AddressSpace space, long offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return Pair.of(this.left.getVar(space, offset, size, quantize, reason), this.right.getVar(space, offset, size, quantize, reason));
    }

    @Override
    public Pair<L, R> getVarInternal(AddressSpace space, long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return Pair.of(this.left.getVarInternal(space, offset, size, reason), this.right.getVarInternal(space, offset, size, reason));
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return this.left.getConcreteBuffer(address, purpose);
    }

    public PcodeExecutorStatePiece<A, L> getLeft() {
        return this.left;
    }

    public PcodeExecutorStatePiece<A, R> getRight() {
        return this.right;
    }

    @Override
    public void clear() {
        this.left.clear();
        this.right.clear();
    }
}

