# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _fec_swig
else:
    import _fec_swig

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def high_res_timer_now() -> "gr::high_res_timer_type":
    r"""high_res_timer_now() -> gr::high_res_timer_type"""
    return _fec_swig.high_res_timer_now()

def high_res_timer_now_perfmon() -> "gr::high_res_timer_type":
    r"""high_res_timer_now_perfmon() -> gr::high_res_timer_type"""
    return _fec_swig.high_res_timer_now_perfmon()

def high_res_timer_tps() -> "gr::high_res_timer_type":
    r"""high_res_timer_tps() -> gr::high_res_timer_type"""
    return _fec_swig.high_res_timer_tps()

def high_res_timer_epoch() -> "gr::high_res_timer_type":
    r"""high_res_timer_epoch() -> gr::high_res_timer_type"""
    return _fec_swig.high_res_timer_epoch()
CC_STREAMING = _fec_swig.CC_STREAMING

CC_TERMINATED = _fec_swig.CC_TERMINATED

CC_TRUNCATED = _fec_swig.CC_TRUNCATED

CC_TAILBITING = _fec_swig.CC_TAILBITING

class decision_t(object):
    r"""Proxy of C++ decision_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    t: "unsigned char *" = property(_fec_swig.decision_t_t_get, _fec_swig.decision_t_t_set, doc=r"""t : p.unsigned char""")
    w: "unsigned int *" = property(_fec_swig.decision_t_w_get, _fec_swig.decision_t_w_set, doc=r"""w : p.unsigned int""")
    s: "unsigned short *" = property(_fec_swig.decision_t_s_get, _fec_swig.decision_t_s_set, doc=r"""s : p.unsigned short""")
    c: "unsigned char *" = property(_fec_swig.decision_t_c_get, _fec_swig.decision_t_c_set, doc=r"""c : p.unsigned char""")

    def __init__(self):
        r"""__init__(decision_t self) -> decision_t"""
        _fec_swig.decision_t_swiginit(self, _fec_swig.new_decision_t())
    __swig_destroy__ = _fec_swig.delete_decision_t

# Register decision_t in _fec_swig:
_fec_swig.decision_t_swigregister(decision_t)
class metric_t(object):
    r"""Proxy of C++ metric_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    t: "unsigned char *" = property(_fec_swig.metric_t_t_get, _fec_swig.metric_t_t_set, doc=r"""t : p.unsigned char""")

    def __init__(self):
        r"""__init__(metric_t self) -> metric_t"""
        _fec_swig.metric_t_swiginit(self, _fec_swig.new_metric_t())
    __swig_destroy__ = _fec_swig.delete_metric_t

# Register metric_t in _fec_swig:
_fec_swig.metric_t_swigregister(metric_t)
class v(object):
    r"""Proxy of C++ v class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    metrics: "unsigned char *" = property(_fec_swig.v_metrics_get, _fec_swig.v_metrics_set, doc=r"""metrics : p.unsigned char""")
    old_metrics: "metric_t" = property(_fec_swig.v_old_metrics_get, _fec_swig.v_old_metrics_set, doc=r"""old_metrics : metric_t""")
    new_metrics: "metric_t" = property(_fec_swig.v_new_metrics_get, _fec_swig.v_new_metrics_set, doc=r"""new_metrics : metric_t""")
    metrics1: "metric_t" = property(_fec_swig.v_metrics1_get, _fec_swig.v_metrics1_set, doc=r"""metrics1 : metric_t""")
    metrics2: "metric_t" = property(_fec_swig.v_metrics2_get, _fec_swig.v_metrics2_set, doc=r"""metrics2 : metric_t""")
    decisions: "unsigned char *" = property(_fec_swig.v_decisions_get, _fec_swig.v_decisions_set, doc=r"""decisions : p.unsigned char""")

    def __init__(self):
        r"""__init__(v self) -> v"""
        _fec_swig.v_swiginit(self, _fec_swig.new_v())
    __swig_destroy__ = _fec_swig.delete_v

# Register v in _fec_swig:
_fec_swig.v_swigregister(v)
class generic_encoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::generic_encoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(generic_encoder_sptr self) -> generic_encoder_sptr
        __init__(generic_encoder_sptr self, generic_encoder p) -> generic_encoder_sptr
        """
        _fec_swig.generic_encoder_sptr_swiginit(self, _fec_swig.new_generic_encoder_sptr(*args))

    def __deref__(self) -> "gr::fec::generic_encoder *":
        r"""__deref__(generic_encoder_sptr self) -> generic_encoder"""
        return _fec_swig.generic_encoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_generic_encoder_sptr

    def generic_work(self, in_buffer: "void *", out_buffer: "void *") -> "void":
        r"""generic_work(generic_encoder_sptr self, void * in_buffer, void * out_buffer)"""
        return _fec_swig.generic_encoder_sptr_generic_work(self, in_buffer, out_buffer)
    base_unique_id: "int" = property(_fec_swig.generic_encoder_sptr_base_unique_id_get, _fec_swig.generic_encoder_sptr_base_unique_id_set, doc=r"""base_unique_id : int""")
    my_id: "int" = property(_fec_swig.generic_encoder_sptr_my_id_get, _fec_swig.generic_encoder_sptr_my_id_set, doc=r"""my_id : int""")

    def unique_id(self) -> "int":
        r"""unique_id(generic_encoder_sptr self) -> int"""
        return _fec_swig.generic_encoder_sptr_unique_id(self)
    d_name: "std::string" = property(_fec_swig.generic_encoder_sptr_d_name_get, _fec_swig.generic_encoder_sptr_d_name_set, doc=r"""d_name : std::string""")

    def alias(self) -> "std::string":
        r"""alias(generic_encoder_sptr self) -> std::string"""
        return _fec_swig.generic_encoder_sptr_alias(self)

    def rate(self) -> "double":
        r"""
        rate(generic_encoder_sptr self) -> double
        Returns the rate of the code. For every 1 input bit, there are r output bits, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


        This function MUST be reimplemented by the child class.
        """
        return _fec_swig.generic_encoder_sptr_rate(self)

    def get_input_size(self) -> "int":
        r"""
        get_input_size(generic_encoder_sptr self) -> int
        Returns the input size in items that the encoder object uses to encode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_encoder_sptr_get_input_size(self)

    def get_output_size(self) -> "int":
        r"""
        get_output_size(generic_encoder_sptr self) -> int
        Returns the output size in items that the encoder object produces after encoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like R*get_input_size() for a 1/R rate code.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_encoder_sptr_get_output_size(self)

    def get_input_conversion(self) -> "char const *":
        r"""
        get_input_conversion(generic_encoder_sptr self) -> char const *
        Set up a conversion type required to setup the data properly for this encoder. The encoder itself will not implement the conversion and expects an external wrapper (e.g., fec.extended_encoder) to read this value and "do the right
        thing" to format the data.


        The default behavior is 'none', which means no conversion is required. Whatever the get_input_item_size() value returns, the input is expected to conform directly to this. Generally, this means unpacked bytes.


        If 'pack', the block expects the inputs to be packed bytes. The wrapper should implement a gr::blocks::pack_k_bits_bb(8) block for this.


        The child class MAY implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_encoder_sptr_get_input_conversion(self)

    def get_output_conversion(self) -> "char const *":
        r"""
        get_output_conversion(generic_encoder_sptr self) -> char const *
        Set up a conversion type required to understand the output style of this encoder. Generally an encoder will produce unpacked bytes with a bit set in the LSB.


        The default behavior is 'none', which means no conversion is required and the encoder produces unpacked bytes.


        If 'packed_bits', the block produces packed bits and the wrapper should unpack these (using, for instance, gr::block::unpack_k_bits_bb(8)).


        The child class MAY implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_encoder_sptr_get_output_conversion(self)

    def set_frame_size(self, frame_size: "unsigned int") -> "bool":
        r"""
        set_frame_size(generic_encoder_sptr self, unsigned int frame_size) -> bool
        Updates the size of the frame to encode.


        The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.
        """
        return _fec_swig.generic_encoder_sptr_set_frame_size(self, frame_size)

# Register generic_encoder_sptr in _fec_swig:
_fec_swig.generic_encoder_sptr_swigregister(generic_encoder_sptr)
class generic_decoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::generic_decoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(generic_decoder_sptr self) -> generic_decoder_sptr
        __init__(generic_decoder_sptr self, generic_decoder p) -> generic_decoder_sptr
        """
        _fec_swig.generic_decoder_sptr_swiginit(self, _fec_swig.new_generic_decoder_sptr(*args))

    def __deref__(self) -> "gr::fec::generic_decoder *":
        r"""__deref__(generic_decoder_sptr self) -> generic_decoder"""
        return _fec_swig.generic_decoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_generic_decoder_sptr

    def generic_work(self, inbuffer: "void *", outbuffer: "void *") -> "void":
        r"""generic_work(generic_decoder_sptr self, void * inbuffer, void * outbuffer)"""
        return _fec_swig.generic_decoder_sptr_generic_work(self, inbuffer, outbuffer)
    base_unique_id: "int" = property(_fec_swig.generic_decoder_sptr_base_unique_id_get, _fec_swig.generic_decoder_sptr_base_unique_id_set, doc=r"""base_unique_id : int""")
    my_id: "int" = property(_fec_swig.generic_decoder_sptr_my_id_get, _fec_swig.generic_decoder_sptr_my_id_set, doc=r"""my_id : int""")

    def unique_id(self) -> "int":
        r"""unique_id(generic_decoder_sptr self) -> int"""
        return _fec_swig.generic_decoder_sptr_unique_id(self)
    d_name: "std::string" = property(_fec_swig.generic_decoder_sptr_d_name_get, _fec_swig.generic_decoder_sptr_d_name_set, doc=r"""d_name : std::string""")

    def alias(self) -> "std::string":
        r"""alias(generic_decoder_sptr self) -> std::string"""
        return _fec_swig.generic_decoder_sptr_alias(self)

    def rate(self) -> "double":
        r"""
        rate(generic_decoder_sptr self) -> double
        Returns the rate of the code. For every r input bits, there is 1 output bit, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


        This function MUST be reimplemented by the child class.
        """
        return _fec_swig.generic_decoder_sptr_rate(self)

    def get_input_size(self) -> "int":
        r"""
        get_input_size(generic_decoder_sptr self) -> int
        Returns the input size in items that the decoder object uses to decode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_decoder_sptr_get_input_size(self)

    def get_output_size(self) -> "int":
        r"""
        get_output_size(generic_decoder_sptr self) -> int
        Returns the output size in items that the decoder object produces after decoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like get_input_size()/R for a 1/R rate code.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_decoder_sptr_get_output_size(self)

    def get_history(self) -> "int":
        r"""
        get_history(generic_decoder_sptr self) -> int
        Sets up history for the decoder when the decoder is required to look ahead in the data stream in order to finish its processing.


        The child class MAY implement this function. If not reimplemented, it returns 0.
        """
        return _fec_swig.generic_decoder_sptr_get_history(self)

    def get_shift(self) -> "float":
        r"""
        get_shift(generic_decoder_sptr self) -> float
        Some decoders require the input items to float around a particular soft value. We can set that floating value by setting this value to return some non-zero number.


        The fec.extended_decoder block will use this to create an add_const_ff block before the decoder block to adjust all input samples appropriately.


        The child class MAY implement this function. If not reimplemented, it returns 0.
        """
        return _fec_swig.generic_decoder_sptr_get_shift(self)

    def get_input_item_size(self) -> "int":
        r"""
        get_input_item_size(generic_decoder_sptr self) -> int
        Sets the size of an input item, as in the size of a char or float item.


        The child class SHOULD implement this function. If not reimplemented, it returns sizeof(float) as the decoders typically expect floating point input types.
        """
        return _fec_swig.generic_decoder_sptr_get_input_item_size(self)

    def get_output_item_size(self) -> "int":
        r"""
        get_output_item_size(generic_decoder_sptr self) -> int
        Sets the size of an output item, as in the size of a char or float item.


        The child class SHOULD implement this function. If not reimplemented, it returns sizeof(char) as the decoders typically expect to produce bits or bytes.
        """
        return _fec_swig.generic_decoder_sptr_get_output_item_size(self)

    def get_input_conversion(self) -> "char const *":
        r"""
        get_input_conversion(generic_decoder_sptr self) -> char const *
        Set up a conversion type required to setup the data properly for this decoder. The decoder itself will not implement the conversion and expects an external wrapper (e.g., fec.extended_decoder) to read this value and "do the right
        thing" to format the data.


        The default behavior is 'none', which means no conversion is required. Whatever the get_input_item_size() value returns, the input is expected to conform directly to this.


        This may also return 'uchar', which indicates that the wrapper should convert the standard float samples to unsigned characters, either hard sliced or 8-bit soft symbols. See gr::fec::code::cc_decoder as an example decoder that uses this conversion format.


        If 'packed_bits', the block expects the inputs to be packed hard bits. Each input item is a unsigned char where each of the 8-bits is a hard bit value.


        The child class SHOULD implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_decoder_sptr_get_input_conversion(self)

    def get_output_conversion(self) -> "char const *":
        r"""
        get_output_conversion(generic_decoder_sptr self) -> char const *
        Set up a conversion type required to understand the output style of this decoder. Generally, follow-on processing expects unpacked bits, so we specify the conversion type here to indicate what the wrapper (e.g., fec.extended_decoder) should do to convert the output samples from the decoder into unpacked bits.


        The default behavior is 'none', which means no conversion is required. This should mean that the output data is produced from this decoder as unpacked bit.


        If 'unpack', the block produces packed bytes that should be unpacked by the wrapper. See gr::fec::code::ccsds_decoder as an example of a decoder that produces packed bytes.


        The child class SHOULD implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_decoder_sptr_get_output_conversion(self)

    def set_frame_size(self, frame_size: "unsigned int") -> "bool":
        r"""
        set_frame_size(generic_decoder_sptr self, unsigned int frame_size) -> bool
        Updates the size of a decoded frame.


        The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.
        """
        return _fec_swig.generic_decoder_sptr_set_frame_size(self, frame_size)

    def get_iterations(self) -> "float":
        r"""
        get_iterations(generic_decoder_sptr self) -> float
        Get repetitions to decode.


        The child class should implement this function and return the number of iterations required to decode.
        """
        return _fec_swig.generic_decoder_sptr_get_iterations(self)

# Register generic_decoder_sptr in _fec_swig:
_fec_swig.generic_decoder_sptr_swigregister(generic_decoder_sptr)
class generic_decoder(object):
    r"""
    Parent class for FECAPI objects.

    Parent of a decoder variable class for FECAPI that will fit into the gr::fec::decoder block to handle FEC decoding. This class provides the basic information required to fit into the FECAPI structure. It provides information about input and output data types, potential data conversions, and a few other parameters useful to establish the decoder's behavior.


    We create objects from FECAPI-derived classes to go into the actual GNU Radio decoder block. Each object contains its own state and so there should be a one-to-one mapping of an FECAPI object and a GR decoder block. Sharing these objects is not guaranteed to be thread-safe.


    This is a pure virtual class and must be derived from by a child class.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def generic_work(self, inbuffer: "void *", outbuffer: "void *") -> "void":
        r"""generic_work(generic_decoder self, void * inbuffer, void * outbuffer)"""
        return _fec_swig.generic_decoder_generic_work(self, inbuffer, outbuffer)
    base_unique_id = property(_fec_swig.generic_decoder_base_unique_id_get, _fec_swig.generic_decoder_base_unique_id_set, doc=r"""base_unique_id : int""")
    my_id: "int" = property(_fec_swig.generic_decoder_my_id_get, _fec_swig.generic_decoder_my_id_set, doc=r"""my_id : int""")

    def unique_id(self) -> "int":
        r"""unique_id(generic_decoder self) -> int"""
        return _fec_swig.generic_decoder_unique_id(self)
    d_name: "std::string" = property(_fec_swig.generic_decoder_d_name_get, _fec_swig.generic_decoder_d_name_set, doc=r"""d_name : std::string""")

    def alias(self) -> "std::string":
        r"""alias(generic_decoder self) -> std::string"""
        return _fec_swig.generic_decoder_alias(self)
    __swig_destroy__ = _fec_swig.delete_generic_decoder

    def rate(self) -> "double":
        r"""
        rate(generic_decoder self) -> double
        Returns the rate of the code. For every r input bits, there is 1 output bit, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


        This function MUST be reimplemented by the child class.
        """
        return _fec_swig.generic_decoder_rate(self)

    def get_input_size(self) -> "int":
        r"""
        get_input_size(generic_decoder self) -> int
        Returns the input size in items that the decoder object uses to decode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_decoder_get_input_size(self)

    def get_output_size(self) -> "int":
        r"""
        get_output_size(generic_decoder self) -> int
        Returns the output size in items that the decoder object produces after decoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like get_input_size()/R for a 1/R rate code.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_decoder_get_output_size(self)

    def get_history(self) -> "int":
        r"""
        get_history(generic_decoder self) -> int
        Sets up history for the decoder when the decoder is required to look ahead in the data stream in order to finish its processing.


        The child class MAY implement this function. If not reimplemented, it returns 0.
        """
        return _fec_swig.generic_decoder_get_history(self)

    def get_shift(self) -> "float":
        r"""
        get_shift(generic_decoder self) -> float
        Some decoders require the input items to float around a particular soft value. We can set that floating value by setting this value to return some non-zero number.


        The fec.extended_decoder block will use this to create an add_const_ff block before the decoder block to adjust all input samples appropriately.


        The child class MAY implement this function. If not reimplemented, it returns 0.
        """
        return _fec_swig.generic_decoder_get_shift(self)

    def get_input_item_size(self) -> "int":
        r"""
        get_input_item_size(generic_decoder self) -> int
        Sets the size of an input item, as in the size of a char or float item.


        The child class SHOULD implement this function. If not reimplemented, it returns sizeof(float) as the decoders typically expect floating point input types.
        """
        return _fec_swig.generic_decoder_get_input_item_size(self)

    def get_output_item_size(self) -> "int":
        r"""
        get_output_item_size(generic_decoder self) -> int
        Sets the size of an output item, as in the size of a char or float item.


        The child class SHOULD implement this function. If not reimplemented, it returns sizeof(char) as the decoders typically expect to produce bits or bytes.
        """
        return _fec_swig.generic_decoder_get_output_item_size(self)

    def get_input_conversion(self) -> "char const *":
        r"""
        get_input_conversion(generic_decoder self) -> char const *
        Set up a conversion type required to setup the data properly for this decoder. The decoder itself will not implement the conversion and expects an external wrapper (e.g., fec.extended_decoder) to read this value and "do the right
        thing" to format the data.


        The default behavior is 'none', which means no conversion is required. Whatever the get_input_item_size() value returns, the input is expected to conform directly to this.


        This may also return 'uchar', which indicates that the wrapper should convert the standard float samples to unsigned characters, either hard sliced or 8-bit soft symbols. See gr::fec::code::cc_decoder as an example decoder that uses this conversion format.


        If 'packed_bits', the block expects the inputs to be packed hard bits. Each input item is a unsigned char where each of the 8-bits is a hard bit value.


        The child class SHOULD implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_decoder_get_input_conversion(self)

    def get_output_conversion(self) -> "char const *":
        r"""
        get_output_conversion(generic_decoder self) -> char const *
        Set up a conversion type required to understand the output style of this decoder. Generally, follow-on processing expects unpacked bits, so we specify the conversion type here to indicate what the wrapper (e.g., fec.extended_decoder) should do to convert the output samples from the decoder into unpacked bits.


        The default behavior is 'none', which means no conversion is required. This should mean that the output data is produced from this decoder as unpacked bit.


        If 'unpack', the block produces packed bytes that should be unpacked by the wrapper. See gr::fec::code::ccsds_decoder as an example of a decoder that produces packed bytes.


        The child class SHOULD implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_decoder_get_output_conversion(self)

    def set_frame_size(self, frame_size: "unsigned int") -> "bool":
        r"""
        set_frame_size(generic_decoder self, unsigned int frame_size) -> bool
        Updates the size of a decoded frame.


        The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.
        """
        return _fec_swig.generic_decoder_set_frame_size(self, frame_size)

    def get_iterations(self) -> "float":
        r"""
        get_iterations(generic_decoder self) -> float
        Get repetitions to decode.


        The child class should implement this function and return the number of iterations required to decode.
        """
        return _fec_swig.generic_decoder_get_iterations(self)

# Register generic_decoder in _fec_swig:
_fec_swig.generic_decoder_swigregister(generic_decoder)
cvar = _fec_swig.cvar


def get_decoder_output_size(my_decoder: "generic_decoder_sptr") -> "int":
    r"""
    get_decoder_output_size(generic_decoder_sptr my_decoder) -> int
    see generic_decoder::get_output_size()
    """
    return _fec_swig.get_decoder_output_size(my_decoder)

def get_decoder_input_size(my_decoder: "generic_decoder_sptr") -> "int":
    r"""
    get_decoder_input_size(generic_decoder_sptr my_decoder) -> int
    see generic_decoder::get_input_size()
    """
    return _fec_swig.get_decoder_input_size(my_decoder)

def get_shift(my_decoder: "generic_decoder_sptr") -> "float":
    r"""
    get_shift(generic_decoder_sptr my_decoder) -> float
    see generic_decoder::get_shift()
    """
    return _fec_swig.get_shift(my_decoder)

def get_history(my_decoder: "generic_decoder_sptr") -> "int":
    r"""
    get_history(generic_decoder_sptr my_decoder) -> int
    see generic_decoder::get_history()
    """
    return _fec_swig.get_history(my_decoder)

def get_decoder_input_item_size(my_decoder: "generic_decoder_sptr") -> "int":
    r"""
    get_decoder_input_item_size(generic_decoder_sptr my_decoder) -> int
    see generic_decoder::get_input_item_size()
    """
    return _fec_swig.get_decoder_input_item_size(my_decoder)

def get_decoder_output_item_size(my_decoder: "generic_decoder_sptr") -> "int":
    r"""
    get_decoder_output_item_size(generic_decoder_sptr my_decoder) -> int
    see generic_decoder::get_output_item_size()
    """
    return _fec_swig.get_decoder_output_item_size(my_decoder)

def get_decoder_input_conversion(my_decoder: "generic_decoder_sptr") -> "char const *":
    r"""
    get_decoder_input_conversion(generic_decoder_sptr my_decoder) -> char const *
    see generic_decoder::get_input_conversion()
    """
    return _fec_swig.get_decoder_input_conversion(my_decoder)

def get_decoder_output_conversion(my_decoder: "generic_decoder_sptr") -> "char const *":
    r"""
    get_decoder_output_conversion(generic_decoder_sptr my_decoder) -> char const *
    see generic_decoder::get_output_conversion()
    """
    return _fec_swig.get_decoder_output_conversion(my_decoder)
class generic_encoder(object):
    r"""Proxy of C++ gr::fec::generic_encoder class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def generic_work(self, in_buffer: "void *", out_buffer: "void *") -> "void":
        r"""generic_work(generic_encoder self, void * in_buffer, void * out_buffer)"""
        return _fec_swig.generic_encoder_generic_work(self, in_buffer, out_buffer)
    base_unique_id = property(_fec_swig.generic_encoder_base_unique_id_get, _fec_swig.generic_encoder_base_unique_id_set, doc=r"""base_unique_id : int""")
    my_id: "int" = property(_fec_swig.generic_encoder_my_id_get, _fec_swig.generic_encoder_my_id_set, doc=r"""my_id : int""")

    def unique_id(self) -> "int":
        r"""unique_id(generic_encoder self) -> int"""
        return _fec_swig.generic_encoder_unique_id(self)
    d_name: "std::string" = property(_fec_swig.generic_encoder_d_name_get, _fec_swig.generic_encoder_d_name_set, doc=r"""d_name : std::string""")

    def alias(self) -> "std::string":
        r"""alias(generic_encoder self) -> std::string"""
        return _fec_swig.generic_encoder_alias(self)

    def rate(self) -> "double":
        r"""
        rate(generic_encoder self) -> double
        Returns the rate of the code. For every 1 input bit, there are r output bits, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


        This function MUST be reimplemented by the child class.
        """
        return _fec_swig.generic_encoder_rate(self)

    def get_input_size(self) -> "int":
        r"""
        get_input_size(generic_encoder self) -> int
        Returns the input size in items that the encoder object uses to encode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_encoder_get_input_size(self)

    def get_output_size(self) -> "int":
        r"""
        get_output_size(generic_encoder self) -> int
        Returns the output size in items that the encoder object produces after encoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like R*get_input_size() for a 1/R rate code.


        The child class MUST implement this function.
        """
        return _fec_swig.generic_encoder_get_output_size(self)

    def get_input_conversion(self) -> "char const *":
        r"""
        get_input_conversion(generic_encoder self) -> char const *
        Set up a conversion type required to setup the data properly for this encoder. The encoder itself will not implement the conversion and expects an external wrapper (e.g., fec.extended_encoder) to read this value and "do the right
        thing" to format the data.


        The default behavior is 'none', which means no conversion is required. Whatever the get_input_item_size() value returns, the input is expected to conform directly to this. Generally, this means unpacked bytes.


        If 'pack', the block expects the inputs to be packed bytes. The wrapper should implement a gr::blocks::pack_k_bits_bb(8) block for this.


        The child class MAY implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_encoder_get_input_conversion(self)

    def get_output_conversion(self) -> "char const *":
        r"""
        get_output_conversion(generic_encoder self) -> char const *
        Set up a conversion type required to understand the output style of this encoder. Generally an encoder will produce unpacked bytes with a bit set in the LSB.


        The default behavior is 'none', which means no conversion is required and the encoder produces unpacked bytes.


        If 'packed_bits', the block produces packed bits and the wrapper should unpack these (using, for instance, gr::block::unpack_k_bits_bb(8)).


        The child class MAY implement this function. If not reimplemented, it returns "none".
        """
        return _fec_swig.generic_encoder_get_output_conversion(self)

    def set_frame_size(self, frame_size: "unsigned int") -> "bool":
        r"""
        set_frame_size(generic_encoder self, unsigned int frame_size) -> bool
        Updates the size of the frame to encode.


        The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.
        """
        return _fec_swig.generic_encoder_set_frame_size(self, frame_size)
    __swig_destroy__ = _fec_swig.delete_generic_encoder

# Register generic_encoder in _fec_swig:
_fec_swig.generic_encoder_swigregister(generic_encoder)

def get_encoder_output_size(my_encoder: "generic_encoder_sptr") -> "int":
    r"""
    get_encoder_output_size(generic_encoder_sptr my_encoder) -> int
    see generic_encoder::get_output_size()
    """
    return _fec_swig.get_encoder_output_size(my_encoder)

def get_encoder_input_size(my_encoder: "generic_encoder_sptr") -> "int":
    r"""
    get_encoder_input_size(generic_encoder_sptr my_encoder) -> int
    see generic_encoder::get_input_size()
    """
    return _fec_swig.get_encoder_input_size(my_encoder)

def get_encoder_input_conversion(my_encoder: "generic_encoder_sptr") -> "char const *":
    r"""
    get_encoder_input_conversion(generic_encoder_sptr my_encoder) -> char const *
    see generic_encoder::get_input_conversion()
    """
    return _fec_swig.get_encoder_input_conversion(my_encoder)

def get_encoder_output_conversion(my_encoder: "generic_encoder_sptr") -> "char const *":
    r"""
    get_encoder_output_conversion(generic_encoder_sptr my_encoder) -> char const *
    see generic_encoder::get_output_conversion()
    """
    return _fec_swig.get_encoder_output_conversion(my_encoder)
class decoder(object):
    r"""
    General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

    This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


    Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


    See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

    Constructor Specific Documentation:

    Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

    Args:
        my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
        input_item_size : The size of the input items (often the my_decoder object can tell us this).
        output_item_size : The size of the output items (often the my_decoder object can tell us this).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(my_decoder: "generic_decoder_sptr", input_item_size: "size_t", output_item_size: "size_t") -> "gr::fec::decoder::sptr":
        r"""
        make(generic_decoder_sptr my_decoder, size_t input_item_size, size_t output_item_size) -> decoder_sptr
        General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

        This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


        Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


        See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

        Constructor Specific Documentation:

        Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

        Args:
            my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
            input_item_size : The size of the input items (often the my_decoder object can tell us this).
            output_item_size : The size of the output items (often the my_decoder object can tell us this).
        """
        return _fec_swig.decoder_make(my_decoder, input_item_size, output_item_size)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(decoder self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.decoder_general_work(self, noutput_items, ninput_items, input_items, output_items)

    def fixed_rate_ninput_to_noutput(self, ninput: "int") -> "int":
        r"""fixed_rate_ninput_to_noutput(decoder self, int ninput) -> int"""
        return _fec_swig.decoder_fixed_rate_ninput_to_noutput(self, ninput)

    def fixed_rate_noutput_to_ninput(self, noutput: "int") -> "int":
        r"""fixed_rate_noutput_to_ninput(decoder self, int noutput) -> int"""
        return _fec_swig.decoder_fixed_rate_noutput_to_ninput(self, noutput)

    def forecast(self, noutput_items: "int", ninput_items_required: "gr_vector_int &") -> "void":
        r"""forecast(decoder self, int noutput_items, gr_vector_int & ninput_items_required)"""
        return _fec_swig.decoder_forecast(self, noutput_items, ninput_items_required)
    __swig_destroy__ = _fec_swig.delete_decoder

# Register decoder in _fec_swig:
_fec_swig.decoder_swigregister(decoder)
class encoder(object):
    r"""
    Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

    Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

    Constructor Specific Documentation:

    Build the FEC encoder block from an FECAPI encoder object.

    Args:
        my_encoder : An FECAPI encoder object child of the generic_encoder class.
        input_item_size : size of a block of data for the encoder.
        output_item_size : size of a block of data the encoder will produce.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(my_encoder: "generic_encoder_sptr", input_item_size: "size_t", output_item_size: "size_t") -> "gr::fec::encoder::sptr":
        r"""
        make(generic_encoder_sptr my_encoder, size_t input_item_size, size_t output_item_size) -> encoder_sptr
        Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

        Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

        Constructor Specific Documentation:

        Build the FEC encoder block from an FECAPI encoder object.

        Args:
            my_encoder : An FECAPI encoder object child of the generic_encoder class.
            input_item_size : size of a block of data for the encoder.
            output_item_size : size of a block of data the encoder will produce.
        """
        return _fec_swig.encoder_make(my_encoder, input_item_size, output_item_size)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(encoder self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.encoder_general_work(self, noutput_items, ninput_items, input_items, output_items)

    def fixed_rate_ninput_to_noutput(self, ninput: "int") -> "int":
        r"""fixed_rate_ninput_to_noutput(encoder self, int ninput) -> int"""
        return _fec_swig.encoder_fixed_rate_ninput_to_noutput(self, ninput)

    def fixed_rate_noutput_to_ninput(self, noutput: "int") -> "int":
        r"""fixed_rate_noutput_to_ninput(encoder self, int noutput) -> int"""
        return _fec_swig.encoder_fixed_rate_noutput_to_ninput(self, noutput)

    def forecast(self, noutput_items: "int", ninput_items_required: "gr_vector_int &") -> "void":
        r"""forecast(encoder self, int noutput_items, gr_vector_int & ninput_items_required)"""
        return _fec_swig.encoder_forecast(self, noutput_items, ninput_items_required)
    __swig_destroy__ = _fec_swig.delete_encoder

# Register encoder in _fec_swig:
_fec_swig.encoder_swigregister(encoder)
class tagged_decoder(object):
    r"""
    General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

    This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


    Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


    See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

    Constructor Specific Documentation:

    Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

    Args:
        my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
        input_item_size : The size of the input items (often the my_decoder object can tell us this).
        output_item_size : The size of the output items (often the my_decoder object can tell us this).
        lengthtagname : Key name of the tagged stream frame size.
        mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::fec::tagged_decoder::sptr":
        r"""
        make(generic_decoder_sptr my_decoder, size_t input_item_size, size_t output_item_size, std::string const & lengthtagname="packet_len", int mtu=1500) -> tagged_decoder_sptr
        General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

        This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


        Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


        See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

        Constructor Specific Documentation:

        Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

        Args:
            my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
            input_item_size : The size of the input items (often the my_decoder object can tell us this).
            output_item_size : The size of the output items (often the my_decoder object can tell us this).
            lengthtagname : Key name of the tagged stream frame size.
            mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.tagged_decoder_make(*args, **kwargs)

    def work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""work(tagged_decoder self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.tagged_decoder_work(self, noutput_items, ninput_items, input_items, output_items)

    def calculate_output_stream_length(self, ninput_items: "gr_vector_int const &") -> "int":
        r"""calculate_output_stream_length(tagged_decoder self, gr_vector_int const & ninput_items) -> int"""
        return _fec_swig.tagged_decoder_calculate_output_stream_length(self, ninput_items)
    __swig_destroy__ = _fec_swig.delete_tagged_decoder

# Register tagged_decoder in _fec_swig:
_fec_swig.tagged_decoder_swigregister(tagged_decoder)
class tagged_encoder(object):
    r"""
    Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

    Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

    Constructor Specific Documentation:

    Build the FEC encoder block from an FECAPI encoder object.

    Args:
        my_encoder : An FECAPI encoder object child of the generic_encoder class.
        input_item_size : size of a block of data for the encoder.
        output_item_size : size of a block of data the encoder will produce.
        lengthtagname : Key name of the tagged stream frame size.
        mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::fec::tagged_encoder::sptr":
        r"""
        make(generic_encoder_sptr my_encoder, size_t input_item_size, size_t output_item_size, std::string const & lengthtagname="packet_len", int mtu=1500) -> tagged_encoder_sptr
        Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

        Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

        Constructor Specific Documentation:

        Build the FEC encoder block from an FECAPI encoder object.

        Args:
            my_encoder : An FECAPI encoder object child of the generic_encoder class.
            input_item_size : size of a block of data for the encoder.
            output_item_size : size of a block of data the encoder will produce.
            lengthtagname : Key name of the tagged stream frame size.
            mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.tagged_encoder_make(*args, **kwargs)

    def work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""work(tagged_encoder self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.tagged_encoder_work(self, noutput_items, ninput_items, input_items, output_items)

    def calculate_output_stream_length(self, ninput_items: "gr_vector_int const &") -> "int":
        r"""calculate_output_stream_length(tagged_encoder self, gr_vector_int const & ninput_items) -> int"""
        return _fec_swig.tagged_encoder_calculate_output_stream_length(self, ninput_items)
    __swig_destroy__ = _fec_swig.delete_tagged_encoder

# Register tagged_encoder in _fec_swig:
_fec_swig.tagged_encoder_swigregister(tagged_encoder)
class async_decoder(object):
    r"""
    Creates the decoder block for use in GNU Radio flowgraphs from a given FEC API object derived from the generic_decoder class.

    Decodes frames received as async messages over a message port. This decoder deployment expects messages of soft decision symbols in and can produce either packed, PDU messages ( = True) or messages full of unpacked bits ( = False).


    This decoder works off a full message as one frame or block to decode. The message length is used to calculate the frame length. To support this, the decoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that after being decoded.


    The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


    Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are packed. All inputs messages are one soft decision per item. By default, the  mode is set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream decoders. That is, putting the same data into both the tagged stream decoder deployment and this with the default setting should produce the same data.


    Because the block handles data as a full frame per message, this decoder deployment cannot work with any decoders that require history. For example, the gr::fec::code::cc_decoder decoder in streaming mode requires an extra rate*(K-1) bits to complete the decoding, so it would have to wait for the next message to come in and finish processing. Therefore, the streaming mode of the CC decoder is not allowed. The other three modes will work with this deployment since the frame is self-contained for decoding.

    Constructor Specific Documentation:

    Build the PDU-based FEC decoder block from an FECAPI decoder object.

    Args:
        my_decoder : An FECAPI decoder object child of the generic_decoder class.
        packed : Sets output to packed bytes if true; otherwise, 1 bit per byte.
        rev_pack : If packing bits, should they be reversed?
        mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(my_decoder: "generic_decoder_sptr", packed: "bool"=False, rev_pack: "bool"=True, mtu: "int"=1500) -> "gr::fec::async_decoder::sptr":
        r"""
        make(generic_decoder_sptr my_decoder, bool packed=False, bool rev_pack=True, int mtu=1500) -> async_decoder_sptr
        Creates the decoder block for use in GNU Radio flowgraphs from a given FEC API object derived from the generic_decoder class.

        Decodes frames received as async messages over a message port. This decoder deployment expects messages of soft decision symbols in and can produce either packed, PDU messages ( = True) or messages full of unpacked bits ( = False).


        This decoder works off a full message as one frame or block to decode. The message length is used to calculate the frame length. To support this, the decoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that after being decoded.


        The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


        Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are packed. All inputs messages are one soft decision per item. By default, the  mode is set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream decoders. That is, putting the same data into both the tagged stream decoder deployment and this with the default setting should produce the same data.


        Because the block handles data as a full frame per message, this decoder deployment cannot work with any decoders that require history. For example, the gr::fec::code::cc_decoder decoder in streaming mode requires an extra rate*(K-1) bits to complete the decoding, so it would have to wait for the next message to come in and finish processing. Therefore, the streaming mode of the CC decoder is not allowed. The other three modes will work with this deployment since the frame is self-contained for decoding.

        Constructor Specific Documentation:

        Build the PDU-based FEC decoder block from an FECAPI decoder object.

        Args:
            my_decoder : An FECAPI decoder object child of the generic_decoder class.
            packed : Sets output to packed bytes if true; otherwise, 1 bit per byte.
            rev_pack : If packing bits, should they be reversed?
            mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.async_decoder_make(my_decoder, packed, rev_pack, mtu)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(async_decoder self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.async_decoder_general_work(self, noutput_items, ninput_items, input_items, output_items)
    __swig_destroy__ = _fec_swig.delete_async_decoder

# Register async_decoder in _fec_swig:
_fec_swig.async_decoder_swigregister(async_decoder)
class async_encoder(object):
    r"""
    Creates the encoder block for use in GNU Radio flowgraphs with async message from a given FEC API object derived from the generic_encoder class.

    Encodes frames received as async messages or as a PDU over a message port. This encoder works off a full message as one frame or block to encode. The message length is used as the frame length. To support this, the encoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that.


    This deployment works off messages and expects them to either be messages full of unpacked bits or PDU messages, which means full bytes of a frame from the higher layers, including things like headers, tails, CRC check bytes, etc. For handling PDUs, set the  option of this deployment block to True. The block will then use the FEC API to properly unpack the bits from the PDU, pass it through the encoder, and repack them to output the PDUs for the next stage of processing.


    The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


    Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are unpacked and packed, where reading or writing from the LSB or MSB. By default, the  and  modes are set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream encoders. That is, putting the same data into both the tagged stream encoder deployment and this with these default settings should produce the same data.

    Constructor Specific Documentation:

    Build the PDU-based FEC encoder block from an FECAPI encoder object.

    Args:
        my_encoder : An FECAPI encoder object child of the generic_encoder class.
        packed : True if working on packed bytes (like PDUs).
        rev_unpack : Reverse the unpacking order from input bytes to bits.
        rev_pack : Reverse the packing order from bits to output bytes.
        mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(my_encoder: "generic_encoder_sptr", packed: "bool"=False, rev_unpack: "bool"=True, rev_pack: "bool"=True, mtu: "int"=1500) -> "gr::fec::async_encoder::sptr":
        r"""
        make(generic_encoder_sptr my_encoder, bool packed=False, bool rev_unpack=True, bool rev_pack=True, int mtu=1500) -> async_encoder_sptr
        Creates the encoder block for use in GNU Radio flowgraphs with async message from a given FEC API object derived from the generic_encoder class.

        Encodes frames received as async messages or as a PDU over a message port. This encoder works off a full message as one frame or block to encode. The message length is used as the frame length. To support this, the encoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that.


        This deployment works off messages and expects them to either be messages full of unpacked bits or PDU messages, which means full bytes of a frame from the higher layers, including things like headers, tails, CRC check bytes, etc. For handling PDUs, set the  option of this deployment block to True. The block will then use the FEC API to properly unpack the bits from the PDU, pass it through the encoder, and repack them to output the PDUs for the next stage of processing.


        The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


        Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are unpacked and packed, where reading or writing from the LSB or MSB. By default, the  and  modes are set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream encoders. That is, putting the same data into both the tagged stream encoder deployment and this with these default settings should produce the same data.

        Constructor Specific Documentation:

        Build the PDU-based FEC encoder block from an FECAPI encoder object.

        Args:
            my_encoder : An FECAPI encoder object child of the generic_encoder class.
            packed : True if working on packed bytes (like PDUs).
            rev_unpack : Reverse the unpacking order from input bytes to bits.
            rev_pack : Reverse the packing order from bits to output bytes.
            mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.async_encoder_make(my_encoder, packed, rev_unpack, rev_pack, mtu)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(async_encoder self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.async_encoder_general_work(self, noutput_items, ninput_items, input_items, output_items)
    __swig_destroy__ = _fec_swig.delete_async_encoder

# Register async_encoder in _fec_swig:
_fec_swig.async_encoder_swigregister(async_encoder)
class cc_decoder(generic_decoder):
    r"""
    Convolutional Code Decoding class.

    This class performs convolutional decoding via the Viterbi algorithm. While it is set up to take variable values for K, rate, and the polynomials, currently, the block is only capable of handling the following settings:



    This is the well-known convolutional part of the Voyager code implemented in the CCSDS encoder.


    The intent of having this FECAPI code classes fully parameterizable is to eventually allow it to take on generic settings, much like the cc_encoder class where the CCSDS settings would be a highly-optimized version of this.


    The decoder is set up with a number of bits per frame in the constructor. When not being used in a tagged stream mode, this encoder will only process frames of the length provided here. If used in a tagged stream block, this setting becomes the maximum allowable frame size that the block may process.


    The  is a cc_mode_t that specifies how the convolutional encoder will behave and under what conditions.






    A common convolutional encoder uses K=7, Rate=1/2, Polynomials=[109, 79]. This is the Voyager code from NASA:
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int", k: "int", rate: "int", polys: "std::vector< int,std::allocator< int > >", start_state: "int"=0, end_state: "int"=-1, mode: "cc_mode_t"=CC_STREAMING, padded: "bool"=False) -> "gr::fec::generic_decoder::sptr":
        r"""
        make(int frame_size, int k, int rate, std::vector< int,std::allocator< int > > polys, int start_state=0, int end_state=-1, cc_mode_t mode=CC_STREAMING, bool padded=False) -> generic_decoder_sptr
        Build a convolutional code decoding FEC API object.
        """
        return _fec_swig.cc_decoder_make(frame_size, k, rate, polys, start_state, end_state, mode, padded)
    __swig_destroy__ = _fec_swig.delete_cc_decoder

# Register cc_decoder in _fec_swig:
_fec_swig.cc_decoder_swigregister(cc_decoder)
class cc_encoder(generic_encoder):
    r"""
    Convolutional Code Encoding class.

    This class performs convolutional encoding for unpacked bits for frames of a constant length. This class is general in its application of the convolutional encoding and allows us to specify the constraint length, the coding rate, and the polynomials used in the coding process.


    The parameter  sets the constraint length directly. We set the coding rate by setting  to R given a desired rate of 1/R. That is, for a rate 1/2 coder, we would set  to 2. And the polynomial is specified as a vector of integers, where each integer represents the coding polynomial for a different arm of the code. The number of polynomials given must be the same as the value .


    The encoding object holds a shift register that takes in each bit from the input stream and then ANDs the shift register with each polynomial, and places the parity of the result into the output stream. The output stream is therefore also unpacked bits.


    The encoder is set up with a number of bits per frame in the constructor. When not being used in a tagged stream mode, this encoder will only process frames of the length provided here. If used in a tagged stream block, this setting becomes the maximum allowable frame size that the block may process.


    The  is a cc_mode_t that specifies how the convolutional encoder will behave and under what conditions.






    A common convolutional encoder uses K=7, Rate=1/2, and the polynomials 
    Another encoder class is provided with gr-fec called the gr::fec::code::ccsds_encoder, which implements the above code that is more highly optimized for just those specific settings.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int", k: "int", rate: "int", polys: "std::vector< int,std::allocator< int > >", start_state: "int"=0, mode: "cc_mode_t"=CC_STREAMING, padded: "bool"=False) -> "gr::fec::generic_encoder::sptr":
        r"""
        make(int frame_size, int k, int rate, std::vector< int,std::allocator< int > > polys, int start_state=0, cc_mode_t mode=CC_STREAMING, bool padded=False) -> generic_encoder_sptr
        Build a convolutional code encoding FEC API object.
        """
        return _fec_swig.cc_encoder_make(frame_size, k, rate, polys, start_state, mode, padded)
    __swig_destroy__ = _fec_swig.delete_cc_encoder

# Register cc_encoder in _fec_swig:
_fec_swig.cc_encoder_swigregister(cc_encoder)
class ccsds_encoder(generic_encoder):
    r"""
    CCSDS Encoding class for convolutional encoding with rate 1/2, K=7, and polynomials [109, 79].

    Uses Phil Karn's (KA9Q) implementation of the CCSDS encoder for rate 1/2, K=7, and CC polynomial [109, 79]. These are non-adjustable in this encoder. For an adjustable CC encoder where we can set the rate, constraint length, and polynomial, see gr::fec::code::cc_encoder.


    The encoder is set up with a number of bits per frame in the constructor. When not being used in a tagged stream mode, this encoder will only process frames of the length provided here. If used in a tagged stream block, this setting becomes the maximum allowable frame size that the block may process.


    The  is a cc_mode_t that specifies how the convolutional encoder will behave and under what conditions.






    A common convolutional encoder uses K=7, Rate=1/2, Polynomials=[109, 79]. This is the Voyager code from NASA:
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int", start_state: "int"=0, mode: "cc_mode_t"=CC_STREAMING) -> "gr::fec::generic_encoder::sptr":
        r"""
        make(int frame_size, int start_state=0, cc_mode_t mode=CC_STREAMING) -> generic_encoder_sptr
        Build the CCSDS (rate=1/2, K=7, polys=[109,79] convolutional code FECAPI object.
        """
        return _fec_swig.ccsds_encoder_make(frame_size, start_state, mode)
    __swig_destroy__ = _fec_swig.delete_ccsds_encoder

# Register ccsds_encoder in _fec_swig:
_fec_swig.ccsds_encoder_swigregister(ccsds_encoder)
class dummy_decoder(generic_decoder):
    r"""
    Dummy Decoding class.

    A dummy decoder class that simply passes the input to the output. It is meant to allow us to easily use the FEC API encoder and decoder blocks in an application with no coding.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int") -> "gr::fec::generic_decoder::sptr":
        r"""
        make(int frame_size) -> generic_decoder_sptr
        Build a dummy decoding FEC API object.
        """
        return _fec_swig.dummy_decoder_make(frame_size)
    __swig_destroy__ = _fec_swig.delete_dummy_decoder

# Register dummy_decoder in _fec_swig:
_fec_swig.dummy_decoder_swigregister(dummy_decoder)
class dummy_encoder(generic_encoder):
    r"""
    Dummy Encoding class.

    A dummy encoder class that simply passes the input to the output. It is meant to allow us to easily use the FEC API encoder and decoder blocks in an application with no coding.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int", pack: "bool"=False, packed_bits: "bool"=False) -> "gr::fec::generic_encoder::sptr":
        r"""
        make(int frame_size, bool pack=False, bool packed_bits=False) -> generic_encoder_sptr
        Build a dummy encoding FEC API object.
        """
        return _fec_swig.dummy_encoder_make(frame_size, pack, packed_bits)
    __swig_destroy__ = _fec_swig.delete_dummy_encoder

# Register dummy_encoder in _fec_swig:
_fec_swig.dummy_encoder_swigregister(dummy_encoder)
class repetition_decoder(generic_decoder):
    r"""
    Repetition Decoding class.

    A repetition decoder class. This takes a majority vote, biased by the  rate, and decides if the number of 1 bits > ap_prob, it is a 1; else, it is a 0.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int", rep: "int", ap_prob: "float"=0.5) -> "gr::fec::generic_decoder::sptr":
        r"""
        make(int frame_size, int rep, float ap_prob=0.5) -> generic_decoder_sptr
        Build a repetition decoding FEC API object.
        """
        return _fec_swig.repetition_decoder_make(frame_size, rep, ap_prob)
    __swig_destroy__ = _fec_swig.delete_repetition_decoder

# Register repetition_decoder in _fec_swig:
_fec_swig.repetition_decoder_swigregister(repetition_decoder)
class repetition_encoder(generic_encoder):
    r"""
    Repetition Encoding class.

    A repetition encoder class that repeats each input bit  times. To decode, take a majority vote over the number of repetitions.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(frame_size: "int", rep: "int") -> "gr::fec::generic_encoder::sptr":
        r"""
        make(int frame_size, int rep) -> generic_encoder_sptr
        Build a repetition encoding FEC API object.
        """
        return _fec_swig.repetition_encoder_make(frame_size, rep)
    __swig_destroy__ = _fec_swig.delete_repetition_encoder

# Register repetition_encoder in _fec_swig:
_fec_swig.repetition_encoder_swigregister(repetition_encoder)
class decode_ccsds_27_fb(object):
    r"""
    A rate 1/2, k=7 convolutional decoder for the CCSDS standard.

    This block performs soft-decision convolutional decoding using the Viterbi algorithm.


    The input is a stream of (possibly noise corrupted) floating point values nominally spanning [-1.0, 1.0], representing the encoded channel symbols 0 (-1.0) and 1 (1.0), with erased symbols at 0.0.


    The output is MSB first packed bytes of decoded values.


    As a rate 1/2 code, there will be one output byte for every 16 input symbols.


    This block is designed for continuous data streaming, not packetized data. The first 32 bits out will be zeroes, with the output delayed four bytes from the corresponding inputs.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::fec::decode_ccsds_27_fb::sptr":
        r"""
        make() -> decode_ccsds_27_fb_sptr
        A rate 1/2, k=7 convolutional decoder for the CCSDS standard.

        This block performs soft-decision convolutional decoding using the Viterbi algorithm.


        The input is a stream of (possibly noise corrupted) floating point values nominally spanning [-1.0, 1.0], representing the encoded channel symbols 0 (-1.0) and 1 (1.0), with erased symbols at 0.0.


        The output is MSB first packed bytes of decoded values.


        As a rate 1/2 code, there will be one output byte for every 16 input symbols.


        This block is designed for continuous data streaming, not packetized data. The first 32 bits out will be zeroes, with the output delayed four bytes from the corresponding inputs.

        Constructor Specific Documentation:


        """
        return _fec_swig.decode_ccsds_27_fb_make()
    __swig_destroy__ = _fec_swig.delete_decode_ccsds_27_fb

# Register decode_ccsds_27_fb in _fec_swig:
_fec_swig.decode_ccsds_27_fb_swigregister(decode_ccsds_27_fb)
class encode_ccsds_27_bb(object):
    r"""
    A rate 1/2, k=7 convolutional encoder for the CCSDS standard.

    This block performs convolutional encoding using the CCSDS standard polynomial ("Voyager").


    The input is an MSB first packed stream of bits.


    The output is a stream of symbols 0 or 1 representing the encoded data.


    As a rate 1/2 code, there will be 16 output symbols for every input byte.


    This block is designed for continuous data streaming, not packetized data. There is no provision to "flush" the encoder.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::fec::encode_ccsds_27_bb::sptr":
        r"""
        make() -> encode_ccsds_27_bb_sptr
        A rate 1/2, k=7 convolutional encoder for the CCSDS standard.

        This block performs convolutional encoding using the CCSDS standard polynomial ("Voyager").


        The input is an MSB first packed stream of bits.


        The output is a stream of symbols 0 or 1 representing the encoded data.


        As a rate 1/2 code, there will be 16 output symbols for every input byte.


        This block is designed for continuous data streaming, not packetized data. There is no provision to "flush" the encoder.

        Constructor Specific Documentation:


        """
        return _fec_swig.encode_ccsds_27_bb_make()
    __swig_destroy__ = _fec_swig.delete_encode_ccsds_27_bb

# Register encode_ccsds_27_bb in _fec_swig:
_fec_swig.encode_ccsds_27_bb_swigregister(encode_ccsds_27_bb)
class ber_bf(object):
    r"""
    BER block in FECAPI.

    This block measures the bit error rate between two streams of packed data. It compares the bits of each streams and counts the number of incorrect bits between them. It outputs the log of the bit error rate, so a value of -X is 10^{-X} bit errors.


    When the  is set to false (default), it is in streaming mode. This means that the output is constantly producing the current value of the BER. In this mode, there is a single output BER calculation per chunk of bytes passed to it, so there is no exact timing between calculations of BER. In this mode, the other two parameters to the constructor are ignored.


    When  is true, the block is in test mode. This mode is used in the ber_curve_gen example and for other offline analysis of BER curves. Here, the block waits until at least  are observed and then produces a BER calculation. The parameter  helps make sure that the simulation is controlled. If the BER calculation drops below the  setting, the block will exit and simply return the set limit; the real BER is therefore some amount lower than this.


    Note that this block takes in data as packed bytes with 8-bits per byte used. It outputs a stream of floats as the log-scale BER.

    Constructor Specific Documentation:

    Calculate the BER between two streams of data.

    Args:
        test_mode : false for normal streaming mode (default); true for test mode.
        berminerrors : the block needs to observe this many errors before outputting a result. Only valid when test_mode=true.
        ber_limit : if the BER calculation falls below this limit, produce this value and exit. Only valid when test_mode=true.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def total_errors(self) -> "long":
        r"""
        total_errors(ber_bf self) -> long
        Get total number of errors counter value.
        """
        return _fec_swig.ber_bf_total_errors(self)

    @staticmethod
    def make(test_mode: "bool"=False, berminerrors: "int"=100, ber_limit: "float"=-7.0) -> "gr::fec::ber_bf::sptr":
        r"""
        make(bool test_mode=False, int berminerrors=100, float ber_limit=-7.0) -> ber_bf_sptr
        BER block in FECAPI.

        This block measures the bit error rate between two streams of packed data. It compares the bits of each streams and counts the number of incorrect bits between them. It outputs the log of the bit error rate, so a value of -X is 10^{-X} bit errors.


        When the  is set to false (default), it is in streaming mode. This means that the output is constantly producing the current value of the BER. In this mode, there is a single output BER calculation per chunk of bytes passed to it, so there is no exact timing between calculations of BER. In this mode, the other two parameters to the constructor are ignored.


        When  is true, the block is in test mode. This mode is used in the ber_curve_gen example and for other offline analysis of BER curves. Here, the block waits until at least  are observed and then produces a BER calculation. The parameter  helps make sure that the simulation is controlled. If the BER calculation drops below the  setting, the block will exit and simply return the set limit; the real BER is therefore some amount lower than this.


        Note that this block takes in data as packed bytes with 8-bits per byte used. It outputs a stream of floats as the log-scale BER.

        Constructor Specific Documentation:

        Calculate the BER between two streams of data.

        Args:
            test_mode : false for normal streaming mode (default); true for test mode.
            berminerrors : the block needs to observe this many errors before outputting a result. Only valid when test_mode=true.
            ber_limit : if the BER calculation falls below this limit, produce this value and exit. Only valid when test_mode=true.
        """
        return _fec_swig.ber_bf_make(test_mode, berminerrors, ber_limit)
    __swig_destroy__ = _fec_swig.delete_ber_bf

# Register ber_bf in _fec_swig:
_fec_swig.ber_bf_swigregister(ber_bf)
class conv_bit_corr_bb(object):
    r"""
    Correlate block in FECAPI.

    What does this block do?

    Constructor Specific Documentation:



    Args:
        correlator : 
        corr_sym : 
        corr_len : 
        cut : 
        flush : 
        thresh : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(correlator: "std::vector< unsigned long long,std::allocator< unsigned long long > >", corr_sym: "int", corr_len: "int", cut: "int", flush: "int", thresh: "float") -> "gr::fec::conv_bit_corr_bb::sptr":
        r"""
        make(std::vector< unsigned long long,std::allocator< unsigned long long > > correlator, int corr_sym, int corr_len, int cut, int flush, float thresh) -> conv_bit_corr_bb_sptr
        Correlate block in FECAPI.

        What does this block do?

        Constructor Specific Documentation:



        Args:
            correlator : 
            corr_sym : 
            corr_len : 
            cut : 
            flush : 
            thresh : 
        """
        return _fec_swig.conv_bit_corr_bb_make(correlator, corr_sym, corr_len, cut, flush, thresh)

    def data_garble_rate(self, taps: "int", syn_density: "float") -> "float":
        r"""
        data_garble_rate(conv_bit_corr_bb self, int taps, float syn_density) -> float
        This subroutine will find the encoded data garble rate corresponding to a syndrome density of target, that is created with an annihilating polynomial with 'taps' number of taps.
        """
        return _fec_swig.conv_bit_corr_bb_data_garble_rate(self, taps, syn_density)
    __swig_destroy__ = _fec_swig.delete_conv_bit_corr_bb

# Register conv_bit_corr_bb in _fec_swig:
_fec_swig.conv_bit_corr_bb_swigregister(conv_bit_corr_bb)
class puncture_bb(object):
    r"""
    Puncture a stream of unpacked bits.

    Puncture a given block of input samples of . The items produced is based on pattern . Basically, if:





    This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the puncturing will be done on the symbol level, not the bit level.


     is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





    Example: 


    The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


    The fec.extended_encoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


    Note that due to the above concept, the default setting in the extended encoder of '11' translates into no puncturing.


    The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

    Constructor Specific Documentation:

    Constructs a puncture block for unpacked bits.

    Args:
        puncsize : Size of block of bits to puncture
        puncpat : The puncturing pattern
        delay : Delayed the puncturing pattern by shifting it
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(puncsize: "int", puncpat: "int", delay: "int"=0) -> "gr::fec::puncture_bb::sptr":
        r"""
        make(int puncsize, int puncpat, int delay=0) -> puncture_bb_sptr
        Puncture a stream of unpacked bits.

        Puncture a given block of input samples of . The items produced is based on pattern . Basically, if:





        This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the puncturing will be done on the symbol level, not the bit level.


         is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





        Example: 


        The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


        The fec.extended_encoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


        Note that due to the above concept, the default setting in the extended encoder of '11' translates into no puncturing.


        The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

        Constructor Specific Documentation:

        Constructs a puncture block for unpacked bits.

        Args:
            puncsize : Size of block of bits to puncture
            puncpat : The puncturing pattern
            delay : Delayed the puncturing pattern by shifting it
        """
        return _fec_swig.puncture_bb_make(puncsize, puncpat, delay)
    __swig_destroy__ = _fec_swig.delete_puncture_bb

# Register puncture_bb in _fec_swig:
_fec_swig.puncture_bb_swigregister(puncture_bb)
class puncture_ff(object):
    r"""
    Puncture a stream of floats.

    For a given block of input samples of , the items produced is based on . Basically, if:





    This block is designed for floats, generally 1's and -1's. It's possible to use other float values as symbols, but this is not the expected operation.


     is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





    Example: 


    The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


    The fec.extended_encoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


    Note that due to the above concept, the default setting in the extended encoder of '11' translates into no puncturing.


    The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

    Constructor Specific Documentation:

    Constructs a puncture block for floats.

    Args:
        puncsize : Size of block of bits to puncture
        puncpat : The puncturing pattern
        delay : Delayed the puncturing pattern by shifting it
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(puncsize: "int", puncpat: "int", delay: "int") -> "gr::fec::puncture_ff::sptr":
        r"""
        make(int puncsize, int puncpat, int delay) -> puncture_ff_sptr
        Puncture a stream of floats.

        For a given block of input samples of , the items produced is based on . Basically, if:





        This block is designed for floats, generally 1's and -1's. It's possible to use other float values as symbols, but this is not the expected operation.


         is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





        Example: 


        The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


        The fec.extended_encoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


        Note that due to the above concept, the default setting in the extended encoder of '11' translates into no puncturing.


        The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

        Constructor Specific Documentation:

        Constructs a puncture block for floats.

        Args:
            puncsize : Size of block of bits to puncture
            puncpat : The puncturing pattern
            delay : Delayed the puncturing pattern by shifting it
        """
        return _fec_swig.puncture_ff_make(puncsize, puncpat, delay)
    __swig_destroy__ = _fec_swig.delete_puncture_ff

# Register puncture_ff in _fec_swig:
_fec_swig.puncture_ff_swigregister(puncture_ff)
class depuncture_bb(object):
    r"""
    Depuncture a stream of samples.

    Depuncture a given block of input samples of . The items produced is based on the pattern . Basically, if:





    This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the depuncturing will be done on the symbol level, not the bit level.


     is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





    Example: 


    The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


    The fec.extended_decoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


    The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

    Constructor Specific Documentation:

    Constructs a depuncture block.

    Args:
        puncsize : Size of block of bits to puncture
        puncpat : The puncturing pattern
        delay : Delayed the puncturing pattern by shifting it
        symbol : The symbol to reinsert into the stream (def=127)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(puncsize: "int", puncpat: "int", delay: "int"=0, symbol: "char"=127) -> "gr::fec::depuncture_bb::sptr":
        r"""
        make(int puncsize, int puncpat, int delay=0, char symbol=127) -> depuncture_bb_sptr
        Depuncture a stream of samples.

        Depuncture a given block of input samples of . The items produced is based on the pattern . Basically, if:





        This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the depuncturing will be done on the symbol level, not the bit level.


         is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





        Example: 


        The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


        The fec.extended_decoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


        The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

        Constructor Specific Documentation:

        Constructs a depuncture block.

        Args:
            puncsize : Size of block of bits to puncture
            puncpat : The puncturing pattern
            delay : Delayed the puncturing pattern by shifting it
            symbol : The symbol to reinsert into the stream (def=127)
        """
        return _fec_swig.depuncture_bb_make(puncsize, puncpat, delay, symbol)
    __swig_destroy__ = _fec_swig.delete_depuncture_bb

# Register depuncture_bb in _fec_swig:
_fec_swig.depuncture_bb_swigregister(depuncture_bb)
class tpc_encoder(generic_encoder):
    r"""Proxy of C++ gr::fec::tpc_encoder class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fec_swig.delete_tpc_encoder

    @staticmethod
    def make(row_poly: "std::vector< int,std::allocator< int > >", col_poly: "std::vector< int,std::allocator< int > >", krow: "int", kcol: "int", bval: "int", qval: "int") -> "gr::fec::generic_encoder::sptr":
        r"""make(std::vector< int,std::allocator< int > > row_poly, std::vector< int,std::allocator< int > > col_poly, int krow, int kcol, int bval, int qval) -> generic_encoder_sptr"""
        return _fec_swig.tpc_encoder_make(row_poly, col_poly, krow, kcol, bval, qval)

# Register tpc_encoder in _fec_swig:
_fec_swig.tpc_encoder_swigregister(tpc_encoder)
MAXLOG = _fec_swig.MAXLOG

class tpc_decoder(generic_decoder):
    r"""Proxy of C++ gr::fec::tpc_decoder class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(row_poly: "std::vector< int,std::allocator< int > >", col_poly: "std::vector< int,std::allocator< int > >", krow: "int", kcol: "int", bval: "int", qval: "int", max_iter: "int", decoder_type: "int") -> "gr::fec::generic_decoder::sptr":
        r"""make(std::vector< int,std::allocator< int > > row_poly, std::vector< int,std::allocator< int > > col_poly, int krow, int kcol, int bval, int qval, int max_iter, int decoder_type) -> generic_decoder_sptr"""
        return _fec_swig.tpc_decoder_make(row_poly, col_poly, krow, kcol, bval, qval, max_iter, decoder_type)
    __swig_destroy__ = _fec_swig.delete_tpc_decoder

# Register tpc_decoder in _fec_swig:
_fec_swig.tpc_decoder_swigregister(tpc_decoder)
class polar_encoder(generic_encoder):
    r"""
    POLAR encoder for basic details see 'polar_common' class.

    expects values with MSB first. It needs a full information word and encodes it in one pass. Output is a codeword of block_size.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(block_size: "int", num_info_bits: "int", frozen_bit_positions: "std::vector< int,std::allocator< int > >", frozen_bit_values: "std::vector< char,std::allocator< char > >", is_packed: "bool"=False) -> "gr::fec::generic_encoder::sptr":
        r"""
        make(int block_size, int num_info_bits, std::vector< int,std::allocator< int > > frozen_bit_positions, std::vector< char,std::allocator< char > > frozen_bit_values, bool is_packed=False) -> generic_encoder_sptr
        Factory for a polar code encoder object.
        """
        return _fec_swig.polar_encoder_make(block_size, num_info_bits, frozen_bit_positions, frozen_bit_values, is_packed)
    __swig_destroy__ = _fec_swig.delete_polar_encoder

# Register polar_encoder in _fec_swig:
_fec_swig.polar_encoder_swigregister(polar_encoder)
class polar_decoder_sc(object):
    r"""
    Standard successive cancellation (SC) decoder for POLAR codes.

    It expects float input with bits mapped 1 --> 1, 0 --> -1 Or: f = 2.0 * bit - 1.0
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(block_size: "int", num_info_bits: "int", frozen_bit_positions: "std::vector< int,std::allocator< int > >", frozen_bit_values: "std::vector< char,std::allocator< char > >") -> "gr::fec::generic_decoder::sptr":
        r"""make(int block_size, int num_info_bits, std::vector< int,std::allocator< int > > frozen_bit_positions, std::vector< char,std::allocator< char > > frozen_bit_values) -> generic_decoder_sptr"""
        return _fec_swig.polar_decoder_sc_make(block_size, num_info_bits, frozen_bit_positions, frozen_bit_values)
    __swig_destroy__ = _fec_swig.delete_polar_decoder_sc

    def generic_work(self, in_buffer: "void *", out_buffer: "void *") -> "void":
        r"""generic_work(polar_decoder_sc self, void * in_buffer, void * out_buffer)"""
        return _fec_swig.polar_decoder_sc_generic_work(self, in_buffer, out_buffer)

# Register polar_decoder_sc in _fec_swig:
_fec_swig.polar_decoder_sc_swigregister(polar_decoder_sc)
class polar_common(object):
    r"""
    POLAR code common operations and attributes.

    Polar codes are based on this paper by Erdal Arikan "Channel
    Polarization: A Method for Constructing Capacity-Achieving Codes
    for Symmetric Binary-Input Memoryless Channels", 2009 block holds common information for encoders and decoders. All polar encoder/decoders inherit from polar_common.


    class holds common info. It is common to all encoders and decoders.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, block_size: "int", num_info_bits: "int", frozen_bit_positions: "std::vector< int,std::allocator< int > >", frozen_bit_values: "std::vector< char,std::allocator< char > >"):
        r"""__init__(polar_common self, int block_size, int num_info_bits, std::vector< int,std::allocator< int > > frozen_bit_positions, std::vector< char,std::allocator< char > > frozen_bit_values) -> polar_common"""
        _fec_swig.polar_common_swiginit(self, _fec_swig.new_polar_common(block_size, num_info_bits, frozen_bit_positions, frozen_bit_values))
    __swig_destroy__ = _fec_swig.delete_polar_common

# Register polar_common in _fec_swig:
_fec_swig.polar_common_swigregister(polar_common)
class polar_decoder_sc_list(object):
    r"""
    Successive cancellation list (SCL) decoder for polar codes.

    Decoder is based on Tal, Vardy "List Decoding of Polar Codes", 2012 LLR version: Balatsoukas-Stimming, Parizi, Burg "LLR-based
    Successive Cancellation List Decoding of Polar Codes", 2015.


    Block expects float input with bits mapped 1 --> 1, 0 --> -1 Or: f = 2.0 * bit - 1.0
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(max_list_size: "int", block_size: "int", num_info_bits: "int", frozen_bit_positions: "std::vector< int,std::allocator< int > >", frozen_bit_values: "std::vector< char,std::allocator< char > >") -> "gr::fec::generic_decoder::sptr":
        r"""make(int max_list_size, int block_size, int num_info_bits, std::vector< int,std::allocator< int > > frozen_bit_positions, std::vector< char,std::allocator< char > > frozen_bit_values) -> generic_decoder_sptr"""
        return _fec_swig.polar_decoder_sc_list_make(max_list_size, block_size, num_info_bits, frozen_bit_positions, frozen_bit_values)
    __swig_destroy__ = _fec_swig.delete_polar_decoder_sc_list

    def generic_work(self, in_buffer: "void *", out_buffer: "void *") -> "void":
        r"""generic_work(polar_decoder_sc_list self, void * in_buffer, void * out_buffer)"""
        return _fec_swig.polar_decoder_sc_list_generic_work(self, in_buffer, out_buffer)

# Register polar_decoder_sc_list in _fec_swig:
_fec_swig.polar_decoder_sc_list_swigregister(polar_decoder_sc_list)
class polar_decoder_common(generic_decoder, polar_common):
    r"""Class holds common methods and attributes for different decoder implementations."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fec_swig.delete_polar_decoder_common

# Register polar_decoder_common in _fec_swig:
_fec_swig.polar_decoder_common_swigregister(polar_decoder_common)
class polar_encoder_systematic(generic_encoder, polar_common):
    r"""
    systematic POLAR encoder for basic details see 'polar_common' class.

    expects values with MSB first. It needs a full information word and encodes it in one pass. Output is a codeword of block_size.


    Systematic encoding indicates that the info bit values are present in the codeword. 'info_bit_positions' may be obtained by ordering all non frozen_bit_positions in increasing order. One may extract them at their positions after a bit reversal operation. encoder -> decoder chain would need additional bit-reversal after encoding + before decoding. This is unnecessary.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(block_size: "int", num_info_bits: "int", frozen_bit_positions: "std::vector< int,std::allocator< int > >") -> "gr::fec::generic_encoder::sptr":
        r"""
        make(int block_size, int num_info_bits, std::vector< int,std::allocator< int > > frozen_bit_positions) -> generic_encoder_sptr
        Factory for a polar code encoder object.
        """
        return _fec_swig.polar_encoder_systematic_make(block_size, num_info_bits, frozen_bit_positions)
    __swig_destroy__ = _fec_swig.delete_polar_encoder_systematic

# Register polar_encoder_systematic in _fec_swig:
_fec_swig.polar_encoder_systematic_swigregister(polar_encoder_systematic)
class polar_decoder_sc_systematic(polar_decoder_common):
    r"""
    Standard systematic successive cancellation (SC) decoder for POLAR codes.

    It expects float input with bits mapped 1 --> 1, 0 --> -1 Or: f = 2.0 * bit - 1.0


    Systematic encoding indicates that the info bit values are present in the codeword. 'info_bit_positions' may be obtained by ordering all non frozen_bit_positions in increasing order. One may extract them at their positions after a bit reversal operation. encoder -> decoder chain would need additional bit-reversal after encoding + before decoding. This is unnecessary.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(block_size: "int", num_info_bits: "int", frozen_bit_positions: "std::vector< int,std::allocator< int > >") -> "gr::fec::generic_decoder::sptr":
        r"""make(int block_size, int num_info_bits, std::vector< int,std::allocator< int > > frozen_bit_positions) -> generic_decoder_sptr"""
        return _fec_swig.polar_decoder_sc_systematic_make(block_size, num_info_bits, frozen_bit_positions)
    __swig_destroy__ = _fec_swig.delete_polar_decoder_sc_systematic

# Register polar_decoder_sc_systematic in _fec_swig:
_fec_swig.polar_decoder_sc_systematic_swigregister(polar_decoder_sc_systematic)
class ldpc_encoder(generic_encoder):
    r"""Proxy of C++ gr::fec::ldpc_encoder class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(alist_file: "std::string") -> "gr::fec::generic_encoder::sptr":
        r"""make(std::string alist_file) -> generic_encoder_sptr"""
        return _fec_swig.ldpc_encoder_make(alist_file)
    __swig_destroy__ = _fec_swig.delete_ldpc_encoder

# Register ldpc_encoder in _fec_swig:
_fec_swig.ldpc_encoder_swigregister(ldpc_encoder)
class block_data(object):
    r"""Proxy of C++ gr::fec::code::block_data class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    size: "size_t" = property(_fec_swig.block_data_size_get, _fec_swig.block_data_size_set, doc=r"""size : size_t""")
    data: "double *" = property(_fec_swig.block_data_data_get, _fec_swig.block_data_data_set, doc=r"""data : p.double""")

    def __init__(self):
        r"""__init__(block_data self) -> block_data"""
        _fec_swig.block_data_swiginit(self, _fec_swig.new_block_data())
    __swig_destroy__ = _fec_swig.delete_block_data

# Register block_data in _fec_swig:
_fec_swig.block_data_swigregister(block_data)
class matrix(object):
    r"""Proxy of C++ gr::fec::code::matrix class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    size1: "size_t" = property(_fec_swig.matrix_size1_get, _fec_swig.matrix_size1_set, doc=r"""size1 : size_t""")
    size2: "size_t" = property(_fec_swig.matrix_size2_get, _fec_swig.matrix_size2_set, doc=r"""size2 : size_t""")
    tda: "size_t" = property(_fec_swig.matrix_tda_get, _fec_swig.matrix_tda_set, doc=r"""tda : size_t""")
    data: "double *" = property(_fec_swig.matrix_data_get, _fec_swig.matrix_data_set, doc=r"""data : p.double""")
    block: "gr::fec::code::block_data *" = property(_fec_swig.matrix_block_get, _fec_swig.matrix_block_set, doc=r"""block : p.gr::fec::code::block_data""")
    owner: "int" = property(_fec_swig.matrix_owner_get, _fec_swig.matrix_owner_set, doc=r"""owner : int""")

    def __init__(self):
        r"""__init__(matrix self) -> matrix"""
        _fec_swig.matrix_swiginit(self, _fec_swig.new_matrix())
    __swig_destroy__ = _fec_swig.delete_matrix

# Register matrix in _fec_swig:
_fec_swig.matrix_swigregister(matrix)

def matrix_free(x: "matrix") -> "void":
    r"""matrix_free(matrix x)"""
    return _fec_swig.matrix_free(x)

def read_matrix_from_file(filename: "std::string const") -> "gr::fec::code::matrix_sptr":
    r"""
    read_matrix_from_file(std::string const filename) -> matrix_sptr
    Read in an alist file and produce the matrix object.

    Takes in a an alist file (the file name as a string) and creates the corresponding matrix. The format of alist files is described at: 


    The result is returned as a matrix shared pointer.
    """
    return _fec_swig.read_matrix_from_file(filename)

def write_matrix_to_file(filename: "std::string const", M: "matrix_sptr") -> "void":
    r"""write_matrix_to_file(std::string const filename, matrix_sptr M)"""
    return _fec_swig.write_matrix_to_file(filename, M)

def generate_G_transpose(H_obj: "matrix_sptr") -> "gr::fec::code::matrix_sptr":
    r"""
    generate_G_transpose(matrix_sptr H_obj) -> matrix_sptr
    Takes a parity check matrix (H) and returns the transpose of the generator matrix (G).

    The result is returned as a matrix shared pointer. The form of this matrix is [I_k | P]^T, where P is the parity check matrix. It is a n x k matrix where k is the information length and n is the codeword length.
    """
    return _fec_swig.generate_G_transpose(H_obj)

def generate_G(H_obj: "matrix_sptr") -> "gr::fec::code::matrix_sptr":
    r"""
    generate_G(matrix_sptr H_obj) -> matrix_sptr
    Takes a parity check matrix (H) and returns the generator matrix (G).

    The result is returned as a matrix shared pointer. The form of this matrix is [I_k | P], where P is the parity check matrix. It is a k x n matrix where k is the information length and n is the codeword length.
    """
    return _fec_swig.generate_G(H_obj)

def generate_H(G_obj: "matrix_sptr") -> "gr::fec::code::matrix_sptr":
    r"""
    generate_H(matrix_sptr G_obj) -> matrix_sptr
    Takes a generator matrix (G) and returns the parity check matrix (H).
    """
    return _fec_swig.generate_H(G_obj)

def print_matrix(M: "matrix_sptr", numpy: "bool"=False) -> "void":
    r"""
    print_matrix(matrix_sptr M, bool numpy=False)
    Takes a matrix and prints it to screen.
    """
    return _fec_swig.print_matrix(M, numpy)
class fec_mtrx(object):
    r"""
    Base class for FEC matrix objects.

    Base class of ldpc_H_matrix and ldpc_G_matrix classes. The child objects can be either generator matrices or parity check matrices. This base class can be provided to the decoder ldpc_bit_flip_decoder, whereas the encoder classes ldpc_gen_mtrx_encoder and ldpc_encoder will not accept this base class; they require one of the child classes.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _fec_swig.delete_fec_mtrx

    def encode(self, outbuffer: "unsigned char *", inbuffer: "unsigned char const *") -> "void":
        r"""
        encode(fec_mtrx self, unsigned char * outbuffer, unsigned char const * inbuffer)
        Encode  with LDPC H matrix into .
        """
        return _fec_swig.fec_mtrx_encode(self, outbuffer, inbuffer)

    def decode(self, outbuffer: "unsigned char *", inbuffer: "float const *", frame_size: "unsigned int", max_iterations: "unsigned int") -> "void":
        r"""
        decode(fec_mtrx self, unsigned char * outbuffer, float const * inbuffer, unsigned int frame_size, unsigned int max_iterations)
        Decode  with LDPC H matrix into .
        """
        return _fec_swig.fec_mtrx_decode(self, outbuffer, inbuffer, frame_size, max_iterations)

    def n(self) -> "unsigned int":
        r"""
        n(fec_mtrx self) -> unsigned int
        Get the codeword length n.
        """
        return _fec_swig.fec_mtrx_n(self)

    def k(self) -> "unsigned int":
        r"""
        k(fec_mtrx self) -> unsigned int
        Get the information word length k.
        """
        return _fec_swig.fec_mtrx_k(self)

# Register fec_mtrx in _fec_swig:
_fec_swig.fec_mtrx_swigregister(fec_mtrx)
class ldpc_H_matrix(fec_mtrx):
    r"""
    Parity check matrix in Richardson/Urbanke format.

    This class stores a matrix for use with the ldpc_encoder class. It must be of the specific format described by Richardson and Urbanke in Appendix A of their book: Modern Coding Theory (ISBN 978-0-521-85229-6). The form is:  This class can be used with the ldpc_bit_flip_decoder.


    To convert a parity check matrix to this format, use the python functions in: /lib/python2.7/dist-packages/gnuradio/fec/LDPC/Generate_LDPC_matrix.py.

    Constructor Specific Documentation:

    Constructor given alist file and gap.

    Args:
        filename : Name of an alist file to use. The alist format is described at:
        gap : A property of the matrix being used. For alist files distributed with GNU Radio, this value is specified in the alist filename. The gap is found during the matrix preprocessing algorithm. It is equal to the number of rows in submatrices E, C and D.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(filename: "std::string const", gap: "unsigned int") -> "gr::fec::code::ldpc_H_matrix::sptr":
        r"""
        make(std::string const filename, unsigned int gap) -> ldpc_H_matrix_sptr
        Parity check matrix in Richardson/Urbanke format.

        This class stores a matrix for use with the ldpc_encoder class. It must be of the specific format described by Richardson and Urbanke in Appendix A of their book: Modern Coding Theory (ISBN 978-0-521-85229-6). The form is:  This class can be used with the ldpc_bit_flip_decoder.


        To convert a parity check matrix to this format, use the python functions in: /lib/python2.7/dist-packages/gnuradio/fec/LDPC/Generate_LDPC_matrix.py.

        Constructor Specific Documentation:

        Constructor given alist file and gap.

        Args:
            filename : Name of an alist file to use. The alist format is described at:
            gap : A property of the matrix being used. For alist files distributed with GNU Radio, this value is specified in the alist filename. The gap is found during the matrix preprocessing algorithm. It is equal to the number of rows in submatrices E, C and D.
        """
        return _fec_swig.ldpc_H_matrix_make(filename, gap)

    def get_base_sptr(self) -> "gr::fec::code::fec_mtrx_sptr":
        r"""
        get_base_sptr(ldpc_H_matrix self) -> fec_mtrx_sptr
        A pointer to make SWIG work.

        SWIG doesn't understand the parent class pointer to this child class for the make function of the ldpc_bit_flip_decoder; it's expecting a pointer to the base class. This returns a shared_from_this instance.
        """
        return _fec_swig.ldpc_H_matrix_get_base_sptr(self)
    __swig_destroy__ = _fec_swig.delete_ldpc_H_matrix

# Register ldpc_H_matrix in _fec_swig:
_fec_swig.ldpc_H_matrix_swigregister(ldpc_H_matrix)
class ldpc_G_matrix(fec_mtrx):
    r"""
    Class for storing H or G matrix.

    This class stores a matrix variable, specifically either a:


    1) Generator matrix, G, in the standard format G = [I P], where I is an identity matrix and P is the parity submatrix.


    or


    2) Parity matrix, H, in the standard format H = [P' I], where P' is the transpose of the parity submatrix and I is an identity matrix.


    This variable can used by the ldpc_gen_mtrx_encoder and ldpc_bit_flip_decoder classes.

    Constructor Specific Documentation:

    Constructor given alist file.

    Args:
        filename : Name of an alist file to use. The alist format is described at:
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(filename: "std::string const") -> "gr::fec::code::ldpc_G_matrix::sptr":
        r"""
        make(std::string const filename) -> ldpc_G_matrix_sptr
        Class for storing H or G matrix.

        This class stores a matrix variable, specifically either a:


        1) Generator matrix, G, in the standard format G = [I P], where I is an identity matrix and P is the parity submatrix.


        or


        2) Parity matrix, H, in the standard format H = [P' I], where P' is the transpose of the parity submatrix and I is an identity matrix.


        This variable can used by the ldpc_gen_mtrx_encoder and ldpc_bit_flip_decoder classes.

        Constructor Specific Documentation:

        Constructor given alist file.

        Args:
            filename : Name of an alist file to use. The alist format is described at:
        """
        return _fec_swig.ldpc_G_matrix_make(filename)

    def get_base_sptr(self) -> "gr::fec::code::fec_mtrx_sptr":
        r"""
        get_base_sptr(ldpc_G_matrix self) -> fec_mtrx_sptr
        A pointer to make SWIG work.

        SWIG doesn't understand the parent class pointer to this child class for the make function of the ldpc_bit_flip_decoder; it's expecting a pointer to the base class. This returns a shared_from_this instance.
        """
        return _fec_swig.ldpc_G_matrix_get_base_sptr(self)
    __swig_destroy__ = _fec_swig.delete_ldpc_G_matrix

# Register ldpc_G_matrix in _fec_swig:
_fec_swig.ldpc_G_matrix_swigregister(ldpc_G_matrix)
class ldpc_gen_mtrx_encoder(generic_encoder):
    r"""
    LDPC generator matrix encoder.

    A standard encoder class. This method is discussed in many textbooks; one is: Turbo Coding for Satellite and Wireless Communications by Soleymani, Gao, and Vilaipornsawai. Given a generator matrix in systematic form, , where  is the identity matrix and  is the parity submatrix, the information word  is encoded into a codeword  via:
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(G_obj: "ldpc_G_matrix_sptr") -> "gr::fec::generic_encoder::sptr":
        r"""
        make(ldpc_G_matrix_sptr G_obj) -> generic_encoder_sptr
        Build an encoding FEC API object.
        """
        return _fec_swig.ldpc_gen_mtrx_encoder_make(G_obj)
    __swig_destroy__ = _fec_swig.delete_ldpc_gen_mtrx_encoder

# Register ldpc_gen_mtrx_encoder in _fec_swig:
_fec_swig.ldpc_gen_mtrx_encoder_swigregister(ldpc_gen_mtrx_encoder)
class ldpc_par_mtrx_encoder(generic_encoder):
    r"""Proxy of C++ gr::fec::code::ldpc_par_mtrx_encoder class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(alist_file: "std::string", gap: "unsigned int"=0) -> "gr::fec::generic_encoder::sptr":
        r"""make(std::string alist_file, unsigned int gap=0) -> generic_encoder_sptr"""
        return _fec_swig.ldpc_par_mtrx_encoder_make(alist_file, gap)

    @staticmethod
    def make_H(H_obj: "ldpc_H_matrix_sptr") -> "gr::fec::generic_encoder::sptr":
        r"""make_H(ldpc_H_matrix_sptr H_obj) -> generic_encoder_sptr"""
        return _fec_swig.ldpc_par_mtrx_encoder_make_H(H_obj)
    __swig_destroy__ = _fec_swig.delete_ldpc_par_mtrx_encoder

# Register ldpc_par_mtrx_encoder in _fec_swig:
_fec_swig.ldpc_par_mtrx_encoder_swigregister(ldpc_par_mtrx_encoder)
class ldpc_bit_flip_decoder(generic_decoder):
    r"""
    LDPC bit flip decoding class.

    A hard decision bit flip decoder class for decoding low density parity check (LDPC) codes. The decoder requires knowledge of the matrix used to create (encode) the codewords. The simple algorithm is:
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(mtrx_obj: "fec_mtrx_sptr", max_iter: "unsigned int"=100) -> "gr::fec::generic_decoder::sptr":
        r"""
        make(fec_mtrx_sptr mtrx_obj, unsigned int max_iter=100) -> generic_decoder_sptr
        Build a bit flip decoding FEC API object.
        """
        return _fec_swig.ldpc_bit_flip_decoder_make(mtrx_obj, max_iter)
    __swig_destroy__ = _fec_swig.delete_ldpc_bit_flip_decoder

# Register ldpc_bit_flip_decoder in _fec_swig:
_fec_swig.ldpc_bit_flip_decoder_swigregister(ldpc_bit_flip_decoder)
class ldpc_decoder(generic_decoder):
    r"""Proxy of C++ gr::fec::ldpc_decoder class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _fec_swig.delete_ldpc_decoder

    @staticmethod
    def make(alist_file: "std::string", sigma: "float"=0.5, max_iterations: "int"=50) -> "gr::fec::generic_decoder::sptr":
        r"""make(std::string alist_file, float sigma=0.5, int max_iterations=50) -> generic_decoder_sptr"""
        return _fec_swig.ldpc_decoder_make(alist_file, sigma, max_iterations)

# Register ldpc_decoder in _fec_swig:
_fec_swig.ldpc_decoder_swigregister(ldpc_decoder)
class matrix_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::code::matrix > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(matrix_sptr self) -> matrix_sptr
        __init__(matrix_sptr self, matrix p) -> matrix_sptr
        """
        _fec_swig.matrix_sptr_swiginit(self, _fec_swig.new_matrix_sptr(*args))

    def __deref__(self) -> "gr::fec::code::matrix *":
        r"""__deref__(matrix_sptr self) -> matrix"""
        return _fec_swig.matrix_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_matrix_sptr
    size1: "size_t" = property(_fec_swig.matrix_sptr_size1_get, _fec_swig.matrix_sptr_size1_set, doc=r"""size1 : size_t""")
    size2: "size_t" = property(_fec_swig.matrix_sptr_size2_get, _fec_swig.matrix_sptr_size2_set, doc=r"""size2 : size_t""")
    tda: "size_t" = property(_fec_swig.matrix_sptr_tda_get, _fec_swig.matrix_sptr_tda_set, doc=r"""tda : size_t""")
    data: "double *" = property(_fec_swig.matrix_sptr_data_get, _fec_swig.matrix_sptr_data_set, doc=r"""data : p.double""")
    block: "gr::fec::code::block_data *" = property(_fec_swig.matrix_sptr_block_get, _fec_swig.matrix_sptr_block_set, doc=r"""block : p.gr::fec::code::block_data""")
    owner: "int" = property(_fec_swig.matrix_sptr_owner_get, _fec_swig.matrix_sptr_owner_set, doc=r"""owner : int""")

# Register matrix_sptr in _fec_swig:
_fec_swig.matrix_sptr_swigregister(matrix_sptr)
class fec_mtrx_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::code::fec_mtrx > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(fec_mtrx_sptr self) -> fec_mtrx_sptr
        __init__(fec_mtrx_sptr self, fec_mtrx p) -> fec_mtrx_sptr
        """
        _fec_swig.fec_mtrx_sptr_swiginit(self, _fec_swig.new_fec_mtrx_sptr(*args))

    def __deref__(self) -> "gr::fec::code::fec_mtrx *":
        r"""__deref__(fec_mtrx_sptr self) -> fec_mtrx"""
        return _fec_swig.fec_mtrx_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_fec_mtrx_sptr

    def encode(self, outbuffer: "unsigned char *", inbuffer: "unsigned char const *") -> "void":
        r"""
        encode(fec_mtrx_sptr self, unsigned char * outbuffer, unsigned char const * inbuffer)
        Encode  with LDPC H matrix into .
        """
        return _fec_swig.fec_mtrx_sptr_encode(self, outbuffer, inbuffer)

    def decode(self, outbuffer: "unsigned char *", inbuffer: "float const *", frame_size: "unsigned int", max_iterations: "unsigned int") -> "void":
        r"""
        decode(fec_mtrx_sptr self, unsigned char * outbuffer, float const * inbuffer, unsigned int frame_size, unsigned int max_iterations)
        Decode  with LDPC H matrix into .
        """
        return _fec_swig.fec_mtrx_sptr_decode(self, outbuffer, inbuffer, frame_size, max_iterations)

    def n(self) -> "unsigned int":
        r"""
        n(fec_mtrx_sptr self) -> unsigned int
        Get the codeword length n.
        """
        return _fec_swig.fec_mtrx_sptr_n(self)

    def k(self) -> "unsigned int":
        r"""
        k(fec_mtrx_sptr self) -> unsigned int
        Get the information word length k.
        """
        return _fec_swig.fec_mtrx_sptr_k(self)

# Register fec_mtrx_sptr in _fec_swig:
_fec_swig.fec_mtrx_sptr_swigregister(fec_mtrx_sptr)
class ldpc_H_matrix_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::code::ldpc_H_matrix > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ldpc_H_matrix_sptr self) -> ldpc_H_matrix_sptr
        __init__(ldpc_H_matrix_sptr self, ldpc_H_matrix p) -> ldpc_H_matrix_sptr
        """
        _fec_swig.ldpc_H_matrix_sptr_swiginit(self, _fec_swig.new_ldpc_H_matrix_sptr(*args))

    def __deref__(self) -> "gr::fec::code::ldpc_H_matrix *":
        r"""__deref__(ldpc_H_matrix_sptr self) -> ldpc_H_matrix"""
        return _fec_swig.ldpc_H_matrix_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_ldpc_H_matrix_sptr

    def make(self, filename: "std::string const", gap: "unsigned int") -> "gr::fec::code::ldpc_H_matrix::sptr":
        r"""
        make(ldpc_H_matrix_sptr self, std::string const filename, unsigned int gap) -> ldpc_H_matrix_sptr
        Parity check matrix in Richardson/Urbanke format.

        This class stores a matrix for use with the ldpc_encoder class. It must be of the specific format described by Richardson and Urbanke in Appendix A of their book: Modern Coding Theory (ISBN 978-0-521-85229-6). The form is:  This class can be used with the ldpc_bit_flip_decoder.


        To convert a parity check matrix to this format, use the python functions in: /lib/python2.7/dist-packages/gnuradio/fec/LDPC/Generate_LDPC_matrix.py.

        Constructor Specific Documentation:

        Constructor given alist file and gap.

        Args:
            filename : Name of an alist file to use. The alist format is described at:
            gap : A property of the matrix being used. For alist files distributed with GNU Radio, this value is specified in the alist filename. The gap is found during the matrix preprocessing algorithm. It is equal to the number of rows in submatrices E, C and D.
        """
        return _fec_swig.ldpc_H_matrix_sptr_make(self, filename, gap)

    def get_base_sptr(self) -> "gr::fec::code::fec_mtrx_sptr":
        r"""
        get_base_sptr(ldpc_H_matrix_sptr self) -> fec_mtrx_sptr
        A pointer to make SWIG work.

        SWIG doesn't understand the parent class pointer to this child class for the make function of the ldpc_bit_flip_decoder; it's expecting a pointer to the base class. This returns a shared_from_this instance.
        """
        return _fec_swig.ldpc_H_matrix_sptr_get_base_sptr(self)

    def encode(self, outbuffer: "unsigned char *", inbuffer: "unsigned char const *") -> "void":
        r"""
        encode(ldpc_H_matrix_sptr self, unsigned char * outbuffer, unsigned char const * inbuffer)
        Encode  with LDPC H matrix into .
        """
        return _fec_swig.ldpc_H_matrix_sptr_encode(self, outbuffer, inbuffer)

    def decode(self, outbuffer: "unsigned char *", inbuffer: "float const *", frame_size: "unsigned int", max_iterations: "unsigned int") -> "void":
        r"""
        decode(ldpc_H_matrix_sptr self, unsigned char * outbuffer, float const * inbuffer, unsigned int frame_size, unsigned int max_iterations)
        Decode  with LDPC H matrix into .
        """
        return _fec_swig.ldpc_H_matrix_sptr_decode(self, outbuffer, inbuffer, frame_size, max_iterations)

    def n(self) -> "unsigned int":
        r"""
        n(ldpc_H_matrix_sptr self) -> unsigned int
        Get the codeword length n.
        """
        return _fec_swig.ldpc_H_matrix_sptr_n(self)

    def k(self) -> "unsigned int":
        r"""
        k(ldpc_H_matrix_sptr self) -> unsigned int
        Get the information word length k.
        """
        return _fec_swig.ldpc_H_matrix_sptr_k(self)

# Register ldpc_H_matrix_sptr in _fec_swig:
_fec_swig.ldpc_H_matrix_sptr_swigregister(ldpc_H_matrix_sptr)

ldpc_H_matrix = ldpc_H_matrix.make;

class ldpc_G_matrix_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::code::ldpc_G_matrix > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ldpc_G_matrix_sptr self) -> ldpc_G_matrix_sptr
        __init__(ldpc_G_matrix_sptr self, ldpc_G_matrix p) -> ldpc_G_matrix_sptr
        """
        _fec_swig.ldpc_G_matrix_sptr_swiginit(self, _fec_swig.new_ldpc_G_matrix_sptr(*args))

    def __deref__(self) -> "gr::fec::code::ldpc_G_matrix *":
        r"""__deref__(ldpc_G_matrix_sptr self) -> ldpc_G_matrix"""
        return _fec_swig.ldpc_G_matrix_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_ldpc_G_matrix_sptr

    def make(self, filename: "std::string const") -> "gr::fec::code::ldpc_G_matrix::sptr":
        r"""
        make(ldpc_G_matrix_sptr self, std::string const filename) -> ldpc_G_matrix_sptr
        Class for storing H or G matrix.

        This class stores a matrix variable, specifically either a:


        1) Generator matrix, G, in the standard format G = [I P], where I is an identity matrix and P is the parity submatrix.


        or


        2) Parity matrix, H, in the standard format H = [P' I], where P' is the transpose of the parity submatrix and I is an identity matrix.


        This variable can used by the ldpc_gen_mtrx_encoder and ldpc_bit_flip_decoder classes.

        Constructor Specific Documentation:

        Constructor given alist file.

        Args:
            filename : Name of an alist file to use. The alist format is described at:
        """
        return _fec_swig.ldpc_G_matrix_sptr_make(self, filename)

    def get_base_sptr(self) -> "gr::fec::code::fec_mtrx_sptr":
        r"""
        get_base_sptr(ldpc_G_matrix_sptr self) -> fec_mtrx_sptr
        A pointer to make SWIG work.

        SWIG doesn't understand the parent class pointer to this child class for the make function of the ldpc_bit_flip_decoder; it's expecting a pointer to the base class. This returns a shared_from_this instance.
        """
        return _fec_swig.ldpc_G_matrix_sptr_get_base_sptr(self)

    def encode(self, outbuffer: "unsigned char *", inbuffer: "unsigned char const *") -> "void":
        r"""
        encode(ldpc_G_matrix_sptr self, unsigned char * outbuffer, unsigned char const * inbuffer)
        Encode  with LDPC H matrix into .
        """
        return _fec_swig.ldpc_G_matrix_sptr_encode(self, outbuffer, inbuffer)

    def decode(self, outbuffer: "unsigned char *", inbuffer: "float const *", frame_size: "unsigned int", max_iterations: "unsigned int") -> "void":
        r"""
        decode(ldpc_G_matrix_sptr self, unsigned char * outbuffer, float const * inbuffer, unsigned int frame_size, unsigned int max_iterations)
        Decode  with LDPC H matrix into .
        """
        return _fec_swig.ldpc_G_matrix_sptr_decode(self, outbuffer, inbuffer, frame_size, max_iterations)

    def n(self) -> "unsigned int":
        r"""
        n(ldpc_G_matrix_sptr self) -> unsigned int
        Get the codeword length n.
        """
        return _fec_swig.ldpc_G_matrix_sptr_n(self)

    def k(self) -> "unsigned int":
        r"""
        k(ldpc_G_matrix_sptr self) -> unsigned int
        Get the information word length k.
        """
        return _fec_swig.ldpc_G_matrix_sptr_k(self)

# Register ldpc_G_matrix_sptr in _fec_swig:
_fec_swig.ldpc_G_matrix_sptr_swigregister(ldpc_G_matrix_sptr)

ldpc_G_matrix = ldpc_G_matrix.make;

class decoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::decoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(decoder_sptr self) -> decoder_sptr
        __init__(decoder_sptr self, decoder p) -> decoder_sptr
        """
        _fec_swig.decoder_sptr_swiginit(self, _fec_swig.new_decoder_sptr(*args))

    def __deref__(self) -> "gr::fec::decoder *":
        r"""__deref__(decoder_sptr self) -> decoder"""
        return _fec_swig.decoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_decoder_sptr

    def make(self, my_decoder: "generic_decoder_sptr", input_item_size: "size_t", output_item_size: "size_t") -> "gr::fec::decoder::sptr":
        r"""
        make(decoder_sptr self, generic_decoder_sptr my_decoder, size_t input_item_size, size_t output_item_size) -> decoder_sptr
        General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

        This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


        Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


        See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

        Constructor Specific Documentation:

        Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

        Args:
            my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
            input_item_size : The size of the input items (often the my_decoder object can tell us this).
            output_item_size : The size of the output items (often the my_decoder object can tell us this).
        """
        return _fec_swig.decoder_sptr_make(self, my_decoder, input_item_size, output_item_size)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(decoder_sptr self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.decoder_sptr_general_work(self, noutput_items, ninput_items, input_items, output_items)

    def fixed_rate_ninput_to_noutput(self, ninput: "int") -> "int":
        r"""fixed_rate_ninput_to_noutput(decoder_sptr self, int ninput) -> int"""
        return _fec_swig.decoder_sptr_fixed_rate_ninput_to_noutput(self, ninput)

    def fixed_rate_noutput_to_ninput(self, noutput: "int") -> "int":
        r"""fixed_rate_noutput_to_ninput(decoder_sptr self, int noutput) -> int"""
        return _fec_swig.decoder_sptr_fixed_rate_noutput_to_ninput(self, noutput)

    def forecast(self, noutput_items: "int", ninput_items_required: "gr_vector_int &") -> "void":
        r"""forecast(decoder_sptr self, int noutput_items, gr_vector_int & ninput_items_required)"""
        return _fec_swig.decoder_sptr_forecast(self, noutput_items, ninput_items_required)

    def history(self) -> "unsigned int":
        r"""history(decoder_sptr self) -> unsigned int"""
        return _fec_swig.decoder_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(decoder_sptr self, int which, int delay)
        declare_sample_delay(decoder_sptr self, unsigned int delay)
        """
        return _fec_swig.decoder_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(decoder_sptr self, int which) -> unsigned int"""
        return _fec_swig.decoder_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(decoder_sptr self, int multiple)"""
        return _fec_swig.decoder_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(decoder_sptr self) -> int"""
        return _fec_swig.decoder_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(decoder_sptr self) -> double"""
        return _fec_swig.decoder_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(decoder_sptr self) -> uint64_t"""
        return _fec_swig.decoder_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(decoder_sptr self) -> uint64_t"""
        return _fec_swig.decoder_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(decoder_sptr self) -> bool"""
        return _fec_swig.decoder_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(decoder_sptr self) -> bool"""
        return _fec_swig.decoder_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(decoder_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.decoder_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(decoder_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.decoder_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(decoder_sptr self, std::string level)"""
        return _fec_swig.decoder_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(decoder_sptr self) -> std::string"""
        return _fec_swig.decoder_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(decoder_sptr self) -> int"""
        return _fec_swig.decoder_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(decoder_sptr self, int m)"""
        return _fec_swig.decoder_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(decoder_sptr self)"""
        return _fec_swig.decoder_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(decoder_sptr self) -> bool"""
        return _fec_swig.decoder_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(decoder_sptr self, int m)"""
        return _fec_swig.decoder_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(decoder_sptr self) -> int"""
        return _fec_swig.decoder_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(decoder_sptr self, int i) -> long"""
        return _fec_swig.decoder_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(decoder_sptr self, long max_output_buffer)
        set_max_output_buffer(decoder_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.decoder_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(decoder_sptr self, int i) -> long"""
        return _fec_swig.decoder_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(decoder_sptr self, long min_output_buffer)
        set_min_output_buffer(decoder_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.decoder_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(decoder_sptr self, int which) -> float
        pc_input_buffers_full(decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decoder_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(decoder_sptr self, int which) -> float
        pc_input_buffers_full_avg(decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decoder_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(decoder_sptr self, int which) -> float
        pc_input_buffers_full_var(decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decoder_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(decoder_sptr self, int which) -> float
        pc_output_buffers_full(decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decoder_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(decoder_sptr self, int which) -> float
        pc_output_buffers_full_avg(decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decoder_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(decoder_sptr self, int which) -> float
        pc_output_buffers_full_var(decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decoder_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(decoder_sptr self) -> float"""
        return _fec_swig.decoder_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(decoder_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.decoder_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(decoder_sptr self)"""
        return _fec_swig.decoder_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(decoder_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.decoder_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(decoder_sptr self) -> int"""
        return _fec_swig.decoder_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(decoder_sptr self) -> int"""
        return _fec_swig.decoder_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(decoder_sptr self, int priority) -> int"""
        return _fec_swig.decoder_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(decoder_sptr self) -> std::string"""
        return _fec_swig.decoder_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(decoder_sptr self) -> std::string"""
        return _fec_swig.decoder_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(decoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.decoder_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(decoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.decoder_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(decoder_sptr self) -> long"""
        return _fec_swig.decoder_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(decoder_sptr self) -> basic_block_sptr"""
        return _fec_swig.decoder_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(decoder_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.decoder_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(decoder_sptr self) -> std::string"""
        return _fec_swig.decoder_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(decoder_sptr self, std::string name)"""
        return _fec_swig.decoder_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(decoder_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.decoder_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(decoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.decoder_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(decoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.decoder_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(decoder_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.decoder_sptr_message_subscribers(self, which_port)

# Register decoder_sptr in _fec_swig:
_fec_swig.decoder_sptr_swigregister(decoder_sptr)

decoder_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
decoder = decoder.make;

class encoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::encoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(encoder_sptr self) -> encoder_sptr
        __init__(encoder_sptr self, encoder p) -> encoder_sptr
        """
        _fec_swig.encoder_sptr_swiginit(self, _fec_swig.new_encoder_sptr(*args))

    def __deref__(self) -> "gr::fec::encoder *":
        r"""__deref__(encoder_sptr self) -> encoder"""
        return _fec_swig.encoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_encoder_sptr

    def make(self, my_encoder: "generic_encoder_sptr", input_item_size: "size_t", output_item_size: "size_t") -> "gr::fec::encoder::sptr":
        r"""
        make(encoder_sptr self, generic_encoder_sptr my_encoder, size_t input_item_size, size_t output_item_size) -> encoder_sptr
        Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

        Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

        Constructor Specific Documentation:

        Build the FEC encoder block from an FECAPI encoder object.

        Args:
            my_encoder : An FECAPI encoder object child of the generic_encoder class.
            input_item_size : size of a block of data for the encoder.
            output_item_size : size of a block of data the encoder will produce.
        """
        return _fec_swig.encoder_sptr_make(self, my_encoder, input_item_size, output_item_size)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(encoder_sptr self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.encoder_sptr_general_work(self, noutput_items, ninput_items, input_items, output_items)

    def fixed_rate_ninput_to_noutput(self, ninput: "int") -> "int":
        r"""fixed_rate_ninput_to_noutput(encoder_sptr self, int ninput) -> int"""
        return _fec_swig.encoder_sptr_fixed_rate_ninput_to_noutput(self, ninput)

    def fixed_rate_noutput_to_ninput(self, noutput: "int") -> "int":
        r"""fixed_rate_noutput_to_ninput(encoder_sptr self, int noutput) -> int"""
        return _fec_swig.encoder_sptr_fixed_rate_noutput_to_ninput(self, noutput)

    def forecast(self, noutput_items: "int", ninput_items_required: "gr_vector_int &") -> "void":
        r"""forecast(encoder_sptr self, int noutput_items, gr_vector_int & ninput_items_required)"""
        return _fec_swig.encoder_sptr_forecast(self, noutput_items, ninput_items_required)

    def history(self) -> "unsigned int":
        r"""history(encoder_sptr self) -> unsigned int"""
        return _fec_swig.encoder_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(encoder_sptr self, int which, int delay)
        declare_sample_delay(encoder_sptr self, unsigned int delay)
        """
        return _fec_swig.encoder_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(encoder_sptr self, int which) -> unsigned int"""
        return _fec_swig.encoder_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(encoder_sptr self, int multiple)"""
        return _fec_swig.encoder_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(encoder_sptr self) -> int"""
        return _fec_swig.encoder_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(encoder_sptr self) -> double"""
        return _fec_swig.encoder_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(encoder_sptr self) -> uint64_t"""
        return _fec_swig.encoder_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(encoder_sptr self) -> uint64_t"""
        return _fec_swig.encoder_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(encoder_sptr self) -> bool"""
        return _fec_swig.encoder_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(encoder_sptr self) -> bool"""
        return _fec_swig.encoder_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(encoder_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.encoder_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(encoder_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.encoder_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(encoder_sptr self, std::string level)"""
        return _fec_swig.encoder_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(encoder_sptr self) -> std::string"""
        return _fec_swig.encoder_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(encoder_sptr self) -> int"""
        return _fec_swig.encoder_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(encoder_sptr self, int m)"""
        return _fec_swig.encoder_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(encoder_sptr self)"""
        return _fec_swig.encoder_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(encoder_sptr self) -> bool"""
        return _fec_swig.encoder_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(encoder_sptr self, int m)"""
        return _fec_swig.encoder_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(encoder_sptr self) -> int"""
        return _fec_swig.encoder_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(encoder_sptr self, int i) -> long"""
        return _fec_swig.encoder_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(encoder_sptr self, long max_output_buffer)
        set_max_output_buffer(encoder_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.encoder_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(encoder_sptr self, int i) -> long"""
        return _fec_swig.encoder_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(encoder_sptr self, long min_output_buffer)
        set_min_output_buffer(encoder_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.encoder_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(encoder_sptr self, int which) -> float
        pc_input_buffers_full(encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encoder_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(encoder_sptr self, int which) -> float
        pc_input_buffers_full_avg(encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encoder_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(encoder_sptr self, int which) -> float
        pc_input_buffers_full_var(encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encoder_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(encoder_sptr self, int which) -> float
        pc_output_buffers_full(encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encoder_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(encoder_sptr self, int which) -> float
        pc_output_buffers_full_avg(encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encoder_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(encoder_sptr self, int which) -> float
        pc_output_buffers_full_var(encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encoder_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(encoder_sptr self) -> float"""
        return _fec_swig.encoder_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(encoder_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.encoder_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(encoder_sptr self)"""
        return _fec_swig.encoder_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(encoder_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.encoder_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(encoder_sptr self) -> int"""
        return _fec_swig.encoder_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(encoder_sptr self) -> int"""
        return _fec_swig.encoder_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(encoder_sptr self, int priority) -> int"""
        return _fec_swig.encoder_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(encoder_sptr self) -> std::string"""
        return _fec_swig.encoder_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(encoder_sptr self) -> std::string"""
        return _fec_swig.encoder_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(encoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.encoder_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(encoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.encoder_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(encoder_sptr self) -> long"""
        return _fec_swig.encoder_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(encoder_sptr self) -> basic_block_sptr"""
        return _fec_swig.encoder_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(encoder_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.encoder_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(encoder_sptr self) -> std::string"""
        return _fec_swig.encoder_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(encoder_sptr self, std::string name)"""
        return _fec_swig.encoder_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(encoder_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.encoder_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(encoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.encoder_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(encoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.encoder_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(encoder_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.encoder_sptr_message_subscribers(self, which_port)

# Register encoder_sptr in _fec_swig:
_fec_swig.encoder_sptr_swigregister(encoder_sptr)

encoder_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
encoder = encoder.make;

class tagged_decoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::tagged_decoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(tagged_decoder_sptr self) -> tagged_decoder_sptr
        __init__(tagged_decoder_sptr self, tagged_decoder p) -> tagged_decoder_sptr
        """
        _fec_swig.tagged_decoder_sptr_swiginit(self, _fec_swig.new_tagged_decoder_sptr(*args))

    def __deref__(self) -> "gr::fec::tagged_decoder *":
        r"""__deref__(tagged_decoder_sptr self) -> tagged_decoder"""
        return _fec_swig.tagged_decoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_tagged_decoder_sptr

    def make(self, *args, **kwargs) -> "gr::fec::tagged_decoder::sptr":
        r"""
        make(tagged_decoder_sptr self, generic_decoder_sptr my_decoder, size_t input_item_size, size_t output_item_size, std::string const & lengthtagname="packet_len", int mtu=1500) -> tagged_decoder_sptr
        General FEC decoding block that takes in a decoder variable object (derived from gr::fec::general_decoder) for use in a flowgraph.

        This block uses a decoder variable object (derived from gr::fec::generic_decoder) to decode data within a flowgraph. This block interacts with the general FECAPI architecture to handle all passing all input and output data in a flowgraph. The decoder variable takes care of understanding the requirements, data types and sizes, and boundary conditions of the specific FEC decoding algorithm.


        Generally, this block is used within the fec.extended_decoder Python block to handle some input/output formatting issues. In the FECAPI, the decoder variable sets properties like the input and output types and sizes and whether the output is packed or unpacked bytes. The fec.extended_decoder uses this information to set up an gr::hier_block2 structure to make sure the I/O to the variable is handled consistently, such as to make sure all inputs are floats with one soft symbol per item and the outputs are unpacked bytes with the bit in the LSB.


        See gr::fec::generic_decoder for detail on what information an FECAPI variable object can set if using this block directly and not as part of the fec.extended_decoder.

        Constructor Specific Documentation:

        Create the FEC decoder block by taking in the FECAPI decoder object as well as input and output sizes.

        Args:
            my_decoder : An FECAPI decoder object (See gr::fec::generic_decoder).
            input_item_size : The size of the input items (often the my_decoder object can tell us this).
            output_item_size : The size of the output items (often the my_decoder object can tell us this).
            lengthtagname : Key name of the tagged stream frame size.
            mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.tagged_decoder_sptr_make(self, *args, **kwargs)

    def work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""work(tagged_decoder_sptr self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.tagged_decoder_sptr_work(self, noutput_items, ninput_items, input_items, output_items)

    def calculate_output_stream_length(self, ninput_items: "gr_vector_int const &") -> "int":
        r"""calculate_output_stream_length(tagged_decoder_sptr self, gr_vector_int const & ninput_items) -> int"""
        return _fec_swig.tagged_decoder_sptr_calculate_output_stream_length(self, ninput_items)

    def history(self) -> "unsigned int":
        r"""history(tagged_decoder_sptr self) -> unsigned int"""
        return _fec_swig.tagged_decoder_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(tagged_decoder_sptr self, int which, int delay)
        declare_sample_delay(tagged_decoder_sptr self, unsigned int delay)
        """
        return _fec_swig.tagged_decoder_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(tagged_decoder_sptr self, int which) -> unsigned int"""
        return _fec_swig.tagged_decoder_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(tagged_decoder_sptr self, int multiple)"""
        return _fec_swig.tagged_decoder_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(tagged_decoder_sptr self) -> int"""
        return _fec_swig.tagged_decoder_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(tagged_decoder_sptr self) -> double"""
        return _fec_swig.tagged_decoder_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(tagged_decoder_sptr self) -> uint64_t"""
        return _fec_swig.tagged_decoder_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(tagged_decoder_sptr self) -> uint64_t"""
        return _fec_swig.tagged_decoder_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(tagged_decoder_sptr self) -> bool"""
        return _fec_swig.tagged_decoder_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(tagged_decoder_sptr self) -> bool"""
        return _fec_swig.tagged_decoder_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(tagged_decoder_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.tagged_decoder_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(tagged_decoder_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.tagged_decoder_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(tagged_decoder_sptr self, std::string level)"""
        return _fec_swig.tagged_decoder_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(tagged_decoder_sptr self) -> std::string"""
        return _fec_swig.tagged_decoder_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(tagged_decoder_sptr self) -> int"""
        return _fec_swig.tagged_decoder_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(tagged_decoder_sptr self, int m)"""
        return _fec_swig.tagged_decoder_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(tagged_decoder_sptr self)"""
        return _fec_swig.tagged_decoder_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(tagged_decoder_sptr self) -> bool"""
        return _fec_swig.tagged_decoder_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(tagged_decoder_sptr self, int m)"""
        return _fec_swig.tagged_decoder_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(tagged_decoder_sptr self) -> int"""
        return _fec_swig.tagged_decoder_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(tagged_decoder_sptr self, int i) -> long"""
        return _fec_swig.tagged_decoder_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(tagged_decoder_sptr self, long max_output_buffer)
        set_max_output_buffer(tagged_decoder_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.tagged_decoder_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(tagged_decoder_sptr self, int i) -> long"""
        return _fec_swig.tagged_decoder_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(tagged_decoder_sptr self, long min_output_buffer)
        set_min_output_buffer(tagged_decoder_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.tagged_decoder_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(tagged_decoder_sptr self, int which) -> float
        pc_input_buffers_full(tagged_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_decoder_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(tagged_decoder_sptr self, int which) -> float
        pc_input_buffers_full_avg(tagged_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_decoder_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(tagged_decoder_sptr self, int which) -> float
        pc_input_buffers_full_var(tagged_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_decoder_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(tagged_decoder_sptr self, int which) -> float
        pc_output_buffers_full(tagged_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_decoder_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(tagged_decoder_sptr self, int which) -> float
        pc_output_buffers_full_avg(tagged_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_decoder_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(tagged_decoder_sptr self, int which) -> float
        pc_output_buffers_full_var(tagged_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_decoder_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(tagged_decoder_sptr self) -> float"""
        return _fec_swig.tagged_decoder_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(tagged_decoder_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.tagged_decoder_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(tagged_decoder_sptr self)"""
        return _fec_swig.tagged_decoder_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(tagged_decoder_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.tagged_decoder_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(tagged_decoder_sptr self) -> int"""
        return _fec_swig.tagged_decoder_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(tagged_decoder_sptr self) -> int"""
        return _fec_swig.tagged_decoder_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(tagged_decoder_sptr self, int priority) -> int"""
        return _fec_swig.tagged_decoder_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(tagged_decoder_sptr self) -> std::string"""
        return _fec_swig.tagged_decoder_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(tagged_decoder_sptr self) -> std::string"""
        return _fec_swig.tagged_decoder_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(tagged_decoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.tagged_decoder_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(tagged_decoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.tagged_decoder_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(tagged_decoder_sptr self) -> long"""
        return _fec_swig.tagged_decoder_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(tagged_decoder_sptr self) -> basic_block_sptr"""
        return _fec_swig.tagged_decoder_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(tagged_decoder_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.tagged_decoder_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(tagged_decoder_sptr self) -> std::string"""
        return _fec_swig.tagged_decoder_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(tagged_decoder_sptr self, std::string name)"""
        return _fec_swig.tagged_decoder_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(tagged_decoder_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.tagged_decoder_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(tagged_decoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.tagged_decoder_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(tagged_decoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.tagged_decoder_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(tagged_decoder_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.tagged_decoder_sptr_message_subscribers(self, which_port)

# Register tagged_decoder_sptr in _fec_swig:
_fec_swig.tagged_decoder_sptr_swigregister(tagged_decoder_sptr)

tagged_decoder_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
tagged_decoder = tagged_decoder.make;

class tagged_encoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::tagged_encoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(tagged_encoder_sptr self) -> tagged_encoder_sptr
        __init__(tagged_encoder_sptr self, tagged_encoder p) -> tagged_encoder_sptr
        """
        _fec_swig.tagged_encoder_sptr_swiginit(self, _fec_swig.new_tagged_encoder_sptr(*args))

    def __deref__(self) -> "gr::fec::tagged_encoder *":
        r"""__deref__(tagged_encoder_sptr self) -> tagged_encoder"""
        return _fec_swig.tagged_encoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_tagged_encoder_sptr

    def make(self, *args, **kwargs) -> "gr::fec::tagged_encoder::sptr":
        r"""
        make(tagged_encoder_sptr self, generic_encoder_sptr my_encoder, size_t input_item_size, size_t output_item_size, std::string const & lengthtagname="packet_len", int mtu=1500) -> tagged_encoder_sptr
        Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

        Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

        Constructor Specific Documentation:

        Build the FEC encoder block from an FECAPI encoder object.

        Args:
            my_encoder : An FECAPI encoder object child of the generic_encoder class.
            input_item_size : size of a block of data for the encoder.
            output_item_size : size of a block of data the encoder will produce.
            lengthtagname : Key name of the tagged stream frame size.
            mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.tagged_encoder_sptr_make(self, *args, **kwargs)

    def work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""work(tagged_encoder_sptr self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.tagged_encoder_sptr_work(self, noutput_items, ninput_items, input_items, output_items)

    def calculate_output_stream_length(self, ninput_items: "gr_vector_int const &") -> "int":
        r"""calculate_output_stream_length(tagged_encoder_sptr self, gr_vector_int const & ninput_items) -> int"""
        return _fec_swig.tagged_encoder_sptr_calculate_output_stream_length(self, ninput_items)

    def history(self) -> "unsigned int":
        r"""history(tagged_encoder_sptr self) -> unsigned int"""
        return _fec_swig.tagged_encoder_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(tagged_encoder_sptr self, int which, int delay)
        declare_sample_delay(tagged_encoder_sptr self, unsigned int delay)
        """
        return _fec_swig.tagged_encoder_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(tagged_encoder_sptr self, int which) -> unsigned int"""
        return _fec_swig.tagged_encoder_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(tagged_encoder_sptr self, int multiple)"""
        return _fec_swig.tagged_encoder_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(tagged_encoder_sptr self) -> int"""
        return _fec_swig.tagged_encoder_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(tagged_encoder_sptr self) -> double"""
        return _fec_swig.tagged_encoder_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(tagged_encoder_sptr self) -> uint64_t"""
        return _fec_swig.tagged_encoder_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(tagged_encoder_sptr self) -> uint64_t"""
        return _fec_swig.tagged_encoder_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(tagged_encoder_sptr self) -> bool"""
        return _fec_swig.tagged_encoder_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(tagged_encoder_sptr self) -> bool"""
        return _fec_swig.tagged_encoder_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(tagged_encoder_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.tagged_encoder_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(tagged_encoder_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.tagged_encoder_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(tagged_encoder_sptr self, std::string level)"""
        return _fec_swig.tagged_encoder_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(tagged_encoder_sptr self) -> std::string"""
        return _fec_swig.tagged_encoder_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(tagged_encoder_sptr self) -> int"""
        return _fec_swig.tagged_encoder_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(tagged_encoder_sptr self, int m)"""
        return _fec_swig.tagged_encoder_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(tagged_encoder_sptr self)"""
        return _fec_swig.tagged_encoder_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(tagged_encoder_sptr self) -> bool"""
        return _fec_swig.tagged_encoder_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(tagged_encoder_sptr self, int m)"""
        return _fec_swig.tagged_encoder_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(tagged_encoder_sptr self) -> int"""
        return _fec_swig.tagged_encoder_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(tagged_encoder_sptr self, int i) -> long"""
        return _fec_swig.tagged_encoder_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(tagged_encoder_sptr self, long max_output_buffer)
        set_max_output_buffer(tagged_encoder_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.tagged_encoder_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(tagged_encoder_sptr self, int i) -> long"""
        return _fec_swig.tagged_encoder_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(tagged_encoder_sptr self, long min_output_buffer)
        set_min_output_buffer(tagged_encoder_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.tagged_encoder_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(tagged_encoder_sptr self, int which) -> float
        pc_input_buffers_full(tagged_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_encoder_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(tagged_encoder_sptr self, int which) -> float
        pc_input_buffers_full_avg(tagged_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_encoder_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(tagged_encoder_sptr self, int which) -> float
        pc_input_buffers_full_var(tagged_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_encoder_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(tagged_encoder_sptr self, int which) -> float
        pc_output_buffers_full(tagged_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_encoder_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(tagged_encoder_sptr self, int which) -> float
        pc_output_buffers_full_avg(tagged_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_encoder_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(tagged_encoder_sptr self, int which) -> float
        pc_output_buffers_full_var(tagged_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.tagged_encoder_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(tagged_encoder_sptr self) -> float"""
        return _fec_swig.tagged_encoder_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(tagged_encoder_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.tagged_encoder_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(tagged_encoder_sptr self)"""
        return _fec_swig.tagged_encoder_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(tagged_encoder_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.tagged_encoder_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(tagged_encoder_sptr self) -> int"""
        return _fec_swig.tagged_encoder_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(tagged_encoder_sptr self) -> int"""
        return _fec_swig.tagged_encoder_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(tagged_encoder_sptr self, int priority) -> int"""
        return _fec_swig.tagged_encoder_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(tagged_encoder_sptr self) -> std::string"""
        return _fec_swig.tagged_encoder_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(tagged_encoder_sptr self) -> std::string"""
        return _fec_swig.tagged_encoder_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(tagged_encoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.tagged_encoder_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(tagged_encoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.tagged_encoder_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(tagged_encoder_sptr self) -> long"""
        return _fec_swig.tagged_encoder_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(tagged_encoder_sptr self) -> basic_block_sptr"""
        return _fec_swig.tagged_encoder_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(tagged_encoder_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.tagged_encoder_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(tagged_encoder_sptr self) -> std::string"""
        return _fec_swig.tagged_encoder_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(tagged_encoder_sptr self, std::string name)"""
        return _fec_swig.tagged_encoder_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(tagged_encoder_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.tagged_encoder_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(tagged_encoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.tagged_encoder_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(tagged_encoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.tagged_encoder_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(tagged_encoder_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.tagged_encoder_sptr_message_subscribers(self, which_port)

# Register tagged_encoder_sptr in _fec_swig:
_fec_swig.tagged_encoder_sptr_swigregister(tagged_encoder_sptr)

tagged_encoder_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
tagged_encoder = tagged_encoder.make;

class async_decoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::async_decoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(async_decoder_sptr self) -> async_decoder_sptr
        __init__(async_decoder_sptr self, async_decoder p) -> async_decoder_sptr
        """
        _fec_swig.async_decoder_sptr_swiginit(self, _fec_swig.new_async_decoder_sptr(*args))

    def __deref__(self) -> "gr::fec::async_decoder *":
        r"""__deref__(async_decoder_sptr self) -> async_decoder"""
        return _fec_swig.async_decoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_async_decoder_sptr

    def make(self, my_decoder: "generic_decoder_sptr", packed: "bool"=False, rev_pack: "bool"=True, mtu: "int"=1500) -> "gr::fec::async_decoder::sptr":
        r"""
        make(async_decoder_sptr self, generic_decoder_sptr my_decoder, bool packed=False, bool rev_pack=True, int mtu=1500) -> async_decoder_sptr
        Creates the decoder block for use in GNU Radio flowgraphs from a given FEC API object derived from the generic_decoder class.

        Decodes frames received as async messages over a message port. This decoder deployment expects messages of soft decision symbols in and can produce either packed, PDU messages ( = True) or messages full of unpacked bits ( = False).


        This decoder works off a full message as one frame or block to decode. The message length is used to calculate the frame length. To support this, the decoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that after being decoded.


        The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


        Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are packed. All inputs messages are one soft decision per item. By default, the  mode is set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream decoders. That is, putting the same data into both the tagged stream decoder deployment and this with the default setting should produce the same data.


        Because the block handles data as a full frame per message, this decoder deployment cannot work with any decoders that require history. For example, the gr::fec::code::cc_decoder decoder in streaming mode requires an extra rate*(K-1) bits to complete the decoding, so it would have to wait for the next message to come in and finish processing. Therefore, the streaming mode of the CC decoder is not allowed. The other three modes will work with this deployment since the frame is self-contained for decoding.

        Constructor Specific Documentation:

        Build the PDU-based FEC decoder block from an FECAPI decoder object.

        Args:
            my_decoder : An FECAPI decoder object child of the generic_decoder class.
            packed : Sets output to packed bytes if true; otherwise, 1 bit per byte.
            rev_pack : If packing bits, should they be reversed?
            mtu : The Maximum Transmission Unit (MTU) of the output frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.async_decoder_sptr_make(self, my_decoder, packed, rev_pack, mtu)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(async_decoder_sptr self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.async_decoder_sptr_general_work(self, noutput_items, ninput_items, input_items, output_items)

    def history(self) -> "unsigned int":
        r"""history(async_decoder_sptr self) -> unsigned int"""
        return _fec_swig.async_decoder_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(async_decoder_sptr self, int which, int delay)
        declare_sample_delay(async_decoder_sptr self, unsigned int delay)
        """
        return _fec_swig.async_decoder_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(async_decoder_sptr self, int which) -> unsigned int"""
        return _fec_swig.async_decoder_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(async_decoder_sptr self, int multiple)"""
        return _fec_swig.async_decoder_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(async_decoder_sptr self) -> int"""
        return _fec_swig.async_decoder_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(async_decoder_sptr self) -> double"""
        return _fec_swig.async_decoder_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(async_decoder_sptr self) -> uint64_t"""
        return _fec_swig.async_decoder_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(async_decoder_sptr self) -> uint64_t"""
        return _fec_swig.async_decoder_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(async_decoder_sptr self) -> bool"""
        return _fec_swig.async_decoder_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(async_decoder_sptr self) -> bool"""
        return _fec_swig.async_decoder_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(async_decoder_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.async_decoder_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(async_decoder_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.async_decoder_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(async_decoder_sptr self, std::string level)"""
        return _fec_swig.async_decoder_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(async_decoder_sptr self) -> std::string"""
        return _fec_swig.async_decoder_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(async_decoder_sptr self) -> int"""
        return _fec_swig.async_decoder_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(async_decoder_sptr self, int m)"""
        return _fec_swig.async_decoder_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(async_decoder_sptr self)"""
        return _fec_swig.async_decoder_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(async_decoder_sptr self) -> bool"""
        return _fec_swig.async_decoder_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(async_decoder_sptr self, int m)"""
        return _fec_swig.async_decoder_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(async_decoder_sptr self) -> int"""
        return _fec_swig.async_decoder_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(async_decoder_sptr self, int i) -> long"""
        return _fec_swig.async_decoder_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(async_decoder_sptr self, long max_output_buffer)
        set_max_output_buffer(async_decoder_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.async_decoder_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(async_decoder_sptr self, int i) -> long"""
        return _fec_swig.async_decoder_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(async_decoder_sptr self, long min_output_buffer)
        set_min_output_buffer(async_decoder_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.async_decoder_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(async_decoder_sptr self, int which) -> float
        pc_input_buffers_full(async_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_decoder_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(async_decoder_sptr self, int which) -> float
        pc_input_buffers_full_avg(async_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_decoder_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(async_decoder_sptr self, int which) -> float
        pc_input_buffers_full_var(async_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_decoder_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(async_decoder_sptr self, int which) -> float
        pc_output_buffers_full(async_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_decoder_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(async_decoder_sptr self, int which) -> float
        pc_output_buffers_full_avg(async_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_decoder_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(async_decoder_sptr self, int which) -> float
        pc_output_buffers_full_var(async_decoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_decoder_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(async_decoder_sptr self) -> float"""
        return _fec_swig.async_decoder_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(async_decoder_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.async_decoder_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(async_decoder_sptr self)"""
        return _fec_swig.async_decoder_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(async_decoder_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.async_decoder_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(async_decoder_sptr self) -> int"""
        return _fec_swig.async_decoder_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(async_decoder_sptr self) -> int"""
        return _fec_swig.async_decoder_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(async_decoder_sptr self, int priority) -> int"""
        return _fec_swig.async_decoder_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(async_decoder_sptr self) -> std::string"""
        return _fec_swig.async_decoder_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(async_decoder_sptr self) -> std::string"""
        return _fec_swig.async_decoder_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(async_decoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.async_decoder_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(async_decoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.async_decoder_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(async_decoder_sptr self) -> long"""
        return _fec_swig.async_decoder_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(async_decoder_sptr self) -> basic_block_sptr"""
        return _fec_swig.async_decoder_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(async_decoder_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.async_decoder_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(async_decoder_sptr self) -> std::string"""
        return _fec_swig.async_decoder_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(async_decoder_sptr self, std::string name)"""
        return _fec_swig.async_decoder_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(async_decoder_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.async_decoder_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(async_decoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.async_decoder_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(async_decoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.async_decoder_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(async_decoder_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.async_decoder_sptr_message_subscribers(self, which_port)

# Register async_decoder_sptr in _fec_swig:
_fec_swig.async_decoder_sptr_swigregister(async_decoder_sptr)

async_decoder_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
async_decoder = async_decoder.make;

class async_encoder_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::async_encoder > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(async_encoder_sptr self) -> async_encoder_sptr
        __init__(async_encoder_sptr self, async_encoder p) -> async_encoder_sptr
        """
        _fec_swig.async_encoder_sptr_swiginit(self, _fec_swig.new_async_encoder_sptr(*args))

    def __deref__(self) -> "gr::fec::async_encoder *":
        r"""__deref__(async_encoder_sptr self) -> async_encoder"""
        return _fec_swig.async_encoder_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_async_encoder_sptr

    def make(self, my_encoder: "generic_encoder_sptr", packed: "bool"=False, rev_unpack: "bool"=True, rev_pack: "bool"=True, mtu: "int"=1500) -> "gr::fec::async_encoder::sptr":
        r"""
        make(async_encoder_sptr self, generic_encoder_sptr my_encoder, bool packed=False, bool rev_unpack=True, bool rev_pack=True, int mtu=1500) -> async_encoder_sptr
        Creates the encoder block for use in GNU Radio flowgraphs with async message from a given FEC API object derived from the generic_encoder class.

        Encodes frames received as async messages or as a PDU over a message port. This encoder works off a full message as one frame or block to encode. The message length is used as the frame length. To support this, the encoder variable used will have had its frame_size set. This block treats that initial frame_size value as the maximum transmission unit (MTU) and will not process frames larger than that.


        This deployment works off messages and expects them to either be messages full of unpacked bits or PDU messages, which means full bytes of a frame from the higher layers, including things like headers, tails, CRC check bytes, etc. For handling PDUs, set the  option of this deployment block to True. The block will then use the FEC API to properly unpack the bits from the PDU, pass it through the encoder, and repack them to output the PDUs for the next stage of processing.


        The packed PDU form of this deployment is designed to work well with other PDU-based blocks to operate within the processing flow of data packets or frames.


        Due to differences in how data is packed and processed, this block also offers the ability to change the direction of how bits are unpacked and packed, where reading or writing from the LSB or MSB. By default, the  and  modes are set to True. Using this setup allows the async block to behave with PDUs in the same operation and format as the tagged stream encoders. That is, putting the same data into both the tagged stream encoder deployment and this with these default settings should produce the same data.

        Constructor Specific Documentation:

        Build the PDU-based FEC encoder block from an FECAPI encoder object.

        Args:
            my_encoder : An FECAPI encoder object child of the generic_encoder class.
            packed : True if working on packed bytes (like PDUs).
            rev_unpack : Reverse the unpacking order from input bytes to bits.
            rev_pack : Reverse the packing order from bits to output bytes.
            mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.
        """
        return _fec_swig.async_encoder_sptr_make(self, my_encoder, packed, rev_unpack, rev_pack, mtu)

    def general_work(self, noutput_items: "int", ninput_items: "gr_vector_int &", input_items: "gr_vector_const_void_star &", output_items: "gr_vector_void_star &") -> "int":
        r"""general_work(async_encoder_sptr self, int noutput_items, gr_vector_int & ninput_items, gr_vector_const_void_star & input_items, gr_vector_void_star & output_items) -> int"""
        return _fec_swig.async_encoder_sptr_general_work(self, noutput_items, ninput_items, input_items, output_items)

    def history(self) -> "unsigned int":
        r"""history(async_encoder_sptr self) -> unsigned int"""
        return _fec_swig.async_encoder_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(async_encoder_sptr self, int which, int delay)
        declare_sample_delay(async_encoder_sptr self, unsigned int delay)
        """
        return _fec_swig.async_encoder_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(async_encoder_sptr self, int which) -> unsigned int"""
        return _fec_swig.async_encoder_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(async_encoder_sptr self, int multiple)"""
        return _fec_swig.async_encoder_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(async_encoder_sptr self) -> int"""
        return _fec_swig.async_encoder_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(async_encoder_sptr self) -> double"""
        return _fec_swig.async_encoder_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(async_encoder_sptr self) -> uint64_t"""
        return _fec_swig.async_encoder_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(async_encoder_sptr self) -> uint64_t"""
        return _fec_swig.async_encoder_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(async_encoder_sptr self) -> bool"""
        return _fec_swig.async_encoder_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(async_encoder_sptr self) -> bool"""
        return _fec_swig.async_encoder_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(async_encoder_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.async_encoder_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(async_encoder_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.async_encoder_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(async_encoder_sptr self, std::string level)"""
        return _fec_swig.async_encoder_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(async_encoder_sptr self) -> std::string"""
        return _fec_swig.async_encoder_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(async_encoder_sptr self) -> int"""
        return _fec_swig.async_encoder_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(async_encoder_sptr self, int m)"""
        return _fec_swig.async_encoder_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(async_encoder_sptr self)"""
        return _fec_swig.async_encoder_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(async_encoder_sptr self) -> bool"""
        return _fec_swig.async_encoder_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(async_encoder_sptr self, int m)"""
        return _fec_swig.async_encoder_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(async_encoder_sptr self) -> int"""
        return _fec_swig.async_encoder_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(async_encoder_sptr self, int i) -> long"""
        return _fec_swig.async_encoder_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(async_encoder_sptr self, long max_output_buffer)
        set_max_output_buffer(async_encoder_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.async_encoder_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(async_encoder_sptr self, int i) -> long"""
        return _fec_swig.async_encoder_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(async_encoder_sptr self, long min_output_buffer)
        set_min_output_buffer(async_encoder_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.async_encoder_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(async_encoder_sptr self, int which) -> float
        pc_input_buffers_full(async_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_encoder_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(async_encoder_sptr self, int which) -> float
        pc_input_buffers_full_avg(async_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_encoder_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(async_encoder_sptr self, int which) -> float
        pc_input_buffers_full_var(async_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_encoder_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(async_encoder_sptr self, int which) -> float
        pc_output_buffers_full(async_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_encoder_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(async_encoder_sptr self, int which) -> float
        pc_output_buffers_full_avg(async_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_encoder_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(async_encoder_sptr self, int which) -> float
        pc_output_buffers_full_var(async_encoder_sptr self) -> pmt_vector_float
        """
        return _fec_swig.async_encoder_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(async_encoder_sptr self) -> float"""
        return _fec_swig.async_encoder_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(async_encoder_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.async_encoder_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(async_encoder_sptr self)"""
        return _fec_swig.async_encoder_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(async_encoder_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.async_encoder_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(async_encoder_sptr self) -> int"""
        return _fec_swig.async_encoder_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(async_encoder_sptr self) -> int"""
        return _fec_swig.async_encoder_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(async_encoder_sptr self, int priority) -> int"""
        return _fec_swig.async_encoder_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(async_encoder_sptr self) -> std::string"""
        return _fec_swig.async_encoder_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(async_encoder_sptr self) -> std::string"""
        return _fec_swig.async_encoder_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(async_encoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.async_encoder_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(async_encoder_sptr self) -> io_signature_sptr"""
        return _fec_swig.async_encoder_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(async_encoder_sptr self) -> long"""
        return _fec_swig.async_encoder_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(async_encoder_sptr self) -> basic_block_sptr"""
        return _fec_swig.async_encoder_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(async_encoder_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.async_encoder_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(async_encoder_sptr self) -> std::string"""
        return _fec_swig.async_encoder_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(async_encoder_sptr self, std::string name)"""
        return _fec_swig.async_encoder_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(async_encoder_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.async_encoder_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(async_encoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.async_encoder_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(async_encoder_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.async_encoder_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(async_encoder_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.async_encoder_sptr_message_subscribers(self, which_port)

# Register async_encoder_sptr in _fec_swig:
_fec_swig.async_encoder_sptr_swigregister(async_encoder_sptr)

async_encoder_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
async_encoder = async_encoder.make;

class decode_ccsds_27_fb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::decode_ccsds_27_fb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(decode_ccsds_27_fb_sptr self) -> decode_ccsds_27_fb_sptr
        __init__(decode_ccsds_27_fb_sptr self, decode_ccsds_27_fb p) -> decode_ccsds_27_fb_sptr
        """
        _fec_swig.decode_ccsds_27_fb_sptr_swiginit(self, _fec_swig.new_decode_ccsds_27_fb_sptr(*args))

    def __deref__(self) -> "gr::fec::decode_ccsds_27_fb *":
        r"""__deref__(decode_ccsds_27_fb_sptr self) -> decode_ccsds_27_fb"""
        return _fec_swig.decode_ccsds_27_fb_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_decode_ccsds_27_fb_sptr

    def make(self) -> "gr::fec::decode_ccsds_27_fb::sptr":
        r"""
        make(decode_ccsds_27_fb_sptr self) -> decode_ccsds_27_fb_sptr
        A rate 1/2, k=7 convolutional decoder for the CCSDS standard.

        This block performs soft-decision convolutional decoding using the Viterbi algorithm.


        The input is a stream of (possibly noise corrupted) floating point values nominally spanning [-1.0, 1.0], representing the encoded channel symbols 0 (-1.0) and 1 (1.0), with erased symbols at 0.0.


        The output is MSB first packed bytes of decoded values.


        As a rate 1/2 code, there will be one output byte for every 16 input symbols.


        This block is designed for continuous data streaming, not packetized data. The first 32 bits out will be zeroes, with the output delayed four bytes from the corresponding inputs.

        Constructor Specific Documentation:


        """
        return _fec_swig.decode_ccsds_27_fb_sptr_make(self)

    def history(self) -> "unsigned int":
        r"""history(decode_ccsds_27_fb_sptr self) -> unsigned int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(decode_ccsds_27_fb_sptr self, int which, int delay)
        declare_sample_delay(decode_ccsds_27_fb_sptr self, unsigned int delay)
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(decode_ccsds_27_fb_sptr self, int which) -> unsigned int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(decode_ccsds_27_fb_sptr self, int multiple)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(decode_ccsds_27_fb_sptr self) -> int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(decode_ccsds_27_fb_sptr self) -> double"""
        return _fec_swig.decode_ccsds_27_fb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(decode_ccsds_27_fb_sptr self) -> uint64_t"""
        return _fec_swig.decode_ccsds_27_fb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(decode_ccsds_27_fb_sptr self) -> uint64_t"""
        return _fec_swig.decode_ccsds_27_fb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(decode_ccsds_27_fb_sptr self) -> bool"""
        return _fec_swig.decode_ccsds_27_fb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(decode_ccsds_27_fb_sptr self) -> bool"""
        return _fec_swig.decode_ccsds_27_fb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(decode_ccsds_27_fb_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.decode_ccsds_27_fb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(decode_ccsds_27_fb_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.decode_ccsds_27_fb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(decode_ccsds_27_fb_sptr self, std::string level)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(decode_ccsds_27_fb_sptr self) -> std::string"""
        return _fec_swig.decode_ccsds_27_fb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(decode_ccsds_27_fb_sptr self) -> int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(decode_ccsds_27_fb_sptr self, int m)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(decode_ccsds_27_fb_sptr self)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(decode_ccsds_27_fb_sptr self) -> bool"""
        return _fec_swig.decode_ccsds_27_fb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(decode_ccsds_27_fb_sptr self, int m)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(decode_ccsds_27_fb_sptr self) -> int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(decode_ccsds_27_fb_sptr self, int i) -> long"""
        return _fec_swig.decode_ccsds_27_fb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(decode_ccsds_27_fb_sptr self, long max_output_buffer)
        set_max_output_buffer(decode_ccsds_27_fb_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(decode_ccsds_27_fb_sptr self, int i) -> long"""
        return _fec_swig.decode_ccsds_27_fb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(decode_ccsds_27_fb_sptr self, long min_output_buffer)
        set_min_output_buffer(decode_ccsds_27_fb_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(decode_ccsds_27_fb_sptr self, int which) -> float
        pc_input_buffers_full(decode_ccsds_27_fb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(decode_ccsds_27_fb_sptr self, int which) -> float
        pc_input_buffers_full_avg(decode_ccsds_27_fb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(decode_ccsds_27_fb_sptr self, int which) -> float
        pc_input_buffers_full_var(decode_ccsds_27_fb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(decode_ccsds_27_fb_sptr self, int which) -> float
        pc_output_buffers_full(decode_ccsds_27_fb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(decode_ccsds_27_fb_sptr self, int which) -> float
        pc_output_buffers_full_avg(decode_ccsds_27_fb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(decode_ccsds_27_fb_sptr self, int which) -> float
        pc_output_buffers_full_var(decode_ccsds_27_fb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(decode_ccsds_27_fb_sptr self) -> float"""
        return _fec_swig.decode_ccsds_27_fb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(decode_ccsds_27_fb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(decode_ccsds_27_fb_sptr self)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(decode_ccsds_27_fb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.decode_ccsds_27_fb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(decode_ccsds_27_fb_sptr self) -> int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(decode_ccsds_27_fb_sptr self) -> int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(decode_ccsds_27_fb_sptr self, int priority) -> int"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(decode_ccsds_27_fb_sptr self) -> std::string"""
        return _fec_swig.decode_ccsds_27_fb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(decode_ccsds_27_fb_sptr self) -> std::string"""
        return _fec_swig.decode_ccsds_27_fb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(decode_ccsds_27_fb_sptr self) -> io_signature_sptr"""
        return _fec_swig.decode_ccsds_27_fb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(decode_ccsds_27_fb_sptr self) -> io_signature_sptr"""
        return _fec_swig.decode_ccsds_27_fb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(decode_ccsds_27_fb_sptr self) -> long"""
        return _fec_swig.decode_ccsds_27_fb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(decode_ccsds_27_fb_sptr self) -> basic_block_sptr"""
        return _fec_swig.decode_ccsds_27_fb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(decode_ccsds_27_fb_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.decode_ccsds_27_fb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(decode_ccsds_27_fb_sptr self) -> std::string"""
        return _fec_swig.decode_ccsds_27_fb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(decode_ccsds_27_fb_sptr self, std::string name)"""
        return _fec_swig.decode_ccsds_27_fb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(decode_ccsds_27_fb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.decode_ccsds_27_fb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(decode_ccsds_27_fb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.decode_ccsds_27_fb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(decode_ccsds_27_fb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.decode_ccsds_27_fb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(decode_ccsds_27_fb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.decode_ccsds_27_fb_sptr_message_subscribers(self, which_port)

# Register decode_ccsds_27_fb_sptr in _fec_swig:
_fec_swig.decode_ccsds_27_fb_sptr_swigregister(decode_ccsds_27_fb_sptr)

decode_ccsds_27_fb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
decode_ccsds_27_fb = decode_ccsds_27_fb.make;

class encode_ccsds_27_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::encode_ccsds_27_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(encode_ccsds_27_bb_sptr self) -> encode_ccsds_27_bb_sptr
        __init__(encode_ccsds_27_bb_sptr self, encode_ccsds_27_bb p) -> encode_ccsds_27_bb_sptr
        """
        _fec_swig.encode_ccsds_27_bb_sptr_swiginit(self, _fec_swig.new_encode_ccsds_27_bb_sptr(*args))

    def __deref__(self) -> "gr::fec::encode_ccsds_27_bb *":
        r"""__deref__(encode_ccsds_27_bb_sptr self) -> encode_ccsds_27_bb"""
        return _fec_swig.encode_ccsds_27_bb_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_encode_ccsds_27_bb_sptr

    def make(self) -> "gr::fec::encode_ccsds_27_bb::sptr":
        r"""
        make(encode_ccsds_27_bb_sptr self) -> encode_ccsds_27_bb_sptr
        A rate 1/2, k=7 convolutional encoder for the CCSDS standard.

        This block performs convolutional encoding using the CCSDS standard polynomial ("Voyager").


        The input is an MSB first packed stream of bits.


        The output is a stream of symbols 0 or 1 representing the encoded data.


        As a rate 1/2 code, there will be 16 output symbols for every input byte.


        This block is designed for continuous data streaming, not packetized data. There is no provision to "flush" the encoder.

        Constructor Specific Documentation:


        """
        return _fec_swig.encode_ccsds_27_bb_sptr_make(self)

    def history(self) -> "unsigned int":
        r"""history(encode_ccsds_27_bb_sptr self) -> unsigned int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(encode_ccsds_27_bb_sptr self, int which, int delay)
        declare_sample_delay(encode_ccsds_27_bb_sptr self, unsigned int delay)
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(encode_ccsds_27_bb_sptr self, int which) -> unsigned int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(encode_ccsds_27_bb_sptr self, int multiple)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(encode_ccsds_27_bb_sptr self) -> int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(encode_ccsds_27_bb_sptr self) -> double"""
        return _fec_swig.encode_ccsds_27_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(encode_ccsds_27_bb_sptr self) -> uint64_t"""
        return _fec_swig.encode_ccsds_27_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(encode_ccsds_27_bb_sptr self) -> uint64_t"""
        return _fec_swig.encode_ccsds_27_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(encode_ccsds_27_bb_sptr self) -> bool"""
        return _fec_swig.encode_ccsds_27_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(encode_ccsds_27_bb_sptr self) -> bool"""
        return _fec_swig.encode_ccsds_27_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(encode_ccsds_27_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.encode_ccsds_27_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(encode_ccsds_27_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.encode_ccsds_27_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(encode_ccsds_27_bb_sptr self, std::string level)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(encode_ccsds_27_bb_sptr self) -> std::string"""
        return _fec_swig.encode_ccsds_27_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(encode_ccsds_27_bb_sptr self) -> int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(encode_ccsds_27_bb_sptr self, int m)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(encode_ccsds_27_bb_sptr self)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(encode_ccsds_27_bb_sptr self) -> bool"""
        return _fec_swig.encode_ccsds_27_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(encode_ccsds_27_bb_sptr self, int m)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(encode_ccsds_27_bb_sptr self) -> int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(encode_ccsds_27_bb_sptr self, int i) -> long"""
        return _fec_swig.encode_ccsds_27_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(encode_ccsds_27_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(encode_ccsds_27_bb_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(encode_ccsds_27_bb_sptr self, int i) -> long"""
        return _fec_swig.encode_ccsds_27_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(encode_ccsds_27_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(encode_ccsds_27_bb_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(encode_ccsds_27_bb_sptr self, int which) -> float
        pc_input_buffers_full(encode_ccsds_27_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(encode_ccsds_27_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(encode_ccsds_27_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(encode_ccsds_27_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(encode_ccsds_27_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(encode_ccsds_27_bb_sptr self, int which) -> float
        pc_output_buffers_full(encode_ccsds_27_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(encode_ccsds_27_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(encode_ccsds_27_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(encode_ccsds_27_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(encode_ccsds_27_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(encode_ccsds_27_bb_sptr self) -> float"""
        return _fec_swig.encode_ccsds_27_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(encode_ccsds_27_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(encode_ccsds_27_bb_sptr self)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(encode_ccsds_27_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.encode_ccsds_27_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(encode_ccsds_27_bb_sptr self) -> int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(encode_ccsds_27_bb_sptr self) -> int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(encode_ccsds_27_bb_sptr self, int priority) -> int"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(encode_ccsds_27_bb_sptr self) -> std::string"""
        return _fec_swig.encode_ccsds_27_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(encode_ccsds_27_bb_sptr self) -> std::string"""
        return _fec_swig.encode_ccsds_27_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(encode_ccsds_27_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.encode_ccsds_27_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(encode_ccsds_27_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.encode_ccsds_27_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(encode_ccsds_27_bb_sptr self) -> long"""
        return _fec_swig.encode_ccsds_27_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(encode_ccsds_27_bb_sptr self) -> basic_block_sptr"""
        return _fec_swig.encode_ccsds_27_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(encode_ccsds_27_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.encode_ccsds_27_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(encode_ccsds_27_bb_sptr self) -> std::string"""
        return _fec_swig.encode_ccsds_27_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(encode_ccsds_27_bb_sptr self, std::string name)"""
        return _fec_swig.encode_ccsds_27_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(encode_ccsds_27_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.encode_ccsds_27_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(encode_ccsds_27_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.encode_ccsds_27_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(encode_ccsds_27_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.encode_ccsds_27_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(encode_ccsds_27_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.encode_ccsds_27_bb_sptr_message_subscribers(self, which_port)

# Register encode_ccsds_27_bb_sptr in _fec_swig:
_fec_swig.encode_ccsds_27_bb_sptr_swigregister(encode_ccsds_27_bb_sptr)

encode_ccsds_27_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
encode_ccsds_27_bb = encode_ccsds_27_bb.make;

class ber_bf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::ber_bf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ber_bf_sptr self) -> ber_bf_sptr
        __init__(ber_bf_sptr self, ber_bf p) -> ber_bf_sptr
        """
        _fec_swig.ber_bf_sptr_swiginit(self, _fec_swig.new_ber_bf_sptr(*args))

    def __deref__(self) -> "gr::fec::ber_bf *":
        r"""__deref__(ber_bf_sptr self) -> ber_bf"""
        return _fec_swig.ber_bf_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_ber_bf_sptr

    def total_errors(self) -> "long":
        r"""
        total_errors(ber_bf_sptr self) -> long
        Get total number of errors counter value.
        """
        return _fec_swig.ber_bf_sptr_total_errors(self)

    def make(self, test_mode: "bool"=False, berminerrors: "int"=100, ber_limit: "float"=-7.0) -> "gr::fec::ber_bf::sptr":
        r"""
        make(ber_bf_sptr self, bool test_mode=False, int berminerrors=100, float ber_limit=-7.0) -> ber_bf_sptr
        BER block in FECAPI.

        This block measures the bit error rate between two streams of packed data. It compares the bits of each streams and counts the number of incorrect bits between them. It outputs the log of the bit error rate, so a value of -X is 10^{-X} bit errors.


        When the  is set to false (default), it is in streaming mode. This means that the output is constantly producing the current value of the BER. In this mode, there is a single output BER calculation per chunk of bytes passed to it, so there is no exact timing between calculations of BER. In this mode, the other two parameters to the constructor are ignored.


        When  is true, the block is in test mode. This mode is used in the ber_curve_gen example and for other offline analysis of BER curves. Here, the block waits until at least  are observed and then produces a BER calculation. The parameter  helps make sure that the simulation is controlled. If the BER calculation drops below the  setting, the block will exit and simply return the set limit; the real BER is therefore some amount lower than this.


        Note that this block takes in data as packed bytes with 8-bits per byte used. It outputs a stream of floats as the log-scale BER.

        Constructor Specific Documentation:

        Calculate the BER between two streams of data.

        Args:
            test_mode : false for normal streaming mode (default); true for test mode.
            berminerrors : the block needs to observe this many errors before outputting a result. Only valid when test_mode=true.
            ber_limit : if the BER calculation falls below this limit, produce this value and exit. Only valid when test_mode=true.
        """
        return _fec_swig.ber_bf_sptr_make(self, test_mode, berminerrors, ber_limit)

    def history(self) -> "unsigned int":
        r"""history(ber_bf_sptr self) -> unsigned int"""
        return _fec_swig.ber_bf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(ber_bf_sptr self, int which, int delay)
        declare_sample_delay(ber_bf_sptr self, unsigned int delay)
        """
        return _fec_swig.ber_bf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(ber_bf_sptr self, int which) -> unsigned int"""
        return _fec_swig.ber_bf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(ber_bf_sptr self, int multiple)"""
        return _fec_swig.ber_bf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(ber_bf_sptr self) -> int"""
        return _fec_swig.ber_bf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(ber_bf_sptr self) -> double"""
        return _fec_swig.ber_bf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(ber_bf_sptr self) -> uint64_t"""
        return _fec_swig.ber_bf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(ber_bf_sptr self) -> uint64_t"""
        return _fec_swig.ber_bf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(ber_bf_sptr self) -> bool"""
        return _fec_swig.ber_bf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(ber_bf_sptr self) -> bool"""
        return _fec_swig.ber_bf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(ber_bf_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.ber_bf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(ber_bf_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.ber_bf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ber_bf_sptr self, std::string level)"""
        return _fec_swig.ber_bf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ber_bf_sptr self) -> std::string"""
        return _fec_swig.ber_bf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(ber_bf_sptr self) -> int"""
        return _fec_swig.ber_bf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(ber_bf_sptr self, int m)"""
        return _fec_swig.ber_bf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(ber_bf_sptr self)"""
        return _fec_swig.ber_bf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(ber_bf_sptr self) -> bool"""
        return _fec_swig.ber_bf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(ber_bf_sptr self, int m)"""
        return _fec_swig.ber_bf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(ber_bf_sptr self) -> int"""
        return _fec_swig.ber_bf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(ber_bf_sptr self, int i) -> long"""
        return _fec_swig.ber_bf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ber_bf_sptr self, long max_output_buffer)
        set_max_output_buffer(ber_bf_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.ber_bf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(ber_bf_sptr self, int i) -> long"""
        return _fec_swig.ber_bf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ber_bf_sptr self, long min_output_buffer)
        set_min_output_buffer(ber_bf_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.ber_bf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(ber_bf_sptr self, int which) -> float
        pc_input_buffers_full(ber_bf_sptr self) -> pmt_vector_float
        """
        return _fec_swig.ber_bf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(ber_bf_sptr self, int which) -> float
        pc_input_buffers_full_avg(ber_bf_sptr self) -> pmt_vector_float
        """
        return _fec_swig.ber_bf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(ber_bf_sptr self, int which) -> float
        pc_input_buffers_full_var(ber_bf_sptr self) -> pmt_vector_float
        """
        return _fec_swig.ber_bf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(ber_bf_sptr self, int which) -> float
        pc_output_buffers_full(ber_bf_sptr self) -> pmt_vector_float
        """
        return _fec_swig.ber_bf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(ber_bf_sptr self, int which) -> float
        pc_output_buffers_full_avg(ber_bf_sptr self) -> pmt_vector_float
        """
        return _fec_swig.ber_bf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(ber_bf_sptr self, int which) -> float
        pc_output_buffers_full_var(ber_bf_sptr self) -> pmt_vector_float
        """
        return _fec_swig.ber_bf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(ber_bf_sptr self) -> float"""
        return _fec_swig.ber_bf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ber_bf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.ber_bf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ber_bf_sptr self)"""
        return _fec_swig.ber_bf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ber_bf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.ber_bf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(ber_bf_sptr self) -> int"""
        return _fec_swig.ber_bf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(ber_bf_sptr self) -> int"""
        return _fec_swig.ber_bf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(ber_bf_sptr self, int priority) -> int"""
        return _fec_swig.ber_bf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(ber_bf_sptr self) -> std::string"""
        return _fec_swig.ber_bf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ber_bf_sptr self) -> std::string"""
        return _fec_swig.ber_bf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ber_bf_sptr self) -> io_signature_sptr"""
        return _fec_swig.ber_bf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ber_bf_sptr self) -> io_signature_sptr"""
        return _fec_swig.ber_bf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ber_bf_sptr self) -> long"""
        return _fec_swig.ber_bf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ber_bf_sptr self) -> basic_block_sptr"""
        return _fec_swig.ber_bf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ber_bf_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.ber_bf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ber_bf_sptr self) -> std::string"""
        return _fec_swig.ber_bf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ber_bf_sptr self, std::string name)"""
        return _fec_swig.ber_bf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ber_bf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.ber_bf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ber_bf_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.ber_bf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ber_bf_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.ber_bf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ber_bf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.ber_bf_sptr_message_subscribers(self, which_port)

# Register ber_bf_sptr in _fec_swig:
_fec_swig.ber_bf_sptr_swigregister(ber_bf_sptr)

ber_bf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ber_bf = ber_bf.make;

class conv_bit_corr_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::conv_bit_corr_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(conv_bit_corr_bb_sptr self) -> conv_bit_corr_bb_sptr
        __init__(conv_bit_corr_bb_sptr self, conv_bit_corr_bb p) -> conv_bit_corr_bb_sptr
        """
        _fec_swig.conv_bit_corr_bb_sptr_swiginit(self, _fec_swig.new_conv_bit_corr_bb_sptr(*args))

    def __deref__(self) -> "gr::fec::conv_bit_corr_bb *":
        r"""__deref__(conv_bit_corr_bb_sptr self) -> conv_bit_corr_bb"""
        return _fec_swig.conv_bit_corr_bb_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_conv_bit_corr_bb_sptr

    def make(self, correlator: "std::vector< unsigned long long,std::allocator< unsigned long long > >", corr_sym: "int", corr_len: "int", cut: "int", flush: "int", thresh: "float") -> "gr::fec::conv_bit_corr_bb::sptr":
        r"""
        make(conv_bit_corr_bb_sptr self, std::vector< unsigned long long,std::allocator< unsigned long long > > correlator, int corr_sym, int corr_len, int cut, int flush, float thresh) -> conv_bit_corr_bb_sptr
        Correlate block in FECAPI.

        What does this block do?

        Constructor Specific Documentation:



        Args:
            correlator : 
            corr_sym : 
            corr_len : 
            cut : 
            flush : 
            thresh : 
        """
        return _fec_swig.conv_bit_corr_bb_sptr_make(self, correlator, corr_sym, corr_len, cut, flush, thresh)

    def data_garble_rate(self, taps: "int", syn_density: "float") -> "float":
        r"""
        data_garble_rate(conv_bit_corr_bb_sptr self, int taps, float syn_density) -> float
        This subroutine will find the encoded data garble rate corresponding to a syndrome density of target, that is created with an annihilating polynomial with 'taps' number of taps.
        """
        return _fec_swig.conv_bit_corr_bb_sptr_data_garble_rate(self, taps, syn_density)

    def history(self) -> "unsigned int":
        r"""history(conv_bit_corr_bb_sptr self) -> unsigned int"""
        return _fec_swig.conv_bit_corr_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(conv_bit_corr_bb_sptr self, int which, int delay)
        declare_sample_delay(conv_bit_corr_bb_sptr self, unsigned int delay)
        """
        return _fec_swig.conv_bit_corr_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(conv_bit_corr_bb_sptr self, int which) -> unsigned int"""
        return _fec_swig.conv_bit_corr_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(conv_bit_corr_bb_sptr self, int multiple)"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(conv_bit_corr_bb_sptr self) -> int"""
        return _fec_swig.conv_bit_corr_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(conv_bit_corr_bb_sptr self) -> double"""
        return _fec_swig.conv_bit_corr_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(conv_bit_corr_bb_sptr self) -> uint64_t"""
        return _fec_swig.conv_bit_corr_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(conv_bit_corr_bb_sptr self) -> uint64_t"""
        return _fec_swig.conv_bit_corr_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(conv_bit_corr_bb_sptr self) -> bool"""
        return _fec_swig.conv_bit_corr_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(conv_bit_corr_bb_sptr self) -> bool"""
        return _fec_swig.conv_bit_corr_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(conv_bit_corr_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.conv_bit_corr_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(conv_bit_corr_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.conv_bit_corr_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(conv_bit_corr_bb_sptr self, std::string level)"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(conv_bit_corr_bb_sptr self) -> std::string"""
        return _fec_swig.conv_bit_corr_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(conv_bit_corr_bb_sptr self) -> int"""
        return _fec_swig.conv_bit_corr_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(conv_bit_corr_bb_sptr self, int m)"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(conv_bit_corr_bb_sptr self)"""
        return _fec_swig.conv_bit_corr_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(conv_bit_corr_bb_sptr self) -> bool"""
        return _fec_swig.conv_bit_corr_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(conv_bit_corr_bb_sptr self, int m)"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(conv_bit_corr_bb_sptr self) -> int"""
        return _fec_swig.conv_bit_corr_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(conv_bit_corr_bb_sptr self, int i) -> long"""
        return _fec_swig.conv_bit_corr_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(conv_bit_corr_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(conv_bit_corr_bb_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.conv_bit_corr_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(conv_bit_corr_bb_sptr self, int i) -> long"""
        return _fec_swig.conv_bit_corr_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(conv_bit_corr_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(conv_bit_corr_bb_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.conv_bit_corr_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(conv_bit_corr_bb_sptr self, int which) -> float
        pc_input_buffers_full(conv_bit_corr_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.conv_bit_corr_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(conv_bit_corr_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(conv_bit_corr_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.conv_bit_corr_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(conv_bit_corr_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(conv_bit_corr_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.conv_bit_corr_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(conv_bit_corr_bb_sptr self, int which) -> float
        pc_output_buffers_full(conv_bit_corr_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.conv_bit_corr_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(conv_bit_corr_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(conv_bit_corr_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.conv_bit_corr_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(conv_bit_corr_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(conv_bit_corr_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.conv_bit_corr_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(conv_bit_corr_bb_sptr self) -> float"""
        return _fec_swig.conv_bit_corr_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(conv_bit_corr_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(conv_bit_corr_bb_sptr self)"""
        return _fec_swig.conv_bit_corr_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(conv_bit_corr_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.conv_bit_corr_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(conv_bit_corr_bb_sptr self) -> int"""
        return _fec_swig.conv_bit_corr_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(conv_bit_corr_bb_sptr self) -> int"""
        return _fec_swig.conv_bit_corr_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(conv_bit_corr_bb_sptr self, int priority) -> int"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(conv_bit_corr_bb_sptr self) -> std::string"""
        return _fec_swig.conv_bit_corr_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(conv_bit_corr_bb_sptr self) -> std::string"""
        return _fec_swig.conv_bit_corr_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(conv_bit_corr_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.conv_bit_corr_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(conv_bit_corr_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.conv_bit_corr_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(conv_bit_corr_bb_sptr self) -> long"""
        return _fec_swig.conv_bit_corr_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(conv_bit_corr_bb_sptr self) -> basic_block_sptr"""
        return _fec_swig.conv_bit_corr_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(conv_bit_corr_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.conv_bit_corr_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(conv_bit_corr_bb_sptr self) -> std::string"""
        return _fec_swig.conv_bit_corr_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(conv_bit_corr_bb_sptr self, std::string name)"""
        return _fec_swig.conv_bit_corr_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(conv_bit_corr_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.conv_bit_corr_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(conv_bit_corr_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.conv_bit_corr_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(conv_bit_corr_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.conv_bit_corr_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(conv_bit_corr_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.conv_bit_corr_bb_sptr_message_subscribers(self, which_port)

# Register conv_bit_corr_bb_sptr in _fec_swig:
_fec_swig.conv_bit_corr_bb_sptr_swigregister(conv_bit_corr_bb_sptr)

conv_bit_corr_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
conv_bit_corr_bb = conv_bit_corr_bb.make;

class puncture_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::puncture_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(puncture_bb_sptr self) -> puncture_bb_sptr
        __init__(puncture_bb_sptr self, puncture_bb p) -> puncture_bb_sptr
        """
        _fec_swig.puncture_bb_sptr_swiginit(self, _fec_swig.new_puncture_bb_sptr(*args))

    def __deref__(self) -> "gr::fec::puncture_bb *":
        r"""__deref__(puncture_bb_sptr self) -> puncture_bb"""
        return _fec_swig.puncture_bb_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_puncture_bb_sptr

    def make(self, puncsize: "int", puncpat: "int", delay: "int"=0) -> "gr::fec::puncture_bb::sptr":
        r"""
        make(puncture_bb_sptr self, int puncsize, int puncpat, int delay=0) -> puncture_bb_sptr
        Puncture a stream of unpacked bits.

        Puncture a given block of input samples of . The items produced is based on pattern . Basically, if:





        This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the puncturing will be done on the symbol level, not the bit level.


         is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





        Example: 


        The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


        The fec.extended_encoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


        Note that due to the above concept, the default setting in the extended encoder of '11' translates into no puncturing.


        The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

        Constructor Specific Documentation:

        Constructs a puncture block for unpacked bits.

        Args:
            puncsize : Size of block of bits to puncture
            puncpat : The puncturing pattern
            delay : Delayed the puncturing pattern by shifting it
        """
        return _fec_swig.puncture_bb_sptr_make(self, puncsize, puncpat, delay)

    def history(self) -> "unsigned int":
        r"""history(puncture_bb_sptr self) -> unsigned int"""
        return _fec_swig.puncture_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(puncture_bb_sptr self, int which, int delay)
        declare_sample_delay(puncture_bb_sptr self, unsigned int delay)
        """
        return _fec_swig.puncture_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(puncture_bb_sptr self, int which) -> unsigned int"""
        return _fec_swig.puncture_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(puncture_bb_sptr self, int multiple)"""
        return _fec_swig.puncture_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(puncture_bb_sptr self) -> int"""
        return _fec_swig.puncture_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(puncture_bb_sptr self) -> double"""
        return _fec_swig.puncture_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(puncture_bb_sptr self) -> uint64_t"""
        return _fec_swig.puncture_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(puncture_bb_sptr self) -> uint64_t"""
        return _fec_swig.puncture_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(puncture_bb_sptr self) -> bool"""
        return _fec_swig.puncture_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(puncture_bb_sptr self) -> bool"""
        return _fec_swig.puncture_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(puncture_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.puncture_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(puncture_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.puncture_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(puncture_bb_sptr self, std::string level)"""
        return _fec_swig.puncture_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(puncture_bb_sptr self) -> std::string"""
        return _fec_swig.puncture_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(puncture_bb_sptr self) -> int"""
        return _fec_swig.puncture_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(puncture_bb_sptr self, int m)"""
        return _fec_swig.puncture_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(puncture_bb_sptr self)"""
        return _fec_swig.puncture_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(puncture_bb_sptr self) -> bool"""
        return _fec_swig.puncture_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(puncture_bb_sptr self, int m)"""
        return _fec_swig.puncture_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(puncture_bb_sptr self) -> int"""
        return _fec_swig.puncture_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(puncture_bb_sptr self, int i) -> long"""
        return _fec_swig.puncture_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(puncture_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(puncture_bb_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.puncture_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(puncture_bb_sptr self, int i) -> long"""
        return _fec_swig.puncture_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(puncture_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(puncture_bb_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.puncture_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(puncture_bb_sptr self, int which) -> float
        pc_input_buffers_full(puncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(puncture_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(puncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(puncture_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(puncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(puncture_bb_sptr self, int which) -> float
        pc_output_buffers_full(puncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(puncture_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(puncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(puncture_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(puncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(puncture_bb_sptr self) -> float"""
        return _fec_swig.puncture_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(puncture_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.puncture_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(puncture_bb_sptr self)"""
        return _fec_swig.puncture_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(puncture_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.puncture_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(puncture_bb_sptr self) -> int"""
        return _fec_swig.puncture_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(puncture_bb_sptr self) -> int"""
        return _fec_swig.puncture_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(puncture_bb_sptr self, int priority) -> int"""
        return _fec_swig.puncture_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(puncture_bb_sptr self) -> std::string"""
        return _fec_swig.puncture_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(puncture_bb_sptr self) -> std::string"""
        return _fec_swig.puncture_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(puncture_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.puncture_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(puncture_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.puncture_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(puncture_bb_sptr self) -> long"""
        return _fec_swig.puncture_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(puncture_bb_sptr self) -> basic_block_sptr"""
        return _fec_swig.puncture_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(puncture_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.puncture_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(puncture_bb_sptr self) -> std::string"""
        return _fec_swig.puncture_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(puncture_bb_sptr self, std::string name)"""
        return _fec_swig.puncture_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(puncture_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.puncture_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(puncture_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.puncture_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(puncture_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.puncture_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(puncture_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.puncture_bb_sptr_message_subscribers(self, which_port)

# Register puncture_bb_sptr in _fec_swig:
_fec_swig.puncture_bb_sptr_swigregister(puncture_bb_sptr)

puncture_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
puncture_bb = puncture_bb.make;

class puncture_ff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::puncture_ff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(puncture_ff_sptr self) -> puncture_ff_sptr
        __init__(puncture_ff_sptr self, puncture_ff p) -> puncture_ff_sptr
        """
        _fec_swig.puncture_ff_sptr_swiginit(self, _fec_swig.new_puncture_ff_sptr(*args))

    def __deref__(self) -> "gr::fec::puncture_ff *":
        r"""__deref__(puncture_ff_sptr self) -> puncture_ff"""
        return _fec_swig.puncture_ff_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_puncture_ff_sptr

    def make(self, puncsize: "int", puncpat: "int", delay: "int") -> "gr::fec::puncture_ff::sptr":
        r"""
        make(puncture_ff_sptr self, int puncsize, int puncpat, int delay) -> puncture_ff_sptr
        Puncture a stream of floats.

        For a given block of input samples of , the items produced is based on . Basically, if:





        This block is designed for floats, generally 1's and -1's. It's possible to use other float values as symbols, but this is not the expected operation.


         is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





        Example: 


        The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


        The fec.extended_encoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


        Note that due to the above concept, the default setting in the extended encoder of '11' translates into no puncturing.


        The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

        Constructor Specific Documentation:

        Constructs a puncture block for floats.

        Args:
            puncsize : Size of block of bits to puncture
            puncpat : The puncturing pattern
            delay : Delayed the puncturing pattern by shifting it
        """
        return _fec_swig.puncture_ff_sptr_make(self, puncsize, puncpat, delay)

    def history(self) -> "unsigned int":
        r"""history(puncture_ff_sptr self) -> unsigned int"""
        return _fec_swig.puncture_ff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(puncture_ff_sptr self, int which, int delay)
        declare_sample_delay(puncture_ff_sptr self, unsigned int delay)
        """
        return _fec_swig.puncture_ff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(puncture_ff_sptr self, int which) -> unsigned int"""
        return _fec_swig.puncture_ff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(puncture_ff_sptr self, int multiple)"""
        return _fec_swig.puncture_ff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(puncture_ff_sptr self) -> int"""
        return _fec_swig.puncture_ff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(puncture_ff_sptr self) -> double"""
        return _fec_swig.puncture_ff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(puncture_ff_sptr self) -> uint64_t"""
        return _fec_swig.puncture_ff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(puncture_ff_sptr self) -> uint64_t"""
        return _fec_swig.puncture_ff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(puncture_ff_sptr self) -> bool"""
        return _fec_swig.puncture_ff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(puncture_ff_sptr self) -> bool"""
        return _fec_swig.puncture_ff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(puncture_ff_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.puncture_ff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(puncture_ff_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.puncture_ff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(puncture_ff_sptr self, std::string level)"""
        return _fec_swig.puncture_ff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(puncture_ff_sptr self) -> std::string"""
        return _fec_swig.puncture_ff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(puncture_ff_sptr self) -> int"""
        return _fec_swig.puncture_ff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(puncture_ff_sptr self, int m)"""
        return _fec_swig.puncture_ff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(puncture_ff_sptr self)"""
        return _fec_swig.puncture_ff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(puncture_ff_sptr self) -> bool"""
        return _fec_swig.puncture_ff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(puncture_ff_sptr self, int m)"""
        return _fec_swig.puncture_ff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(puncture_ff_sptr self) -> int"""
        return _fec_swig.puncture_ff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(puncture_ff_sptr self, int i) -> long"""
        return _fec_swig.puncture_ff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(puncture_ff_sptr self, long max_output_buffer)
        set_max_output_buffer(puncture_ff_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.puncture_ff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(puncture_ff_sptr self, int i) -> long"""
        return _fec_swig.puncture_ff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(puncture_ff_sptr self, long min_output_buffer)
        set_min_output_buffer(puncture_ff_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.puncture_ff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(puncture_ff_sptr self, int which) -> float
        pc_input_buffers_full(puncture_ff_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_ff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(puncture_ff_sptr self, int which) -> float
        pc_input_buffers_full_avg(puncture_ff_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_ff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(puncture_ff_sptr self, int which) -> float
        pc_input_buffers_full_var(puncture_ff_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_ff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(puncture_ff_sptr self, int which) -> float
        pc_output_buffers_full(puncture_ff_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_ff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(puncture_ff_sptr self, int which) -> float
        pc_output_buffers_full_avg(puncture_ff_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_ff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(puncture_ff_sptr self, int which) -> float
        pc_output_buffers_full_var(puncture_ff_sptr self) -> pmt_vector_float
        """
        return _fec_swig.puncture_ff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(puncture_ff_sptr self) -> float"""
        return _fec_swig.puncture_ff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(puncture_ff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.puncture_ff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(puncture_ff_sptr self)"""
        return _fec_swig.puncture_ff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(puncture_ff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.puncture_ff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(puncture_ff_sptr self) -> int"""
        return _fec_swig.puncture_ff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(puncture_ff_sptr self) -> int"""
        return _fec_swig.puncture_ff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(puncture_ff_sptr self, int priority) -> int"""
        return _fec_swig.puncture_ff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(puncture_ff_sptr self) -> std::string"""
        return _fec_swig.puncture_ff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(puncture_ff_sptr self) -> std::string"""
        return _fec_swig.puncture_ff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(puncture_ff_sptr self) -> io_signature_sptr"""
        return _fec_swig.puncture_ff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(puncture_ff_sptr self) -> io_signature_sptr"""
        return _fec_swig.puncture_ff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(puncture_ff_sptr self) -> long"""
        return _fec_swig.puncture_ff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(puncture_ff_sptr self) -> basic_block_sptr"""
        return _fec_swig.puncture_ff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(puncture_ff_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.puncture_ff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(puncture_ff_sptr self) -> std::string"""
        return _fec_swig.puncture_ff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(puncture_ff_sptr self, std::string name)"""
        return _fec_swig.puncture_ff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(puncture_ff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.puncture_ff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(puncture_ff_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.puncture_ff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(puncture_ff_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.puncture_ff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(puncture_ff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.puncture_ff_sptr_message_subscribers(self, which_port)

# Register puncture_ff_sptr in _fec_swig:
_fec_swig.puncture_ff_sptr_swigregister(puncture_ff_sptr)

puncture_ff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
puncture_ff = puncture_ff.make;

class depuncture_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::fec::depuncture_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(depuncture_bb_sptr self) -> depuncture_bb_sptr
        __init__(depuncture_bb_sptr self, depuncture_bb p) -> depuncture_bb_sptr
        """
        _fec_swig.depuncture_bb_sptr_swiginit(self, _fec_swig.new_depuncture_bb_sptr(*args))

    def __deref__(self) -> "gr::fec::depuncture_bb *":
        r"""__deref__(depuncture_bb_sptr self) -> depuncture_bb"""
        return _fec_swig.depuncture_bb_sptr___deref__(self)
    __swig_destroy__ = _fec_swig.delete_depuncture_bb_sptr

    def make(self, puncsize: "int", puncpat: "int", delay: "int"=0, symbol: "char"=127) -> "gr::fec::depuncture_bb::sptr":
        r"""
        make(depuncture_bb_sptr self, int puncsize, int puncpat, int delay=0, char symbol=127) -> depuncture_bb_sptr
        Depuncture a stream of samples.

        Depuncture a given block of input samples of . The items produced is based on the pattern . Basically, if:





        This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the depuncturing will be done on the symbol level, not the bit level.


         is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





        Example: 


        The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist("11101111"). Also, this allows us to use puncsize=len("11101111") to make sure that our sizes are set up correctly for the pattern we want.


        The fec.extended_decoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


        The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

        Constructor Specific Documentation:

        Constructs a depuncture block.

        Args:
            puncsize : Size of block of bits to puncture
            puncpat : The puncturing pattern
            delay : Delayed the puncturing pattern by shifting it
            symbol : The symbol to reinsert into the stream (def=127)
        """
        return _fec_swig.depuncture_bb_sptr_make(self, puncsize, puncpat, delay, symbol)

    def history(self) -> "unsigned int":
        r"""history(depuncture_bb_sptr self) -> unsigned int"""
        return _fec_swig.depuncture_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(depuncture_bb_sptr self, int which, int delay)
        declare_sample_delay(depuncture_bb_sptr self, unsigned int delay)
        """
        return _fec_swig.depuncture_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(depuncture_bb_sptr self, int which) -> unsigned int"""
        return _fec_swig.depuncture_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(depuncture_bb_sptr self, int multiple)"""
        return _fec_swig.depuncture_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(depuncture_bb_sptr self) -> int"""
        return _fec_swig.depuncture_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(depuncture_bb_sptr self) -> double"""
        return _fec_swig.depuncture_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(depuncture_bb_sptr self) -> uint64_t"""
        return _fec_swig.depuncture_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(depuncture_bb_sptr self) -> uint64_t"""
        return _fec_swig.depuncture_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(depuncture_bb_sptr self) -> bool"""
        return _fec_swig.depuncture_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(depuncture_bb_sptr self) -> bool"""
        return _fec_swig.depuncture_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(depuncture_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _fec_swig.depuncture_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(depuncture_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _fec_swig.depuncture_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(depuncture_bb_sptr self, std::string level)"""
        return _fec_swig.depuncture_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(depuncture_bb_sptr self) -> std::string"""
        return _fec_swig.depuncture_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(depuncture_bb_sptr self) -> int"""
        return _fec_swig.depuncture_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(depuncture_bb_sptr self, int m)"""
        return _fec_swig.depuncture_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(depuncture_bb_sptr self)"""
        return _fec_swig.depuncture_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(depuncture_bb_sptr self) -> bool"""
        return _fec_swig.depuncture_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(depuncture_bb_sptr self, int m)"""
        return _fec_swig.depuncture_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(depuncture_bb_sptr self) -> int"""
        return _fec_swig.depuncture_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(depuncture_bb_sptr self, int i) -> long"""
        return _fec_swig.depuncture_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(depuncture_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(depuncture_bb_sptr self, int port, long max_output_buffer)
        """
        return _fec_swig.depuncture_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(depuncture_bb_sptr self, int i) -> long"""
        return _fec_swig.depuncture_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(depuncture_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(depuncture_bb_sptr self, int port, long min_output_buffer)
        """
        return _fec_swig.depuncture_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(depuncture_bb_sptr self, int which) -> float
        pc_input_buffers_full(depuncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.depuncture_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(depuncture_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(depuncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.depuncture_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(depuncture_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(depuncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.depuncture_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(depuncture_bb_sptr self, int which) -> float
        pc_output_buffers_full(depuncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.depuncture_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(depuncture_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(depuncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.depuncture_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(depuncture_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(depuncture_bb_sptr self) -> pmt_vector_float
        """
        return _fec_swig.depuncture_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(depuncture_bb_sptr self) -> float"""
        return _fec_swig.depuncture_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(depuncture_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _fec_swig.depuncture_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(depuncture_bb_sptr self)"""
        return _fec_swig.depuncture_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(depuncture_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _fec_swig.depuncture_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(depuncture_bb_sptr self) -> int"""
        return _fec_swig.depuncture_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(depuncture_bb_sptr self) -> int"""
        return _fec_swig.depuncture_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(depuncture_bb_sptr self, int priority) -> int"""
        return _fec_swig.depuncture_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(depuncture_bb_sptr self) -> std::string"""
        return _fec_swig.depuncture_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(depuncture_bb_sptr self) -> std::string"""
        return _fec_swig.depuncture_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(depuncture_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.depuncture_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(depuncture_bb_sptr self) -> io_signature_sptr"""
        return _fec_swig.depuncture_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(depuncture_bb_sptr self) -> long"""
        return _fec_swig.depuncture_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(depuncture_bb_sptr self) -> basic_block_sptr"""
        return _fec_swig.depuncture_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(depuncture_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _fec_swig.depuncture_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(depuncture_bb_sptr self) -> std::string"""
        return _fec_swig.depuncture_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(depuncture_bb_sptr self, std::string name)"""
        return _fec_swig.depuncture_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(depuncture_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _fec_swig.depuncture_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(depuncture_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.depuncture_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(depuncture_bb_sptr self) -> swig_pmt_ptr"""
        return _fec_swig.depuncture_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(depuncture_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _fec_swig.depuncture_bb_sptr_message_subscribers(self, which_port)

# Register depuncture_bb_sptr in _fec_swig:
_fec_swig.depuncture_bb_sptr_swigregister(depuncture_bb_sptr)

depuncture_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
depuncture_bb = depuncture_bb.make;


