# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _digital_swig2
else:
    import _digital_swig2

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def high_res_timer_now() -> "gr::high_res_timer_type":
    r"""high_res_timer_now() -> gr::high_res_timer_type"""
    return _digital_swig2.high_res_timer_now()

def high_res_timer_now_perfmon() -> "gr::high_res_timer_type":
    r"""high_res_timer_now_perfmon() -> gr::high_res_timer_type"""
    return _digital_swig2.high_res_timer_now_perfmon()

def high_res_timer_tps() -> "gr::high_res_timer_type":
    r"""high_res_timer_tps() -> gr::high_res_timer_type"""
    return _digital_swig2.high_res_timer_tps()

def high_res_timer_epoch() -> "gr::high_res_timer_type":
    r"""high_res_timer_epoch() -> gr::high_res_timer_type"""
    return _digital_swig2.high_res_timer_epoch()
class control_loop(object):
    r"""Proxy of C++ gr::blocks::control_loop class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(control_loop self) -> control_loop
        __init__(control_loop self, float loop_bw, float max_freq, float min_freq) -> control_loop
        """
        _digital_swig2.control_loop_swiginit(self, _digital_swig2.new_control_loop(*args))
    __swig_destroy__ = _digital_swig2.delete_control_loop

    def update_gains(self) -> "void":
        r"""update_gains(control_loop self)"""
        return _digital_swig2.control_loop_update_gains(self)

    def advance_loop(self, error: "float") -> "void":
        r"""advance_loop(control_loop self, float error)"""
        return _digital_swig2.control_loop_advance_loop(self, error)

    def phase_wrap(self) -> "void":
        r"""phase_wrap(control_loop self)"""
        return _digital_swig2.control_loop_phase_wrap(self)

    def frequency_limit(self) -> "void":
        r"""frequency_limit(control_loop self)"""
        return _digital_swig2.control_loop_frequency_limit(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""set_loop_bandwidth(control_loop self, float bw)"""
        return _digital_swig2.control_loop_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""set_damping_factor(control_loop self, float df)"""
        return _digital_swig2.control_loop_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""set_alpha(control_loop self, float alpha)"""
        return _digital_swig2.control_loop_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""set_beta(control_loop self, float beta)"""
        return _digital_swig2.control_loop_set_beta(self, beta)

    def set_frequency(self, freq: "float") -> "void":
        r"""set_frequency(control_loop self, float freq)"""
        return _digital_swig2.control_loop_set_frequency(self, freq)

    def set_phase(self, phase: "float") -> "void":
        r"""set_phase(control_loop self, float phase)"""
        return _digital_swig2.control_loop_set_phase(self, phase)

    def set_max_freq(self, freq: "float") -> "void":
        r"""set_max_freq(control_loop self, float freq)"""
        return _digital_swig2.control_loop_set_max_freq(self, freq)

    def set_min_freq(self, freq: "float") -> "void":
        r"""set_min_freq(control_loop self, float freq)"""
        return _digital_swig2.control_loop_set_min_freq(self, freq)

    def get_loop_bandwidth(self) -> "float":
        r"""get_loop_bandwidth(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_loop_bandwidth(self)

    def get_damping_factor(self) -> "float":
        r"""get_damping_factor(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_damping_factor(self)

    def get_alpha(self) -> "float":
        r"""get_alpha(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_alpha(self)

    def get_beta(self) -> "float":
        r"""get_beta(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_beta(self)

    def get_frequency(self) -> "float":
        r"""get_frequency(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_frequency(self)

    def get_phase(self) -> "float":
        r"""get_phase(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_phase(self)

    def get_max_freq(self) -> "float":
        r"""get_max_freq(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_max_freq(self)

    def get_min_freq(self) -> "float":
        r"""get_min_freq(control_loop self) -> float"""
        return _digital_swig2.control_loop_get_min_freq(self)

# Register control_loop in _digital_swig2:
_digital_swig2.control_loop_swigregister(control_loop)

def tanhf_lut(x: "float") -> "float":
    r"""tanhf_lut(float x) -> float"""
    return _digital_swig2.tanhf_lut(x)
class constellation(object):
    r"""
    An abstracted constellation object.

    The constellation objects hold the necessary information to pass around constellation information for modulators and demodulators. These objects contain the mapping between the bits and the constellation points used to represent them as well as methods for slicing the symbol space. Various implementations are possible for efficiency and ease of use.


    Standard constellations (BPSK, QPSK, QAM, etc) can be inherited from this class and overloaded to perform optimized slicing and constellation mappings.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig2.delete_constellation

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation self) -> unsigned int"""
        return _digital_swig2.constellation_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation self) -> unsigned int"""
        return _digital_swig2.constellation_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation self) -> constellation_sptr"""
        return _digital_swig2.constellation_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_soft_decision_maker(self, sample)

# Register constellation in _digital_swig2:
_digital_swig2.constellation_swigregister(constellation)
cvar = _digital_swig2.cvar

class constellation_calcdist(constellation):
    r"""
    Calculate Euclidean distance for any constellation.

    Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

    Constructor Specific Documentation:

    Make a general constellation object that calculates the Euclidean distance for hard decisions.

    Args:
        constell : List of constellation points (order of list matches pre_diff_code)
        pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
        rotational_symmetry : Number of rotations around unit circle that have the same representation.
        dimensionality : Number of dimensions to the constellation.
        normalize_points : Normalize constellation points to mean(abs(points))=1 (default is true)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", dimensionality: "unsigned int", normalize_points: "bool"=True) -> "gr::digital::constellation_calcdist::sptr":
        r"""
        make(pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int dimensionality, bool normalize_points=True) -> constellation_calcdist_sptr
        Calculate Euclidean distance for any constellation.

        Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

        Constructor Specific Documentation:

        Make a general constellation object that calculates the Euclidean distance for hard decisions.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            dimensionality : Number of dimensions to the constellation.
            normalize_points : Normalize constellation points to mean(abs(points))=1 (default is true)
        """
        return _digital_swig2.constellation_calcdist_make(constell, pre_diff_code, rotational_symmetry, dimensionality, normalize_points)
    __swig_destroy__ = _digital_swig2.delete_constellation_calcdist

# Register constellation_calcdist in _digital_swig2:
_digital_swig2.constellation_calcdist_swigregister(constellation_calcdist)
class constellation_sector(constellation):
    r"""
    Sectorized digital constellation.

    constellation_sector


    Constellation space is divided into sectors. Each sector is associated with the nearest constellation point.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig2.delete_constellation_sector

# Register constellation_sector in _digital_swig2:
_digital_swig2.constellation_sector_swigregister(constellation_sector)
class constellation_rect(constellation_sector):
    r"""
    Rectangular digital constellation.

    Only implemented for 1-(complex)dimensional constellation.


    Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


    Works well for square QAM.


    Works for any generic constellation provided sectors are not too large.

    Constructor Specific Documentation:

    Make a rectangular constellation object.

    Args:
        constell : List of constellation points (order of list matches pre_diff_code)
        pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
        rotational_symmetry : Number of rotations around unit circle that have the same representation.
        real_sectors : Number of sectors the real axis is split in to.
        imag_sectors : Number of sectors the imag axis is split in to.
        width_real_sectors : width of each real sector to calculate decision boundaries.
        width_imag_sectors : width of each imag sector to calculate decision boundaries.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float") -> "gr::digital::constellation_rect::sptr":
        r"""
        make(pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors) -> constellation_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        Works well for square QAM.


        Works for any generic constellation provided sectors are not too large.

        Constructor Specific Documentation:

        Make a rectangular constellation object.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            real_sectors : Number of sectors the real axis is split in to.
            imag_sectors : Number of sectors the imag axis is split in to.
            width_real_sectors : width of each real sector to calculate decision boundaries.
            width_imag_sectors : width of each imag sector to calculate decision boundaries.
        """
        return _digital_swig2.constellation_rect_make(constell, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors)
    __swig_destroy__ = _digital_swig2.delete_constellation_rect

# Register constellation_rect in _digital_swig2:
_digital_swig2.constellation_rect_swigregister(constellation_rect)
class constellation_expl_rect(constellation_rect):
    r"""
    Rectangular digital constellation.

    Only implemented for 1-(complex)dimensional constellation.


    Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


    This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

    Constructor Specific Documentation:



    Args:
        constellation : 
        pre_diff_code : 
        rotational_symmetry : 
        real_sectors : 
        imag_sectors : 
        width_real_sectors : 
        width_imag_sectors : 
        sector_values : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constellation: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float", sector_values: "std::vector< unsigned int,std::allocator< unsigned int > >") -> "gr::digital::constellation_expl_rect::sptr":
        r"""
        make(pmt_vector_cfloat constellation, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors, std::vector< unsigned int,std::allocator< unsigned int > > sector_values) -> constellation_expl_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

        Constructor Specific Documentation:



        Args:
            constellation : 
            pre_diff_code : 
            rotational_symmetry : 
            real_sectors : 
            imag_sectors : 
            width_real_sectors : 
            width_imag_sectors : 
            sector_values : 
        """
        return _digital_swig2.constellation_expl_rect_make(constellation, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors, sector_values)
    __swig_destroy__ = _digital_swig2.delete_constellation_expl_rect

# Register constellation_expl_rect in _digital_swig2:
_digital_swig2.constellation_expl_rect_swigregister(constellation_expl_rect)
class constellation_psk(constellation_sector):
    r"""
    constellation_psk

    Constellation space is divided into pie slices sectors.


    Each slice is associated with the nearest constellation point.


    Works well for PSK but nothing else.


    Assumes that there is a constellation point at 1.x

    Constructor Specific Documentation:



    Args:
        constell : 
        pre_diff_code : 
        n_sectors : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", n_sectors: "unsigned int") -> "gr::digital::constellation_psk::sptr":
        r"""
        make(pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int n_sectors) -> constellation_psk_sptr
        constellation_psk

        Constellation space is divided into pie slices sectors.


        Each slice is associated with the nearest constellation point.


        Works well for PSK but nothing else.


        Assumes that there is a constellation point at 1.x

        Constructor Specific Documentation:



        Args:
            constell : 
            pre_diff_code : 
            n_sectors : 
        """
        return _digital_swig2.constellation_psk_make(constell, pre_diff_code, n_sectors)
    __swig_destroy__ = _digital_swig2.delete_constellation_psk

# Register constellation_psk in _digital_swig2:
_digital_swig2.constellation_psk_swigregister(constellation_psk)
class constellation_bpsk(constellation):
    r"""
    Digital constellation for BPSK .

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_bpsk::sptr":
        r"""
        make() -> constellation_bpsk_sptr
        Digital constellation for BPSK .

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_bpsk_make()
    __swig_destroy__ = _digital_swig2.delete_constellation_bpsk

# Register constellation_bpsk in _digital_swig2:
_digital_swig2.constellation_bpsk_swigregister(constellation_bpsk)
class constellation_qpsk(constellation):
    r"""
    Digital constellation for QPSK.

    Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_qpsk::sptr":
        r"""
        make() -> constellation_qpsk_sptr
        Digital constellation for QPSK.

        Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_qpsk_make()
    __swig_destroy__ = _digital_swig2.delete_constellation_qpsk

# Register constellation_qpsk in _digital_swig2:
_digital_swig2.constellation_qpsk_swigregister(constellation_qpsk)
class constellation_dqpsk(constellation):
    r"""
    Digital constellation for DQPSK.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_dqpsk::sptr":
        r"""
        make() -> constellation_dqpsk_sptr
        Digital constellation for DQPSK.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_dqpsk_make()
    __swig_destroy__ = _digital_swig2.delete_constellation_dqpsk

# Register constellation_dqpsk in _digital_swig2:
_digital_swig2.constellation_dqpsk_swigregister(constellation_dqpsk)
class constellation_8psk(constellation):
    r"""
    Digital constellation for 8PSK.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_8psk::sptr":
        r"""
        make() -> constellation_8psk_sptr
        Digital constellation for 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_8psk_make()
    __swig_destroy__ = _digital_swig2.delete_constellation_8psk

# Register constellation_8psk in _digital_swig2:
_digital_swig2.constellation_8psk_swigregister(constellation_8psk)
class constellation_8psk_natural(constellation):
    r"""
    Digital constellation for natually mapped 8PSK.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_8psk_natural::sptr":
        r"""
        make() -> constellation_8psk_natural_sptr
        Digital constellation for natually mapped 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_8psk_natural_make()
    __swig_destroy__ = _digital_swig2.delete_constellation_8psk_natural

# Register constellation_8psk_natural in _digital_swig2:
_digital_swig2.constellation_8psk_natural_swigregister(constellation_8psk_natural)
class constellation_16qam(constellation):
    r"""
    Digital constellation for 16qam.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_16qam::sptr":
        r"""
        make() -> constellation_16qam_sptr
        Digital constellation for 16qam.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_16qam_make()
    __swig_destroy__ = _digital_swig2.delete_constellation_16qam

# Register constellation_16qam in _digital_swig2:
_digital_swig2.constellation_16qam_swigregister(constellation_16qam)
TED_NONE = _digital_swig2.TED_NONE

TED_MUELLER_AND_MULLER = _digital_swig2.TED_MUELLER_AND_MULLER

TED_MOD_MUELLER_AND_MULLER = _digital_swig2.TED_MOD_MUELLER_AND_MULLER

TED_ZERO_CROSSING = _digital_swig2.TED_ZERO_CROSSING

TED_GARDNER = _digital_swig2.TED_GARDNER

TED_EARLY_LATE = _digital_swig2.TED_EARLY_LATE

TED_DANDREA_AND_MENGALI_GEN_MSK = _digital_swig2.TED_DANDREA_AND_MENGALI_GEN_MSK

TED_SIGNAL_TIMES_SLOPE_ML = _digital_swig2.TED_SIGNAL_TIMES_SLOPE_ML

TED_SIGNUM_TIMES_SLOPE_ML = _digital_swig2.TED_SIGNUM_TIMES_SLOPE_ML

TED_MENGALI_AND_DANDREA_GMSK = _digital_swig2.TED_MENGALI_AND_DANDREA_GMSK

IR_NONE = _digital_swig2.IR_NONE

IR_MMSE_8TAP = _digital_swig2.IR_MMSE_8TAP

IR_PFB_NO_MF = _digital_swig2.IR_PFB_NO_MF

IR_PFB_MF = _digital_swig2.IR_PFB_MF

SNR_EST_SIMPLE = _digital_swig2.SNR_EST_SIMPLE

SNR_EST_SKEW = _digital_swig2.SNR_EST_SKEW

SNR_EST_M2M4 = _digital_swig2.SNR_EST_M2M4

SNR_EST_SVR = _digital_swig2.SNR_EST_SVR

class mpsk_snr_est(object):
    r"""A parent class for SNR estimators, specifically for M-PSK signals in AWGN channels."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, alpha: "double"):
        r"""
        __init__(mpsk_snr_est self, double alpha) -> mpsk_snr_est
        Constructor


        Parameters:
        """
        _digital_swig2.mpsk_snr_est_swiginit(self, _digital_swig2.new_mpsk_snr_est(alpha))
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est

    def alpha(self) -> "double":
        r"""
        alpha(mpsk_snr_est self) -> double
        Get the running-average coefficient.
        """
        return _digital_swig2.mpsk_snr_est_alpha(self)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(mpsk_snr_est self, double alpha)
        Set the running-average coefficient.
        """
        return _digital_swig2.mpsk_snr_est_set_alpha(self, alpha)

    def update(self, noutput_items: "int", input: "gr_complex const *") -> "int":
        r"""
        update(mpsk_snr_est self, int noutput_items, gr_complex const * input) -> int
        Update the current registers.
        """
        return _digital_swig2.mpsk_snr_est_update(self, noutput_items, input)

    def snr(self) -> "double":
        r"""
        snr(mpsk_snr_est self) -> double
        Use the register values to compute a new estimate.
        """
        return _digital_swig2.mpsk_snr_est_snr(self)

    def signal(self) -> "double":
        r"""
        signal(mpsk_snr_est self) -> double
        Returns the signal power estimate.
        """
        return _digital_swig2.mpsk_snr_est_signal(self)

    def noise(self) -> "double":
        r"""
        noise(mpsk_snr_est self) -> double
        Returns the noise power estimate.
        """
        return _digital_swig2.mpsk_snr_est_noise(self)

# Register mpsk_snr_est in _digital_swig2:
_digital_swig2.mpsk_snr_est_swigregister(mpsk_snr_est)
class mpsk_snr_est_simple(mpsk_snr_est):
    r"""
    SNR Estimator using simple mean/variance estimates.

    A very simple SNR estimator that just uses mean and variance estimates of an M-PSK constellation. This estimator is quick and cheap and accurate for high SNR (above 7 dB or so) but quickly starts to overestimate the SNR at low SNR.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, alpha: "double"):
        r"""
        __init__(mpsk_snr_est_simple self, double alpha) -> mpsk_snr_est_simple
        Constructor


        Parameters:
        """
        _digital_swig2.mpsk_snr_est_simple_swiginit(self, _digital_swig2.new_mpsk_snr_est_simple(alpha))
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est_simple

# Register mpsk_snr_est_simple in _digital_swig2:
_digital_swig2.mpsk_snr_est_simple_swigregister(mpsk_snr_est_simple)
class mpsk_snr_est_skew(mpsk_snr_est):
    r"""
    SNR Estimator using skewness correction.

    This is an estimator that came from a discussion between Tom Rondeau and fred harris with no known paper reference. The idea is that at low SNR, the variance estimations will be affected because of fold-over around the decision boundaries, which results in a skewness to the samples. We estimate the skewness and use this as a correcting term.


    This algorithm only appears to work well for BPSK signals.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, alpha: "double"):
        r"""
        __init__(mpsk_snr_est_skew self, double alpha) -> mpsk_snr_est_skew
        Constructor


        Parameters:
        """
        _digital_swig2.mpsk_snr_est_skew_swiginit(self, _digital_swig2.new_mpsk_snr_est_skew(alpha))
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est_skew

# Register mpsk_snr_est_skew in _digital_swig2:
_digital_swig2.mpsk_snr_est_skew_swigregister(mpsk_snr_est_skew)
class mpsk_snr_est_m2m4(mpsk_snr_est):
    r"""
    SNR Estimator using 2nd and 4th-order moments.

    An SNR estimator for M-PSK signals that uses 2nd (M2) and 4th (M4) order moments. This estimator uses knowledge of the kurtosis of the signal (  and noise ( ) to make its estimation. We use Beaulieu's approximations here to M-PSK signals and AWGN channels such that  and . These approximations significantly reduce the complexity of the calculations (and computations) required.


    Reference: D. R. Pauluzzi and N. C. Beaulieu, "A comparison of SNR
    estimation techniques for the AWGN channel," IEEE Trans. Communications, Vol. 48, No. 10, pp. 1681-1691, 2000.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, alpha: "double"):
        r"""
        __init__(mpsk_snr_est_m2m4 self, double alpha) -> mpsk_snr_est_m2m4
        Constructor


        Parameters:
        """
        _digital_swig2.mpsk_snr_est_m2m4_swiginit(self, _digital_swig2.new_mpsk_snr_est_m2m4(alpha))
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est_m2m4

# Register mpsk_snr_est_m2m4 in _digital_swig2:
_digital_swig2.mpsk_snr_est_m2m4_swigregister(mpsk_snr_est_m2m4)
class snr_est_m2m4(mpsk_snr_est):
    r"""
    SNR Estimator using 2nd and 4th-order moments.

    An SNR estimator for M-PSK signals that uses 2nd (M2) and 4th (M4) order moments. This estimator uses knowledge of the kurtosis of the signal (k_a) and noise (k_w) to make its estimation. In this case, you can set your own estimations for k_a and k_w, the kurtosis of the signal and noise, to fit this estimation better to your signal and channel conditions.


    A word of warning: this estimator has not been fully tested or proved with any amount of rigor. The estimation for M4 in particular might be ignoring effectf of when k_a and k_w are different. Use this estimator with caution and a copy of the reference on hand.


    The digital_mpsk_snr_est_m2m4 assumes k_a and k_w to simplify the computations for M-PSK and AWGN channels. Use that estimator unless you have a way to guess or estimate these values here.


    Original paper: R. Matzner, "An SNR estimation algorithm for complex baseband
    signal using higher order statistics," Facta Universitatis (Nis), no. 6, pp. 41-52, 1993.


    Reference used in derivation: D. R. Pauluzzi and N. C. Beaulieu, "A comparison of SNR
    estimation techniques for the AWGN channel," IEEE Trans. Communications, Vol. 48, No. 10, pp. 1681-1691, 2000.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, alpha: "double", ka: "double", kw: "double"):
        r"""
        __init__(snr_est_m2m4 self, double alpha, double ka, double kw) -> snr_est_m2m4
        Constructor


        Parameters:
        """
        _digital_swig2.snr_est_m2m4_swiginit(self, _digital_swig2.new_snr_est_m2m4(alpha, ka, kw))
    __swig_destroy__ = _digital_swig2.delete_snr_est_m2m4

# Register snr_est_m2m4 in _digital_swig2:
_digital_swig2.snr_est_m2m4_swigregister(snr_est_m2m4)
class mpsk_snr_est_svr(mpsk_snr_est):
    r"""
    Signal-to-Variation Ratio SNR Estimator.

    This estimator actually comes from an SNR estimator for M-PSK signals in fading channels, but this implementation is specifically for AWGN channels. The math was simplified to assume a signal and noise kurtosis (  and ) for M-PSK signals in AWGN. These approximations significantly reduce the complexity of the calculations (and computations) required.


    Original paper: A. L. Brandao, L. B. Lopes, and D. C. McLernon, "In-service
    monitoring of multipath delay and cochannel interference for
    indoor mobile communication systems," Proc. IEEE Int. Conf. Communications, vol. 3, pp. 1458-1462, May 1994.


    Reference: D. R. Pauluzzi and N. C. Beaulieu, "A comparison of SNR
    estimation techniques for the AWGN channel," IEEE Trans. Communications, Vol. 48, No. 10, pp. 1681-1691, 2000.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, alpha: "double"):
        r"""
        __init__(mpsk_snr_est_svr self, double alpha) -> mpsk_snr_est_svr
        Constructor


        Parameters:
        """
        _digital_swig2.mpsk_snr_est_svr_swiginit(self, _digital_swig2.new_mpsk_snr_est_svr(alpha))
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est_svr

# Register mpsk_snr_est_svr in _digital_swig2:
_digital_swig2.mpsk_snr_est_svr_swigregister(mpsk_snr_est_svr)
class mpsk_snr_est_cc(object):
    r"""
    A block for computing SNR of a signal.

    This block can be used to monitor and retrieve estimations of the signal SNR. It is designed to work in a flowgraph and passes all incoming data along to its output.


    The block is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


    The estimator is normally placed before clock recovery.

    Constructor Specific Documentation:

    Factory function returning shared pointer of this class

    Args:
        type : the type of estimator to use gr::digital::snr_est_type_t "snr_est_type_t" for details about the available types
        tag_nsamples : after this many samples, a tag containing the SNR (key='snr') will be sent
        alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(type: "gr::digital::snr_est_type_t", tag_nsamples: "int"=10000, alpha: "double"=0.001) -> "gr::digital::mpsk_snr_est_cc::sptr":
        r"""
        make(gr::digital::snr_est_type_t type, int tag_nsamples=10000, double alpha=0.001) -> mpsk_snr_est_cc_sptr
        A block for computing SNR of a signal.

        This block can be used to monitor and retrieve estimations of the signal SNR. It is designed to work in a flowgraph and passes all incoming data along to its output.


        The block is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


        The estimator is normally placed before clock recovery.

        Constructor Specific Documentation:

        Factory function returning shared pointer of this class

        Args:
            type : the type of estimator to use gr::digital::snr_est_type_t "snr_est_type_t" for details about the available types
            tag_nsamples : after this many samples, a tag containing the SNR (key='snr') will be sent
            alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.
        """
        return _digital_swig2.mpsk_snr_est_cc_make(type, tag_nsamples, alpha)

    def snr(self) -> "double":
        r"""
        snr(mpsk_snr_est_cc self) -> double
        Return the estimated signal-to-noise ratio in decibels.
        """
        return _digital_swig2.mpsk_snr_est_cc_snr(self)

    def type(self) -> "gr::digital::snr_est_type_t":
        r"""
        type(mpsk_snr_est_cc self) -> gr::digital::snr_est_type_t
        Return the type of estimator in use.
        """
        return _digital_swig2.mpsk_snr_est_cc_type(self)

    def tag_nsample(self) -> "int":
        r"""
        tag_nsample(mpsk_snr_est_cc self) -> int
        Return how many samples between SNR tags.
        """
        return _digital_swig2.mpsk_snr_est_cc_tag_nsample(self)

    def alpha(self) -> "double":
        r"""
        alpha(mpsk_snr_est_cc self) -> double
        Get the running-average coefficient.
        """
        return _digital_swig2.mpsk_snr_est_cc_alpha(self)

    def set_type(self, t: "gr::digital::snr_est_type_t") -> "void":
        r"""
        set_type(mpsk_snr_est_cc self, gr::digital::snr_est_type_t t)
        Set type of estimator to use.
        """
        return _digital_swig2.mpsk_snr_est_cc_set_type(self, t)

    def set_tag_nsample(self, n: "int") -> "void":
        r"""
        set_tag_nsample(mpsk_snr_est_cc self, int n)
        Set the number of samples between SNR tags.
        """
        return _digital_swig2.mpsk_snr_est_cc_set_tag_nsample(self, n)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(mpsk_snr_est_cc self, double alpha)
        Set the running-average coefficient.
        """
        return _digital_swig2.mpsk_snr_est_cc_set_alpha(self, alpha)
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est_cc

# Register mpsk_snr_est_cc in _digital_swig2:
_digital_swig2.mpsk_snr_est_cc_swigregister(mpsk_snr_est_cc)
class header_format_base(object):
    r"""
    Base header formatter class.

    Creates a base class that other packet formatters will inherit from. The child classes create and parse protocol-specific headers. To add a new protocol processing class, create a class that inherits from this and overload the necessary functions. The main functions to overload are:







    Protected functions of this class that the child class should overload include:



    These three function represent the different states of the parsing state machine. Expected behavior is that the protocol has some known word that we are first looking for the identify the start of the frame. The parsing FSM starts in a state to search for the beginning of the header, normally by looking for a known word (i.e., the access code). Then it changes state to read in the full header. We expect that the protocol provides the length of the header for processing, so the parsing looks pulls in the full length of the header. Then it changes state to the "have header" state for checking and processing. The base class provides the basic functionality for this state machine. However, most likely, each child class must manage these states for themselves.


    This class is specifically designed to work with packets/frames in the asynchronous PDU architecture of GNU Radio. See the packet_format_async block for formatting the headers onto payloads and packet_parse_b block for parsing headers in a receiver.


    The Packet Format block takes in a PDU and uses a formatter class derived from this class to add a header onto the packet. The Packet Format blocks takes in the PDU, unpacks the message, and passes it to a formatter class' format function, which builds a header based on the payload. The header is passed back and emitted from formatter block as a separate output. The async format block, packet_format_async, has two message output ports. The 'header' port passes the header out as a PDU and the 'payload' passes the payload out as a PDU. The flowgraph can then separately modulate and combine these two pieces in the follow-on processing.


    The packet_sync_b block uses the formatter class by calling the 'parse' function to parse the received packet headers. This parser block is a sink for the data stream and emits a message from an 'info' port that contains an PMT dictionary of the information in the header. The formatter class determines the dictionary keys.


    This is the base class for dealing with formatting headers for different protocols and purposes. For other header formatting behaviors, create a child class from here and overload the format, parse, and parsing state machine functions as necessary.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig2.delete_header_format_base

    def base(self) -> "gr::digital::header_format_base::sptr":
        r"""base(header_format_base self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_base_base(self)

    def formatter(self) -> "gr::digital::header_format_base::sptr":
        r"""formatter(header_format_base self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_base_formatter(self)

    def format(self, nbytes_in: "int", input: "unsigned char const *", output: "swig_pmt_ptr", info: "swig_pmt_ptr") -> "bool":
        r"""
        format(header_format_base self, int nbytes_in, unsigned char const * input, swig_pmt_ptr output, swig_pmt_ptr info) -> bool
        Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_base_format(self, nbytes_in, input, output, info)

    def parse(self, nbits_in: "int", input: "unsigned char const *", info: "std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > &", nbits_processed: "int &") -> "bool":
        r"""
        parse(header_format_base self, int nbits_in, unsigned char const * input, std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > & info, int & nbits_processed) -> bool
        Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_base_parse(self, nbits_in, input, info, nbits_processed)

    def header_nbits(self) -> "size_t":
        r"""
        header_nbits(header_format_base self) -> size_t
        Returns the length of the formatted header in bits. MUST be overloaded.
        """
        return _digital_swig2.header_format_base_header_nbits(self)

    def header_nbytes(self) -> "size_t":
        r"""
        header_nbytes(header_format_base self) -> size_t
        Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().
        """
        return _digital_swig2.header_format_base_header_nbytes(self)

# Register header_format_base in _digital_swig2:
_digital_swig2.header_format_base_swigregister(header_format_base)
class header_format_default(header_format_base):
    r"""
    Default header formatter for PDU formatting.

    Used to handle the default packet header.


    See the parent class header_format_base for details of how these classes operate.


    The default header created in this base class consists of an access code and the packet length. The length is encoded as a 16-bit value repeated twice:





    Where the access code is <= 64 bits and hdr is:





    The access code and header are formatted for network byte order.


    This header generator does not calculate or append a CRC to the packet. Use the CRC32 Async block for that before adding the header. The header's length will then measure the payload plus the CRC length (4 bytes for a CRC32).


    The default header parser produces a PMT dictionary that contains the following keys. All formatter blocks MUST produce these two values in any dictionary.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, access_code: "std::string const &", threshold: "int", bps: "int"):
        r"""__init__(header_format_default self, std::string const & access_code, int threshold, int bps) -> header_format_default"""
        _digital_swig2.header_format_default_swiginit(self, _digital_swig2.new_header_format_default(access_code, threshold, bps))
    __swig_destroy__ = _digital_swig2.delete_header_format_default

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""
        set_access_code(header_format_default self, std::string const & access_code) -> bool
        Updates the access code. Must be a string of 1's and 0's and <= 64 bits.
        """
        return _digital_swig2.header_format_default_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""
        access_code(header_format_default self) -> unsigned long long
        Returns the formatted access code as a 64-bit register.
        """
        return _digital_swig2.header_format_default_access_code(self)

    def set_threshold(self, thresh: "unsigned int"=0) -> "void":
        r"""
        set_threshold(header_format_default self, unsigned int thresh=0)
        Sets the threshold for number of access code bits can be in error before detection. Defaults to 0.
        """
        return _digital_swig2.header_format_default_set_threshold(self, thresh)

    def threshold(self) -> "unsigned int":
        r"""
        threshold(header_format_default self) -> unsigned int
        Returns threshold value for access code detection.
        """
        return _digital_swig2.header_format_default_threshold(self)

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int", bps: "int"=1) -> "gr::digital::header_format_base::sptr":
        r"""
        make(std::string const & access_code, int threshold, int bps=1) -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_default_make(access_code, threshold, bps)

# Register header_format_default in _digital_swig2:
_digital_swig2.header_format_default_swigregister(header_format_default)
class header_format_counter(header_format_default):
    r"""
    Header formatter that adds the payload bits/symbol format and a packet number counter.

    Child class of header_format_default. This version adds two fields to the header:



    Like the default packet formatter, the length is encoded as a 16-bit value repeated twice. The full packet looks like: 


    Where the access code is <= 64 bits and hdr is: 


    The access code and header are formatted for network byte order.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, access_code: "std::string const &", threshold: "int", bps: "int"):
        r"""__init__(header_format_counter self, std::string const & access_code, int threshold, int bps) -> header_format_counter"""
        _digital_swig2.header_format_counter_swiginit(self, _digital_swig2.new_header_format_counter(access_code, threshold, bps))
    __swig_destroy__ = _digital_swig2.delete_header_format_counter

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int", bps: "int") -> "gr::digital::header_format_base::sptr":
        r"""
        make(std::string const & access_code, int threshold, int bps) -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_counter_make(access_code, threshold, bps)

# Register header_format_counter in _digital_swig2:
_digital_swig2.header_format_counter_swigregister(header_format_counter)
class header_format_crc(header_format_base):
    r"""
    Header formatter that includes the payload length, packet number, and a CRC check on the header.

    Child class of header_format_base. This version's header format looks like:



    Instead of duplicating the payload length, we only add it once and use the CRC8 to make sure it's correctly received.





    Reimplements packet_header_default in the style of the header_format_base.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        r"""__init__(header_format_crc self, std::string const & len_key_name="packet_len", std::string const & num_key_name="packet_num") -> header_format_crc"""
        _digital_swig2.header_format_crc_swiginit(self, _digital_swig2.new_header_format_crc(*args, **kwargs))
    __swig_destroy__ = _digital_swig2.delete_header_format_crc

    def set_header_num(self, header_num: "unsigned int") -> "void":
        r"""set_header_num(header_format_crc self, unsigned int header_num)"""
        return _digital_swig2.header_format_crc_set_header_num(self, header_num)

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::header_format_base::sptr":
        r"""
        make(std::string const & len_key_name="packet_len", std::string const & num_key_name="packet_num") -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_crc_make(*args, **kwargs)

# Register header_format_crc in _digital_swig2:
_digital_swig2.header_format_crc_swigregister(header_format_crc)
class header_format_ofdm(header_format_crc):
    r"""
    Header formatter that includes the payload length, packet number, and a CRC check on the header.

    Child class of header_format_base. This version's header format looks like:



    Instead of duplicating the payload length, we only add it once and use the CRC8 to make sure it's correctly received.





    Reimplements packet_header_default in the style of the header_format_base.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        r"""__init__(header_format_ofdm self, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, int n_syms, std::string const & len_key_name="packet_len", std::string const & frame_key_name="frame_len", std::string const & num_key_name="packet_num", int bits_per_header_sym=1, int bits_per_payload_sym=1, bool scramble_header=False) -> header_format_ofdm"""
        _digital_swig2.header_format_ofdm_swiginit(self, _digital_swig2.new_header_format_ofdm(*args, **kwargs))
    __swig_destroy__ = _digital_swig2.delete_header_format_ofdm

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::header_format_base::sptr":
        r"""
        make(std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, int n_syms, std::string const & len_key_name="packet_len", std::string const & frame_key_name="frame_len", std::string const & num_key_name="packet_num", int bits_per_header_sym=1, int bits_per_payload_sym=1, bool scramble_header=False) -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_ofdm_make(*args, **kwargs)

# Register header_format_ofdm in _digital_swig2:
_digital_swig2.header_format_ofdm_swigregister(header_format_ofdm)
class protocol_formatter_async(object):
    r"""
    Uses a header format object to append a header onto a PDU.

    This block takes in PDUs and creates a header, generally for MAC-level processing. Each received PDU is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


    The header that is created and transmitted out of the 'header' message port as a PDU. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output PDU as a PMT argument along with any changes to the metadata info PMT.


    For different packet header formatting needs, we can define new classes that inherit from the header_format_base block and which overload the header_format_base::format function.





    This block only uses asynchronous message passing interfaces to receiver and emit PDUs. The message ports are:

    Constructor Specific Documentation:

    Make a packet header block using a given .

    Args:
        format : The format object to use when creating the header for the packet.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(format: "header_format_base_sptr") -> "gr::digital::protocol_formatter_async::sptr":
        r"""
        make(header_format_base_sptr format) -> protocol_formatter_async_sptr
        Uses a header format object to append a header onto a PDU.

        This block takes in PDUs and creates a header, generally for MAC-level processing. Each received PDU is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


        The header that is created and transmitted out of the 'header' message port as a PDU. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output PDU as a PMT argument along with any changes to the metadata info PMT.


        For different packet header formatting needs, we can define new classes that inherit from the header_format_base block and which overload the header_format_base::format function.





        This block only uses asynchronous message passing interfaces to receiver and emit PDUs. The message ports are:

        Constructor Specific Documentation:

        Make a packet header block using a given .

        Args:
            format : The format object to use when creating the header for the packet.
        """
        return _digital_swig2.protocol_formatter_async_make(format)
    __swig_destroy__ = _digital_swig2.delete_protocol_formatter_async

# Register protocol_formatter_async in _digital_swig2:
_digital_swig2.protocol_formatter_async_swigregister(protocol_formatter_async)
class protocol_formatter_bb(object):
    r"""
    Uses a header format object to create a header from a tagged stream packet.

    This block takes in tagged stream and creates a header, generally for MAC-level processing. Each received tagged stream is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


    The header that is created and transmitted from this block. The payload should then be sent as a parallel tagged stream to be muxed together later. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output and metadata info. This block then transmits the header vector and attaches and metadata as tags at the start of the header.

    Constructor Specific Documentation:

    Make a packet header block using a given .

    Args:
        format : The format object to use when creating the header for the packet. Derived from the header_format_base class.
        len_tag_key : The tagged stream length key.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::protocol_formatter_bb::sptr":
        r"""
        make(header_format_base_sptr format, std::string const & len_tag_key="packet_len") -> protocol_formatter_bb_sptr
        Uses a header format object to create a header from a tagged stream packet.

        This block takes in tagged stream and creates a header, generally for MAC-level processing. Each received tagged stream is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


        The header that is created and transmitted from this block. The payload should then be sent as a parallel tagged stream to be muxed together later. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output and metadata info. This block then transmits the header vector and attaches and metadata as tags at the start of the header.

        Constructor Specific Documentation:

        Make a packet header block using a given .

        Args:
            format : The format object to use when creating the header for the packet. Derived from the header_format_base class.
            len_tag_key : The tagged stream length key.
        """
        return _digital_swig2.protocol_formatter_bb_make(*args, **kwargs)

    def set_header_format(self, format: "header_format_base_sptr") -> "void":
        r"""set_header_format(protocol_formatter_bb self, header_format_base_sptr format)"""
        return _digital_swig2.protocol_formatter_bb_set_header_format(self, format)
    __swig_destroy__ = _digital_swig2.delete_protocol_formatter_bb

# Register protocol_formatter_bb in _digital_swig2:
_digital_swig2.protocol_formatter_bb_swigregister(protocol_formatter_bb)
class protocol_parser_b(object):
    r"""
    Block that synchronizes to a header based on a header format object class. Designed to accept hard bits and produce PDUs with packed bytes (pmt::u8vector).

    A packet synchronizer block. This block takes in hard bits (unpacked bytes; 1's and 0's as the LSB) and finds the access code as a sync word to find the start of a frame.


    The block uses a format object derived from a header_format_base class.


    Once the frame is detected (usually through the use of an access code), the block uses the format object's parser function to decode the remaining header. Generally, as in the default header case, the header will contain the length of the frame's payload. That and anything else in the header will generally go into the PDU's meta-data dictionary.


    The block will output a PDU that contains frame's header info in the meta-data portion of the PDU and the payload itself. The payload is packed hard bits as taken from the input stream.

    Constructor Specific Documentation:

    Make a packet header block using a given .

    Args:
        format : The format object to use when reading the header.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(format: "header_format_base_sptr") -> "gr::digital::protocol_parser_b::sptr":
        r"""
        make(header_format_base_sptr format) -> protocol_parser_b_sptr
        Block that synchronizes to a header based on a header format object class. Designed to accept hard bits and produce PDUs with packed bytes (pmt::u8vector).

        A packet synchronizer block. This block takes in hard bits (unpacked bytes; 1's and 0's as the LSB) and finds the access code as a sync word to find the start of a frame.


        The block uses a format object derived from a header_format_base class.


        Once the frame is detected (usually through the use of an access code), the block uses the format object's parser function to decode the remaining header. Generally, as in the default header case, the header will contain the length of the frame's payload. That and anything else in the header will generally go into the PDU's meta-data dictionary.


        The block will output a PDU that contains frame's header info in the meta-data portion of the PDU and the payload itself. The payload is packed hard bits as taken from the input stream.

        Constructor Specific Documentation:

        Make a packet header block using a given .

        Args:
            format : The format object to use when reading the header.
        """
        return _digital_swig2.protocol_parser_b_make(format)
    __swig_destroy__ = _digital_swig2.delete_protocol_parser_b

# Register protocol_parser_b in _digital_swig2:
_digital_swig2.protocol_parser_b_swigregister(protocol_parser_b)
class packet_header_default(object):
    r"""
    Default header formatter for digital packet transmission.

    For bursty/packetized digital transmission, packets are usually prepended with a packet header, containing the number of bytes etc. This class is not a block, but a tool to create these packet header.


    This is a default packet header (see header_formatter()) for a description on the header format). To create other header, derive packet header creator classes from this function.


    gr::digital::packet_headergenerator_bb uses header generators derived from this class to create packet headers from data streams.

    Constructor Specific Documentation:



    Args:
        header_len : 
        len_tag_key : 
        num_tag_key : 
        bits_per_byte : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        r"""__init__(packet_header_default self, long header_len, std::string const & len_tag_key="packet_len", std::string const & num_tag_key="packet_num", int bits_per_byte=1) -> packet_header_default"""
        _digital_swig2.packet_header_default_swiginit(self, _digital_swig2.new_packet_header_default(*args, **kwargs))
    __swig_destroy__ = _digital_swig2.delete_packet_header_default

    def base(self) -> "gr::digital::packet_header_default::sptr":
        r"""base(packet_header_default self) -> packet_header_default_sptr"""
        return _digital_swig2.packet_header_default_base(self)

    def formatter(self) -> "gr::digital::packet_header_default::sptr":
        r"""formatter(packet_header_default self) -> packet_header_default_sptr"""
        return _digital_swig2.packet_header_default_formatter(self)

    def set_header_num(self, header_num: "unsigned int") -> "void":
        r"""set_header_num(packet_header_default self, unsigned int header_num)"""
        return _digital_swig2.packet_header_default_set_header_num(self, header_num)

    def header_len(self) -> "long":
        r"""header_len(packet_header_default self) -> long"""
        return _digital_swig2.packet_header_default_header_len(self)

    def len_tag_key(self) -> "pmt::pmt_t":
        r"""len_tag_key(packet_header_default self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_header_default_len_tag_key(self)

    def header_formatter(self, *args, **kwargs) -> "bool":
        r"""
        header_formatter(packet_header_default self, long packet_len, unsigned char * out, tags_vector_t tags=std::vector< gr::tag_t >()) -> bool
        Encodes the header information in the given tags into bits and places them into .

        Uses the following header format: Bits 0-11: The packet length (what was stored in the tag with key ) Bits 12-23: The header number (counts up every time this function is called) Bit 24-31: 8-Bit CRC All other bits: Are set to zero


        If the header length is smaller than 32, bits are simply left out. For this reason, they always start with the LSB.


        However, it is recommended to stay above 32 Bits, in order to have a working CRC.
        """
        return _digital_swig2.packet_header_default_header_formatter(self, *args, **kwargs)

    def header_parser(self, header: "unsigned char const *", tags: "tags_vector_t") -> "bool":
        r"""
        header_parser(packet_header_default self, unsigned char const * header, tags_vector_t tags) -> bool
        Inverse function to header_formatter().

        Reads the bit stream in  and writes a corresponding tag into .
        """
        return _digital_swig2.packet_header_default_header_parser(self, header, tags)

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::packet_header_default::sptr":
        r"""
        make(long header_len, std::string const & len_tag_key="packet_len", std::string const & num_tag_key="packet_num", int bits_per_byte=1) -> packet_header_default_sptr
        Default header formatter for digital packet transmission.

        For bursty/packetized digital transmission, packets are usually prepended with a packet header, containing the number of bytes etc. This class is not a block, but a tool to create these packet header.


        This is a default packet header (see header_formatter()) for a description on the header format). To create other header, derive packet header creator classes from this function.


        gr::digital::packet_headergenerator_bb uses header generators derived from this class to create packet headers from data streams.

        Constructor Specific Documentation:



        Args:
            header_len : 
            len_tag_key : 
            num_tag_key : 
            bits_per_byte : 
        """
        return _digital_swig2.packet_header_default_make(*args, **kwargs)

# Register packet_header_default in _digital_swig2:
_digital_swig2.packet_header_default_swigregister(packet_header_default)
class packet_header_ofdm(packet_header_default):
    r"""
    Header utility for OFDM signals.

    Constructor Specific Documentation:



    Args:
        occupied_carriers : See carrier allocator
        n_syms : The number of OFDM symbols the header should be (usually 1)
        len_tag_key : The tag key used for the packet length (number of bytes)
        frame_len_tag_key : The tag key used for the frame length (number of OFDM symbols, this is the tag key required for the frame equalizer etc.)
        num_tag_key : The tag key used for packet numbering.
        bits_per_header_sym : Bits per complex symbol in the header, e.g. 1 if the header is BPSK modulated, 2 if it's QPSK modulated etc.
        bits_per_payload_sym : Bits per complex symbol in the payload. This is required to figure out how many OFDM symbols are necessary to encode the given number of bytes.
        scramble_header : Set this to true to scramble the bits. This is highly recommended, as it reduces PAPR spikes.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, occupied_carriers: "std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const &", n_syms: "int", len_tag_key: "std::string const &", frame_len_tag_key: "std::string const &", num_tag_key: "std::string const &", bits_per_header_sym: "int", bits_per_payload_sym: "int", scramble_header: "bool"):
        r"""__init__(packet_header_ofdm self, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, int n_syms, std::string const & len_tag_key, std::string const & frame_len_tag_key, std::string const & num_tag_key, int bits_per_header_sym, int bits_per_payload_sym, bool scramble_header) -> packet_header_ofdm"""
        _digital_swig2.packet_header_ofdm_swiginit(self, _digital_swig2.new_packet_header_ofdm(occupied_carriers, n_syms, len_tag_key, frame_len_tag_key, num_tag_key, bits_per_header_sym, bits_per_payload_sym, scramble_header))
    __swig_destroy__ = _digital_swig2.delete_packet_header_ofdm

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::packet_header_ofdm::sptr":
        r"""
        make(std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, int n_syms, std::string const & len_tag_key="packet_len", std::string const & frame_len_tag_key="frame_len", std::string const & num_tag_key="packet_num", int bits_per_header_sym=1, int bits_per_payload_sym=1, bool scramble_header=False) -> packet_header_ofdm_sptr
        Header utility for OFDM signals.

        Constructor Specific Documentation:



        Args:
            occupied_carriers : See carrier allocator
            n_syms : The number of OFDM symbols the header should be (usually 1)
            len_tag_key : The tag key used for the packet length (number of bytes)
            frame_len_tag_key : The tag key used for the frame length (number of OFDM symbols, this is the tag key required for the frame equalizer etc.)
            num_tag_key : The tag key used for packet numbering.
            bits_per_header_sym : Bits per complex symbol in the header, e.g. 1 if the header is BPSK modulated, 2 if it's QPSK modulated etc.
            bits_per_payload_sym : Bits per complex symbol in the payload. This is required to figure out how many OFDM symbols are necessary to encode the given number of bytes.
            scramble_header : Set this to true to scramble the bits. This is highly recommended, as it reduces PAPR spikes.
        """
        return _digital_swig2.packet_header_ofdm_make(*args, **kwargs)

# Register packet_header_ofdm in _digital_swig2:
_digital_swig2.packet_header_ofdm_swigregister(packet_header_ofdm)
class packet_headergenerator_bb(object):
    r"""
    Generates a header for a tagged, streamed packet.

    Input: A tagged stream. This is consumed entirely, it is not appended to the output stream. Output: An tagged stream containing the header. The details on the header are set in a header formatter object (of type packet_header_default or a subclass thereof). If only a number of bits is specified, a default header is generated (see packet_header_default).

    Constructor Specific Documentation:



    Args:
        header_formatter : 
        len_tag_key : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args) -> "gr::digital::packet_headergenerator_bb::sptr":
        r"""
        make(packet_header_default_sptr header_formatter, std::string const & len_tag_key="packet_len") -> packet_headergenerator_bb_sptr
        make(long header_len, std::string const & len_tag_key="packet_len") -> packet_headergenerator_bb_sptr
        Generates a header for a tagged, streamed packet.

        Input: A tagged stream. This is consumed entirely, it is not appended to the output stream. Output: An tagged stream containing the header. The details on the header are set in a header formatter object (of type packet_header_default or a subclass thereof). If only a number of bits is specified, a default header is generated (see packet_header_default).

        Constructor Specific Documentation:



        Args:
            header_formatter : 
            len_tag_key : 
        """
        return _digital_swig2.packet_headergenerator_bb_make(*args)

    def set_header_formatter(self, header_formatter: "packet_header_default_sptr") -> "void":
        r"""set_header_formatter(packet_headergenerator_bb self, packet_header_default_sptr header_formatter)"""
        return _digital_swig2.packet_headergenerator_bb_set_header_formatter(self, header_formatter)
    __swig_destroy__ = _digital_swig2.delete_packet_headergenerator_bb

# Register packet_headergenerator_bb in _digital_swig2:
_digital_swig2.packet_headergenerator_bb_swigregister(packet_headergenerator_bb)
class packet_headerparser_b(object):
    r"""
    Post header metadata as a PMT.

    In a sense, this is the inverse block to packet_headergenerator_bb. The difference is, the parsed header is not output as a stream, but as a PMT dictionary, which is published to message port with the id "header_data".


    The dictionary consists of the tags created by the header formatter object. You should be able to use the exact same formatter object as used on the Tx side in the packet_headergenerator_bb.


    If only a header length is given, this block uses the default header format.

    Constructor Specific Documentation:



    Args:
        header_formatter : Header object. This should be the same as used for packet_headergenerator_bb.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args) -> "gr::digital::packet_headerparser_b::sptr":
        r"""
        make(packet_header_default_sptr header_formatter) -> packet_headerparser_b_sptr
        make(long header_len, std::string const & len_tag_key) -> packet_headerparser_b_sptr
        Post header metadata as a PMT.

        In a sense, this is the inverse block to packet_headergenerator_bb. The difference is, the parsed header is not output as a stream, but as a PMT dictionary, which is published to message port with the id "header_data".


        The dictionary consists of the tags created by the header formatter object. You should be able to use the exact same formatter object as used on the Tx side in the packet_headergenerator_bb.


        If only a header length is given, this block uses the default header format.

        Constructor Specific Documentation:



        Args:
            header_formatter : Header object. This should be the same as used for packet_headergenerator_bb.
        """
        return _digital_swig2.packet_headerparser_b_make(*args)
    __swig_destroy__ = _digital_swig2.delete_packet_headerparser_b

# Register packet_headerparser_b in _digital_swig2:
_digital_swig2.packet_headerparser_b_swigregister(packet_headerparser_b)
class packet_sink(object):
    r"""
    process received bits looking for packet sync, header, and process bits into packet

    input: stream of symbols to be sliced.


    output: none. Pushes assembled packet into target queue


    The packet sink takes in a stream of binary symbols that are sliced around 0. The bits are then checked for the  to determine find and decode the packet. It then expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


    This block is not very useful anymore as it only works with 2-level modulations such as BPSK or GMSK. The block can generally be replaced with a correlate access code and frame sink blocks.

    Constructor Specific Documentation:

    Make a packet_sink block.

    Args:
        sync_vector : The synchronization vector as a vector of 1's and 0's.
        target_queue : The message queue that packets are sent to.
        threshold : Number of bits that can be incorrect in the .
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(sync_vector: "std::vector< unsigned char,std::allocator< unsigned char > > const &", target_queue: "msg_queue_sptr", threshold: "int"=-1) -> "gr::digital::packet_sink::sptr":
        r"""
        make(std::vector< unsigned char,std::allocator< unsigned char > > const & sync_vector, msg_queue_sptr target_queue, int threshold=-1) -> packet_sink_sptr
        process received bits looking for packet sync, header, and process bits into packet

        input: stream of symbols to be sliced.


        output: none. Pushes assembled packet into target queue


        The packet sink takes in a stream of binary symbols that are sliced around 0. The bits are then checked for the  to determine find and decode the packet. It then expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


        This block is not very useful anymore as it only works with 2-level modulations such as BPSK or GMSK. The block can generally be replaced with a correlate access code and frame sink blocks.

        Constructor Specific Documentation:

        Make a packet_sink block.

        Args:
            sync_vector : The synchronization vector as a vector of 1's and 0's.
            target_queue : The message queue that packets are sent to.
            threshold : Number of bits that can be incorrect in the .
        """
        return _digital_swig2.packet_sink_make(sync_vector, target_queue, threshold)

    def carrier_sensed(self) -> "bool":
        r"""
        carrier_sensed(packet_sink self) -> bool
        return true if we detect carrier
        """
        return _digital_swig2.packet_sink_carrier_sensed(self)
    __swig_destroy__ = _digital_swig2.delete_packet_sink

# Register packet_sink in _digital_swig2:
_digital_swig2.packet_sink_swigregister(packet_sink)
class pfb_clock_sync_ccf(object):
    r"""
    Timing synchronizer using polyphase filterbanks.

    This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


    This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


    If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


    The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for "gain," which is d_alpha while d_beta is equal to (gain^2)/4.


    The block's parameters are:









    Reference: f. j. harris and M. Rice, "Multirate Digital Filters for Symbol
    Timing Synchronization in Software Defined Radios", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

    Constructor Specific Documentation:

    Build the polyphase filterbank timing synchronizer.

    Args:
        sps : (double) The number of samples per symbol in the incoming signal
        loop_bw : (float) The bandwidth of the control loop; set's alpha and beta.
        taps : (vector<int>) The filter taps.
        filter_size : (uint) The number of filters in the filterbank (default = 32).
        init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
        max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
        osps : (int) The number of output samples per symbol (default=1).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(sps: "double", loop_bw: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32, init_phase: "float"=0, max_rate_deviation: "float"=1.5, osps: "int"=1) -> "gr::digital::pfb_clock_sync_ccf::sptr":
        r"""
        make(double sps, float loop_bw, pmt_vector_float taps, unsigned int filter_size=32, float init_phase=0, float max_rate_deviation=1.5, int osps=1) -> pfb_clock_sync_ccf_sptr
        Timing synchronizer using polyphase filterbanks.

        This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


        This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


        If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


        The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for "gain," which is d_alpha while d_beta is equal to (gain^2)/4.


        The block's parameters are:









        Reference: f. j. harris and M. Rice, "Multirate Digital Filters for Symbol
        Timing Synchronization in Software Defined Radios", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

        Constructor Specific Documentation:

        Build the polyphase filterbank timing synchronizer.

        Args:
            sps : (double) The number of samples per symbol in the incoming signal
            loop_bw : (float) The bandwidth of the control loop; set's alpha and beta.
            taps : (vector<int>) The filter taps.
            filter_size : (uint) The number of filters in the filterbank (default = 32).
            init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
            max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
            osps : (int) The number of output samples per symbol (default=1).
        """
        return _digital_swig2.pfb_clock_sync_ccf_make(sps, loop_bw, taps, filter_size, init_phase, max_rate_deviation, osps)

    def update_gains(self) -> "void":
        r"""
        update_gains(pfb_clock_sync_ccf self)
        update the system gains from omega and eta

        This function updates the system gains based on the loop bandwidth and damping factor of the system. These two factors can be set separately through their own set functions.
        """
        return _digital_swig2.pfb_clock_sync_ccf_update_gains(self)

    def update_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        update_taps(pfb_clock_sync_ccf self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter.
        """
        return _digital_swig2.pfb_clock_sync_ccf_update_taps(self, taps)

    def set_taps(self, taps: "pmt_vector_float", ourtaps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > &", ourfilter: "std::vector< gr::filter::kernel::fir_filter_ccf *,std::allocator< gr::filter::kernel::fir_filter_ccf * > > &") -> "void":
        r"""
        set_taps(pfb_clock_sync_ccf self, pmt_vector_float taps, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > & ourtaps, std::vector< gr::filter::kernel::fir_filter_ccf *,std::allocator< gr::filter::kernel::fir_filter_ccf * > > & ourfilter)
        Used to set the taps of the filters in the filterbank and differential filterbank.


        WARNING: this should not be used externally and will be moved to a private function in the next API.
        """
        return _digital_swig2.pfb_clock_sync_ccf_set_taps(self, taps, ourtaps, ourfilter)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_clock_sync_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the matched filter
        """
        return _digital_swig2.pfb_clock_sync_ccf_taps(self)

    def diff_taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        diff_taps(pfb_clock_sync_ccf self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the derivative filter
        """
        return _digital_swig2.pfb_clock_sync_ccf_diff_taps(self)

    def channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        channel_taps(pfb_clock_sync_ccf self, int channel) -> pmt_vector_float
        Returns the taps of the matched filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_ccf_channel_taps(self, channel)

    def diff_channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        diff_channel_taps(pfb_clock_sync_ccf self, int channel) -> pmt_vector_float
        Returns the taps in the derivative filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_ccf_diff_channel_taps(self, channel)

    def taps_as_string(self) -> "std::string":
        r"""
        taps_as_string(pfb_clock_sync_ccf self) -> std::string
        Return the taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_ccf_taps_as_string(self)

    def diff_taps_as_string(self) -> "std::string":
        r"""
        diff_taps_as_string(pfb_clock_sync_ccf self) -> std::string
        Return the derivative filter taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_ccf_diff_taps_as_string(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""
        set_loop_bandwidth(pfb_clock_sync_ccf self, float bw)
        Set the loop bandwidth.

        Set the loop filter's bandwidth to . This should be between 2*pi/200 and 2*pi/100 (in rads/samp). It must also be a positive number.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_ccf_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""
        set_damping_factor(pfb_clock_sync_ccf self, float df)
        Set the loop damping factor.

        Set the loop filter's damping factor to . The damping factor should be sqrt(2)/2.0 for critically damped systems. Set it to anything else only if you know what you are doing. It must be a number between 0 and 1.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_ccf_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(pfb_clock_sync_ccf self, float alpha)
        Set the loop gain alpha.

        Set's the loop filter's alpha gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_ccf_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(pfb_clock_sync_ccf self, float beta)
        Set the loop gain beta.

        Set's the loop filter's beta gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_ccf_set_beta(self, beta)

    def set_max_rate_deviation(self, m: "float") -> "void":
        r"""
        set_max_rate_deviation(pfb_clock_sync_ccf self, float m)
        Set the maximum deviation from 0 d_rate can have
        """
        return _digital_swig2.pfb_clock_sync_ccf_set_max_rate_deviation(self, m)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(pfb_clock_sync_ccf self) -> float
        Returns the loop bandwidth.
        """
        return _digital_swig2.pfb_clock_sync_ccf_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(pfb_clock_sync_ccf self) -> float
        Returns the loop damping factor.
        """
        return _digital_swig2.pfb_clock_sync_ccf_damping_factor(self)

    def alpha(self) -> "float":
        r"""
        alpha(pfb_clock_sync_ccf self) -> float
        Returns the loop gain alpha.
        """
        return _digital_swig2.pfb_clock_sync_ccf_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(pfb_clock_sync_ccf self) -> float
        Returns the loop gain beta.
        """
        return _digital_swig2.pfb_clock_sync_ccf_beta(self)

    def clock_rate(self) -> "float":
        r"""
        clock_rate(pfb_clock_sync_ccf self) -> float
        Returns the current clock rate.
        """
        return _digital_swig2.pfb_clock_sync_ccf_clock_rate(self)

    def error(self) -> "float":
        r"""
        error(pfb_clock_sync_ccf self) -> float
        Returns the current error of the control loop.
        """
        return _digital_swig2.pfb_clock_sync_ccf_error(self)

    def rate(self) -> "float":
        r"""
        rate(pfb_clock_sync_ccf self) -> float
        Returns the current rate of the control loop.
        """
        return _digital_swig2.pfb_clock_sync_ccf_rate(self)

    def phase(self) -> "float":
        r"""
        phase(pfb_clock_sync_ccf self) -> float
        Returns the current phase arm of the control loop.
        """
        return _digital_swig2.pfb_clock_sync_ccf_phase(self)
    __swig_destroy__ = _digital_swig2.delete_pfb_clock_sync_ccf

# Register pfb_clock_sync_ccf in _digital_swig2:
_digital_swig2.pfb_clock_sync_ccf_swigregister(pfb_clock_sync_ccf)
class pfb_clock_sync_fff(object):
    r"""
    Timing synchronizer using polyphase filterbanks.

    This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


    This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


    If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


    The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for "gain," which is d_alpha while d_beta is equal to (gain^2)/4.


    The block's parameters are:









    Reference: f. j. harris and M. Rice, "Multirate Digital Filters for Symbol
    Timing Synchronization in Software Defined Radios", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

    Constructor Specific Documentation:

    Build the polyphase filterbank timing synchronizer.

    Args:
        sps : (double) The number of samples per second in the incoming signal
        gain : (float) The alpha gain of the control loop; beta = (gain^2)/4 by default.
        taps : (vector<int>) The filter taps.
        filter_size : (uint) The number of filters in the filterbank (default = 32).
        init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
        max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
        osps : (int) The number of output samples per symbol (default=1).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(sps: "double", gain: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32, init_phase: "float"=0, max_rate_deviation: "float"=1.5, osps: "int"=1) -> "gr::digital::pfb_clock_sync_fff::sptr":
        r"""
        make(double sps, float gain, pmt_vector_float taps, unsigned int filter_size=32, float init_phase=0, float max_rate_deviation=1.5, int osps=1) -> pfb_clock_sync_fff_sptr
        Timing synchronizer using polyphase filterbanks.

        This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


        This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


        If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


        The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for "gain," which is d_alpha while d_beta is equal to (gain^2)/4.


        The block's parameters are:









        Reference: f. j. harris and M. Rice, "Multirate Digital Filters for Symbol
        Timing Synchronization in Software Defined Radios", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

        Constructor Specific Documentation:

        Build the polyphase filterbank timing synchronizer.

        Args:
            sps : (double) The number of samples per second in the incoming signal
            gain : (float) The alpha gain of the control loop; beta = (gain^2)/4 by default.
            taps : (vector<int>) The filter taps.
            filter_size : (uint) The number of filters in the filterbank (default = 32).
            init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
            max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
            osps : (int) The number of output samples per symbol (default=1).
        """
        return _digital_swig2.pfb_clock_sync_fff_make(sps, gain, taps, filter_size, init_phase, max_rate_deviation, osps)

    def update_gains(self) -> "void":
        r"""
        update_gains(pfb_clock_sync_fff self)
        update the system gains from omega and eta

        This function updates the system gains based on the loop bandwidth and damping factor of the system. These two factors can be set separately through their own set functions.
        """
        return _digital_swig2.pfb_clock_sync_fff_update_gains(self)

    def update_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        update_taps(pfb_clock_sync_fff self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter.
        """
        return _digital_swig2.pfb_clock_sync_fff_update_taps(self, taps)

    def set_taps(self, taps: "pmt_vector_float", ourtaps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > &", ourfilter: "std::vector< gr::filter::kernel::fir_filter_fff *,std::allocator< gr::filter::kernel::fir_filter_fff * > > &") -> "void":
        r"""
        set_taps(pfb_clock_sync_fff self, pmt_vector_float taps, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > & ourtaps, std::vector< gr::filter::kernel::fir_filter_fff *,std::allocator< gr::filter::kernel::fir_filter_fff * > > & ourfilter)
        Used to set the taps of the filters in the filterbank and differential filterbank.


        WARNING: this should not be used externally and will be moved to a private function in the next API.
        """
        return _digital_swig2.pfb_clock_sync_fff_set_taps(self, taps, ourtaps, ourfilter)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_clock_sync_fff self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the matched filter
        """
        return _digital_swig2.pfb_clock_sync_fff_taps(self)

    def diff_taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        diff_taps(pfb_clock_sync_fff self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the derivative filter
        """
        return _digital_swig2.pfb_clock_sync_fff_diff_taps(self)

    def channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        channel_taps(pfb_clock_sync_fff self, int channel) -> pmt_vector_float
        Returns the taps of the matched filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_fff_channel_taps(self, channel)

    def diff_channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        diff_channel_taps(pfb_clock_sync_fff self, int channel) -> pmt_vector_float
        Returns the taps in the derivative filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_fff_diff_channel_taps(self, channel)

    def taps_as_string(self) -> "std::string":
        r"""
        taps_as_string(pfb_clock_sync_fff self) -> std::string
        Return the taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_fff_taps_as_string(self)

    def diff_taps_as_string(self) -> "std::string":
        r"""
        diff_taps_as_string(pfb_clock_sync_fff self) -> std::string
        Return the derivative filter taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_fff_diff_taps_as_string(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""
        set_loop_bandwidth(pfb_clock_sync_fff self, float bw)
        Set the loop bandwidth.

        Set the loop filter's bandwidth to . This should be between 2*pi/200 and 2*pi/100 (in rads/samp). It must also be a positive number.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_fff_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""
        set_damping_factor(pfb_clock_sync_fff self, float df)
        Set the loop damping factor.

        Set the loop filter's damping factor to . The damping factor should be sqrt(2)/2.0 for critically damped systems. Set it to anything else only if you know what you are doing. It must be a number between 0 and 1.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_fff_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(pfb_clock_sync_fff self, float alpha)
        Set the loop gain alpha.

        Set's the loop filter's alpha gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_fff_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(pfb_clock_sync_fff self, float beta)
        Set the loop gain beta.

        Set's the loop filter's beta gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_fff_set_beta(self, beta)

    def set_max_rate_deviation(self, m: "float") -> "void":
        r"""
        set_max_rate_deviation(pfb_clock_sync_fff self, float m)
        Set the maximum deviation from 0 d_rate can have
        """
        return _digital_swig2.pfb_clock_sync_fff_set_max_rate_deviation(self, m)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(pfb_clock_sync_fff self) -> float
        Returns the loop bandwidth.
        """
        return _digital_swig2.pfb_clock_sync_fff_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(pfb_clock_sync_fff self) -> float
        Returns the loop damping factor.
        """
        return _digital_swig2.pfb_clock_sync_fff_damping_factor(self)

    def alpha(self) -> "float":
        r"""
        alpha(pfb_clock_sync_fff self) -> float
        Returns the loop gain alpha.
        """
        return _digital_swig2.pfb_clock_sync_fff_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(pfb_clock_sync_fff self) -> float
        Returns the loop gain beta.
        """
        return _digital_swig2.pfb_clock_sync_fff_beta(self)

    def clock_rate(self) -> "float":
        r"""
        clock_rate(pfb_clock_sync_fff self) -> float
        Returns the current clock rate.
        """
        return _digital_swig2.pfb_clock_sync_fff_clock_rate(self)
    __swig_destroy__ = _digital_swig2.delete_pfb_clock_sync_fff

# Register pfb_clock_sync_fff in _digital_swig2:
_digital_swig2.pfb_clock_sync_fff_swigregister(pfb_clock_sync_fff)
class pn_correlator_cc(object):
    r"""
    PN code sequential search correlator.

    Receives complex baseband signal, outputs complex correlation against reference PN code, one sample per PN code period. The PN sequence is generated using a GLFSR.

    Constructor Specific Documentation:

    Make PN code sequential search correlator block.

    Args:
        degree : Degree of shift register must be in [1, 32]. If mask is 0, the degree determines a default mask (see digital_impl_glfsr.cc for the mapping).
        mask : Allows a user-defined bit mask for indexes of the shift register to feed back.
        seed : Initial setting for values in shift register.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(degree: "int", mask: "int"=0, seed: "int"=1) -> "gr::digital::pn_correlator_cc::sptr":
        r"""
        make(int degree, int mask=0, int seed=1) -> pn_correlator_cc_sptr
        PN code sequential search correlator.

        Receives complex baseband signal, outputs complex correlation against reference PN code, one sample per PN code period. The PN sequence is generated using a GLFSR.

        Constructor Specific Documentation:

        Make PN code sequential search correlator block.

        Args:
            degree : Degree of shift register must be in [1, 32]. If mask is 0, the degree determines a default mask (see digital_impl_glfsr.cc for the mapping).
            mask : Allows a user-defined bit mask for indexes of the shift register to feed back.
            seed : Initial setting for values in shift register.
        """
        return _digital_swig2.pn_correlator_cc_make(degree, mask, seed)
    __swig_destroy__ = _digital_swig2.delete_pn_correlator_cc

# Register pn_correlator_cc in _digital_swig2:
_digital_swig2.pn_correlator_cc_swigregister(pn_correlator_cc)
class probe_density_b(object):
    r"""
    This block maintains a running average of the input stream and makes it available as an accessor function. The input stream is type unsigned char.


    If you send this block a stream of unpacked bytes, it will tell you what the bit density is.

    Constructor Specific Documentation:

    Make a density probe block.

    Args:
        alpha : Average filter constant
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(alpha: "double") -> "gr::digital::probe_density_b::sptr":
        r"""
        make(double alpha) -> probe_density_b_sptr
        This block maintains a running average of the input stream and makes it available as an accessor function. The input stream is type unsigned char.


        If you send this block a stream of unpacked bytes, it will tell you what the bit density is.

        Constructor Specific Documentation:

        Make a density probe block.

        Args:
            alpha : Average filter constant
        """
        return _digital_swig2.probe_density_b_make(alpha)

    def density(self) -> "double":
        r"""
        density(probe_density_b self) -> double
        Returns the current density value.
        """
        return _digital_swig2.probe_density_b_density(self)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(probe_density_b self, double alpha)
        Set the average filter constant.
        """
        return _digital_swig2.probe_density_b_set_alpha(self, alpha)
    __swig_destroy__ = _digital_swig2.delete_probe_density_b

# Register probe_density_b in _digital_swig2:
_digital_swig2.probe_density_b_swigregister(probe_density_b)
class probe_mpsk_snr_est_c(object):
    r"""
    A probe for computing SNR of a PSK signal.

    This is a probe block (a sink) that can be used to monitor and retrieve estimations of the signal SNR. This probe is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


    The block has three output message ports that will emit a message every msg_samples number of samples. These message ports are: 
    Some calibration is required to convert dBx of the signal and noise power estimates to real measurements, such as dBm.


    The estimator is normally placed before clock recovery.

    Constructor Specific Documentation:

    Make an MPSK SNR probe.


    Parameters:

    Args:
        type : the type of estimator to use see gr::digital::snr_est_type_t for details about the types.
        msg_nsamples : [not implemented yet] after this many samples, a message containing the SNR (key='snr') will be sent
        alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(type: "gr::digital::snr_est_type_t", msg_nsamples: "int"=10000, alpha: "double"=0.001) -> "gr::digital::probe_mpsk_snr_est_c::sptr":
        r"""
        make(gr::digital::snr_est_type_t type, int msg_nsamples=10000, double alpha=0.001) -> probe_mpsk_snr_est_c_sptr
        A probe for computing SNR of a PSK signal.

        This is a probe block (a sink) that can be used to monitor and retrieve estimations of the signal SNR. This probe is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


        The block has three output message ports that will emit a message every msg_samples number of samples. These message ports are: 
        Some calibration is required to convert dBx of the signal and noise power estimates to real measurements, such as dBm.


        The estimator is normally placed before clock recovery.

        Constructor Specific Documentation:

        Make an MPSK SNR probe.


        Parameters:

        Args:
            type : the type of estimator to use see gr::digital::snr_est_type_t for details about the types.
            msg_nsamples : [not implemented yet] after this many samples, a message containing the SNR (key='snr') will be sent
            alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_make(type, msg_nsamples, alpha)

    def snr(self) -> "double":
        r"""
        snr(probe_mpsk_snr_est_c self) -> double
        Return the estimated signal-to-noise ratio in decibels.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_snr(self)

    def signal(self) -> "double":
        r"""
        signal(probe_mpsk_snr_est_c self) -> double
        Return the estimated signal power in decibels.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_signal(self)

    def noise(self) -> "double":
        r"""
        noise(probe_mpsk_snr_est_c self) -> double
        Return the estimated noise power in decibels.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_noise(self)

    def type(self) -> "gr::digital::snr_est_type_t":
        r"""
        type(probe_mpsk_snr_est_c self) -> gr::digital::snr_est_type_t
        Return the type of estimator in use.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_type(self)

    def msg_nsample(self) -> "int":
        r"""
        msg_nsample(probe_mpsk_snr_est_c self) -> int
        Return how many samples between SNR messages.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_msg_nsample(self)

    def alpha(self) -> "double":
        r"""
        alpha(probe_mpsk_snr_est_c self) -> double
        Get the running-average coefficient.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_alpha(self)

    def set_type(self, t: "gr::digital::snr_est_type_t") -> "void":
        r"""
        set_type(probe_mpsk_snr_est_c self, gr::digital::snr_est_type_t t)
        Set type of estimator to use.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_set_type(self, t)

    def set_msg_nsample(self, n: "int") -> "void":
        r"""
        set_msg_nsample(probe_mpsk_snr_est_c self, int n)
        Set the number of samples between SNR messages.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_set_msg_nsample(self, n)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(probe_mpsk_snr_est_c self, double alpha)
        Set the running-average coefficient.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_set_alpha(self, alpha)
    __swig_destroy__ = _digital_swig2.delete_probe_mpsk_snr_est_c

# Register probe_mpsk_snr_est_c in _digital_swig2:
_digital_swig2.probe_mpsk_snr_est_c_swigregister(probe_mpsk_snr_est_c)
class scrambler_bb(object):
    r"""
    Scramble an input stream using an LFSR.

    This block works on the LSB only of the input data stream, i.e., on an "unpacked binary" stream, and produces the same format on its output.

    Constructor Specific Documentation:

    Make a scramber block.

    Args:
        mask : Polynomial mask for LFSR
        seed : Initial shift register contents
        len : Shift register length
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(mask: "int", seed: "int", len: "int") -> "gr::digital::scrambler_bb::sptr":
        r"""
        make(int mask, int seed, int len) -> scrambler_bb_sptr
        Scramble an input stream using an LFSR.

        This block works on the LSB only of the input data stream, i.e., on an "unpacked binary" stream, and produces the same format on its output.

        Constructor Specific Documentation:

        Make a scramber block.

        Args:
            mask : Polynomial mask for LFSR
            seed : Initial shift register contents
            len : Shift register length
        """
        return _digital_swig2.scrambler_bb_make(mask, seed, len)
    __swig_destroy__ = _digital_swig2.delete_scrambler_bb

# Register scrambler_bb in _digital_swig2:
_digital_swig2.scrambler_bb_swigregister(scrambler_bb)
class simple_correlator(object):
    r"""
    inverse of simple_framer (more or less)

    Constructor Specific Documentation:



    Args:
        payload_bytesize : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(payload_bytesize: "int") -> "gr::digital::simple_correlator::sptr":
        r"""
        make(int payload_bytesize) -> simple_correlator_sptr
        inverse of simple_framer (more or less)

        Constructor Specific Documentation:



        Args:
            payload_bytesize : 
        """
        return _digital_swig2.simple_correlator_make(payload_bytesize)
    __swig_destroy__ = _digital_swig2.delete_simple_correlator

# Register simple_correlator in _digital_swig2:
_digital_swig2.simple_correlator_swigregister(simple_correlator)
class simple_framer(object):
    r"""
    add sync field, seq number and command field to payload

    Takes in enough samples to create a full output frame. The frame is prepended with the GRSF_SYNC (defined in simple_framer_sync.h) and an 8-bit sequence number.

    Constructor Specific Documentation:

    Make a simple_framer block.

    Args:
        payload_bytesize : The size of the payload in bytes.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(payload_bytesize: "int") -> "gr::digital::simple_framer::sptr":
        r"""
        make(int payload_bytesize) -> simple_framer_sptr
        add sync field, seq number and command field to payload

        Takes in enough samples to create a full output frame. The frame is prepended with the GRSF_SYNC (defined in simple_framer_sync.h) and an 8-bit sequence number.

        Constructor Specific Documentation:

        Make a simple_framer block.

        Args:
            payload_bytesize : The size of the payload in bytes.
        """
        return _digital_swig2.simple_framer_make(payload_bytesize)
    __swig_destroy__ = _digital_swig2.delete_simple_framer

# Register simple_framer in _digital_swig2:
_digital_swig2.simple_framer_swigregister(simple_framer)
class symbol_sync_cc(object):
    r"""
    Symbol Synchronizer block with complex input, complex output.

    This implements a discrete-time error-tracking synchronizer.


    For this block to work properly, the input stream must meet the following requirements:

    Constructor Specific Documentation:

    Make a Symbol Synchronizer block.


    This implements a discrete-time error-tracking synchronizer.


    For this block to work properly, the input stream must meet the following requirements:

    Args:
        detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
        sps : User specified nominal clock period in samples per symbol.
        loop_bw : Approximate normailzed loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
        damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
        ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
        max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
        osps : The number of output samples per symbol (default=1).
        slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
        interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
        n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
        taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::symbol_sync_cc::sptr":
        r"""
        make(enum gr::digital::ted_type detector_type, float sps, float loop_bw, float damping_factor=1.0, float ted_gain=1.0, float max_deviation=1.5, int osps=1, constellation_sptr slicer=gr::digital::constellation_sptr(), gr::digital::ir_type interp_type=IR_MMSE_8TAP, int n_filters=128, pmt_vector_float taps=std::vector< float >()) -> symbol_sync_cc_sptr
        Symbol Synchronizer block with complex input, complex output.

        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Constructor Specific Documentation:

        Make a Symbol Synchronizer block.


        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Args:
            detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
            sps : User specified nominal clock period in samples per symbol.
            loop_bw : Approximate normailzed loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
            damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
            ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
            max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
            osps : The number of output samples per symbol (default=1).
            slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
            interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
            n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
            taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
        """
        return _digital_swig2.symbol_sync_cc_make(*args, **kwargs)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(symbol_sync_cc self) -> float
        Returns the normalized approximate loop bandwidth.

        See the documentation for set_loop_bandwidth() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_cc_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(symbol_sync_cc self) -> float
        Returns the loop damping factor.

        See the documentation for set_damping_factor() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_cc_damping_factor(self)

    def ted_gain(self) -> "float":
        r"""
        ted_gain(symbol_sync_cc self) -> float
        Returns the user provided expected gain of the Timing Error Detector.

        See the documentation for set_ted_gain() for more details.
        """
        return _digital_swig2.symbol_sync_cc_ted_gain(self)

    def alpha(self) -> "float":
        r"""
        alpha(symbol_sync_cc self) -> float
        Returns the PI filter proportional gain, alpha.

        See the documentation for set_alpha() for more details.
        """
        return _digital_swig2.symbol_sync_cc_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(symbol_sync_cc self) -> float
        Returns the PI filter integral gain, beta.

        See the documentation for set_beta() for more details.
        """
        return _digital_swig2.symbol_sync_cc_beta(self)

    def set_loop_bandwidth(self, omega_n_norm: "float") -> "void":
        r"""
        set_loop_bandwidth(symbol_sync_cc self, float omega_n_norm)
        Set the normalized approximate loop bandwidth.

        Set the normalized approximate loop bandwidth. Useful values are usually close to 0.0, e.g. 2*pi*0.045.


        It should be a small positive number, corresponding to the normalized natural radian frequency of the loop as digital low-pass filter that is filtering the clock phase/timing error.


        Technically this parameter corresponds to the natural radian frequency of the 2nd order loop transfer function (scaled by Fs), which is the radius of the pole locations in the s-plane of an underdamped analog 2nd order system.


        The input parameter corresponds to omega_n_norm in the following relation: 


        where T is the period of the clock being estimated by this clock tracking loop, and omega_n is the natural radian frequency of the 2nd order loop transfer function.


        When a new loop bandwidth is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_cc_set_loop_bandwidth(self, omega_n_norm)

    def set_damping_factor(self, zeta: "float") -> "void":
        r"""
        set_damping_factor(symbol_sync_cc self, float zeta)
        Set the loop damping factor.

        Set the damping factor of the loop. Damping in the range (0.0, 1.0) yields an under-damped loop. Damping in the range (1.0, Inf) yields an over-damped loop. Damping equal to 1.0 yields a crtically-damped loop. Damping equal to 1.0/sqrt(2.0) yields a maximally flat loop filter response.


        Damping factor of the 2nd order loop transfer function. When a new damping factor is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_cc_set_damping_factor(self, zeta)

    def set_ted_gain(self, ted_gain: "float") -> "void":
        r"""
        set_ted_gain(symbol_sync_cc self, float ted_gain)
        Set the expected gain of the Timing Error Detector.

        Sets the expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.


        When a new ted_gain is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_cc_set_ted_gain(self, ted_gain)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(symbol_sync_cc self, float alpha)
        Set the PI filter proportional gain, alpha.

        Sets the PI filter proportional gain, alpha. This gain directly mutliplies the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the instantaneous clock period estimate, T_inst, and instantaneous clock phase estimate, tau.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_cc_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(symbol_sync_cc self, float beta)
        Set the PI filter integral gain, beta.

        Sets the PI filter integral gain, beta. This gain is used when integrating the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the average clock period estimate, T_avg.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_cc_set_beta(self, beta)
    __swig_destroy__ = _digital_swig2.delete_symbol_sync_cc

# Register symbol_sync_cc in _digital_swig2:
_digital_swig2.symbol_sync_cc_swigregister(symbol_sync_cc)
class symbol_sync_ff(object):
    r"""
    Symbol Synchronizer block with float input, float output.

    This implements a discrete-time error-tracking synchronizer.


    For this block to work properly, the input stream must meet the following requirements:

    Constructor Specific Documentation:

    Make a Symbol Synchronizer block.


    This implements a discrete-time error-tracking synchronizer.


    For this block to work properly, the input stream must meet the following requirements:

    Args:
        detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
        sps : User specified nominal clock period in samples per symbol.
        loop_bw : Approximate normailzed loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
        damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
        ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
        max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
        osps : The number of output samples per symbol (default=1).
        slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
        interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
        n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
        taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::symbol_sync_ff::sptr":
        r"""
        make(enum gr::digital::ted_type detector_type, float sps, float loop_bw, float damping_factor=1.0, float ted_gain=1.0, float max_deviation=1.5, int osps=1, constellation_sptr slicer=gr::digital::constellation_sptr(), gr::digital::ir_type interp_type=IR_MMSE_8TAP, int n_filters=128, pmt_vector_float taps=std::vector< float >()) -> symbol_sync_ff_sptr
        Symbol Synchronizer block with float input, float output.

        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Constructor Specific Documentation:

        Make a Symbol Synchronizer block.


        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Args:
            detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
            sps : User specified nominal clock period in samples per symbol.
            loop_bw : Approximate normailzed loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
            damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
            ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
            max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
            osps : The number of output samples per symbol (default=1).
            slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
            interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
            n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
            taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
        """
        return _digital_swig2.symbol_sync_ff_make(*args, **kwargs)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(symbol_sync_ff self) -> float
        Returns the normalized approximate loop bandwidth.

        See the documentation for set_loop_bandwidth() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_ff_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(symbol_sync_ff self) -> float
        Returns the loop damping factor.

        See the documentation for set_damping_factor() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_ff_damping_factor(self)

    def ted_gain(self) -> "float":
        r"""
        ted_gain(symbol_sync_ff self) -> float
        Returns the user provided expected gain of the Timing Error Detector.

        See the documentation for set_ted_gain() for more details.
        """
        return _digital_swig2.symbol_sync_ff_ted_gain(self)

    def alpha(self) -> "float":
        r"""
        alpha(symbol_sync_ff self) -> float
        Returns the PI filter proportional gain, alpha.

        See the documentation for set_alpha() for more details.
        """
        return _digital_swig2.symbol_sync_ff_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(symbol_sync_ff self) -> float
        Returns the PI filter integral gain, beta.

        See the documentation for set_beta() for more details.
        """
        return _digital_swig2.symbol_sync_ff_beta(self)

    def set_loop_bandwidth(self, omega_n_norm: "float") -> "void":
        r"""
        set_loop_bandwidth(symbol_sync_ff self, float omega_n_norm)
        Set the normalized approximate loop bandwidth.

        Set the normalized approximate loop bandwidth. Useful values are usually close to 0.0, e.g. 2*pi*0.045.


        It should be a small positive number, corresponding to the normalized natural radian frequency of the loop as digital low-pass filter that is filtering the clock phase/timing error.


        Technically this parameter corresponds to the natural radian frequency of the 2nd order loop transfer function (scaled by Fs), which is the radius of the pole locations in the s-plane of an underdamped analog 2nd order system.


        The input parameter corresponds to omega_n_norm in the following relation: 


        where T is the period of the clock being estimated by this clock tracking loop, and omega_n is the natural radian frequency of the 2nd order loop transfer function.


        When a new loop bandwidth is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_ff_set_loop_bandwidth(self, omega_n_norm)

    def set_damping_factor(self, zeta: "float") -> "void":
        r"""
        set_damping_factor(symbol_sync_ff self, float zeta)
        Set the loop damping factor.

        Set the damping factor of the loop. Damping in the range (0.0, 1.0) yields an under-damped loop. Damping in the range (1.0, Inf) yields an over-damped loop. Damping equal to 1.0 yields a crtically-damped loop. Damping equal to 1.0/sqrt(2.0) yields a maximally flat loop filter response.


        Damping factor of the 2nd order loop transfer function. When a new damping factor is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_ff_set_damping_factor(self, zeta)

    def set_ted_gain(self, ted_gain: "float") -> "void":
        r"""
        set_ted_gain(symbol_sync_ff self, float ted_gain)
        Set the expected gain of the Timing Error Detector.

        Sets the expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.


        When a new ted_gain is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_ff_set_ted_gain(self, ted_gain)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(symbol_sync_ff self, float alpha)
        Set the PI filter proportional gain, alpha.

        Sets the PI filter proportional gain, alpha. This gain directly mutliplies the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the instantaneous clock period estimate, T_inst, and instantaneous clock phase estimate, tau.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_ff_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(symbol_sync_ff self, float beta)
        Set the PI filter integral gain, beta.

        Sets the PI filter integral gain, beta. This gain is used when integrating the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the average clock period estimate, T_avg.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_ff_set_beta(self, beta)
    __swig_destroy__ = _digital_swig2.delete_symbol_sync_ff

# Register symbol_sync_ff in _digital_swig2:
_digital_swig2.symbol_sync_ff_swigregister(symbol_sync_ff)
class mpsk_snr_est_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::mpsk_snr_est_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(mpsk_snr_est_cc_sptr self) -> mpsk_snr_est_cc_sptr
        __init__(mpsk_snr_est_cc_sptr self, mpsk_snr_est_cc p) -> mpsk_snr_est_cc_sptr
        """
        _digital_swig2.mpsk_snr_est_cc_sptr_swiginit(self, _digital_swig2.new_mpsk_snr_est_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::mpsk_snr_est_cc *":
        r"""__deref__(mpsk_snr_est_cc_sptr self) -> mpsk_snr_est_cc"""
        return _digital_swig2.mpsk_snr_est_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_mpsk_snr_est_cc_sptr

    def make(self, type: "gr::digital::snr_est_type_t", tag_nsamples: "int"=10000, alpha: "double"=0.001) -> "gr::digital::mpsk_snr_est_cc::sptr":
        r"""
        make(mpsk_snr_est_cc_sptr self, gr::digital::snr_est_type_t type, int tag_nsamples=10000, double alpha=0.001) -> mpsk_snr_est_cc_sptr
        A block for computing SNR of a signal.

        This block can be used to monitor and retrieve estimations of the signal SNR. It is designed to work in a flowgraph and passes all incoming data along to its output.


        The block is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


        The estimator is normally placed before clock recovery.

        Constructor Specific Documentation:

        Factory function returning shared pointer of this class

        Args:
            type : the type of estimator to use gr::digital::snr_est_type_t "snr_est_type_t" for details about the available types
            tag_nsamples : after this many samples, a tag containing the SNR (key='snr') will be sent
            alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_make(self, type, tag_nsamples, alpha)

    def snr(self) -> "double":
        r"""
        snr(mpsk_snr_est_cc_sptr self) -> double
        Return the estimated signal-to-noise ratio in decibels.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_snr(self)

    def type(self) -> "gr::digital::snr_est_type_t":
        r"""
        type(mpsk_snr_est_cc_sptr self) -> gr::digital::snr_est_type_t
        Return the type of estimator in use.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_type(self)

    def tag_nsample(self) -> "int":
        r"""
        tag_nsample(mpsk_snr_est_cc_sptr self) -> int
        Return how many samples between SNR tags.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_tag_nsample(self)

    def alpha(self) -> "double":
        r"""
        alpha(mpsk_snr_est_cc_sptr self) -> double
        Get the running-average coefficient.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_alpha(self)

    def set_type(self, t: "gr::digital::snr_est_type_t") -> "void":
        r"""
        set_type(mpsk_snr_est_cc_sptr self, gr::digital::snr_est_type_t t)
        Set type of estimator to use.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_type(self, t)

    def set_tag_nsample(self, n: "int") -> "void":
        r"""
        set_tag_nsample(mpsk_snr_est_cc_sptr self, int n)
        Set the number of samples between SNR tags.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_tag_nsample(self, n)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(mpsk_snr_est_cc_sptr self, double alpha)
        Set the running-average coefficient.
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_alpha(self, alpha)

    def history(self) -> "unsigned int":
        r"""history(mpsk_snr_est_cc_sptr self) -> unsigned int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(mpsk_snr_est_cc_sptr self, int which, int delay)
        declare_sample_delay(mpsk_snr_est_cc_sptr self, unsigned int delay)
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(mpsk_snr_est_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(mpsk_snr_est_cc_sptr self, int multiple)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(mpsk_snr_est_cc_sptr self) -> int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(mpsk_snr_est_cc_sptr self) -> double"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(mpsk_snr_est_cc_sptr self) -> uint64_t"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(mpsk_snr_est_cc_sptr self) -> uint64_t"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(mpsk_snr_est_cc_sptr self) -> bool"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(mpsk_snr_est_cc_sptr self) -> bool"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(mpsk_snr_est_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(mpsk_snr_est_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(mpsk_snr_est_cc_sptr self, std::string level)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(mpsk_snr_est_cc_sptr self) -> std::string"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(mpsk_snr_est_cc_sptr self) -> int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(mpsk_snr_est_cc_sptr self, int m)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(mpsk_snr_est_cc_sptr self)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(mpsk_snr_est_cc_sptr self) -> bool"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(mpsk_snr_est_cc_sptr self, int m)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(mpsk_snr_est_cc_sptr self) -> int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(mpsk_snr_est_cc_sptr self, int i) -> long"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(mpsk_snr_est_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(mpsk_snr_est_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(mpsk_snr_est_cc_sptr self, int i) -> long"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(mpsk_snr_est_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(mpsk_snr_est_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(mpsk_snr_est_cc_sptr self, int which) -> float
        pc_input_buffers_full(mpsk_snr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(mpsk_snr_est_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(mpsk_snr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(mpsk_snr_est_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(mpsk_snr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(mpsk_snr_est_cc_sptr self, int which) -> float
        pc_output_buffers_full(mpsk_snr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(mpsk_snr_est_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(mpsk_snr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(mpsk_snr_est_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(mpsk_snr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(mpsk_snr_est_cc_sptr self) -> float"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(mpsk_snr_est_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(mpsk_snr_est_cc_sptr self)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(mpsk_snr_est_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(mpsk_snr_est_cc_sptr self) -> int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(mpsk_snr_est_cc_sptr self) -> int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(mpsk_snr_est_cc_sptr self, int priority) -> int"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(mpsk_snr_est_cc_sptr self) -> std::string"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(mpsk_snr_est_cc_sptr self) -> std::string"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(mpsk_snr_est_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(mpsk_snr_est_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(mpsk_snr_est_cc_sptr self) -> long"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(mpsk_snr_est_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(mpsk_snr_est_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(mpsk_snr_est_cc_sptr self) -> std::string"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(mpsk_snr_est_cc_sptr self, std::string name)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(mpsk_snr_est_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.mpsk_snr_est_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(mpsk_snr_est_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(mpsk_snr_est_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(mpsk_snr_est_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.mpsk_snr_est_cc_sptr_message_subscribers(self, which_port)

# Register mpsk_snr_est_cc_sptr in _digital_swig2:
_digital_swig2.mpsk_snr_est_cc_sptr_swigregister(mpsk_snr_est_cc_sptr)

mpsk_snr_est_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
mpsk_snr_est_cc = mpsk_snr_est_cc.make;

class protocol_formatter_async_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::protocol_formatter_async > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(protocol_formatter_async_sptr self) -> protocol_formatter_async_sptr
        __init__(protocol_formatter_async_sptr self, protocol_formatter_async p) -> protocol_formatter_async_sptr
        """
        _digital_swig2.protocol_formatter_async_sptr_swiginit(self, _digital_swig2.new_protocol_formatter_async_sptr(*args))

    def __deref__(self) -> "gr::digital::protocol_formatter_async *":
        r"""__deref__(protocol_formatter_async_sptr self) -> protocol_formatter_async"""
        return _digital_swig2.protocol_formatter_async_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_protocol_formatter_async_sptr

    def make(self, format: "header_format_base_sptr") -> "gr::digital::protocol_formatter_async::sptr":
        r"""
        make(protocol_formatter_async_sptr self, header_format_base_sptr format) -> protocol_formatter_async_sptr
        Uses a header format object to append a header onto a PDU.

        This block takes in PDUs and creates a header, generally for MAC-level processing. Each received PDU is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


        The header that is created and transmitted out of the 'header' message port as a PDU. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output PDU as a PMT argument along with any changes to the metadata info PMT.


        For different packet header formatting needs, we can define new classes that inherit from the header_format_base block and which overload the header_format_base::format function.





        This block only uses asynchronous message passing interfaces to receiver and emit PDUs. The message ports are:

        Constructor Specific Documentation:

        Make a packet header block using a given .

        Args:
            format : The format object to use when creating the header for the packet.
        """
        return _digital_swig2.protocol_formatter_async_sptr_make(self, format)

    def history(self) -> "unsigned int":
        r"""history(protocol_formatter_async_sptr self) -> unsigned int"""
        return _digital_swig2.protocol_formatter_async_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(protocol_formatter_async_sptr self, int which, int delay)
        declare_sample_delay(protocol_formatter_async_sptr self, unsigned int delay)
        """
        return _digital_swig2.protocol_formatter_async_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(protocol_formatter_async_sptr self, int which) -> unsigned int"""
        return _digital_swig2.protocol_formatter_async_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(protocol_formatter_async_sptr self, int multiple)"""
        return _digital_swig2.protocol_formatter_async_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(protocol_formatter_async_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_async_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(protocol_formatter_async_sptr self) -> double"""
        return _digital_swig2.protocol_formatter_async_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(protocol_formatter_async_sptr self) -> uint64_t"""
        return _digital_swig2.protocol_formatter_async_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(protocol_formatter_async_sptr self) -> uint64_t"""
        return _digital_swig2.protocol_formatter_async_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(protocol_formatter_async_sptr self) -> bool"""
        return _digital_swig2.protocol_formatter_async_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(protocol_formatter_async_sptr self) -> bool"""
        return _digital_swig2.protocol_formatter_async_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(protocol_formatter_async_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.protocol_formatter_async_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(protocol_formatter_async_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.protocol_formatter_async_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(protocol_formatter_async_sptr self, std::string level)"""
        return _digital_swig2.protocol_formatter_async_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(protocol_formatter_async_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_async_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(protocol_formatter_async_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_async_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(protocol_formatter_async_sptr self, int m)"""
        return _digital_swig2.protocol_formatter_async_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(protocol_formatter_async_sptr self)"""
        return _digital_swig2.protocol_formatter_async_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(protocol_formatter_async_sptr self) -> bool"""
        return _digital_swig2.protocol_formatter_async_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(protocol_formatter_async_sptr self, int m)"""
        return _digital_swig2.protocol_formatter_async_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(protocol_formatter_async_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_async_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(protocol_formatter_async_sptr self, int i) -> long"""
        return _digital_swig2.protocol_formatter_async_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(protocol_formatter_async_sptr self, long max_output_buffer)
        set_max_output_buffer(protocol_formatter_async_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.protocol_formatter_async_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(protocol_formatter_async_sptr self, int i) -> long"""
        return _digital_swig2.protocol_formatter_async_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(protocol_formatter_async_sptr self, long min_output_buffer)
        set_min_output_buffer(protocol_formatter_async_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.protocol_formatter_async_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(protocol_formatter_async_sptr self, int which) -> float
        pc_input_buffers_full(protocol_formatter_async_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_async_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(protocol_formatter_async_sptr self, int which) -> float
        pc_input_buffers_full_avg(protocol_formatter_async_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_async_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(protocol_formatter_async_sptr self, int which) -> float
        pc_input_buffers_full_var(protocol_formatter_async_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_async_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(protocol_formatter_async_sptr self, int which) -> float
        pc_output_buffers_full(protocol_formatter_async_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_async_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(protocol_formatter_async_sptr self, int which) -> float
        pc_output_buffers_full_avg(protocol_formatter_async_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_async_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(protocol_formatter_async_sptr self, int which) -> float
        pc_output_buffers_full_var(protocol_formatter_async_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_async_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(protocol_formatter_async_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_async_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(protocol_formatter_async_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.protocol_formatter_async_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(protocol_formatter_async_sptr self)"""
        return _digital_swig2.protocol_formatter_async_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(protocol_formatter_async_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.protocol_formatter_async_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(protocol_formatter_async_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_async_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(protocol_formatter_async_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_async_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(protocol_formatter_async_sptr self, int priority) -> int"""
        return _digital_swig2.protocol_formatter_async_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(protocol_formatter_async_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_async_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(protocol_formatter_async_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_async_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(protocol_formatter_async_sptr self) -> io_signature_sptr"""
        return _digital_swig2.protocol_formatter_async_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(protocol_formatter_async_sptr self) -> io_signature_sptr"""
        return _digital_swig2.protocol_formatter_async_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(protocol_formatter_async_sptr self) -> long"""
        return _digital_swig2.protocol_formatter_async_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(protocol_formatter_async_sptr self) -> basic_block_sptr"""
        return _digital_swig2.protocol_formatter_async_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(protocol_formatter_async_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.protocol_formatter_async_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(protocol_formatter_async_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_async_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(protocol_formatter_async_sptr self, std::string name)"""
        return _digital_swig2.protocol_formatter_async_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(protocol_formatter_async_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.protocol_formatter_async_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(protocol_formatter_async_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_formatter_async_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(protocol_formatter_async_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_formatter_async_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(protocol_formatter_async_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_formatter_async_sptr_message_subscribers(self, which_port)

# Register protocol_formatter_async_sptr in _digital_swig2:
_digital_swig2.protocol_formatter_async_sptr_swigregister(protocol_formatter_async_sptr)

protocol_formatter_async_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
protocol_formatter_async = protocol_formatter_async.make;

class protocol_formatter_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::protocol_formatter_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(protocol_formatter_bb_sptr self) -> protocol_formatter_bb_sptr
        __init__(protocol_formatter_bb_sptr self, protocol_formatter_bb p) -> protocol_formatter_bb_sptr
        """
        _digital_swig2.protocol_formatter_bb_sptr_swiginit(self, _digital_swig2.new_protocol_formatter_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::protocol_formatter_bb *":
        r"""__deref__(protocol_formatter_bb_sptr self) -> protocol_formatter_bb"""
        return _digital_swig2.protocol_formatter_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_protocol_formatter_bb_sptr

    def make(self, *args, **kwargs) -> "gr::digital::protocol_formatter_bb::sptr":
        r"""
        make(protocol_formatter_bb_sptr self, header_format_base_sptr format, std::string const & len_tag_key="packet_len") -> protocol_formatter_bb_sptr
        Uses a header format object to create a header from a tagged stream packet.

        This block takes in tagged stream and creates a header, generally for MAC-level processing. Each received tagged stream is assumed to be its own frame, so any fragmentation would be done upstream in or before the flowgraph.


        The header that is created and transmitted from this block. The payload should then be sent as a parallel tagged stream to be muxed together later. The header is based entirely on the  object, which is an object derived from the header_format_base class. All of these packet header format objects operate the same: they take in the payload data as well as possible extra metadata info about the PDU; the format object then returns the output and metadata info. This block then transmits the header vector and attaches and metadata as tags at the start of the header.

        Constructor Specific Documentation:

        Make a packet header block using a given .

        Args:
            format : The format object to use when creating the header for the packet. Derived from the header_format_base class.
            len_tag_key : The tagged stream length key.
        """
        return _digital_swig2.protocol_formatter_bb_sptr_make(self, *args, **kwargs)

    def set_header_format(self, format: "header_format_base_sptr") -> "void":
        r"""set_header_format(protocol_formatter_bb_sptr self, header_format_base_sptr format)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_header_format(self, format)

    def history(self) -> "unsigned int":
        r"""history(protocol_formatter_bb_sptr self) -> unsigned int"""
        return _digital_swig2.protocol_formatter_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(protocol_formatter_bb_sptr self, int which, int delay)
        declare_sample_delay(protocol_formatter_bb_sptr self, unsigned int delay)
        """
        return _digital_swig2.protocol_formatter_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(protocol_formatter_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig2.protocol_formatter_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(protocol_formatter_bb_sptr self, int multiple)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(protocol_formatter_bb_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(protocol_formatter_bb_sptr self) -> double"""
        return _digital_swig2.protocol_formatter_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(protocol_formatter_bb_sptr self) -> uint64_t"""
        return _digital_swig2.protocol_formatter_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(protocol_formatter_bb_sptr self) -> uint64_t"""
        return _digital_swig2.protocol_formatter_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(protocol_formatter_bb_sptr self) -> bool"""
        return _digital_swig2.protocol_formatter_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(protocol_formatter_bb_sptr self) -> bool"""
        return _digital_swig2.protocol_formatter_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(protocol_formatter_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.protocol_formatter_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(protocol_formatter_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.protocol_formatter_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(protocol_formatter_bb_sptr self, std::string level)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(protocol_formatter_bb_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(protocol_formatter_bb_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(protocol_formatter_bb_sptr self, int m)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(protocol_formatter_bb_sptr self)"""
        return _digital_swig2.protocol_formatter_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(protocol_formatter_bb_sptr self) -> bool"""
        return _digital_swig2.protocol_formatter_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(protocol_formatter_bb_sptr self, int m)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(protocol_formatter_bb_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(protocol_formatter_bb_sptr self, int i) -> long"""
        return _digital_swig2.protocol_formatter_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(protocol_formatter_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(protocol_formatter_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.protocol_formatter_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(protocol_formatter_bb_sptr self, int i) -> long"""
        return _digital_swig2.protocol_formatter_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(protocol_formatter_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(protocol_formatter_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.protocol_formatter_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(protocol_formatter_bb_sptr self, int which) -> float
        pc_input_buffers_full(protocol_formatter_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(protocol_formatter_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(protocol_formatter_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(protocol_formatter_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(protocol_formatter_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(protocol_formatter_bb_sptr self, int which) -> float
        pc_output_buffers_full(protocol_formatter_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(protocol_formatter_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(protocol_formatter_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(protocol_formatter_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(protocol_formatter_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_formatter_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(protocol_formatter_bb_sptr self) -> float"""
        return _digital_swig2.protocol_formatter_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(protocol_formatter_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(protocol_formatter_bb_sptr self)"""
        return _digital_swig2.protocol_formatter_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(protocol_formatter_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.protocol_formatter_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(protocol_formatter_bb_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(protocol_formatter_bb_sptr self) -> int"""
        return _digital_swig2.protocol_formatter_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(protocol_formatter_bb_sptr self, int priority) -> int"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(protocol_formatter_bb_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(protocol_formatter_bb_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(protocol_formatter_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig2.protocol_formatter_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(protocol_formatter_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig2.protocol_formatter_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(protocol_formatter_bb_sptr self) -> long"""
        return _digital_swig2.protocol_formatter_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(protocol_formatter_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig2.protocol_formatter_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(protocol_formatter_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.protocol_formatter_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(protocol_formatter_bb_sptr self) -> std::string"""
        return _digital_swig2.protocol_formatter_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(protocol_formatter_bb_sptr self, std::string name)"""
        return _digital_swig2.protocol_formatter_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(protocol_formatter_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.protocol_formatter_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(protocol_formatter_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_formatter_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(protocol_formatter_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_formatter_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(protocol_formatter_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_formatter_bb_sptr_message_subscribers(self, which_port)

# Register protocol_formatter_bb_sptr in _digital_swig2:
_digital_swig2.protocol_formatter_bb_sptr_swigregister(protocol_formatter_bb_sptr)

protocol_formatter_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
protocol_formatter_bb = protocol_formatter_bb.make;

class protocol_parser_b_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::protocol_parser_b > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(protocol_parser_b_sptr self) -> protocol_parser_b_sptr
        __init__(protocol_parser_b_sptr self, protocol_parser_b p) -> protocol_parser_b_sptr
        """
        _digital_swig2.protocol_parser_b_sptr_swiginit(self, _digital_swig2.new_protocol_parser_b_sptr(*args))

    def __deref__(self) -> "gr::digital::protocol_parser_b *":
        r"""__deref__(protocol_parser_b_sptr self) -> protocol_parser_b"""
        return _digital_swig2.protocol_parser_b_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_protocol_parser_b_sptr

    def make(self, format: "header_format_base_sptr") -> "gr::digital::protocol_parser_b::sptr":
        r"""
        make(protocol_parser_b_sptr self, header_format_base_sptr format) -> protocol_parser_b_sptr
        Block that synchronizes to a header based on a header format object class. Designed to accept hard bits and produce PDUs with packed bytes (pmt::u8vector).

        A packet synchronizer block. This block takes in hard bits (unpacked bytes; 1's and 0's as the LSB) and finds the access code as a sync word to find the start of a frame.


        The block uses a format object derived from a header_format_base class.


        Once the frame is detected (usually through the use of an access code), the block uses the format object's parser function to decode the remaining header. Generally, as in the default header case, the header will contain the length of the frame's payload. That and anything else in the header will generally go into the PDU's meta-data dictionary.


        The block will output a PDU that contains frame's header info in the meta-data portion of the PDU and the payload itself. The payload is packed hard bits as taken from the input stream.

        Constructor Specific Documentation:

        Make a packet header block using a given .

        Args:
            format : The format object to use when reading the header.
        """
        return _digital_swig2.protocol_parser_b_sptr_make(self, format)

    def history(self) -> "unsigned int":
        r"""history(protocol_parser_b_sptr self) -> unsigned int"""
        return _digital_swig2.protocol_parser_b_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(protocol_parser_b_sptr self, int which, int delay)
        declare_sample_delay(protocol_parser_b_sptr self, unsigned int delay)
        """
        return _digital_swig2.protocol_parser_b_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(protocol_parser_b_sptr self, int which) -> unsigned int"""
        return _digital_swig2.protocol_parser_b_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(protocol_parser_b_sptr self, int multiple)"""
        return _digital_swig2.protocol_parser_b_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(protocol_parser_b_sptr self) -> int"""
        return _digital_swig2.protocol_parser_b_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(protocol_parser_b_sptr self) -> double"""
        return _digital_swig2.protocol_parser_b_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(protocol_parser_b_sptr self) -> uint64_t"""
        return _digital_swig2.protocol_parser_b_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(protocol_parser_b_sptr self) -> uint64_t"""
        return _digital_swig2.protocol_parser_b_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(protocol_parser_b_sptr self) -> bool"""
        return _digital_swig2.protocol_parser_b_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(protocol_parser_b_sptr self) -> bool"""
        return _digital_swig2.protocol_parser_b_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(protocol_parser_b_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.protocol_parser_b_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(protocol_parser_b_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.protocol_parser_b_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(protocol_parser_b_sptr self, std::string level)"""
        return _digital_swig2.protocol_parser_b_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(protocol_parser_b_sptr self) -> std::string"""
        return _digital_swig2.protocol_parser_b_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(protocol_parser_b_sptr self) -> int"""
        return _digital_swig2.protocol_parser_b_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(protocol_parser_b_sptr self, int m)"""
        return _digital_swig2.protocol_parser_b_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(protocol_parser_b_sptr self)"""
        return _digital_swig2.protocol_parser_b_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(protocol_parser_b_sptr self) -> bool"""
        return _digital_swig2.protocol_parser_b_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(protocol_parser_b_sptr self, int m)"""
        return _digital_swig2.protocol_parser_b_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(protocol_parser_b_sptr self) -> int"""
        return _digital_swig2.protocol_parser_b_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(protocol_parser_b_sptr self, int i) -> long"""
        return _digital_swig2.protocol_parser_b_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(protocol_parser_b_sptr self, long max_output_buffer)
        set_max_output_buffer(protocol_parser_b_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.protocol_parser_b_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(protocol_parser_b_sptr self, int i) -> long"""
        return _digital_swig2.protocol_parser_b_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(protocol_parser_b_sptr self, long min_output_buffer)
        set_min_output_buffer(protocol_parser_b_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.protocol_parser_b_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(protocol_parser_b_sptr self, int which) -> float
        pc_input_buffers_full(protocol_parser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_parser_b_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(protocol_parser_b_sptr self, int which) -> float
        pc_input_buffers_full_avg(protocol_parser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_parser_b_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(protocol_parser_b_sptr self, int which) -> float
        pc_input_buffers_full_var(protocol_parser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_parser_b_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(protocol_parser_b_sptr self, int which) -> float
        pc_output_buffers_full(protocol_parser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_parser_b_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(protocol_parser_b_sptr self, int which) -> float
        pc_output_buffers_full_avg(protocol_parser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_parser_b_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(protocol_parser_b_sptr self, int which) -> float
        pc_output_buffers_full_var(protocol_parser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.protocol_parser_b_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(protocol_parser_b_sptr self) -> float"""
        return _digital_swig2.protocol_parser_b_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(protocol_parser_b_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.protocol_parser_b_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(protocol_parser_b_sptr self)"""
        return _digital_swig2.protocol_parser_b_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(protocol_parser_b_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.protocol_parser_b_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(protocol_parser_b_sptr self) -> int"""
        return _digital_swig2.protocol_parser_b_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(protocol_parser_b_sptr self) -> int"""
        return _digital_swig2.protocol_parser_b_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(protocol_parser_b_sptr self, int priority) -> int"""
        return _digital_swig2.protocol_parser_b_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(protocol_parser_b_sptr self) -> std::string"""
        return _digital_swig2.protocol_parser_b_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(protocol_parser_b_sptr self) -> std::string"""
        return _digital_swig2.protocol_parser_b_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(protocol_parser_b_sptr self) -> io_signature_sptr"""
        return _digital_swig2.protocol_parser_b_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(protocol_parser_b_sptr self) -> io_signature_sptr"""
        return _digital_swig2.protocol_parser_b_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(protocol_parser_b_sptr self) -> long"""
        return _digital_swig2.protocol_parser_b_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(protocol_parser_b_sptr self) -> basic_block_sptr"""
        return _digital_swig2.protocol_parser_b_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(protocol_parser_b_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.protocol_parser_b_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(protocol_parser_b_sptr self) -> std::string"""
        return _digital_swig2.protocol_parser_b_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(protocol_parser_b_sptr self, std::string name)"""
        return _digital_swig2.protocol_parser_b_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(protocol_parser_b_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.protocol_parser_b_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(protocol_parser_b_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_parser_b_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(protocol_parser_b_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_parser_b_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(protocol_parser_b_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.protocol_parser_b_sptr_message_subscribers(self, which_port)

# Register protocol_parser_b_sptr in _digital_swig2:
_digital_swig2.protocol_parser_b_sptr_swigregister(protocol_parser_b_sptr)

protocol_parser_b_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
protocol_parser_b = protocol_parser_b.make;

class packet_headergenerator_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::packet_headergenerator_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(packet_headergenerator_bb_sptr self) -> packet_headergenerator_bb_sptr
        __init__(packet_headergenerator_bb_sptr self, packet_headergenerator_bb p) -> packet_headergenerator_bb_sptr
        """
        _digital_swig2.packet_headergenerator_bb_sptr_swiginit(self, _digital_swig2.new_packet_headergenerator_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::packet_headergenerator_bb *":
        r"""__deref__(packet_headergenerator_bb_sptr self) -> packet_headergenerator_bb"""
        return _digital_swig2.packet_headergenerator_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_packet_headergenerator_bb_sptr

    def make(self, *args) -> "gr::digital::packet_headergenerator_bb::sptr":
        r"""
        make(packet_headergenerator_bb_sptr self, packet_header_default_sptr header_formatter, std::string const & len_tag_key="packet_len") -> packet_headergenerator_bb_sptr
        make(packet_headergenerator_bb_sptr self, long header_len, std::string const & len_tag_key="packet_len") -> packet_headergenerator_bb_sptr
        Generates a header for a tagged, streamed packet.

        Input: A tagged stream. This is consumed entirely, it is not appended to the output stream. Output: An tagged stream containing the header. The details on the header are set in a header formatter object (of type packet_header_default or a subclass thereof). If only a number of bits is specified, a default header is generated (see packet_header_default).

        Constructor Specific Documentation:



        Args:
            header_formatter : 
            len_tag_key : 
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_make(self, *args)

    def set_header_formatter(self, header_formatter: "packet_header_default_sptr") -> "void":
        r"""set_header_formatter(packet_headergenerator_bb_sptr self, packet_header_default_sptr header_formatter)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_header_formatter(self, header_formatter)

    def history(self) -> "unsigned int":
        r"""history(packet_headergenerator_bb_sptr self) -> unsigned int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(packet_headergenerator_bb_sptr self, int which, int delay)
        declare_sample_delay(packet_headergenerator_bb_sptr self, unsigned int delay)
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(packet_headergenerator_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(packet_headergenerator_bb_sptr self, int multiple)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(packet_headergenerator_bb_sptr self) -> int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(packet_headergenerator_bb_sptr self) -> double"""
        return _digital_swig2.packet_headergenerator_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(packet_headergenerator_bb_sptr self) -> uint64_t"""
        return _digital_swig2.packet_headergenerator_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(packet_headergenerator_bb_sptr self) -> uint64_t"""
        return _digital_swig2.packet_headergenerator_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(packet_headergenerator_bb_sptr self) -> bool"""
        return _digital_swig2.packet_headergenerator_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(packet_headergenerator_bb_sptr self) -> bool"""
        return _digital_swig2.packet_headergenerator_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(packet_headergenerator_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.packet_headergenerator_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(packet_headergenerator_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.packet_headergenerator_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(packet_headergenerator_bb_sptr self, std::string level)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(packet_headergenerator_bb_sptr self) -> std::string"""
        return _digital_swig2.packet_headergenerator_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(packet_headergenerator_bb_sptr self) -> int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(packet_headergenerator_bb_sptr self, int m)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(packet_headergenerator_bb_sptr self)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(packet_headergenerator_bb_sptr self) -> bool"""
        return _digital_swig2.packet_headergenerator_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(packet_headergenerator_bb_sptr self, int m)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(packet_headergenerator_bb_sptr self) -> int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(packet_headergenerator_bb_sptr self, int i) -> long"""
        return _digital_swig2.packet_headergenerator_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(packet_headergenerator_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(packet_headergenerator_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(packet_headergenerator_bb_sptr self, int i) -> long"""
        return _digital_swig2.packet_headergenerator_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(packet_headergenerator_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(packet_headergenerator_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(packet_headergenerator_bb_sptr self, int which) -> float
        pc_input_buffers_full(packet_headergenerator_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(packet_headergenerator_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(packet_headergenerator_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(packet_headergenerator_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(packet_headergenerator_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(packet_headergenerator_bb_sptr self, int which) -> float
        pc_output_buffers_full(packet_headergenerator_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(packet_headergenerator_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(packet_headergenerator_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(packet_headergenerator_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(packet_headergenerator_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(packet_headergenerator_bb_sptr self) -> float"""
        return _digital_swig2.packet_headergenerator_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(packet_headergenerator_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(packet_headergenerator_bb_sptr self)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(packet_headergenerator_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.packet_headergenerator_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(packet_headergenerator_bb_sptr self) -> int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(packet_headergenerator_bb_sptr self) -> int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(packet_headergenerator_bb_sptr self, int priority) -> int"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(packet_headergenerator_bb_sptr self) -> std::string"""
        return _digital_swig2.packet_headergenerator_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(packet_headergenerator_bb_sptr self) -> std::string"""
        return _digital_swig2.packet_headergenerator_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(packet_headergenerator_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig2.packet_headergenerator_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(packet_headergenerator_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig2.packet_headergenerator_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(packet_headergenerator_bb_sptr self) -> long"""
        return _digital_swig2.packet_headergenerator_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(packet_headergenerator_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig2.packet_headergenerator_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(packet_headergenerator_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.packet_headergenerator_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(packet_headergenerator_bb_sptr self) -> std::string"""
        return _digital_swig2.packet_headergenerator_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(packet_headergenerator_bb_sptr self, std::string name)"""
        return _digital_swig2.packet_headergenerator_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(packet_headergenerator_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.packet_headergenerator_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(packet_headergenerator_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_headergenerator_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(packet_headergenerator_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_headergenerator_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(packet_headergenerator_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.packet_headergenerator_bb_sptr_message_subscribers(self, which_port)

# Register packet_headergenerator_bb_sptr in _digital_swig2:
_digital_swig2.packet_headergenerator_bb_sptr_swigregister(packet_headergenerator_bb_sptr)

packet_headergenerator_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
packet_headergenerator_bb = packet_headergenerator_bb.make;

class packet_headerparser_b_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::packet_headerparser_b > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(packet_headerparser_b_sptr self) -> packet_headerparser_b_sptr
        __init__(packet_headerparser_b_sptr self, packet_headerparser_b p) -> packet_headerparser_b_sptr
        """
        _digital_swig2.packet_headerparser_b_sptr_swiginit(self, _digital_swig2.new_packet_headerparser_b_sptr(*args))

    def __deref__(self) -> "gr::digital::packet_headerparser_b *":
        r"""__deref__(packet_headerparser_b_sptr self) -> packet_headerparser_b"""
        return _digital_swig2.packet_headerparser_b_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_packet_headerparser_b_sptr

    def make(self, *args) -> "gr::digital::packet_headerparser_b::sptr":
        r"""
        make(packet_headerparser_b_sptr self, packet_header_default_sptr header_formatter) -> packet_headerparser_b_sptr
        make(packet_headerparser_b_sptr self, long header_len, std::string const & len_tag_key) -> packet_headerparser_b_sptr
        Post header metadata as a PMT.

        In a sense, this is the inverse block to packet_headergenerator_bb. The difference is, the parsed header is not output as a stream, but as a PMT dictionary, which is published to message port with the id "header_data".


        The dictionary consists of the tags created by the header formatter object. You should be able to use the exact same formatter object as used on the Tx side in the packet_headergenerator_bb.


        If only a header length is given, this block uses the default header format.

        Constructor Specific Documentation:



        Args:
            header_formatter : Header object. This should be the same as used for packet_headergenerator_bb.
        """
        return _digital_swig2.packet_headerparser_b_sptr_make(self, *args)

    def history(self) -> "unsigned int":
        r"""history(packet_headerparser_b_sptr self) -> unsigned int"""
        return _digital_swig2.packet_headerparser_b_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(packet_headerparser_b_sptr self, int which, int delay)
        declare_sample_delay(packet_headerparser_b_sptr self, unsigned int delay)
        """
        return _digital_swig2.packet_headerparser_b_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(packet_headerparser_b_sptr self, int which) -> unsigned int"""
        return _digital_swig2.packet_headerparser_b_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(packet_headerparser_b_sptr self, int multiple)"""
        return _digital_swig2.packet_headerparser_b_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(packet_headerparser_b_sptr self) -> int"""
        return _digital_swig2.packet_headerparser_b_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(packet_headerparser_b_sptr self) -> double"""
        return _digital_swig2.packet_headerparser_b_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(packet_headerparser_b_sptr self) -> uint64_t"""
        return _digital_swig2.packet_headerparser_b_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(packet_headerparser_b_sptr self) -> uint64_t"""
        return _digital_swig2.packet_headerparser_b_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(packet_headerparser_b_sptr self) -> bool"""
        return _digital_swig2.packet_headerparser_b_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(packet_headerparser_b_sptr self) -> bool"""
        return _digital_swig2.packet_headerparser_b_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(packet_headerparser_b_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.packet_headerparser_b_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(packet_headerparser_b_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.packet_headerparser_b_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(packet_headerparser_b_sptr self, std::string level)"""
        return _digital_swig2.packet_headerparser_b_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(packet_headerparser_b_sptr self) -> std::string"""
        return _digital_swig2.packet_headerparser_b_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(packet_headerparser_b_sptr self) -> int"""
        return _digital_swig2.packet_headerparser_b_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(packet_headerparser_b_sptr self, int m)"""
        return _digital_swig2.packet_headerparser_b_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(packet_headerparser_b_sptr self)"""
        return _digital_swig2.packet_headerparser_b_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(packet_headerparser_b_sptr self) -> bool"""
        return _digital_swig2.packet_headerparser_b_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(packet_headerparser_b_sptr self, int m)"""
        return _digital_swig2.packet_headerparser_b_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(packet_headerparser_b_sptr self) -> int"""
        return _digital_swig2.packet_headerparser_b_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(packet_headerparser_b_sptr self, int i) -> long"""
        return _digital_swig2.packet_headerparser_b_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(packet_headerparser_b_sptr self, long max_output_buffer)
        set_max_output_buffer(packet_headerparser_b_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.packet_headerparser_b_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(packet_headerparser_b_sptr self, int i) -> long"""
        return _digital_swig2.packet_headerparser_b_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(packet_headerparser_b_sptr self, long min_output_buffer)
        set_min_output_buffer(packet_headerparser_b_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.packet_headerparser_b_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(packet_headerparser_b_sptr self, int which) -> float
        pc_input_buffers_full(packet_headerparser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headerparser_b_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(packet_headerparser_b_sptr self, int which) -> float
        pc_input_buffers_full_avg(packet_headerparser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headerparser_b_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(packet_headerparser_b_sptr self, int which) -> float
        pc_input_buffers_full_var(packet_headerparser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headerparser_b_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(packet_headerparser_b_sptr self, int which) -> float
        pc_output_buffers_full(packet_headerparser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headerparser_b_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(packet_headerparser_b_sptr self, int which) -> float
        pc_output_buffers_full_avg(packet_headerparser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headerparser_b_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(packet_headerparser_b_sptr self, int which) -> float
        pc_output_buffers_full_var(packet_headerparser_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_headerparser_b_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(packet_headerparser_b_sptr self) -> float"""
        return _digital_swig2.packet_headerparser_b_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(packet_headerparser_b_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.packet_headerparser_b_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(packet_headerparser_b_sptr self)"""
        return _digital_swig2.packet_headerparser_b_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(packet_headerparser_b_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.packet_headerparser_b_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(packet_headerparser_b_sptr self) -> int"""
        return _digital_swig2.packet_headerparser_b_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(packet_headerparser_b_sptr self) -> int"""
        return _digital_swig2.packet_headerparser_b_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(packet_headerparser_b_sptr self, int priority) -> int"""
        return _digital_swig2.packet_headerparser_b_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(packet_headerparser_b_sptr self) -> std::string"""
        return _digital_swig2.packet_headerparser_b_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(packet_headerparser_b_sptr self) -> std::string"""
        return _digital_swig2.packet_headerparser_b_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(packet_headerparser_b_sptr self) -> io_signature_sptr"""
        return _digital_swig2.packet_headerparser_b_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(packet_headerparser_b_sptr self) -> io_signature_sptr"""
        return _digital_swig2.packet_headerparser_b_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(packet_headerparser_b_sptr self) -> long"""
        return _digital_swig2.packet_headerparser_b_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(packet_headerparser_b_sptr self) -> basic_block_sptr"""
        return _digital_swig2.packet_headerparser_b_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(packet_headerparser_b_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.packet_headerparser_b_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(packet_headerparser_b_sptr self) -> std::string"""
        return _digital_swig2.packet_headerparser_b_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(packet_headerparser_b_sptr self, std::string name)"""
        return _digital_swig2.packet_headerparser_b_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(packet_headerparser_b_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.packet_headerparser_b_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(packet_headerparser_b_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_headerparser_b_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(packet_headerparser_b_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_headerparser_b_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(packet_headerparser_b_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.packet_headerparser_b_sptr_message_subscribers(self, which_port)

# Register packet_headerparser_b_sptr in _digital_swig2:
_digital_swig2.packet_headerparser_b_sptr_swigregister(packet_headerparser_b_sptr)

packet_headerparser_b_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
packet_headerparser_b = packet_headerparser_b.make;

class packet_sink_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::packet_sink > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(packet_sink_sptr self) -> packet_sink_sptr
        __init__(packet_sink_sptr self, packet_sink p) -> packet_sink_sptr
        """
        _digital_swig2.packet_sink_sptr_swiginit(self, _digital_swig2.new_packet_sink_sptr(*args))

    def __deref__(self) -> "gr::digital::packet_sink *":
        r"""__deref__(packet_sink_sptr self) -> packet_sink"""
        return _digital_swig2.packet_sink_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_packet_sink_sptr

    def make(self, sync_vector: "std::vector< unsigned char,std::allocator< unsigned char > > const &", target_queue: "msg_queue_sptr", threshold: "int"=-1) -> "gr::digital::packet_sink::sptr":
        r"""
        make(packet_sink_sptr self, std::vector< unsigned char,std::allocator< unsigned char > > const & sync_vector, msg_queue_sptr target_queue, int threshold=-1) -> packet_sink_sptr
        process received bits looking for packet sync, header, and process bits into packet

        input: stream of symbols to be sliced.


        output: none. Pushes assembled packet into target queue


        The packet sink takes in a stream of binary symbols that are sliced around 0. The bits are then checked for the  to determine find and decode the packet. It then expects a fixed length header of 2 16-bit shorts containing the payload length, followed by the payload. If the 2 16-bit shorts are not identical, this packet is ignored. Better algs are welcome.


        This block is not very useful anymore as it only works with 2-level modulations such as BPSK or GMSK. The block can generally be replaced with a correlate access code and frame sink blocks.

        Constructor Specific Documentation:

        Make a packet_sink block.

        Args:
            sync_vector : The synchronization vector as a vector of 1's and 0's.
            target_queue : The message queue that packets are sent to.
            threshold : Number of bits that can be incorrect in the .
        """
        return _digital_swig2.packet_sink_sptr_make(self, sync_vector, target_queue, threshold)

    def carrier_sensed(self) -> "bool":
        r"""
        carrier_sensed(packet_sink_sptr self) -> bool
        return true if we detect carrier
        """
        return _digital_swig2.packet_sink_sptr_carrier_sensed(self)

    def history(self) -> "unsigned int":
        r"""history(packet_sink_sptr self) -> unsigned int"""
        return _digital_swig2.packet_sink_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(packet_sink_sptr self, int which, int delay)
        declare_sample_delay(packet_sink_sptr self, unsigned int delay)
        """
        return _digital_swig2.packet_sink_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(packet_sink_sptr self, int which) -> unsigned int"""
        return _digital_swig2.packet_sink_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(packet_sink_sptr self, int multiple)"""
        return _digital_swig2.packet_sink_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(packet_sink_sptr self) -> int"""
        return _digital_swig2.packet_sink_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(packet_sink_sptr self) -> double"""
        return _digital_swig2.packet_sink_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(packet_sink_sptr self) -> uint64_t"""
        return _digital_swig2.packet_sink_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(packet_sink_sptr self) -> uint64_t"""
        return _digital_swig2.packet_sink_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(packet_sink_sptr self) -> bool"""
        return _digital_swig2.packet_sink_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(packet_sink_sptr self) -> bool"""
        return _digital_swig2.packet_sink_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(packet_sink_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.packet_sink_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(packet_sink_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.packet_sink_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(packet_sink_sptr self, std::string level)"""
        return _digital_swig2.packet_sink_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(packet_sink_sptr self) -> std::string"""
        return _digital_swig2.packet_sink_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(packet_sink_sptr self) -> int"""
        return _digital_swig2.packet_sink_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(packet_sink_sptr self, int m)"""
        return _digital_swig2.packet_sink_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(packet_sink_sptr self)"""
        return _digital_swig2.packet_sink_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(packet_sink_sptr self) -> bool"""
        return _digital_swig2.packet_sink_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(packet_sink_sptr self, int m)"""
        return _digital_swig2.packet_sink_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(packet_sink_sptr self) -> int"""
        return _digital_swig2.packet_sink_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(packet_sink_sptr self, int i) -> long"""
        return _digital_swig2.packet_sink_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(packet_sink_sptr self, long max_output_buffer)
        set_max_output_buffer(packet_sink_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.packet_sink_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(packet_sink_sptr self, int i) -> long"""
        return _digital_swig2.packet_sink_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(packet_sink_sptr self, long min_output_buffer)
        set_min_output_buffer(packet_sink_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.packet_sink_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(packet_sink_sptr self, int which) -> float
        pc_input_buffers_full(packet_sink_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_sink_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(packet_sink_sptr self, int which) -> float
        pc_input_buffers_full_avg(packet_sink_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_sink_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(packet_sink_sptr self, int which) -> float
        pc_input_buffers_full_var(packet_sink_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_sink_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(packet_sink_sptr self, int which) -> float
        pc_output_buffers_full(packet_sink_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_sink_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(packet_sink_sptr self, int which) -> float
        pc_output_buffers_full_avg(packet_sink_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_sink_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(packet_sink_sptr self, int which) -> float
        pc_output_buffers_full_var(packet_sink_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.packet_sink_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(packet_sink_sptr self) -> float"""
        return _digital_swig2.packet_sink_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(packet_sink_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.packet_sink_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(packet_sink_sptr self)"""
        return _digital_swig2.packet_sink_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(packet_sink_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.packet_sink_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(packet_sink_sptr self) -> int"""
        return _digital_swig2.packet_sink_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(packet_sink_sptr self) -> int"""
        return _digital_swig2.packet_sink_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(packet_sink_sptr self, int priority) -> int"""
        return _digital_swig2.packet_sink_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(packet_sink_sptr self) -> std::string"""
        return _digital_swig2.packet_sink_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(packet_sink_sptr self) -> std::string"""
        return _digital_swig2.packet_sink_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(packet_sink_sptr self) -> io_signature_sptr"""
        return _digital_swig2.packet_sink_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(packet_sink_sptr self) -> io_signature_sptr"""
        return _digital_swig2.packet_sink_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(packet_sink_sptr self) -> long"""
        return _digital_swig2.packet_sink_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(packet_sink_sptr self) -> basic_block_sptr"""
        return _digital_swig2.packet_sink_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(packet_sink_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.packet_sink_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(packet_sink_sptr self) -> std::string"""
        return _digital_swig2.packet_sink_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(packet_sink_sptr self, std::string name)"""
        return _digital_swig2.packet_sink_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(packet_sink_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.packet_sink_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(packet_sink_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_sink_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(packet_sink_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_sink_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(packet_sink_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.packet_sink_sptr_message_subscribers(self, which_port)

# Register packet_sink_sptr in _digital_swig2:
_digital_swig2.packet_sink_sptr_swigregister(packet_sink_sptr)

packet_sink_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
packet_sink = packet_sink.make;

class pfb_clock_sync_ccf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::pfb_clock_sync_ccf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_clock_sync_ccf_sptr self) -> pfb_clock_sync_ccf_sptr
        __init__(pfb_clock_sync_ccf_sptr self, pfb_clock_sync_ccf p) -> pfb_clock_sync_ccf_sptr
        """
        _digital_swig2.pfb_clock_sync_ccf_sptr_swiginit(self, _digital_swig2.new_pfb_clock_sync_ccf_sptr(*args))

    def __deref__(self) -> "gr::digital::pfb_clock_sync_ccf *":
        r"""__deref__(pfb_clock_sync_ccf_sptr self) -> pfb_clock_sync_ccf"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_pfb_clock_sync_ccf_sptr

    def make(self, sps: "double", loop_bw: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32, init_phase: "float"=0, max_rate_deviation: "float"=1.5, osps: "int"=1) -> "gr::digital::pfb_clock_sync_ccf::sptr":
        r"""
        make(pfb_clock_sync_ccf_sptr self, double sps, float loop_bw, pmt_vector_float taps, unsigned int filter_size=32, float init_phase=0, float max_rate_deviation=1.5, int osps=1) -> pfb_clock_sync_ccf_sptr
        Timing synchronizer using polyphase filterbanks.

        This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


        This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


        If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


        The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for "gain," which is d_alpha while d_beta is equal to (gain^2)/4.


        The block's parameters are:









        Reference: f. j. harris and M. Rice, "Multirate Digital Filters for Symbol
        Timing Synchronization in Software Defined Radios", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

        Constructor Specific Documentation:

        Build the polyphase filterbank timing synchronizer.

        Args:
            sps : (double) The number of samples per symbol in the incoming signal
            loop_bw : (float) The bandwidth of the control loop; set's alpha and beta.
            taps : (vector<int>) The filter taps.
            filter_size : (uint) The number of filters in the filterbank (default = 32).
            init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
            max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
            osps : (int) The number of output samples per symbol (default=1).
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_make(self, sps, loop_bw, taps, filter_size, init_phase, max_rate_deviation, osps)

    def update_gains(self) -> "void":
        r"""
        update_gains(pfb_clock_sync_ccf_sptr self)
        update the system gains from omega and eta

        This function updates the system gains based on the loop bandwidth and damping factor of the system. These two factors can be set separately through their own set functions.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_update_gains(self)

    def update_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        update_taps(pfb_clock_sync_ccf_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_update_taps(self, taps)

    def set_taps(self, taps: "pmt_vector_float", ourtaps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > &", ourfilter: "std::vector< gr::filter::kernel::fir_filter_ccf *,std::allocator< gr::filter::kernel::fir_filter_ccf * > > &") -> "void":
        r"""
        set_taps(pfb_clock_sync_ccf_sptr self, pmt_vector_float taps, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > & ourtaps, std::vector< gr::filter::kernel::fir_filter_ccf *,std::allocator< gr::filter::kernel::fir_filter_ccf * > > & ourfilter)
        Used to set the taps of the filters in the filterbank and differential filterbank.


        WARNING: this should not be used externally and will be moved to a private function in the next API.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_taps(self, taps, ourtaps, ourfilter)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_clock_sync_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the matched filter
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_taps(self)

    def diff_taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        diff_taps(pfb_clock_sync_ccf_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the derivative filter
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_diff_taps(self)

    def channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        channel_taps(pfb_clock_sync_ccf_sptr self, int channel) -> pmt_vector_float
        Returns the taps of the matched filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_channel_taps(self, channel)

    def diff_channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        diff_channel_taps(pfb_clock_sync_ccf_sptr self, int channel) -> pmt_vector_float
        Returns the taps in the derivative filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_diff_channel_taps(self, channel)

    def taps_as_string(self) -> "std::string":
        r"""
        taps_as_string(pfb_clock_sync_ccf_sptr self) -> std::string
        Return the taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_taps_as_string(self)

    def diff_taps_as_string(self) -> "std::string":
        r"""
        diff_taps_as_string(pfb_clock_sync_ccf_sptr self) -> std::string
        Return the derivative filter taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_diff_taps_as_string(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""
        set_loop_bandwidth(pfb_clock_sync_ccf_sptr self, float bw)
        Set the loop bandwidth.

        Set the loop filter's bandwidth to . This should be between 2*pi/200 and 2*pi/100 (in rads/samp). It must also be a positive number.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""
        set_damping_factor(pfb_clock_sync_ccf_sptr self, float df)
        Set the loop damping factor.

        Set the loop filter's damping factor to . The damping factor should be sqrt(2)/2.0 for critically damped systems. Set it to anything else only if you know what you are doing. It must be a number between 0 and 1.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(pfb_clock_sync_ccf_sptr self, float alpha)
        Set the loop gain alpha.

        Set's the loop filter's alpha gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(pfb_clock_sync_ccf_sptr self, float beta)
        Set the loop gain beta.

        Set's the loop filter's beta gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_beta(self, beta)

    def set_max_rate_deviation(self, m: "float") -> "void":
        r"""
        set_max_rate_deviation(pfb_clock_sync_ccf_sptr self, float m)
        Set the maximum deviation from 0 d_rate can have
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_max_rate_deviation(self, m)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(pfb_clock_sync_ccf_sptr self) -> float
        Returns the loop bandwidth.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(pfb_clock_sync_ccf_sptr self) -> float
        Returns the loop damping factor.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_damping_factor(self)

    def alpha(self) -> "float":
        r"""
        alpha(pfb_clock_sync_ccf_sptr self) -> float
        Returns the loop gain alpha.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(pfb_clock_sync_ccf_sptr self) -> float
        Returns the loop gain beta.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_beta(self)

    def clock_rate(self) -> "float":
        r"""
        clock_rate(pfb_clock_sync_ccf_sptr self) -> float
        Returns the current clock rate.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_clock_rate(self)

    def error(self) -> "float":
        r"""
        error(pfb_clock_sync_ccf_sptr self) -> float
        Returns the current error of the control loop.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_error(self)

    def rate(self) -> "float":
        r"""
        rate(pfb_clock_sync_ccf_sptr self) -> float
        Returns the current rate of the control loop.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_rate(self)

    def phase(self) -> "float":
        r"""
        phase(pfb_clock_sync_ccf_sptr self) -> float
        Returns the current phase arm of the control loop.
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_phase(self)

    def history(self) -> "unsigned int":
        r"""history(pfb_clock_sync_ccf_sptr self) -> unsigned int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_clock_sync_ccf_sptr self, int which, int delay)
        declare_sample_delay(pfb_clock_sync_ccf_sptr self, unsigned int delay)
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_clock_sync_ccf_sptr self, int which) -> unsigned int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_clock_sync_ccf_sptr self, int multiple)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_clock_sync_ccf_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_clock_sync_ccf_sptr self) -> double"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_clock_sync_ccf_sptr self) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_clock_sync_ccf_sptr self) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_clock_sync_ccf_sptr self) -> bool"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_clock_sync_ccf_sptr self) -> bool"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_clock_sync_ccf_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_clock_sync_ccf_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_clock_sync_ccf_sptr self, std::string level)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_clock_sync_ccf_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_clock_sync_ccf_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_clock_sync_ccf_sptr self, int m)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_clock_sync_ccf_sptr self)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_clock_sync_ccf_sptr self) -> bool"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_clock_sync_ccf_sptr self, int m)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_clock_sync_ccf_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_clock_sync_ccf_sptr self, int i) -> long"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_clock_sync_ccf_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_clock_sync_ccf_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_clock_sync_ccf_sptr self, int i) -> long"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_clock_sync_ccf_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_clock_sync_ccf_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_clock_sync_ccf_sptr self, int which) -> float
        pc_input_buffers_full(pfb_clock_sync_ccf_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_clock_sync_ccf_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_clock_sync_ccf_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_clock_sync_ccf_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_clock_sync_ccf_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_clock_sync_ccf_sptr self, int which) -> float
        pc_output_buffers_full(pfb_clock_sync_ccf_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_clock_sync_ccf_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_clock_sync_ccf_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_clock_sync_ccf_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_clock_sync_ccf_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_clock_sync_ccf_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_clock_sync_ccf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_clock_sync_ccf_sptr self)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_clock_sync_ccf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_clock_sync_ccf_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_clock_sync_ccf_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_clock_sync_ccf_sptr self, int priority) -> int"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_clock_sync_ccf_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_clock_sync_ccf_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_clock_sync_ccf_sptr self) -> io_signature_sptr"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_clock_sync_ccf_sptr self) -> io_signature_sptr"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_clock_sync_ccf_sptr self) -> long"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_clock_sync_ccf_sptr self) -> basic_block_sptr"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_clock_sync_ccf_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_clock_sync_ccf_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_clock_sync_ccf_sptr self, std::string name)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_clock_sync_ccf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_clock_sync_ccf_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_clock_sync_ccf_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_clock_sync_ccf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.pfb_clock_sync_ccf_sptr_message_subscribers(self, which_port)

# Register pfb_clock_sync_ccf_sptr in _digital_swig2:
_digital_swig2.pfb_clock_sync_ccf_sptr_swigregister(pfb_clock_sync_ccf_sptr)

pfb_clock_sync_ccf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_clock_sync_ccf = pfb_clock_sync_ccf.make;

class pfb_clock_sync_fff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::pfb_clock_sync_fff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pfb_clock_sync_fff_sptr self) -> pfb_clock_sync_fff_sptr
        __init__(pfb_clock_sync_fff_sptr self, pfb_clock_sync_fff p) -> pfb_clock_sync_fff_sptr
        """
        _digital_swig2.pfb_clock_sync_fff_sptr_swiginit(self, _digital_swig2.new_pfb_clock_sync_fff_sptr(*args))

    def __deref__(self) -> "gr::digital::pfb_clock_sync_fff *":
        r"""__deref__(pfb_clock_sync_fff_sptr self) -> pfb_clock_sync_fff"""
        return _digital_swig2.pfb_clock_sync_fff_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_pfb_clock_sync_fff_sptr

    def make(self, sps: "double", gain: "float", taps: "pmt_vector_float", filter_size: "unsigned int"=32, init_phase: "float"=0, max_rate_deviation: "float"=1.5, osps: "int"=1) -> "gr::digital::pfb_clock_sync_fff::sptr":
        r"""
        make(pfb_clock_sync_fff_sptr self, double sps, float gain, pmt_vector_float taps, unsigned int filter_size=32, float init_phase=0, float max_rate_deviation=1.5, int osps=1) -> pfb_clock_sync_fff_sptr
        Timing synchronizer using polyphase filterbanks.

        This block performs timing synchronization for PAM signals by minimizing the derivative of the filtered signal, which in turn maximizes the SNR and minimizes ISI.


        This approach works by setting up two filterbanks; one filterbank contains the signal's pulse shaping matched filter (such as a root raised cosine filter), where each branch of the filterbank contains a different phase of the filter. The second filterbank contains the derivatives of the filters in the first filterbank. Thinking of this in the time domain, the first filterbank contains filters that have a sinc shape to them. We want to align the output signal to be sampled at exactly the peak of the sinc shape. The derivative of the sinc contains a zero at the maximum point of the sinc (sinc(0) = 1, sinc(0)' = 0). Furthermore, the region around the zero point is relatively linear. We make use of this fact to generate the error signal.


        If the signal out of the derivative filters is d_i[n] for the ith filter, and the output of the matched filter is x_i[n], we calculate the error as: e[n] = (Re{x_i[n]} * Re{d_i[n]} + Im{x_i[n]} * Im{d_i[n]}) / 2.0 This equation averages the error in the real and imaginary parts. There are two reasons we multiply by the signal itself. First, if the symbol could be positive or negative going, but we want the error term to always tell us to go in the same direction depending on which side of the zero point we are on. The sign of x_i[n] adjusts the error term to do this. Second, the magnitude of x_i[n] scales the error term depending on the symbol's amplitude, so larger signals give us a stronger error term because we have more confidence in that symbol's value. Using the magnitude of x_i[n] instead of just the sign is especially good for signals with low SNR.


        The error signal, e[n], gives us a value proportional to how far away from the zero point we are in the derivative signal. We want to drive this value to zero, so we set up a second order loop. We have two variables for this loop; d_k is the filter number in the filterbank we are on and d_rate is the rate which we travel through the filters in the steady state. That is, due to the natural clock differences between the transmitter and receiver, d_rate represents that difference and would traverse the filter phase paths to keep the receiver locked. Thinking of this as a second-order PLL, the d_rate is the frequency and d_k is the phase. So we update d_rate and d_k using the standard loop equations based on two error signals, d_alpha and d_beta. We have these two values set based on each other for a critically damped system, so in the block constructor, we just ask for "gain," which is d_alpha while d_beta is equal to (gain^2)/4.


        The block's parameters are:









        Reference: f. j. harris and M. Rice, "Multirate Digital Filters for Symbol
        Timing Synchronization in Software Defined Radios", IEEE Selected Areas in Communications, Vol. 19, No. 12, Dec., 2001.

        Constructor Specific Documentation:

        Build the polyphase filterbank timing synchronizer.

        Args:
            sps : (double) The number of samples per second in the incoming signal
            gain : (float) The alpha gain of the control loop; beta = (gain^2)/4 by default.
            taps : (vector<int>) The filter taps.
            filter_size : (uint) The number of filters in the filterbank (default = 32).
            init_phase : (float) The initial phase to look at, or which filter to start with (default = 0).
            max_rate_deviation : (float) Distance from 0 d_rate can get (default = 1.5).
            osps : (int) The number of output samples per symbol (default=1).
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_make(self, sps, gain, taps, filter_size, init_phase, max_rate_deviation, osps)

    def update_gains(self) -> "void":
        r"""
        update_gains(pfb_clock_sync_fff_sptr self)
        update the system gains from omega and eta

        This function updates the system gains based on the loop bandwidth and damping factor of the system. These two factors can be set separately through their own set functions.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_update_gains(self)

    def update_taps(self, taps: "pmt_vector_float") -> "void":
        r"""
        update_taps(pfb_clock_sync_fff_sptr self, pmt_vector_float taps)
        Resets the filterbank's filter taps with the new prototype filter.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_update_taps(self, taps)

    def set_taps(self, taps: "pmt_vector_float", ourtaps: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > &", ourfilter: "std::vector< gr::filter::kernel::fir_filter_fff *,std::allocator< gr::filter::kernel::fir_filter_fff * > > &") -> "void":
        r"""
        set_taps(pfb_clock_sync_fff_sptr self, pmt_vector_float taps, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > & ourtaps, std::vector< gr::filter::kernel::fir_filter_fff *,std::allocator< gr::filter::kernel::fir_filter_fff * > > & ourfilter)
        Used to set the taps of the filters in the filterbank and differential filterbank.


        WARNING: this should not be used externally and will be moved to a private function in the next API.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_taps(self, taps, ourtaps, ourfilter)

    def taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        taps(pfb_clock_sync_fff_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the matched filter
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_taps(self)

    def diff_taps(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""
        diff_taps(pfb_clock_sync_fff_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >
        Returns all of the taps of the derivative filter
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_diff_taps(self)

    def channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        channel_taps(pfb_clock_sync_fff_sptr self, int channel) -> pmt_vector_float
        Returns the taps of the matched filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_channel_taps(self, channel)

    def diff_channel_taps(self, channel: "int") -> "std::vector< float,std::allocator< float > >":
        r"""
        diff_channel_taps(pfb_clock_sync_fff_sptr self, int channel) -> pmt_vector_float
        Returns the taps in the derivative filter for a particular channel
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_diff_channel_taps(self, channel)

    def taps_as_string(self) -> "std::string":
        r"""
        taps_as_string(pfb_clock_sync_fff_sptr self) -> std::string
        Return the taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_taps_as_string(self)

    def diff_taps_as_string(self) -> "std::string":
        r"""
        diff_taps_as_string(pfb_clock_sync_fff_sptr self) -> std::string
        Return the derivative filter taps as a formatted string for printing
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_diff_taps_as_string(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""
        set_loop_bandwidth(pfb_clock_sync_fff_sptr self, float bw)
        Set the loop bandwidth.

        Set the loop filter's bandwidth to . This should be between 2*pi/200 and 2*pi/100 (in rads/samp). It must also be a positive number.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""
        set_damping_factor(pfb_clock_sync_fff_sptr self, float df)
        Set the loop damping factor.

        Set the loop filter's damping factor to . The damping factor should be sqrt(2)/2.0 for critically damped systems. Set it to anything else only if you know what you are doing. It must be a number between 0 and 1.


        When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(pfb_clock_sync_fff_sptr self, float alpha)
        Set the loop gain alpha.

        Set's the loop filter's alpha gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(pfb_clock_sync_fff_sptr self, float beta)
        Set the loop gain beta.

        Set's the loop filter's beta gain parameter.


        This value should really only be set by adjusting the loop bandwidth and damping factor.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_beta(self, beta)

    def set_max_rate_deviation(self, m: "float") -> "void":
        r"""
        set_max_rate_deviation(pfb_clock_sync_fff_sptr self, float m)
        Set the maximum deviation from 0 d_rate can have
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_max_rate_deviation(self, m)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(pfb_clock_sync_fff_sptr self) -> float
        Returns the loop bandwidth.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(pfb_clock_sync_fff_sptr self) -> float
        Returns the loop damping factor.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_damping_factor(self)

    def alpha(self) -> "float":
        r"""
        alpha(pfb_clock_sync_fff_sptr self) -> float
        Returns the loop gain alpha.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(pfb_clock_sync_fff_sptr self) -> float
        Returns the loop gain beta.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_beta(self)

    def clock_rate(self) -> "float":
        r"""
        clock_rate(pfb_clock_sync_fff_sptr self) -> float
        Returns the current clock rate.
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_clock_rate(self)

    def history(self) -> "unsigned int":
        r"""history(pfb_clock_sync_fff_sptr self) -> unsigned int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pfb_clock_sync_fff_sptr self, int which, int delay)
        declare_sample_delay(pfb_clock_sync_fff_sptr self, unsigned int delay)
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pfb_clock_sync_fff_sptr self, int which) -> unsigned int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pfb_clock_sync_fff_sptr self, int multiple)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pfb_clock_sync_fff_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pfb_clock_sync_fff_sptr self) -> double"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pfb_clock_sync_fff_sptr self) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pfb_clock_sync_fff_sptr self) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pfb_clock_sync_fff_sptr self) -> bool"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pfb_clock_sync_fff_sptr self) -> bool"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pfb_clock_sync_fff_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pfb_clock_sync_fff_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pfb_clock_sync_fff_sptr self, std::string level)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pfb_clock_sync_fff_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pfb_clock_sync_fff_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pfb_clock_sync_fff_sptr self, int m)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pfb_clock_sync_fff_sptr self)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pfb_clock_sync_fff_sptr self) -> bool"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pfb_clock_sync_fff_sptr self, int m)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pfb_clock_sync_fff_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pfb_clock_sync_fff_sptr self, int i) -> long"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pfb_clock_sync_fff_sptr self, long max_output_buffer)
        set_max_output_buffer(pfb_clock_sync_fff_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pfb_clock_sync_fff_sptr self, int i) -> long"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pfb_clock_sync_fff_sptr self, long min_output_buffer)
        set_min_output_buffer(pfb_clock_sync_fff_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pfb_clock_sync_fff_sptr self, int which) -> float
        pc_input_buffers_full(pfb_clock_sync_fff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pfb_clock_sync_fff_sptr self, int which) -> float
        pc_input_buffers_full_avg(pfb_clock_sync_fff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pfb_clock_sync_fff_sptr self, int which) -> float
        pc_input_buffers_full_var(pfb_clock_sync_fff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pfb_clock_sync_fff_sptr self, int which) -> float
        pc_output_buffers_full(pfb_clock_sync_fff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pfb_clock_sync_fff_sptr self, int which) -> float
        pc_output_buffers_full_avg(pfb_clock_sync_fff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pfb_clock_sync_fff_sptr self, int which) -> float
        pc_output_buffers_full_var(pfb_clock_sync_fff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pfb_clock_sync_fff_sptr self) -> float"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pfb_clock_sync_fff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pfb_clock_sync_fff_sptr self)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pfb_clock_sync_fff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pfb_clock_sync_fff_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pfb_clock_sync_fff_sptr self) -> int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pfb_clock_sync_fff_sptr self, int priority) -> int"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pfb_clock_sync_fff_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pfb_clock_sync_fff_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pfb_clock_sync_fff_sptr self) -> io_signature_sptr"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pfb_clock_sync_fff_sptr self) -> io_signature_sptr"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pfb_clock_sync_fff_sptr self) -> long"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pfb_clock_sync_fff_sptr self) -> basic_block_sptr"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pfb_clock_sync_fff_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pfb_clock_sync_fff_sptr self) -> std::string"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pfb_clock_sync_fff_sptr self, std::string name)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pfb_clock_sync_fff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.pfb_clock_sync_fff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pfb_clock_sync_fff_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pfb_clock_sync_fff_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pfb_clock_sync_fff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.pfb_clock_sync_fff_sptr_message_subscribers(self, which_port)

# Register pfb_clock_sync_fff_sptr in _digital_swig2:
_digital_swig2.pfb_clock_sync_fff_sptr_swigregister(pfb_clock_sync_fff_sptr)

pfb_clock_sync_fff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pfb_clock_sync_fff = pfb_clock_sync_fff.make;

class pn_correlator_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::pn_correlator_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(pn_correlator_cc_sptr self) -> pn_correlator_cc_sptr
        __init__(pn_correlator_cc_sptr self, pn_correlator_cc p) -> pn_correlator_cc_sptr
        """
        _digital_swig2.pn_correlator_cc_sptr_swiginit(self, _digital_swig2.new_pn_correlator_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::pn_correlator_cc *":
        r"""__deref__(pn_correlator_cc_sptr self) -> pn_correlator_cc"""
        return _digital_swig2.pn_correlator_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_pn_correlator_cc_sptr

    def make(self, degree: "int", mask: "int"=0, seed: "int"=1) -> "gr::digital::pn_correlator_cc::sptr":
        r"""
        make(pn_correlator_cc_sptr self, int degree, int mask=0, int seed=1) -> pn_correlator_cc_sptr
        PN code sequential search correlator.

        Receives complex baseband signal, outputs complex correlation against reference PN code, one sample per PN code period. The PN sequence is generated using a GLFSR.

        Constructor Specific Documentation:

        Make PN code sequential search correlator block.

        Args:
            degree : Degree of shift register must be in [1, 32]. If mask is 0, the degree determines a default mask (see digital_impl_glfsr.cc for the mapping).
            mask : Allows a user-defined bit mask for indexes of the shift register to feed back.
            seed : Initial setting for values in shift register.
        """
        return _digital_swig2.pn_correlator_cc_sptr_make(self, degree, mask, seed)

    def history(self) -> "unsigned int":
        r"""history(pn_correlator_cc_sptr self) -> unsigned int"""
        return _digital_swig2.pn_correlator_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(pn_correlator_cc_sptr self, int which, int delay)
        declare_sample_delay(pn_correlator_cc_sptr self, unsigned int delay)
        """
        return _digital_swig2.pn_correlator_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(pn_correlator_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig2.pn_correlator_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(pn_correlator_cc_sptr self, int multiple)"""
        return _digital_swig2.pn_correlator_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(pn_correlator_cc_sptr self) -> int"""
        return _digital_swig2.pn_correlator_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(pn_correlator_cc_sptr self) -> double"""
        return _digital_swig2.pn_correlator_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(pn_correlator_cc_sptr self) -> uint64_t"""
        return _digital_swig2.pn_correlator_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(pn_correlator_cc_sptr self) -> uint64_t"""
        return _digital_swig2.pn_correlator_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(pn_correlator_cc_sptr self) -> bool"""
        return _digital_swig2.pn_correlator_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(pn_correlator_cc_sptr self) -> bool"""
        return _digital_swig2.pn_correlator_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(pn_correlator_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.pn_correlator_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(pn_correlator_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.pn_correlator_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(pn_correlator_cc_sptr self, std::string level)"""
        return _digital_swig2.pn_correlator_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(pn_correlator_cc_sptr self) -> std::string"""
        return _digital_swig2.pn_correlator_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(pn_correlator_cc_sptr self) -> int"""
        return _digital_swig2.pn_correlator_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(pn_correlator_cc_sptr self, int m)"""
        return _digital_swig2.pn_correlator_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(pn_correlator_cc_sptr self)"""
        return _digital_swig2.pn_correlator_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(pn_correlator_cc_sptr self) -> bool"""
        return _digital_swig2.pn_correlator_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(pn_correlator_cc_sptr self, int m)"""
        return _digital_swig2.pn_correlator_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(pn_correlator_cc_sptr self) -> int"""
        return _digital_swig2.pn_correlator_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(pn_correlator_cc_sptr self, int i) -> long"""
        return _digital_swig2.pn_correlator_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(pn_correlator_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(pn_correlator_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.pn_correlator_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(pn_correlator_cc_sptr self, int i) -> long"""
        return _digital_swig2.pn_correlator_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(pn_correlator_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(pn_correlator_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.pn_correlator_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(pn_correlator_cc_sptr self, int which) -> float
        pc_input_buffers_full(pn_correlator_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pn_correlator_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(pn_correlator_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(pn_correlator_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pn_correlator_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(pn_correlator_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(pn_correlator_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pn_correlator_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(pn_correlator_cc_sptr self, int which) -> float
        pc_output_buffers_full(pn_correlator_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pn_correlator_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(pn_correlator_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(pn_correlator_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pn_correlator_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(pn_correlator_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(pn_correlator_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.pn_correlator_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(pn_correlator_cc_sptr self) -> float"""
        return _digital_swig2.pn_correlator_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(pn_correlator_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.pn_correlator_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(pn_correlator_cc_sptr self)"""
        return _digital_swig2.pn_correlator_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(pn_correlator_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.pn_correlator_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(pn_correlator_cc_sptr self) -> int"""
        return _digital_swig2.pn_correlator_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(pn_correlator_cc_sptr self) -> int"""
        return _digital_swig2.pn_correlator_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(pn_correlator_cc_sptr self, int priority) -> int"""
        return _digital_swig2.pn_correlator_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(pn_correlator_cc_sptr self) -> std::string"""
        return _digital_swig2.pn_correlator_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(pn_correlator_cc_sptr self) -> std::string"""
        return _digital_swig2.pn_correlator_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(pn_correlator_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig2.pn_correlator_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(pn_correlator_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig2.pn_correlator_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(pn_correlator_cc_sptr self) -> long"""
        return _digital_swig2.pn_correlator_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(pn_correlator_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig2.pn_correlator_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(pn_correlator_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.pn_correlator_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(pn_correlator_cc_sptr self) -> std::string"""
        return _digital_swig2.pn_correlator_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(pn_correlator_cc_sptr self, std::string name)"""
        return _digital_swig2.pn_correlator_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(pn_correlator_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.pn_correlator_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(pn_correlator_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.pn_correlator_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(pn_correlator_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.pn_correlator_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(pn_correlator_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.pn_correlator_cc_sptr_message_subscribers(self, which_port)

# Register pn_correlator_cc_sptr in _digital_swig2:
_digital_swig2.pn_correlator_cc_sptr_swigregister(pn_correlator_cc_sptr)

pn_correlator_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
pn_correlator_cc = pn_correlator_cc.make;

class probe_density_b_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::probe_density_b > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(probe_density_b_sptr self) -> probe_density_b_sptr
        __init__(probe_density_b_sptr self, probe_density_b p) -> probe_density_b_sptr
        """
        _digital_swig2.probe_density_b_sptr_swiginit(self, _digital_swig2.new_probe_density_b_sptr(*args))

    def __deref__(self) -> "gr::digital::probe_density_b *":
        r"""__deref__(probe_density_b_sptr self) -> probe_density_b"""
        return _digital_swig2.probe_density_b_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_probe_density_b_sptr

    def make(self, alpha: "double") -> "gr::digital::probe_density_b::sptr":
        r"""
        make(probe_density_b_sptr self, double alpha) -> probe_density_b_sptr
        This block maintains a running average of the input stream and makes it available as an accessor function. The input stream is type unsigned char.


        If you send this block a stream of unpacked bytes, it will tell you what the bit density is.

        Constructor Specific Documentation:

        Make a density probe block.

        Args:
            alpha : Average filter constant
        """
        return _digital_swig2.probe_density_b_sptr_make(self, alpha)

    def density(self) -> "double":
        r"""
        density(probe_density_b_sptr self) -> double
        Returns the current density value.
        """
        return _digital_swig2.probe_density_b_sptr_density(self)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(probe_density_b_sptr self, double alpha)
        Set the average filter constant.
        """
        return _digital_swig2.probe_density_b_sptr_set_alpha(self, alpha)

    def history(self) -> "unsigned int":
        r"""history(probe_density_b_sptr self) -> unsigned int"""
        return _digital_swig2.probe_density_b_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(probe_density_b_sptr self, int which, int delay)
        declare_sample_delay(probe_density_b_sptr self, unsigned int delay)
        """
        return _digital_swig2.probe_density_b_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(probe_density_b_sptr self, int which) -> unsigned int"""
        return _digital_swig2.probe_density_b_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(probe_density_b_sptr self, int multiple)"""
        return _digital_swig2.probe_density_b_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(probe_density_b_sptr self) -> int"""
        return _digital_swig2.probe_density_b_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(probe_density_b_sptr self) -> double"""
        return _digital_swig2.probe_density_b_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(probe_density_b_sptr self) -> uint64_t"""
        return _digital_swig2.probe_density_b_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(probe_density_b_sptr self) -> uint64_t"""
        return _digital_swig2.probe_density_b_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(probe_density_b_sptr self) -> bool"""
        return _digital_swig2.probe_density_b_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(probe_density_b_sptr self) -> bool"""
        return _digital_swig2.probe_density_b_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(probe_density_b_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.probe_density_b_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(probe_density_b_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.probe_density_b_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(probe_density_b_sptr self, std::string level)"""
        return _digital_swig2.probe_density_b_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(probe_density_b_sptr self) -> std::string"""
        return _digital_swig2.probe_density_b_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(probe_density_b_sptr self) -> int"""
        return _digital_swig2.probe_density_b_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(probe_density_b_sptr self, int m)"""
        return _digital_swig2.probe_density_b_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(probe_density_b_sptr self)"""
        return _digital_swig2.probe_density_b_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(probe_density_b_sptr self) -> bool"""
        return _digital_swig2.probe_density_b_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(probe_density_b_sptr self, int m)"""
        return _digital_swig2.probe_density_b_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(probe_density_b_sptr self) -> int"""
        return _digital_swig2.probe_density_b_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(probe_density_b_sptr self, int i) -> long"""
        return _digital_swig2.probe_density_b_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(probe_density_b_sptr self, long max_output_buffer)
        set_max_output_buffer(probe_density_b_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.probe_density_b_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(probe_density_b_sptr self, int i) -> long"""
        return _digital_swig2.probe_density_b_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(probe_density_b_sptr self, long min_output_buffer)
        set_min_output_buffer(probe_density_b_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.probe_density_b_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(probe_density_b_sptr self, int which) -> float
        pc_input_buffers_full(probe_density_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_density_b_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(probe_density_b_sptr self, int which) -> float
        pc_input_buffers_full_avg(probe_density_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_density_b_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(probe_density_b_sptr self, int which) -> float
        pc_input_buffers_full_var(probe_density_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_density_b_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(probe_density_b_sptr self, int which) -> float
        pc_output_buffers_full(probe_density_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_density_b_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(probe_density_b_sptr self, int which) -> float
        pc_output_buffers_full_avg(probe_density_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_density_b_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(probe_density_b_sptr self, int which) -> float
        pc_output_buffers_full_var(probe_density_b_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_density_b_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(probe_density_b_sptr self) -> float"""
        return _digital_swig2.probe_density_b_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(probe_density_b_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.probe_density_b_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(probe_density_b_sptr self)"""
        return _digital_swig2.probe_density_b_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(probe_density_b_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.probe_density_b_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(probe_density_b_sptr self) -> int"""
        return _digital_swig2.probe_density_b_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(probe_density_b_sptr self) -> int"""
        return _digital_swig2.probe_density_b_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(probe_density_b_sptr self, int priority) -> int"""
        return _digital_swig2.probe_density_b_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(probe_density_b_sptr self) -> std::string"""
        return _digital_swig2.probe_density_b_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(probe_density_b_sptr self) -> std::string"""
        return _digital_swig2.probe_density_b_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(probe_density_b_sptr self) -> io_signature_sptr"""
        return _digital_swig2.probe_density_b_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(probe_density_b_sptr self) -> io_signature_sptr"""
        return _digital_swig2.probe_density_b_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(probe_density_b_sptr self) -> long"""
        return _digital_swig2.probe_density_b_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(probe_density_b_sptr self) -> basic_block_sptr"""
        return _digital_swig2.probe_density_b_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(probe_density_b_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.probe_density_b_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(probe_density_b_sptr self) -> std::string"""
        return _digital_swig2.probe_density_b_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(probe_density_b_sptr self, std::string name)"""
        return _digital_swig2.probe_density_b_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(probe_density_b_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.probe_density_b_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(probe_density_b_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.probe_density_b_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(probe_density_b_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.probe_density_b_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(probe_density_b_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.probe_density_b_sptr_message_subscribers(self, which_port)

# Register probe_density_b_sptr in _digital_swig2:
_digital_swig2.probe_density_b_sptr_swigregister(probe_density_b_sptr)

probe_density_b_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
probe_density_b = probe_density_b.make;

class probe_mpsk_snr_est_c_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::probe_mpsk_snr_est_c > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(probe_mpsk_snr_est_c_sptr self) -> probe_mpsk_snr_est_c_sptr
        __init__(probe_mpsk_snr_est_c_sptr self, probe_mpsk_snr_est_c p) -> probe_mpsk_snr_est_c_sptr
        """
        _digital_swig2.probe_mpsk_snr_est_c_sptr_swiginit(self, _digital_swig2.new_probe_mpsk_snr_est_c_sptr(*args))

    def __deref__(self) -> "gr::digital::probe_mpsk_snr_est_c *":
        r"""__deref__(probe_mpsk_snr_est_c_sptr self) -> probe_mpsk_snr_est_c"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_probe_mpsk_snr_est_c_sptr

    def make(self, type: "gr::digital::snr_est_type_t", msg_nsamples: "int"=10000, alpha: "double"=0.001) -> "gr::digital::probe_mpsk_snr_est_c::sptr":
        r"""
        make(probe_mpsk_snr_est_c_sptr self, gr::digital::snr_est_type_t type, int msg_nsamples=10000, double alpha=0.001) -> probe_mpsk_snr_est_c_sptr
        A probe for computing SNR of a PSK signal.

        This is a probe block (a sink) that can be used to monitor and retrieve estimations of the signal SNR. This probe is designed for use with M-PSK signals especially. The type of estimator is specified as the  parameter in the constructor. The estimators tend to trade off performance for accuracy, although experimentation should be done to figure out the right approach for a given implementation. Further, the current set of estimators are designed and proven theoretically under AWGN conditions; some amount of error should be assumed and/or estimated for real channel conditions.


        The block has three output message ports that will emit a message every msg_samples number of samples. These message ports are: 
        Some calibration is required to convert dBx of the signal and noise power estimates to real measurements, such as dBm.


        The estimator is normally placed before clock recovery.

        Constructor Specific Documentation:

        Make an MPSK SNR probe.


        Parameters:

        Args:
            type : the type of estimator to use see gr::digital::snr_est_type_t for details about the types.
            msg_nsamples : [not implemented yet] after this many samples, a message containing the SNR (key='snr') will be sent
            alpha : the update rate of internal running average calculations. Needs to be between 0 and 1, where higher value adjusts faster to new data.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_make(self, type, msg_nsamples, alpha)

    def snr(self) -> "double":
        r"""
        snr(probe_mpsk_snr_est_c_sptr self) -> double
        Return the estimated signal-to-noise ratio in decibels.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_snr(self)

    def signal(self) -> "double":
        r"""
        signal(probe_mpsk_snr_est_c_sptr self) -> double
        Return the estimated signal power in decibels.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_signal(self)

    def noise(self) -> "double":
        r"""
        noise(probe_mpsk_snr_est_c_sptr self) -> double
        Return the estimated noise power in decibels.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_noise(self)

    def type(self) -> "gr::digital::snr_est_type_t":
        r"""
        type(probe_mpsk_snr_est_c_sptr self) -> gr::digital::snr_est_type_t
        Return the type of estimator in use.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_type(self)

    def msg_nsample(self) -> "int":
        r"""
        msg_nsample(probe_mpsk_snr_est_c_sptr self) -> int
        Return how many samples between SNR messages.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_msg_nsample(self)

    def alpha(self) -> "double":
        r"""
        alpha(probe_mpsk_snr_est_c_sptr self) -> double
        Get the running-average coefficient.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_alpha(self)

    def set_type(self, t: "gr::digital::snr_est_type_t") -> "void":
        r"""
        set_type(probe_mpsk_snr_est_c_sptr self, gr::digital::snr_est_type_t t)
        Set type of estimator to use.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_type(self, t)

    def set_msg_nsample(self, n: "int") -> "void":
        r"""
        set_msg_nsample(probe_mpsk_snr_est_c_sptr self, int n)
        Set the number of samples between SNR messages.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_msg_nsample(self, n)

    def set_alpha(self, alpha: "double") -> "void":
        r"""
        set_alpha(probe_mpsk_snr_est_c_sptr self, double alpha)
        Set the running-average coefficient.
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_alpha(self, alpha)

    def history(self) -> "unsigned int":
        r"""history(probe_mpsk_snr_est_c_sptr self) -> unsigned int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(probe_mpsk_snr_est_c_sptr self, int which, int delay)
        declare_sample_delay(probe_mpsk_snr_est_c_sptr self, unsigned int delay)
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(probe_mpsk_snr_est_c_sptr self, int which) -> unsigned int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(probe_mpsk_snr_est_c_sptr self, int multiple)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(probe_mpsk_snr_est_c_sptr self) -> int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(probe_mpsk_snr_est_c_sptr self) -> double"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(probe_mpsk_snr_est_c_sptr self) -> uint64_t"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(probe_mpsk_snr_est_c_sptr self) -> uint64_t"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(probe_mpsk_snr_est_c_sptr self) -> bool"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(probe_mpsk_snr_est_c_sptr self) -> bool"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(probe_mpsk_snr_est_c_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(probe_mpsk_snr_est_c_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(probe_mpsk_snr_est_c_sptr self, std::string level)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(probe_mpsk_snr_est_c_sptr self) -> std::string"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(probe_mpsk_snr_est_c_sptr self) -> int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(probe_mpsk_snr_est_c_sptr self, int m)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(probe_mpsk_snr_est_c_sptr self)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(probe_mpsk_snr_est_c_sptr self) -> bool"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(probe_mpsk_snr_est_c_sptr self, int m)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(probe_mpsk_snr_est_c_sptr self) -> int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(probe_mpsk_snr_est_c_sptr self, int i) -> long"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(probe_mpsk_snr_est_c_sptr self, long max_output_buffer)
        set_max_output_buffer(probe_mpsk_snr_est_c_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(probe_mpsk_snr_est_c_sptr self, int i) -> long"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(probe_mpsk_snr_est_c_sptr self, long min_output_buffer)
        set_min_output_buffer(probe_mpsk_snr_est_c_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(probe_mpsk_snr_est_c_sptr self, int which) -> float
        pc_input_buffers_full(probe_mpsk_snr_est_c_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(probe_mpsk_snr_est_c_sptr self, int which) -> float
        pc_input_buffers_full_avg(probe_mpsk_snr_est_c_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(probe_mpsk_snr_est_c_sptr self, int which) -> float
        pc_input_buffers_full_var(probe_mpsk_snr_est_c_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(probe_mpsk_snr_est_c_sptr self, int which) -> float
        pc_output_buffers_full(probe_mpsk_snr_est_c_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(probe_mpsk_snr_est_c_sptr self, int which) -> float
        pc_output_buffers_full_avg(probe_mpsk_snr_est_c_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(probe_mpsk_snr_est_c_sptr self, int which) -> float
        pc_output_buffers_full_var(probe_mpsk_snr_est_c_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(probe_mpsk_snr_est_c_sptr self) -> float"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(probe_mpsk_snr_est_c_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(probe_mpsk_snr_est_c_sptr self)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(probe_mpsk_snr_est_c_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(probe_mpsk_snr_est_c_sptr self) -> int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(probe_mpsk_snr_est_c_sptr self) -> int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(probe_mpsk_snr_est_c_sptr self, int priority) -> int"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(probe_mpsk_snr_est_c_sptr self) -> std::string"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(probe_mpsk_snr_est_c_sptr self) -> std::string"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(probe_mpsk_snr_est_c_sptr self) -> io_signature_sptr"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(probe_mpsk_snr_est_c_sptr self) -> io_signature_sptr"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(probe_mpsk_snr_est_c_sptr self) -> long"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(probe_mpsk_snr_est_c_sptr self) -> basic_block_sptr"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(probe_mpsk_snr_est_c_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(probe_mpsk_snr_est_c_sptr self) -> std::string"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(probe_mpsk_snr_est_c_sptr self, std::string name)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(probe_mpsk_snr_est_c_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(probe_mpsk_snr_est_c_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(probe_mpsk_snr_est_c_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(probe_mpsk_snr_est_c_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.probe_mpsk_snr_est_c_sptr_message_subscribers(self, which_port)

# Register probe_mpsk_snr_est_c_sptr in _digital_swig2:
_digital_swig2.probe_mpsk_snr_est_c_sptr_swigregister(probe_mpsk_snr_est_c_sptr)

probe_mpsk_snr_est_c_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
probe_mpsk_snr_est_c = probe_mpsk_snr_est_c.make;

class scrambler_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::scrambler_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(scrambler_bb_sptr self) -> scrambler_bb_sptr
        __init__(scrambler_bb_sptr self, scrambler_bb p) -> scrambler_bb_sptr
        """
        _digital_swig2.scrambler_bb_sptr_swiginit(self, _digital_swig2.new_scrambler_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::scrambler_bb *":
        r"""__deref__(scrambler_bb_sptr self) -> scrambler_bb"""
        return _digital_swig2.scrambler_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_scrambler_bb_sptr

    def make(self, mask: "int", seed: "int", len: "int") -> "gr::digital::scrambler_bb::sptr":
        r"""
        make(scrambler_bb_sptr self, int mask, int seed, int len) -> scrambler_bb_sptr
        Scramble an input stream using an LFSR.

        This block works on the LSB only of the input data stream, i.e., on an "unpacked binary" stream, and produces the same format on its output.

        Constructor Specific Documentation:

        Make a scramber block.

        Args:
            mask : Polynomial mask for LFSR
            seed : Initial shift register contents
            len : Shift register length
        """
        return _digital_swig2.scrambler_bb_sptr_make(self, mask, seed, len)

    def history(self) -> "unsigned int":
        r"""history(scrambler_bb_sptr self) -> unsigned int"""
        return _digital_swig2.scrambler_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(scrambler_bb_sptr self, int which, int delay)
        declare_sample_delay(scrambler_bb_sptr self, unsigned int delay)
        """
        return _digital_swig2.scrambler_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(scrambler_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig2.scrambler_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(scrambler_bb_sptr self, int multiple)"""
        return _digital_swig2.scrambler_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(scrambler_bb_sptr self) -> int"""
        return _digital_swig2.scrambler_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(scrambler_bb_sptr self) -> double"""
        return _digital_swig2.scrambler_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(scrambler_bb_sptr self) -> uint64_t"""
        return _digital_swig2.scrambler_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(scrambler_bb_sptr self) -> uint64_t"""
        return _digital_swig2.scrambler_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(scrambler_bb_sptr self) -> bool"""
        return _digital_swig2.scrambler_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(scrambler_bb_sptr self) -> bool"""
        return _digital_swig2.scrambler_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(scrambler_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.scrambler_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(scrambler_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.scrambler_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(scrambler_bb_sptr self, std::string level)"""
        return _digital_swig2.scrambler_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(scrambler_bb_sptr self) -> std::string"""
        return _digital_swig2.scrambler_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(scrambler_bb_sptr self) -> int"""
        return _digital_swig2.scrambler_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(scrambler_bb_sptr self, int m)"""
        return _digital_swig2.scrambler_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(scrambler_bb_sptr self)"""
        return _digital_swig2.scrambler_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(scrambler_bb_sptr self) -> bool"""
        return _digital_swig2.scrambler_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(scrambler_bb_sptr self, int m)"""
        return _digital_swig2.scrambler_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(scrambler_bb_sptr self) -> int"""
        return _digital_swig2.scrambler_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(scrambler_bb_sptr self, int i) -> long"""
        return _digital_swig2.scrambler_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(scrambler_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(scrambler_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.scrambler_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(scrambler_bb_sptr self, int i) -> long"""
        return _digital_swig2.scrambler_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(scrambler_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(scrambler_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.scrambler_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(scrambler_bb_sptr self, int which) -> float
        pc_input_buffers_full(scrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.scrambler_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(scrambler_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(scrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.scrambler_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(scrambler_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(scrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.scrambler_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(scrambler_bb_sptr self, int which) -> float
        pc_output_buffers_full(scrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.scrambler_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(scrambler_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(scrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.scrambler_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(scrambler_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(scrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.scrambler_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(scrambler_bb_sptr self) -> float"""
        return _digital_swig2.scrambler_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(scrambler_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.scrambler_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(scrambler_bb_sptr self)"""
        return _digital_swig2.scrambler_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(scrambler_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.scrambler_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(scrambler_bb_sptr self) -> int"""
        return _digital_swig2.scrambler_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(scrambler_bb_sptr self) -> int"""
        return _digital_swig2.scrambler_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(scrambler_bb_sptr self, int priority) -> int"""
        return _digital_swig2.scrambler_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(scrambler_bb_sptr self) -> std::string"""
        return _digital_swig2.scrambler_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(scrambler_bb_sptr self) -> std::string"""
        return _digital_swig2.scrambler_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(scrambler_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig2.scrambler_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(scrambler_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig2.scrambler_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(scrambler_bb_sptr self) -> long"""
        return _digital_swig2.scrambler_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(scrambler_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig2.scrambler_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(scrambler_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.scrambler_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(scrambler_bb_sptr self) -> std::string"""
        return _digital_swig2.scrambler_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(scrambler_bb_sptr self, std::string name)"""
        return _digital_swig2.scrambler_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(scrambler_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.scrambler_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(scrambler_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.scrambler_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(scrambler_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.scrambler_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(scrambler_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.scrambler_bb_sptr_message_subscribers(self, which_port)

# Register scrambler_bb_sptr in _digital_swig2:
_digital_swig2.scrambler_bb_sptr_swigregister(scrambler_bb_sptr)

scrambler_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
scrambler_bb = scrambler_bb.make;

class simple_correlator_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::simple_correlator > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(simple_correlator_sptr self) -> simple_correlator_sptr
        __init__(simple_correlator_sptr self, simple_correlator p) -> simple_correlator_sptr
        """
        _digital_swig2.simple_correlator_sptr_swiginit(self, _digital_swig2.new_simple_correlator_sptr(*args))

    def __deref__(self) -> "gr::digital::simple_correlator *":
        r"""__deref__(simple_correlator_sptr self) -> simple_correlator"""
        return _digital_swig2.simple_correlator_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_simple_correlator_sptr

    def make(self, payload_bytesize: "int") -> "gr::digital::simple_correlator::sptr":
        r"""
        make(simple_correlator_sptr self, int payload_bytesize) -> simple_correlator_sptr
        inverse of simple_framer (more or less)

        Constructor Specific Documentation:



        Args:
            payload_bytesize : 
        """
        return _digital_swig2.simple_correlator_sptr_make(self, payload_bytesize)

    def history(self) -> "unsigned int":
        r"""history(simple_correlator_sptr self) -> unsigned int"""
        return _digital_swig2.simple_correlator_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(simple_correlator_sptr self, int which, int delay)
        declare_sample_delay(simple_correlator_sptr self, unsigned int delay)
        """
        return _digital_swig2.simple_correlator_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(simple_correlator_sptr self, int which) -> unsigned int"""
        return _digital_swig2.simple_correlator_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(simple_correlator_sptr self, int multiple)"""
        return _digital_swig2.simple_correlator_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(simple_correlator_sptr self) -> int"""
        return _digital_swig2.simple_correlator_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(simple_correlator_sptr self) -> double"""
        return _digital_swig2.simple_correlator_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(simple_correlator_sptr self) -> uint64_t"""
        return _digital_swig2.simple_correlator_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(simple_correlator_sptr self) -> uint64_t"""
        return _digital_swig2.simple_correlator_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(simple_correlator_sptr self) -> bool"""
        return _digital_swig2.simple_correlator_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(simple_correlator_sptr self) -> bool"""
        return _digital_swig2.simple_correlator_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(simple_correlator_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.simple_correlator_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(simple_correlator_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.simple_correlator_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(simple_correlator_sptr self, std::string level)"""
        return _digital_swig2.simple_correlator_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(simple_correlator_sptr self) -> std::string"""
        return _digital_swig2.simple_correlator_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(simple_correlator_sptr self) -> int"""
        return _digital_swig2.simple_correlator_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(simple_correlator_sptr self, int m)"""
        return _digital_swig2.simple_correlator_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(simple_correlator_sptr self)"""
        return _digital_swig2.simple_correlator_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(simple_correlator_sptr self) -> bool"""
        return _digital_swig2.simple_correlator_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(simple_correlator_sptr self, int m)"""
        return _digital_swig2.simple_correlator_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(simple_correlator_sptr self) -> int"""
        return _digital_swig2.simple_correlator_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(simple_correlator_sptr self, int i) -> long"""
        return _digital_swig2.simple_correlator_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(simple_correlator_sptr self, long max_output_buffer)
        set_max_output_buffer(simple_correlator_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.simple_correlator_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(simple_correlator_sptr self, int i) -> long"""
        return _digital_swig2.simple_correlator_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(simple_correlator_sptr self, long min_output_buffer)
        set_min_output_buffer(simple_correlator_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.simple_correlator_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(simple_correlator_sptr self, int which) -> float
        pc_input_buffers_full(simple_correlator_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_correlator_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(simple_correlator_sptr self, int which) -> float
        pc_input_buffers_full_avg(simple_correlator_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_correlator_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(simple_correlator_sptr self, int which) -> float
        pc_input_buffers_full_var(simple_correlator_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_correlator_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(simple_correlator_sptr self, int which) -> float
        pc_output_buffers_full(simple_correlator_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_correlator_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(simple_correlator_sptr self, int which) -> float
        pc_output_buffers_full_avg(simple_correlator_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_correlator_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(simple_correlator_sptr self, int which) -> float
        pc_output_buffers_full_var(simple_correlator_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_correlator_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(simple_correlator_sptr self) -> float"""
        return _digital_swig2.simple_correlator_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(simple_correlator_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.simple_correlator_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(simple_correlator_sptr self)"""
        return _digital_swig2.simple_correlator_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(simple_correlator_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.simple_correlator_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(simple_correlator_sptr self) -> int"""
        return _digital_swig2.simple_correlator_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(simple_correlator_sptr self) -> int"""
        return _digital_swig2.simple_correlator_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(simple_correlator_sptr self, int priority) -> int"""
        return _digital_swig2.simple_correlator_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(simple_correlator_sptr self) -> std::string"""
        return _digital_swig2.simple_correlator_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(simple_correlator_sptr self) -> std::string"""
        return _digital_swig2.simple_correlator_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(simple_correlator_sptr self) -> io_signature_sptr"""
        return _digital_swig2.simple_correlator_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(simple_correlator_sptr self) -> io_signature_sptr"""
        return _digital_swig2.simple_correlator_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(simple_correlator_sptr self) -> long"""
        return _digital_swig2.simple_correlator_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(simple_correlator_sptr self) -> basic_block_sptr"""
        return _digital_swig2.simple_correlator_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(simple_correlator_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.simple_correlator_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(simple_correlator_sptr self) -> std::string"""
        return _digital_swig2.simple_correlator_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(simple_correlator_sptr self, std::string name)"""
        return _digital_swig2.simple_correlator_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(simple_correlator_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.simple_correlator_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(simple_correlator_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.simple_correlator_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(simple_correlator_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.simple_correlator_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(simple_correlator_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.simple_correlator_sptr_message_subscribers(self, which_port)

# Register simple_correlator_sptr in _digital_swig2:
_digital_swig2.simple_correlator_sptr_swigregister(simple_correlator_sptr)

simple_correlator_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
simple_correlator = simple_correlator.make;

class simple_framer_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::simple_framer > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(simple_framer_sptr self) -> simple_framer_sptr
        __init__(simple_framer_sptr self, simple_framer p) -> simple_framer_sptr
        """
        _digital_swig2.simple_framer_sptr_swiginit(self, _digital_swig2.new_simple_framer_sptr(*args))

    def __deref__(self) -> "gr::digital::simple_framer *":
        r"""__deref__(simple_framer_sptr self) -> simple_framer"""
        return _digital_swig2.simple_framer_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_simple_framer_sptr

    def make(self, payload_bytesize: "int") -> "gr::digital::simple_framer::sptr":
        r"""
        make(simple_framer_sptr self, int payload_bytesize) -> simple_framer_sptr
        add sync field, seq number and command field to payload

        Takes in enough samples to create a full output frame. The frame is prepended with the GRSF_SYNC (defined in simple_framer_sync.h) and an 8-bit sequence number.

        Constructor Specific Documentation:

        Make a simple_framer block.

        Args:
            payload_bytesize : The size of the payload in bytes.
        """
        return _digital_swig2.simple_framer_sptr_make(self, payload_bytesize)

    def history(self) -> "unsigned int":
        r"""history(simple_framer_sptr self) -> unsigned int"""
        return _digital_swig2.simple_framer_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(simple_framer_sptr self, int which, int delay)
        declare_sample_delay(simple_framer_sptr self, unsigned int delay)
        """
        return _digital_swig2.simple_framer_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(simple_framer_sptr self, int which) -> unsigned int"""
        return _digital_swig2.simple_framer_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(simple_framer_sptr self, int multiple)"""
        return _digital_swig2.simple_framer_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(simple_framer_sptr self) -> int"""
        return _digital_swig2.simple_framer_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(simple_framer_sptr self) -> double"""
        return _digital_swig2.simple_framer_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(simple_framer_sptr self) -> uint64_t"""
        return _digital_swig2.simple_framer_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(simple_framer_sptr self) -> uint64_t"""
        return _digital_swig2.simple_framer_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(simple_framer_sptr self) -> bool"""
        return _digital_swig2.simple_framer_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(simple_framer_sptr self) -> bool"""
        return _digital_swig2.simple_framer_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(simple_framer_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.simple_framer_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(simple_framer_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.simple_framer_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(simple_framer_sptr self, std::string level)"""
        return _digital_swig2.simple_framer_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(simple_framer_sptr self) -> std::string"""
        return _digital_swig2.simple_framer_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(simple_framer_sptr self) -> int"""
        return _digital_swig2.simple_framer_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(simple_framer_sptr self, int m)"""
        return _digital_swig2.simple_framer_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(simple_framer_sptr self)"""
        return _digital_swig2.simple_framer_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(simple_framer_sptr self) -> bool"""
        return _digital_swig2.simple_framer_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(simple_framer_sptr self, int m)"""
        return _digital_swig2.simple_framer_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(simple_framer_sptr self) -> int"""
        return _digital_swig2.simple_framer_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(simple_framer_sptr self, int i) -> long"""
        return _digital_swig2.simple_framer_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(simple_framer_sptr self, long max_output_buffer)
        set_max_output_buffer(simple_framer_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.simple_framer_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(simple_framer_sptr self, int i) -> long"""
        return _digital_swig2.simple_framer_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(simple_framer_sptr self, long min_output_buffer)
        set_min_output_buffer(simple_framer_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.simple_framer_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(simple_framer_sptr self, int which) -> float
        pc_input_buffers_full(simple_framer_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_framer_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(simple_framer_sptr self, int which) -> float
        pc_input_buffers_full_avg(simple_framer_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_framer_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(simple_framer_sptr self, int which) -> float
        pc_input_buffers_full_var(simple_framer_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_framer_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(simple_framer_sptr self, int which) -> float
        pc_output_buffers_full(simple_framer_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_framer_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(simple_framer_sptr self, int which) -> float
        pc_output_buffers_full_avg(simple_framer_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_framer_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(simple_framer_sptr self, int which) -> float
        pc_output_buffers_full_var(simple_framer_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.simple_framer_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(simple_framer_sptr self) -> float"""
        return _digital_swig2.simple_framer_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(simple_framer_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.simple_framer_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(simple_framer_sptr self)"""
        return _digital_swig2.simple_framer_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(simple_framer_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.simple_framer_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(simple_framer_sptr self) -> int"""
        return _digital_swig2.simple_framer_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(simple_framer_sptr self) -> int"""
        return _digital_swig2.simple_framer_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(simple_framer_sptr self, int priority) -> int"""
        return _digital_swig2.simple_framer_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(simple_framer_sptr self) -> std::string"""
        return _digital_swig2.simple_framer_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(simple_framer_sptr self) -> std::string"""
        return _digital_swig2.simple_framer_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(simple_framer_sptr self) -> io_signature_sptr"""
        return _digital_swig2.simple_framer_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(simple_framer_sptr self) -> io_signature_sptr"""
        return _digital_swig2.simple_framer_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(simple_framer_sptr self) -> long"""
        return _digital_swig2.simple_framer_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(simple_framer_sptr self) -> basic_block_sptr"""
        return _digital_swig2.simple_framer_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(simple_framer_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.simple_framer_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(simple_framer_sptr self) -> std::string"""
        return _digital_swig2.simple_framer_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(simple_framer_sptr self, std::string name)"""
        return _digital_swig2.simple_framer_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(simple_framer_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.simple_framer_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(simple_framer_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.simple_framer_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(simple_framer_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.simple_framer_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(simple_framer_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.simple_framer_sptr_message_subscribers(self, which_port)

# Register simple_framer_sptr in _digital_swig2:
_digital_swig2.simple_framer_sptr_swigregister(simple_framer_sptr)

simple_framer_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
simple_framer = simple_framer.make;

class symbol_sync_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::symbol_sync_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(symbol_sync_cc_sptr self) -> symbol_sync_cc_sptr
        __init__(symbol_sync_cc_sptr self, symbol_sync_cc p) -> symbol_sync_cc_sptr
        """
        _digital_swig2.symbol_sync_cc_sptr_swiginit(self, _digital_swig2.new_symbol_sync_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::symbol_sync_cc *":
        r"""__deref__(symbol_sync_cc_sptr self) -> symbol_sync_cc"""
        return _digital_swig2.symbol_sync_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_symbol_sync_cc_sptr

    def make(self, *args, **kwargs) -> "gr::digital::symbol_sync_cc::sptr":
        r"""
        make(symbol_sync_cc_sptr self, enum gr::digital::ted_type detector_type, float sps, float loop_bw, float damping_factor=1.0, float ted_gain=1.0, float max_deviation=1.5, int osps=1, constellation_sptr slicer=gr::digital::constellation_sptr(), gr::digital::ir_type interp_type=IR_MMSE_8TAP, int n_filters=128, pmt_vector_float taps=std::vector< float >()) -> symbol_sync_cc_sptr
        Symbol Synchronizer block with complex input, complex output.

        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Constructor Specific Documentation:

        Make a Symbol Synchronizer block.


        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Args:
            detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
            sps : User specified nominal clock period in samples per symbol.
            loop_bw : Approximate normailzed loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
            damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
            ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
            max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
            osps : The number of output samples per symbol (default=1).
            slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
            interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
            n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
            taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
        """
        return _digital_swig2.symbol_sync_cc_sptr_make(self, *args, **kwargs)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(symbol_sync_cc_sptr self) -> float
        Returns the normalized approximate loop bandwidth.

        See the documentation for set_loop_bandwidth() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_cc_sptr_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(symbol_sync_cc_sptr self) -> float
        Returns the loop damping factor.

        See the documentation for set_damping_factor() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_cc_sptr_damping_factor(self)

    def ted_gain(self) -> "float":
        r"""
        ted_gain(symbol_sync_cc_sptr self) -> float
        Returns the user provided expected gain of the Timing Error Detector.

        See the documentation for set_ted_gain() for more details.
        """
        return _digital_swig2.symbol_sync_cc_sptr_ted_gain(self)

    def alpha(self) -> "float":
        r"""
        alpha(symbol_sync_cc_sptr self) -> float
        Returns the PI filter proportional gain, alpha.

        See the documentation for set_alpha() for more details.
        """
        return _digital_swig2.symbol_sync_cc_sptr_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(symbol_sync_cc_sptr self) -> float
        Returns the PI filter integral gain, beta.

        See the documentation for set_beta() for more details.
        """
        return _digital_swig2.symbol_sync_cc_sptr_beta(self)

    def set_loop_bandwidth(self, omega_n_norm: "float") -> "void":
        r"""
        set_loop_bandwidth(symbol_sync_cc_sptr self, float omega_n_norm)
        Set the normalized approximate loop bandwidth.

        Set the normalized approximate loop bandwidth. Useful values are usually close to 0.0, e.g. 2*pi*0.045.


        It should be a small positive number, corresponding to the normalized natural radian frequency of the loop as digital low-pass filter that is filtering the clock phase/timing error.


        Technically this parameter corresponds to the natural radian frequency of the 2nd order loop transfer function (scaled by Fs), which is the radius of the pole locations in the s-plane of an underdamped analog 2nd order system.


        The input parameter corresponds to omega_n_norm in the following relation: 


        where T is the period of the clock being estimated by this clock tracking loop, and omega_n is the natural radian frequency of the 2nd order loop transfer function.


        When a new loop bandwidth is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_loop_bandwidth(self, omega_n_norm)

    def set_damping_factor(self, zeta: "float") -> "void":
        r"""
        set_damping_factor(symbol_sync_cc_sptr self, float zeta)
        Set the loop damping factor.

        Set the damping factor of the loop. Damping in the range (0.0, 1.0) yields an under-damped loop. Damping in the range (1.0, Inf) yields an over-damped loop. Damping equal to 1.0 yields a crtically-damped loop. Damping equal to 1.0/sqrt(2.0) yields a maximally flat loop filter response.


        Damping factor of the 2nd order loop transfer function. When a new damping factor is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_damping_factor(self, zeta)

    def set_ted_gain(self, ted_gain: "float") -> "void":
        r"""
        set_ted_gain(symbol_sync_cc_sptr self, float ted_gain)
        Set the expected gain of the Timing Error Detector.

        Sets the expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.


        When a new ted_gain is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_ted_gain(self, ted_gain)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(symbol_sync_cc_sptr self, float alpha)
        Set the PI filter proportional gain, alpha.

        Sets the PI filter proportional gain, alpha. This gain directly mutliplies the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the instantaneous clock period estimate, T_inst, and instantaneous clock phase estimate, tau.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(symbol_sync_cc_sptr self, float beta)
        Set the PI filter integral gain, beta.

        Sets the PI filter integral gain, beta. This gain is used when integrating the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the average clock period estimate, T_avg.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_beta(self, beta)

    def history(self) -> "unsigned int":
        r"""history(symbol_sync_cc_sptr self) -> unsigned int"""
        return _digital_swig2.symbol_sync_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(symbol_sync_cc_sptr self, int which, int delay)
        declare_sample_delay(symbol_sync_cc_sptr self, unsigned int delay)
        """
        return _digital_swig2.symbol_sync_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(symbol_sync_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig2.symbol_sync_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(symbol_sync_cc_sptr self, int multiple)"""
        return _digital_swig2.symbol_sync_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(symbol_sync_cc_sptr self) -> int"""
        return _digital_swig2.symbol_sync_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(symbol_sync_cc_sptr self) -> double"""
        return _digital_swig2.symbol_sync_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(symbol_sync_cc_sptr self) -> uint64_t"""
        return _digital_swig2.symbol_sync_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(symbol_sync_cc_sptr self) -> uint64_t"""
        return _digital_swig2.symbol_sync_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(symbol_sync_cc_sptr self) -> bool"""
        return _digital_swig2.symbol_sync_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(symbol_sync_cc_sptr self) -> bool"""
        return _digital_swig2.symbol_sync_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(symbol_sync_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.symbol_sync_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(symbol_sync_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.symbol_sync_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(symbol_sync_cc_sptr self, std::string level)"""
        return _digital_swig2.symbol_sync_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(symbol_sync_cc_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(symbol_sync_cc_sptr self) -> int"""
        return _digital_swig2.symbol_sync_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(symbol_sync_cc_sptr self, int m)"""
        return _digital_swig2.symbol_sync_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(symbol_sync_cc_sptr self)"""
        return _digital_swig2.symbol_sync_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(symbol_sync_cc_sptr self) -> bool"""
        return _digital_swig2.symbol_sync_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(symbol_sync_cc_sptr self, int m)"""
        return _digital_swig2.symbol_sync_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(symbol_sync_cc_sptr self) -> int"""
        return _digital_swig2.symbol_sync_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(symbol_sync_cc_sptr self, int i) -> long"""
        return _digital_swig2.symbol_sync_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(symbol_sync_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(symbol_sync_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(symbol_sync_cc_sptr self, int i) -> long"""
        return _digital_swig2.symbol_sync_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(symbol_sync_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(symbol_sync_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.symbol_sync_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(symbol_sync_cc_sptr self, int which) -> float
        pc_input_buffers_full(symbol_sync_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(symbol_sync_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(symbol_sync_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(symbol_sync_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(symbol_sync_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(symbol_sync_cc_sptr self, int which) -> float
        pc_output_buffers_full(symbol_sync_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(symbol_sync_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(symbol_sync_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(symbol_sync_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(symbol_sync_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(symbol_sync_cc_sptr self) -> float"""
        return _digital_swig2.symbol_sync_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(symbol_sync_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.symbol_sync_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(symbol_sync_cc_sptr self)"""
        return _digital_swig2.symbol_sync_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(symbol_sync_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.symbol_sync_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(symbol_sync_cc_sptr self) -> int"""
        return _digital_swig2.symbol_sync_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(symbol_sync_cc_sptr self) -> int"""
        return _digital_swig2.symbol_sync_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(symbol_sync_cc_sptr self, int priority) -> int"""
        return _digital_swig2.symbol_sync_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(symbol_sync_cc_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(symbol_sync_cc_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(symbol_sync_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig2.symbol_sync_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(symbol_sync_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig2.symbol_sync_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(symbol_sync_cc_sptr self) -> long"""
        return _digital_swig2.symbol_sync_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(symbol_sync_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig2.symbol_sync_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(symbol_sync_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.symbol_sync_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(symbol_sync_cc_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(symbol_sync_cc_sptr self, std::string name)"""
        return _digital_swig2.symbol_sync_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(symbol_sync_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.symbol_sync_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(symbol_sync_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.symbol_sync_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(symbol_sync_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.symbol_sync_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(symbol_sync_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.symbol_sync_cc_sptr_message_subscribers(self, which_port)

# Register symbol_sync_cc_sptr in _digital_swig2:
_digital_swig2.symbol_sync_cc_sptr_swigregister(symbol_sync_cc_sptr)

symbol_sync_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
symbol_sync_cc = symbol_sync_cc.make;

class symbol_sync_ff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::symbol_sync_ff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(symbol_sync_ff_sptr self) -> symbol_sync_ff_sptr
        __init__(symbol_sync_ff_sptr self, symbol_sync_ff p) -> symbol_sync_ff_sptr
        """
        _digital_swig2.symbol_sync_ff_sptr_swiginit(self, _digital_swig2.new_symbol_sync_ff_sptr(*args))

    def __deref__(self) -> "gr::digital::symbol_sync_ff *":
        r"""__deref__(symbol_sync_ff_sptr self) -> symbol_sync_ff"""
        return _digital_swig2.symbol_sync_ff_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_symbol_sync_ff_sptr

    def make(self, *args, **kwargs) -> "gr::digital::symbol_sync_ff::sptr":
        r"""
        make(symbol_sync_ff_sptr self, enum gr::digital::ted_type detector_type, float sps, float loop_bw, float damping_factor=1.0, float ted_gain=1.0, float max_deviation=1.5, int osps=1, constellation_sptr slicer=gr::digital::constellation_sptr(), gr::digital::ir_type interp_type=IR_MMSE_8TAP, int n_filters=128, pmt_vector_float taps=std::vector< float >()) -> symbol_sync_ff_sptr
        Symbol Synchronizer block with float input, float output.

        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Constructor Specific Documentation:

        Make a Symbol Synchronizer block.


        This implements a discrete-time error-tracking synchronizer.


        For this block to work properly, the input stream must meet the following requirements:

        Args:
            detector_type : The enumerated type of timing error detector to use. See enum ted_type for a list of possible types.
            sps : User specified nominal clock period in samples per symbol.
            loop_bw : Approximate normailzed loop bandwidth of the symbol clock tracking loop. It should nominally be close to 0, but greater than 0. If unsure, start with a number around 2*pi*0.040, and experiment to find the value that works best for your situation.
            damping_factor : Damping factor of the symbol clock tracking loop. Damping < 1.0f is an under-damped loop. Damping = 1.0f/sqrt(2.0f) is a maximally flat loop response. Damping = 1.0f is a critically-damped loop. Damping > 1.0f is an over-damped loop.
            ted_gain : Expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.
            max_deviation : Maximum absolute deviation of the average clock period estimate from the user specified nominal clock period in samples per symbol.
            osps : The number of output samples per symbol (default=1).
            slicer : A constellation obj shared pointer that will be used by decision directed timing error detectors to make decisions. I.e. the timing error detector will use this constellation as a slicer, if the particular algorithm needs sliced symbols.
            interp_type : The enumerated type of interpolating resampler to use. See the interpolating resampler type enum for a list of possible types.
            n_filters : The number of arms in the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
            taps : The prototype filter for the polyphase filterbank of the interpolating resampler, if using an interpolating resampler that uses a PFB.
        """
        return _digital_swig2.symbol_sync_ff_sptr_make(self, *args, **kwargs)

    def loop_bandwidth(self) -> "float":
        r"""
        loop_bandwidth(symbol_sync_ff_sptr self) -> float
        Returns the normalized approximate loop bandwidth.

        See the documentation for set_loop_bandwidth() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_ff_sptr_loop_bandwidth(self)

    def damping_factor(self) -> "float":
        r"""
        damping_factor(symbol_sync_ff_sptr self) -> float
        Returns the loop damping factor.

        See the documentation for set_damping_factor() for more details.


        Note that if set_alpha() or set_beta() were called to directly set gains, the value returned by this method will be inaccurate/stale.
        """
        return _digital_swig2.symbol_sync_ff_sptr_damping_factor(self)

    def ted_gain(self) -> "float":
        r"""
        ted_gain(symbol_sync_ff_sptr self) -> float
        Returns the user provided expected gain of the Timing Error Detector.

        See the documentation for set_ted_gain() for more details.
        """
        return _digital_swig2.symbol_sync_ff_sptr_ted_gain(self)

    def alpha(self) -> "float":
        r"""
        alpha(symbol_sync_ff_sptr self) -> float
        Returns the PI filter proportional gain, alpha.

        See the documentation for set_alpha() for more details.
        """
        return _digital_swig2.symbol_sync_ff_sptr_alpha(self)

    def beta(self) -> "float":
        r"""
        beta(symbol_sync_ff_sptr self) -> float
        Returns the PI filter integral gain, beta.

        See the documentation for set_beta() for more details.
        """
        return _digital_swig2.symbol_sync_ff_sptr_beta(self)

    def set_loop_bandwidth(self, omega_n_norm: "float") -> "void":
        r"""
        set_loop_bandwidth(symbol_sync_ff_sptr self, float omega_n_norm)
        Set the normalized approximate loop bandwidth.

        Set the normalized approximate loop bandwidth. Useful values are usually close to 0.0, e.g. 2*pi*0.045.


        It should be a small positive number, corresponding to the normalized natural radian frequency of the loop as digital low-pass filter that is filtering the clock phase/timing error.


        Technically this parameter corresponds to the natural radian frequency of the 2nd order loop transfer function (scaled by Fs), which is the radius of the pole locations in the s-plane of an underdamped analog 2nd order system.


        The input parameter corresponds to omega_n_norm in the following relation: 


        where T is the period of the clock being estimated by this clock tracking loop, and omega_n is the natural radian frequency of the 2nd order loop transfer function.


        When a new loop bandwidth is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_loop_bandwidth(self, omega_n_norm)

    def set_damping_factor(self, zeta: "float") -> "void":
        r"""
        set_damping_factor(symbol_sync_ff_sptr self, float zeta)
        Set the loop damping factor.

        Set the damping factor of the loop. Damping in the range (0.0, 1.0) yields an under-damped loop. Damping in the range (1.0, Inf) yields an over-damped loop. Damping equal to 1.0 yields a crtically-damped loop. Damping equal to 1.0/sqrt(2.0) yields a maximally flat loop filter response.


        Damping factor of the 2nd order loop transfer function. When a new damping factor is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_damping_factor(self, zeta)

    def set_ted_gain(self, ted_gain: "float") -> "void":
        r"""
        set_ted_gain(symbol_sync_ff_sptr self, float ted_gain)
        Set the expected gain of the Timing Error Detector.

        Sets the expected gain of the timing error detector, given the TED in use and the anticipated input amplitude, pulse shape, and Es/No. This value is the slope of the TED's S-curve at timing offset tau = 0. This value is normally computed by the user analytically or by simulation in a tool outside of GNURadio. This value must be correct for the loop filter gains to be computed properly from the desired input loop bandwidth and damping factor.


        When a new ted_gain is set, the gains, alpha and beta, of the loop are automatically recalculated.
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_ted_gain(self, ted_gain)

    def set_alpha(self, alpha: "float") -> "void":
        r"""
        set_alpha(symbol_sync_ff_sptr self, float alpha)
        Set the PI filter proportional gain, alpha.

        Sets the PI filter proportional gain, alpha. This gain directly mutliplies the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the instantaneous clock period estimate, T_inst, and instantaneous clock phase estimate, tau.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""
        set_beta(symbol_sync_ff_sptr self, float beta)
        Set the PI filter integral gain, beta.

        Sets the PI filter integral gain, beta. This gain is used when integrating the clock phase/timing error term in the PI filter when advancing the loop. It most directly affects the average clock period estimate, T_avg.


        This value would normally be adjusted by setting the loop bandwidth and damping factor. However, it can be set here directly if desired.


        Setting this parameter directly is probably only feasible if the user is directly observing the estimates of average clock period and instantaneous clock period over time in response to an impulsive change in the input stream (i.e. watching the loop transient behavior at the start of a data burst).
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_beta(self, beta)

    def history(self) -> "unsigned int":
        r"""history(symbol_sync_ff_sptr self) -> unsigned int"""
        return _digital_swig2.symbol_sync_ff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(symbol_sync_ff_sptr self, int which, int delay)
        declare_sample_delay(symbol_sync_ff_sptr self, unsigned int delay)
        """
        return _digital_swig2.symbol_sync_ff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(symbol_sync_ff_sptr self, int which) -> unsigned int"""
        return _digital_swig2.symbol_sync_ff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(symbol_sync_ff_sptr self, int multiple)"""
        return _digital_swig2.symbol_sync_ff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(symbol_sync_ff_sptr self) -> int"""
        return _digital_swig2.symbol_sync_ff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(symbol_sync_ff_sptr self) -> double"""
        return _digital_swig2.symbol_sync_ff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(symbol_sync_ff_sptr self) -> uint64_t"""
        return _digital_swig2.symbol_sync_ff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(symbol_sync_ff_sptr self) -> uint64_t"""
        return _digital_swig2.symbol_sync_ff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(symbol_sync_ff_sptr self) -> bool"""
        return _digital_swig2.symbol_sync_ff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(symbol_sync_ff_sptr self) -> bool"""
        return _digital_swig2.symbol_sync_ff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(symbol_sync_ff_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig2.symbol_sync_ff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(symbol_sync_ff_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig2.symbol_sync_ff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(symbol_sync_ff_sptr self, std::string level)"""
        return _digital_swig2.symbol_sync_ff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(symbol_sync_ff_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_ff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(symbol_sync_ff_sptr self) -> int"""
        return _digital_swig2.symbol_sync_ff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(symbol_sync_ff_sptr self, int m)"""
        return _digital_swig2.symbol_sync_ff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(symbol_sync_ff_sptr self)"""
        return _digital_swig2.symbol_sync_ff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(symbol_sync_ff_sptr self) -> bool"""
        return _digital_swig2.symbol_sync_ff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(symbol_sync_ff_sptr self, int m)"""
        return _digital_swig2.symbol_sync_ff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(symbol_sync_ff_sptr self) -> int"""
        return _digital_swig2.symbol_sync_ff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(symbol_sync_ff_sptr self, int i) -> long"""
        return _digital_swig2.symbol_sync_ff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(symbol_sync_ff_sptr self, long max_output_buffer)
        set_max_output_buffer(symbol_sync_ff_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(symbol_sync_ff_sptr self, int i) -> long"""
        return _digital_swig2.symbol_sync_ff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(symbol_sync_ff_sptr self, long min_output_buffer)
        set_min_output_buffer(symbol_sync_ff_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig2.symbol_sync_ff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(symbol_sync_ff_sptr self, int which) -> float
        pc_input_buffers_full(symbol_sync_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_ff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(symbol_sync_ff_sptr self, int which) -> float
        pc_input_buffers_full_avg(symbol_sync_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_ff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(symbol_sync_ff_sptr self, int which) -> float
        pc_input_buffers_full_var(symbol_sync_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_ff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(symbol_sync_ff_sptr self, int which) -> float
        pc_output_buffers_full(symbol_sync_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_ff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(symbol_sync_ff_sptr self, int which) -> float
        pc_output_buffers_full_avg(symbol_sync_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_ff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(symbol_sync_ff_sptr self, int which) -> float
        pc_output_buffers_full_var(symbol_sync_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig2.symbol_sync_ff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(symbol_sync_ff_sptr self) -> float"""
        return _digital_swig2.symbol_sync_ff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(symbol_sync_ff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig2.symbol_sync_ff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(symbol_sync_ff_sptr self)"""
        return _digital_swig2.symbol_sync_ff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(symbol_sync_ff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig2.symbol_sync_ff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(symbol_sync_ff_sptr self) -> int"""
        return _digital_swig2.symbol_sync_ff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(symbol_sync_ff_sptr self) -> int"""
        return _digital_swig2.symbol_sync_ff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(symbol_sync_ff_sptr self, int priority) -> int"""
        return _digital_swig2.symbol_sync_ff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(symbol_sync_ff_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_ff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(symbol_sync_ff_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_ff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(symbol_sync_ff_sptr self) -> io_signature_sptr"""
        return _digital_swig2.symbol_sync_ff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(symbol_sync_ff_sptr self) -> io_signature_sptr"""
        return _digital_swig2.symbol_sync_ff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(symbol_sync_ff_sptr self) -> long"""
        return _digital_swig2.symbol_sync_ff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(symbol_sync_ff_sptr self) -> basic_block_sptr"""
        return _digital_swig2.symbol_sync_ff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(symbol_sync_ff_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig2.symbol_sync_ff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(symbol_sync_ff_sptr self) -> std::string"""
        return _digital_swig2.symbol_sync_ff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(symbol_sync_ff_sptr self, std::string name)"""
        return _digital_swig2.symbol_sync_ff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(symbol_sync_ff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig2.symbol_sync_ff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(symbol_sync_ff_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.symbol_sync_ff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(symbol_sync_ff_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.symbol_sync_ff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(symbol_sync_ff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig2.symbol_sync_ff_sptr_message_subscribers(self, which_port)

# Register symbol_sync_ff_sptr in _digital_swig2:
_digital_swig2.symbol_sync_ff_sptr_swigregister(symbol_sync_ff_sptr)

symbol_sync_ff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
symbol_sync_ff = symbol_sync_ff.make;

class packet_header_default_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::packet_header_default > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(packet_header_default_sptr self) -> packet_header_default_sptr
        __init__(packet_header_default_sptr self, packet_header_default p) -> packet_header_default_sptr
        """
        _digital_swig2.packet_header_default_sptr_swiginit(self, _digital_swig2.new_packet_header_default_sptr(*args))

    def __deref__(self) -> "gr::digital::packet_header_default *":
        r"""__deref__(packet_header_default_sptr self) -> packet_header_default"""
        return _digital_swig2.packet_header_default_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_packet_header_default_sptr

    def base(self) -> "gr::digital::packet_header_default::sptr":
        r"""base(packet_header_default_sptr self) -> packet_header_default_sptr"""
        return _digital_swig2.packet_header_default_sptr_base(self)

    def formatter(self) -> "gr::digital::packet_header_default::sptr":
        r"""formatter(packet_header_default_sptr self) -> packet_header_default_sptr"""
        return _digital_swig2.packet_header_default_sptr_formatter(self)

    def set_header_num(self, header_num: "unsigned int") -> "void":
        r"""set_header_num(packet_header_default_sptr self, unsigned int header_num)"""
        return _digital_swig2.packet_header_default_sptr_set_header_num(self, header_num)

    def header_len(self) -> "long":
        r"""header_len(packet_header_default_sptr self) -> long"""
        return _digital_swig2.packet_header_default_sptr_header_len(self)

    def len_tag_key(self) -> "pmt::pmt_t":
        r"""len_tag_key(packet_header_default_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_header_default_sptr_len_tag_key(self)

    def header_formatter(self, *args, **kwargs) -> "bool":
        r"""
        header_formatter(packet_header_default_sptr self, long packet_len, unsigned char * out, tags_vector_t tags=std::vector< gr::tag_t >()) -> bool
        Encodes the header information in the given tags into bits and places them into .

        Uses the following header format: Bits 0-11: The packet length (what was stored in the tag with key ) Bits 12-23: The header number (counts up every time this function is called) Bit 24-31: 8-Bit CRC All other bits: Are set to zero


        If the header length is smaller than 32, bits are simply left out. For this reason, they always start with the LSB.


        However, it is recommended to stay above 32 Bits, in order to have a working CRC.
        """
        return _digital_swig2.packet_header_default_sptr_header_formatter(self, *args, **kwargs)

    def header_parser(self, header: "unsigned char const *", tags: "tags_vector_t") -> "bool":
        r"""
        header_parser(packet_header_default_sptr self, unsigned char const * header, tags_vector_t tags) -> bool
        Inverse function to header_formatter().

        Reads the bit stream in  and writes a corresponding tag into .
        """
        return _digital_swig2.packet_header_default_sptr_header_parser(self, header, tags)

    def make(self, *args, **kwargs) -> "gr::digital::packet_header_default::sptr":
        r"""
        make(packet_header_default_sptr self, long header_len, std::string const & len_tag_key="packet_len", std::string const & num_tag_key="packet_num", int bits_per_byte=1) -> packet_header_default_sptr
        Default header formatter for digital packet transmission.

        For bursty/packetized digital transmission, packets are usually prepended with a packet header, containing the number of bytes etc. This class is not a block, but a tool to create these packet header.


        This is a default packet header (see header_formatter()) for a description on the header format). To create other header, derive packet header creator classes from this function.


        gr::digital::packet_headergenerator_bb uses header generators derived from this class to create packet headers from data streams.

        Constructor Specific Documentation:



        Args:
            header_len : 
            len_tag_key : 
            num_tag_key : 
            bits_per_byte : 
        """
        return _digital_swig2.packet_header_default_sptr_make(self, *args, **kwargs)

# Register packet_header_default_sptr in _digital_swig2:
_digital_swig2.packet_header_default_sptr_swigregister(packet_header_default_sptr)

packet_header_default_sptr.__repr__ = lambda self: "<packet_header_default>"
packet_header_default = packet_header_default .make;

class packet_header_ofdm_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::packet_header_ofdm > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(packet_header_ofdm_sptr self) -> packet_header_ofdm_sptr
        __init__(packet_header_ofdm_sptr self, packet_header_ofdm p) -> packet_header_ofdm_sptr
        """
        _digital_swig2.packet_header_ofdm_sptr_swiginit(self, _digital_swig2.new_packet_header_ofdm_sptr(*args))

    def __deref__(self) -> "gr::digital::packet_header_ofdm *":
        r"""__deref__(packet_header_ofdm_sptr self) -> packet_header_ofdm"""
        return _digital_swig2.packet_header_ofdm_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_packet_header_ofdm_sptr

    def make(self, *args, **kwargs) -> "gr::digital::packet_header_ofdm::sptr":
        r"""
        make(packet_header_ofdm_sptr self, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, int n_syms, std::string const & len_tag_key="packet_len", std::string const & frame_len_tag_key="frame_len", std::string const & num_tag_key="packet_num", int bits_per_header_sym=1, int bits_per_payload_sym=1, bool scramble_header=False) -> packet_header_ofdm_sptr
        Header utility for OFDM signals.

        Constructor Specific Documentation:



        Args:
            occupied_carriers : See carrier allocator
            n_syms : The number of OFDM symbols the header should be (usually 1)
            len_tag_key : The tag key used for the packet length (number of bytes)
            frame_len_tag_key : The tag key used for the frame length (number of OFDM symbols, this is the tag key required for the frame equalizer etc.)
            num_tag_key : The tag key used for packet numbering.
            bits_per_header_sym : Bits per complex symbol in the header, e.g. 1 if the header is BPSK modulated, 2 if it's QPSK modulated etc.
            bits_per_payload_sym : Bits per complex symbol in the payload. This is required to figure out how many OFDM symbols are necessary to encode the given number of bytes.
            scramble_header : Set this to true to scramble the bits. This is highly recommended, as it reduces PAPR spikes.
        """
        return _digital_swig2.packet_header_ofdm_sptr_make(self, *args, **kwargs)

    def base(self) -> "gr::digital::packet_header_default::sptr":
        r"""base(packet_header_ofdm_sptr self) -> packet_header_default_sptr"""
        return _digital_swig2.packet_header_ofdm_sptr_base(self)

    def formatter(self) -> "gr::digital::packet_header_default::sptr":
        r"""formatter(packet_header_ofdm_sptr self) -> packet_header_default_sptr"""
        return _digital_swig2.packet_header_ofdm_sptr_formatter(self)

    def set_header_num(self, header_num: "unsigned int") -> "void":
        r"""set_header_num(packet_header_ofdm_sptr self, unsigned int header_num)"""
        return _digital_swig2.packet_header_ofdm_sptr_set_header_num(self, header_num)

    def header_len(self) -> "long":
        r"""header_len(packet_header_ofdm_sptr self) -> long"""
        return _digital_swig2.packet_header_ofdm_sptr_header_len(self)

    def len_tag_key(self) -> "pmt::pmt_t":
        r"""len_tag_key(packet_header_ofdm_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.packet_header_ofdm_sptr_len_tag_key(self)

    def header_formatter(self, *args, **kwargs) -> "bool":
        r"""
        header_formatter(packet_header_ofdm_sptr self, long packet_len, unsigned char * out, tags_vector_t tags=std::vector< gr::tag_t >()) -> bool
        Encodes the header information in the given tags into bits and places them into .

        Uses the following header format: Bits 0-11: The packet length (what was stored in the tag with key ) Bits 12-23: The header number (counts up every time this function is called) Bit 24-31: 8-Bit CRC All other bits: Are set to zero


        If the header length is smaller than 32, bits are simply left out. For this reason, they always start with the LSB.


        However, it is recommended to stay above 32 Bits, in order to have a working CRC.
        """
        return _digital_swig2.packet_header_ofdm_sptr_header_formatter(self, *args, **kwargs)

    def header_parser(self, header: "unsigned char const *", tags: "tags_vector_t") -> "bool":
        r"""
        header_parser(packet_header_ofdm_sptr self, unsigned char const * header, tags_vector_t tags) -> bool
        Inverse function to header_formatter().

        Reads the bit stream in  and writes a corresponding tag into .
        """
        return _digital_swig2.packet_header_ofdm_sptr_header_parser(self, header, tags)

# Register packet_header_ofdm_sptr in _digital_swig2:
_digital_swig2.packet_header_ofdm_sptr_swigregister(packet_header_ofdm_sptr)

packet_header_ofdm_sptr.__repr__ = lambda self: "<packet_header_ofdm>"
packet_header_ofdm = packet_header_ofdm .make;

class header_format_base_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::header_format_base > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(header_format_base_sptr self) -> header_format_base_sptr
        __init__(header_format_base_sptr self, header_format_base p) -> header_format_base_sptr
        """
        _digital_swig2.header_format_base_sptr_swiginit(self, _digital_swig2.new_header_format_base_sptr(*args))

    def __deref__(self) -> "gr::digital::header_format_base *":
        r"""__deref__(header_format_base_sptr self) -> header_format_base"""
        return _digital_swig2.header_format_base_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_header_format_base_sptr

    def base(self) -> "gr::digital::header_format_base::sptr":
        r"""base(header_format_base_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_base_sptr_base(self)

    def formatter(self) -> "gr::digital::header_format_base::sptr":
        r"""formatter(header_format_base_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_base_sptr_formatter(self)

    def format(self, nbytes_in: "int", input: "unsigned char const *", output: "swig_pmt_ptr", info: "swig_pmt_ptr") -> "bool":
        r"""
        format(header_format_base_sptr self, int nbytes_in, unsigned char const * input, swig_pmt_ptr output, swig_pmt_ptr info) -> bool
        Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_base_sptr_format(self, nbytes_in, input, output, info)

    def parse(self, nbits_in: "int", input: "unsigned char const *", info: "std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > &", nbits_processed: "int &") -> "bool":
        r"""
        parse(header_format_base_sptr self, int nbits_in, unsigned char const * input, std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > & info, int & nbits_processed) -> bool
        Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_base_sptr_parse(self, nbits_in, input, info, nbits_processed)

    def header_nbits(self) -> "size_t":
        r"""
        header_nbits(header_format_base_sptr self) -> size_t
        Returns the length of the formatted header in bits. MUST be overloaded.
        """
        return _digital_swig2.header_format_base_sptr_header_nbits(self)

    def header_nbytes(self) -> "size_t":
        r"""
        header_nbytes(header_format_base_sptr self) -> size_t
        Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().
        """
        return _digital_swig2.header_format_base_sptr_header_nbytes(self)

# Register header_format_base_sptr in _digital_swig2:
_digital_swig2.header_format_base_sptr_swigregister(header_format_base_sptr)
class header_format_default_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::header_format_default > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(header_format_default_sptr self) -> header_format_default_sptr
        __init__(header_format_default_sptr self, header_format_default p) -> header_format_default_sptr
        """
        _digital_swig2.header_format_default_sptr_swiginit(self, _digital_swig2.new_header_format_default_sptr(*args))

    def __deref__(self) -> "gr::digital::header_format_default *":
        r"""__deref__(header_format_default_sptr self) -> header_format_default"""
        return _digital_swig2.header_format_default_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_header_format_default_sptr

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""
        set_access_code(header_format_default_sptr self, std::string const & access_code) -> bool
        Updates the access code. Must be a string of 1's and 0's and <= 64 bits.
        """
        return _digital_swig2.header_format_default_sptr_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""
        access_code(header_format_default_sptr self) -> unsigned long long
        Returns the formatted access code as a 64-bit register.
        """
        return _digital_swig2.header_format_default_sptr_access_code(self)

    def set_threshold(self, thresh: "unsigned int"=0) -> "void":
        r"""
        set_threshold(header_format_default_sptr self, unsigned int thresh=0)
        Sets the threshold for number of access code bits can be in error before detection. Defaults to 0.
        """
        return _digital_swig2.header_format_default_sptr_set_threshold(self, thresh)

    def threshold(self) -> "unsigned int":
        r"""
        threshold(header_format_default_sptr self) -> unsigned int
        Returns threshold value for access code detection.
        """
        return _digital_swig2.header_format_default_sptr_threshold(self)

    def make(self, access_code: "std::string const &", threshold: "int", bps: "int"=1) -> "gr::digital::header_format_base::sptr":
        r"""
        make(header_format_default_sptr self, std::string const & access_code, int threshold, int bps=1) -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_default_sptr_make(self, access_code, threshold, bps)

    def base(self) -> "gr::digital::header_format_base::sptr":
        r"""base(header_format_default_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_default_sptr_base(self)

    def formatter(self) -> "gr::digital::header_format_base::sptr":
        r"""formatter(header_format_default_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_default_sptr_formatter(self)

    def format(self, nbytes_in: "int", input: "unsigned char const *", output: "swig_pmt_ptr", info: "swig_pmt_ptr") -> "bool":
        r"""
        format(header_format_default_sptr self, int nbytes_in, unsigned char const * input, swig_pmt_ptr output, swig_pmt_ptr info) -> bool
        Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_default_sptr_format(self, nbytes_in, input, output, info)

    def parse(self, nbits_in: "int", input: "unsigned char const *", info: "std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > &", nbits_processed: "int &") -> "bool":
        r"""
        parse(header_format_default_sptr self, int nbits_in, unsigned char const * input, std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > & info, int & nbits_processed) -> bool
        Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_default_sptr_parse(self, nbits_in, input, info, nbits_processed)

    def header_nbits(self) -> "size_t":
        r"""
        header_nbits(header_format_default_sptr self) -> size_t
        Returns the length of the formatted header in bits. MUST be overloaded.
        """
        return _digital_swig2.header_format_default_sptr_header_nbits(self)

    def header_nbytes(self) -> "size_t":
        r"""
        header_nbytes(header_format_default_sptr self) -> size_t
        Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().
        """
        return _digital_swig2.header_format_default_sptr_header_nbytes(self)

# Register header_format_default_sptr in _digital_swig2:
_digital_swig2.header_format_default_sptr_swigregister(header_format_default_sptr)

header_format_default_sptr.__repr__ = lambda self: "<header_format_default>"
header_format_default = header_format_default .make;

class header_format_counter_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::header_format_counter > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(header_format_counter_sptr self) -> header_format_counter_sptr
        __init__(header_format_counter_sptr self, header_format_counter p) -> header_format_counter_sptr
        """
        _digital_swig2.header_format_counter_sptr_swiginit(self, _digital_swig2.new_header_format_counter_sptr(*args))

    def __deref__(self) -> "gr::digital::header_format_counter *":
        r"""__deref__(header_format_counter_sptr self) -> header_format_counter"""
        return _digital_swig2.header_format_counter_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_header_format_counter_sptr

    def make(self, access_code: "std::string const &", threshold: "int", bps: "int") -> "gr::digital::header_format_base::sptr":
        r"""
        make(header_format_counter_sptr self, std::string const & access_code, int threshold, int bps) -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_counter_sptr_make(self, access_code, threshold, bps)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""
        set_access_code(header_format_counter_sptr self, std::string const & access_code) -> bool
        Updates the access code. Must be a string of 1's and 0's and <= 64 bits.
        """
        return _digital_swig2.header_format_counter_sptr_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""
        access_code(header_format_counter_sptr self) -> unsigned long long
        Returns the formatted access code as a 64-bit register.
        """
        return _digital_swig2.header_format_counter_sptr_access_code(self)

    def set_threshold(self, thresh: "unsigned int"=0) -> "void":
        r"""
        set_threshold(header_format_counter_sptr self, unsigned int thresh=0)
        Sets the threshold for number of access code bits can be in error before detection. Defaults to 0.
        """
        return _digital_swig2.header_format_counter_sptr_set_threshold(self, thresh)

    def threshold(self) -> "unsigned int":
        r"""
        threshold(header_format_counter_sptr self) -> unsigned int
        Returns threshold value for access code detection.
        """
        return _digital_swig2.header_format_counter_sptr_threshold(self)

    def base(self) -> "gr::digital::header_format_base::sptr":
        r"""base(header_format_counter_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_counter_sptr_base(self)

    def formatter(self) -> "gr::digital::header_format_base::sptr":
        r"""formatter(header_format_counter_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_counter_sptr_formatter(self)

    def format(self, nbytes_in: "int", input: "unsigned char const *", output: "swig_pmt_ptr", info: "swig_pmt_ptr") -> "bool":
        r"""
        format(header_format_counter_sptr self, int nbytes_in, unsigned char const * input, swig_pmt_ptr output, swig_pmt_ptr info) -> bool
        Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_counter_sptr_format(self, nbytes_in, input, output, info)

    def parse(self, nbits_in: "int", input: "unsigned char const *", info: "std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > &", nbits_processed: "int &") -> "bool":
        r"""
        parse(header_format_counter_sptr self, int nbits_in, unsigned char const * input, std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > & info, int & nbits_processed) -> bool
        Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_counter_sptr_parse(self, nbits_in, input, info, nbits_processed)

    def header_nbits(self) -> "size_t":
        r"""
        header_nbits(header_format_counter_sptr self) -> size_t
        Returns the length of the formatted header in bits. MUST be overloaded.
        """
        return _digital_swig2.header_format_counter_sptr_header_nbits(self)

    def header_nbytes(self) -> "size_t":
        r"""
        header_nbytes(header_format_counter_sptr self) -> size_t
        Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().
        """
        return _digital_swig2.header_format_counter_sptr_header_nbytes(self)

# Register header_format_counter_sptr in _digital_swig2:
_digital_swig2.header_format_counter_sptr_swigregister(header_format_counter_sptr)

header_format_counter_sptr.__repr__ = lambda self: "<header_format_counter>"
header_format_counter = header_format_counter .make;

class header_format_crc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::header_format_crc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(header_format_crc_sptr self) -> header_format_crc_sptr
        __init__(header_format_crc_sptr self, header_format_crc p) -> header_format_crc_sptr
        """
        _digital_swig2.header_format_crc_sptr_swiginit(self, _digital_swig2.new_header_format_crc_sptr(*args))

    def __deref__(self) -> "gr::digital::header_format_crc *":
        r"""__deref__(header_format_crc_sptr self) -> header_format_crc"""
        return _digital_swig2.header_format_crc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_header_format_crc_sptr

    def set_header_num(self, header_num: "unsigned int") -> "void":
        r"""set_header_num(header_format_crc_sptr self, unsigned int header_num)"""
        return _digital_swig2.header_format_crc_sptr_set_header_num(self, header_num)

    def make(self, *args, **kwargs) -> "gr::digital::header_format_base::sptr":
        r"""
        make(header_format_crc_sptr self, std::string const & len_key_name="packet_len", std::string const & num_key_name="packet_num") -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_crc_sptr_make(self, *args, **kwargs)

    def base(self) -> "gr::digital::header_format_base::sptr":
        r"""base(header_format_crc_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_crc_sptr_base(self)

    def formatter(self) -> "gr::digital::header_format_base::sptr":
        r"""formatter(header_format_crc_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_crc_sptr_formatter(self)

    def format(self, nbytes_in: "int", input: "unsigned char const *", output: "swig_pmt_ptr", info: "swig_pmt_ptr") -> "bool":
        r"""
        format(header_format_crc_sptr self, int nbytes_in, unsigned char const * input, swig_pmt_ptr output, swig_pmt_ptr info) -> bool
        Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_crc_sptr_format(self, nbytes_in, input, output, info)

    def parse(self, nbits_in: "int", input: "unsigned char const *", info: "std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > &", nbits_processed: "int &") -> "bool":
        r"""
        parse(header_format_crc_sptr self, int nbits_in, unsigned char const * input, std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > & info, int & nbits_processed) -> bool
        Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_crc_sptr_parse(self, nbits_in, input, info, nbits_processed)

    def header_nbits(self) -> "size_t":
        r"""
        header_nbits(header_format_crc_sptr self) -> size_t
        Returns the length of the formatted header in bits. MUST be overloaded.
        """
        return _digital_swig2.header_format_crc_sptr_header_nbits(self)

    def header_nbytes(self) -> "size_t":
        r"""
        header_nbytes(header_format_crc_sptr self) -> size_t
        Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().
        """
        return _digital_swig2.header_format_crc_sptr_header_nbytes(self)

# Register header_format_crc_sptr in _digital_swig2:
_digital_swig2.header_format_crc_sptr_swigregister(header_format_crc_sptr)

header_format_crc_sptr.__repr__ = lambda self: "<header_format_crc>"
header_format_crc = header_format_crc .make;

class header_format_ofdm_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::header_format_ofdm > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(header_format_ofdm_sptr self) -> header_format_ofdm_sptr
        __init__(header_format_ofdm_sptr self, header_format_ofdm p) -> header_format_ofdm_sptr
        """
        _digital_swig2.header_format_ofdm_sptr_swiginit(self, _digital_swig2.new_header_format_ofdm_sptr(*args))

    def __deref__(self) -> "gr::digital::header_format_ofdm *":
        r"""__deref__(header_format_ofdm_sptr self) -> header_format_ofdm"""
        return _digital_swig2.header_format_ofdm_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_header_format_ofdm_sptr

    def make(self, *args, **kwargs) -> "gr::digital::header_format_base::sptr":
        r"""
        make(header_format_ofdm_sptr self, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, int n_syms, std::string const & len_key_name="packet_len", std::string const & frame_key_name="frame_len", std::string const & num_key_name="packet_num", int bits_per_header_sym=1, int bits_per_payload_sym=1, bool scramble_header=False) -> header_format_base_sptr
        Factory to create an async packet header formatter; returns an sptr to the object.
        """
        return _digital_swig2.header_format_ofdm_sptr_make(self, *args, **kwargs)

    def set_header_num(self, header_num: "unsigned int") -> "void":
        r"""set_header_num(header_format_ofdm_sptr self, unsigned int header_num)"""
        return _digital_swig2.header_format_ofdm_sptr_set_header_num(self, header_num)

    def base(self) -> "gr::digital::header_format_base::sptr":
        r"""base(header_format_ofdm_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_ofdm_sptr_base(self)

    def formatter(self) -> "gr::digital::header_format_base::sptr":
        r"""formatter(header_format_ofdm_sptr self) -> header_format_base_sptr"""
        return _digital_swig2.header_format_ofdm_sptr_formatter(self)

    def format(self, nbytes_in: "int", input: "unsigned char const *", output: "swig_pmt_ptr", info: "swig_pmt_ptr") -> "bool":
        r"""
        format(header_format_ofdm_sptr self, int nbytes_in, unsigned char const * input, swig_pmt_ptr output, swig_pmt_ptr info) -> bool
        Function to creates a header. The child classes overload this function to format the header in the protocol-specific way.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_ofdm_sptr_format(self, nbytes_in, input, output, info)

    def parse(self, nbits_in: "int", input: "unsigned char const *", info: "std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > &", nbits_processed: "int &") -> "bool":
        r"""
        parse(header_format_ofdm_sptr self, int nbits_in, unsigned char const * input, std::vector< pmt::pmt_t,std::allocator< pmt::pmt_t > > & info, int & nbits_processed) -> bool
        Parses a header. This function is overloaded in the child class, which knows how to convert the incoming hard bits (0's and 1's) back into a packet header.



        MUST be overloaded.
        """
        return _digital_swig2.header_format_ofdm_sptr_parse(self, nbits_in, input, info, nbits_processed)

    def header_nbits(self) -> "size_t":
        r"""
        header_nbits(header_format_ofdm_sptr self) -> size_t
        Returns the length of the formatted header in bits. MUST be overloaded.
        """
        return _digital_swig2.header_format_ofdm_sptr_header_nbits(self)

    def header_nbytes(self) -> "size_t":
        r"""
        header_nbytes(header_format_ofdm_sptr self) -> size_t
        Returns the length of the formatted header in bytes. Auto-calculated from the overloaded header_nbits().
        """
        return _digital_swig2.header_format_ofdm_sptr_header_nbytes(self)

# Register header_format_ofdm_sptr in _digital_swig2:
_digital_swig2.header_format_ofdm_sptr_swigregister(header_format_ofdm_sptr)

header_format_ofdm_sptr.__repr__ = lambda self: "<header_format_ofdm>"
header_format_ofdm = header_format_ofdm .make;

class constellation_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_sptr self) -> constellation_sptr
        __init__(constellation_sptr self, constellation p) -> constellation_sptr
        """
        _digital_swig2.constellation_sptr_swiginit(self, _digital_swig2.new_constellation_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation *":
        r"""__deref__(constellation_sptr self) -> constellation"""
        return _digital_swig2.constellation_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_sptr

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_sptr_soft_decision_maker(self, sample)

# Register constellation_sptr in _digital_swig2:
_digital_swig2.constellation_sptr_swigregister(constellation_sptr)
class constellation_calcdist_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_calcdist > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_calcdist_sptr self) -> constellation_calcdist_sptr
        __init__(constellation_calcdist_sptr self, constellation_calcdist p) -> constellation_calcdist_sptr
        """
        _digital_swig2.constellation_calcdist_sptr_swiginit(self, _digital_swig2.new_constellation_calcdist_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_calcdist *":
        r"""__deref__(constellation_calcdist_sptr self) -> constellation_calcdist"""
        return _digital_swig2.constellation_calcdist_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_calcdist_sptr

    def make(self, constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", dimensionality: "unsigned int", normalize_points: "bool"=True) -> "gr::digital::constellation_calcdist::sptr":
        r"""
        make(constellation_calcdist_sptr self, pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int dimensionality, bool normalize_points=True) -> constellation_calcdist_sptr
        Calculate Euclidean distance for any constellation.

        Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

        Constructor Specific Documentation:

        Make a general constellation object that calculates the Euclidean distance for hard decisions.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            dimensionality : Number of dimensions to the constellation.
            normalize_points : Normalize constellation points to mean(abs(points))=1 (default is true)
        """
        return _digital_swig2.constellation_calcdist_sptr_make(self, constell, pre_diff_code, rotational_symmetry, dimensionality, normalize_points)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_calcdist_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_calcdist_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_calcdist_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_calcdist_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_calcdist_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_calcdist_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_calcdist_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_calcdist_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_calcdist_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_calcdist_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_calcdist_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_calcdist_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_calcdist_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_calcdist_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_calcdist_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_calcdist_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_calcdist_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_calcdist_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_calcdist_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_calcdist_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_calcdist_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_calcdist_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_calcdist_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_calcdist_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_calcdist_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_calcdist_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_calcdist_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_calcdist_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_calcdist_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_calcdist_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_calcdist_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_calcdist_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_calcdist_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_calcdist_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_calcdist_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_calcdist_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_calcdist_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_calcdist_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_calcdist_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_calcdist_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_calcdist_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_calcdist_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_calcdist_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_calcdist_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_calcdist_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_calcdist_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_calcdist_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_calcdist_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_calcdist_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_calcdist_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_calcdist_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_calcdist_sptr_soft_decision_maker(self, sample)

# Register constellation_calcdist_sptr in _digital_swig2:
_digital_swig2.constellation_calcdist_sptr_swigregister(constellation_calcdist_sptr)

constellation_calcdist_sptr.__repr__ = lambda self: "<constellation calcdist (m=%d)>" % (len(self.points()))
constellation_calcdist = constellation_calcdist.make;

class constellation_rect_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_rect > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_rect_sptr self) -> constellation_rect_sptr
        __init__(constellation_rect_sptr self, constellation_rect p) -> constellation_rect_sptr
        """
        _digital_swig2.constellation_rect_sptr_swiginit(self, _digital_swig2.new_constellation_rect_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_rect *":
        r"""__deref__(constellation_rect_sptr self) -> constellation_rect"""
        return _digital_swig2.constellation_rect_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_rect_sptr

    def make(self, constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float") -> "gr::digital::constellation_rect::sptr":
        r"""
        make(constellation_rect_sptr self, pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors) -> constellation_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        Works well for square QAM.


        Works for any generic constellation provided sectors are not too large.

        Constructor Specific Documentation:

        Make a rectangular constellation object.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            real_sectors : Number of sectors the real axis is split in to.
            imag_sectors : Number of sectors the imag axis is split in to.
            width_real_sectors : width of each real sector to calculate decision boundaries.
            width_imag_sectors : width of each imag sector to calculate decision boundaries.
        """
        return _digital_swig2.constellation_rect_sptr_make(self, constell, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_rect_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_rect_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_rect_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_rect_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_rect_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_rect_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_rect_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_rect_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_rect_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_rect_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_rect_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_rect_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_rect_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_rect_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_rect_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_rect_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_rect_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_rect_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_rect_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_rect_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_rect_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_rect_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_rect_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_rect_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_rect_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_rect_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_rect_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_rect_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_rect_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_rect_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_rect_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_rect_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_rect_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_rect_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_rect_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_rect_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_rect_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_rect_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_rect_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_rect_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_rect_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_rect_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_rect_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_rect_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_rect_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_rect_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_rect_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_rect_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_rect_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_rect_sptr_soft_decision_maker(self, sample)

# Register constellation_rect_sptr in _digital_swig2:
_digital_swig2.constellation_rect_sptr_swigregister(constellation_rect_sptr)

constellation_rect_sptr.__repr__ = lambda self: "<constellation rect (m=%d)>" % (len(self.points()))
constellation_rect = constellation_rect.make;

class constellation_expl_rect_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_expl_rect > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_expl_rect_sptr self) -> constellation_expl_rect_sptr
        __init__(constellation_expl_rect_sptr self, constellation_expl_rect p) -> constellation_expl_rect_sptr
        """
        _digital_swig2.constellation_expl_rect_sptr_swiginit(self, _digital_swig2.new_constellation_expl_rect_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_expl_rect *":
        r"""__deref__(constellation_expl_rect_sptr self) -> constellation_expl_rect"""
        return _digital_swig2.constellation_expl_rect_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_expl_rect_sptr

    def make(self, constellation: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float", sector_values: "std::vector< unsigned int,std::allocator< unsigned int > >") -> "gr::digital::constellation_expl_rect::sptr":
        r"""
        make(constellation_expl_rect_sptr self, pmt_vector_cfloat constellation, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors, std::vector< unsigned int,std::allocator< unsigned int > > sector_values) -> constellation_expl_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

        Constructor Specific Documentation:



        Args:
            constellation : 
            pre_diff_code : 
            rotational_symmetry : 
            real_sectors : 
            imag_sectors : 
            width_real_sectors : 
            width_imag_sectors : 
            sector_values : 
        """
        return _digital_swig2.constellation_expl_rect_sptr_make(self, constellation, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors, sector_values)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_expl_rect_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_expl_rect_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_expl_rect_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_expl_rect_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_expl_rect_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_expl_rect_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_expl_rect_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_expl_rect_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_expl_rect_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_expl_rect_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_expl_rect_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_expl_rect_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_expl_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_expl_rect_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_expl_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_expl_rect_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_expl_rect_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_expl_rect_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_expl_rect_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_expl_rect_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_expl_rect_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_expl_rect_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_expl_rect_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_expl_rect_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_expl_rect_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_expl_rect_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_expl_rect_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_expl_rect_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_expl_rect_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_expl_rect_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_expl_rect_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_expl_rect_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_expl_rect_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_expl_rect_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_expl_rect_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_expl_rect_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_expl_rect_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_expl_rect_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_expl_rect_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_expl_rect_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_expl_rect_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_expl_rect_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_expl_rect_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_expl_rect_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_expl_rect_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_expl_rect_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_expl_rect_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_expl_rect_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_expl_rect_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_expl_rect_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_expl_rect_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_expl_rect_sptr_soft_decision_maker(self, sample)

# Register constellation_expl_rect_sptr in _digital_swig2:
_digital_swig2.constellation_expl_rect_sptr_swigregister(constellation_expl_rect_sptr)

constellation_expl_rect_sptr.__repr__ = lambda self: "<constellation expl rect (m=%d)>" % (len(self.points()))
constellation_expl_rect = constellation_expl_rect.make;

class constellation_psk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_psk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_psk_sptr self) -> constellation_psk_sptr
        __init__(constellation_psk_sptr self, constellation_psk p) -> constellation_psk_sptr
        """
        _digital_swig2.constellation_psk_sptr_swiginit(self, _digital_swig2.new_constellation_psk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_psk *":
        r"""__deref__(constellation_psk_sptr self) -> constellation_psk"""
        return _digital_swig2.constellation_psk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_psk_sptr

    def make(self, constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", n_sectors: "unsigned int") -> "gr::digital::constellation_psk::sptr":
        r"""
        make(constellation_psk_sptr self, pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int n_sectors) -> constellation_psk_sptr
        constellation_psk

        Constellation space is divided into pie slices sectors.


        Each slice is associated with the nearest constellation point.


        Works well for PSK but nothing else.


        Assumes that there is a constellation point at 1.x

        Constructor Specific Documentation:



        Args:
            constell : 
            pre_diff_code : 
            n_sectors : 
        """
        return _digital_swig2.constellation_psk_sptr_make(self, constell, pre_diff_code, n_sectors)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_psk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_psk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_psk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_psk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_psk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_psk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_psk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_psk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_psk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_psk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_psk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_psk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_psk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_psk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_psk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_psk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_psk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_psk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_psk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_psk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_psk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_psk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_psk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_psk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_psk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_psk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_psk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_psk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_psk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_psk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_psk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_psk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_psk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_psk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_psk_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_psk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_psk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_psk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_psk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_psk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_psk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_psk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_psk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_psk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_psk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_psk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_psk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_psk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_psk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_psk_sptr_soft_decision_maker(self, sample)

# Register constellation_psk_sptr in _digital_swig2:
_digital_swig2.constellation_psk_sptr_swigregister(constellation_psk_sptr)

constellation_psk_sptr.__repr__ = lambda self: "<constellation PSK (m=%d)>" % (len(self.points()))
constellation_psk = constellation_psk.make;

class constellation_bpsk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_bpsk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_bpsk_sptr self) -> constellation_bpsk_sptr
        __init__(constellation_bpsk_sptr self, constellation_bpsk p) -> constellation_bpsk_sptr
        """
        _digital_swig2.constellation_bpsk_sptr_swiginit(self, _digital_swig2.new_constellation_bpsk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_bpsk *":
        r"""__deref__(constellation_bpsk_sptr self) -> constellation_bpsk"""
        return _digital_swig2.constellation_bpsk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_bpsk_sptr

    def make(self) -> "gr::digital::constellation_bpsk::sptr":
        r"""
        make(constellation_bpsk_sptr self) -> constellation_bpsk_sptr
        Digital constellation for BPSK .

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_bpsk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_bpsk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_bpsk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_bpsk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_bpsk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_bpsk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_bpsk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_bpsk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_bpsk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_bpsk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_bpsk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_bpsk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_bpsk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_bpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_bpsk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_bpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_bpsk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_bpsk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_bpsk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_bpsk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_bpsk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_bpsk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_bpsk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_bpsk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_bpsk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_bpsk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_bpsk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_bpsk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_bpsk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_bpsk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_bpsk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_bpsk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_bpsk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_bpsk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_bpsk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_bpsk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_bpsk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_bpsk_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_bpsk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_bpsk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_bpsk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_bpsk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_bpsk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_bpsk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_bpsk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_bpsk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_bpsk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_bpsk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_bpsk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_bpsk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_bpsk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_bpsk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_bpsk_sptr_soft_decision_maker(self, sample)

# Register constellation_bpsk_sptr in _digital_swig2:
_digital_swig2.constellation_bpsk_sptr_swigregister(constellation_bpsk_sptr)

constellation_bpsk_sptr.__repr__ = lambda self: "<constellation BPSK>"
constellation_bpsk = constellation_bpsk.make;

class constellation_qpsk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_qpsk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_qpsk_sptr self) -> constellation_qpsk_sptr
        __init__(constellation_qpsk_sptr self, constellation_qpsk p) -> constellation_qpsk_sptr
        """
        _digital_swig2.constellation_qpsk_sptr_swiginit(self, _digital_swig2.new_constellation_qpsk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_qpsk *":
        r"""__deref__(constellation_qpsk_sptr self) -> constellation_qpsk"""
        return _digital_swig2.constellation_qpsk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_qpsk_sptr

    def make(self) -> "gr::digital::constellation_qpsk::sptr":
        r"""
        make(constellation_qpsk_sptr self) -> constellation_qpsk_sptr
        Digital constellation for QPSK.

        Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_qpsk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_qpsk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_qpsk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_qpsk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_qpsk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_qpsk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_qpsk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_qpsk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_qpsk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_qpsk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_qpsk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_qpsk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_qpsk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_qpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_qpsk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_qpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_qpsk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_qpsk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_qpsk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_qpsk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_qpsk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_qpsk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_qpsk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_qpsk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_qpsk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_qpsk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_qpsk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_qpsk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_qpsk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_qpsk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_qpsk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_qpsk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_qpsk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_qpsk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_qpsk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_qpsk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_qpsk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_qpsk_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_qpsk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_qpsk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_qpsk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_qpsk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_qpsk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_qpsk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_qpsk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_qpsk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_qpsk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_qpsk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_qpsk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_qpsk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_qpsk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_qpsk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_qpsk_sptr_soft_decision_maker(self, sample)

# Register constellation_qpsk_sptr in _digital_swig2:
_digital_swig2.constellation_qpsk_sptr_swigregister(constellation_qpsk_sptr)

constellation_qpsk_sptr.__repr__ = lambda self: "<constellation QPSK>"
constellation_qpsk = constellation_qpsk.make;

class constellation_dqpsk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_dqpsk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_dqpsk_sptr self) -> constellation_dqpsk_sptr
        __init__(constellation_dqpsk_sptr self, constellation_dqpsk p) -> constellation_dqpsk_sptr
        """
        _digital_swig2.constellation_dqpsk_sptr_swiginit(self, _digital_swig2.new_constellation_dqpsk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_dqpsk *":
        r"""__deref__(constellation_dqpsk_sptr self) -> constellation_dqpsk"""
        return _digital_swig2.constellation_dqpsk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_dqpsk_sptr

    def make(self) -> "gr::digital::constellation_dqpsk::sptr":
        r"""
        make(constellation_dqpsk_sptr self) -> constellation_dqpsk_sptr
        Digital constellation for DQPSK.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_dqpsk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_dqpsk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_dqpsk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_dqpsk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_dqpsk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_dqpsk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_dqpsk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_dqpsk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_dqpsk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_dqpsk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_dqpsk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_dqpsk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_dqpsk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_dqpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_dqpsk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_dqpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_dqpsk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_dqpsk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_dqpsk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_dqpsk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_dqpsk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_dqpsk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_dqpsk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_dqpsk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_dqpsk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_dqpsk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_dqpsk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_dqpsk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_dqpsk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_dqpsk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_dqpsk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_dqpsk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_dqpsk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_dqpsk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_dqpsk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_dqpsk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_dqpsk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_dqpsk_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_dqpsk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_dqpsk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_dqpsk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_dqpsk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_dqpsk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_dqpsk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_dqpsk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_dqpsk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_dqpsk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_dqpsk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_dqpsk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_dqpsk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_dqpsk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_dqpsk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_dqpsk_sptr_soft_decision_maker(self, sample)

# Register constellation_dqpsk_sptr in _digital_swig2:
_digital_swig2.constellation_dqpsk_sptr_swigregister(constellation_dqpsk_sptr)

constellation_dqpsk_sptr.__repr__ = lambda self: "<constellation DQPSK>"
constellation_dqpsk = constellation_dqpsk.make;

class constellation_8psk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_8psk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_8psk_sptr self) -> constellation_8psk_sptr
        __init__(constellation_8psk_sptr self, constellation_8psk p) -> constellation_8psk_sptr
        """
        _digital_swig2.constellation_8psk_sptr_swiginit(self, _digital_swig2.new_constellation_8psk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_8psk *":
        r"""__deref__(constellation_8psk_sptr self) -> constellation_8psk"""
        return _digital_swig2.constellation_8psk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_8psk_sptr

    def make(self) -> "gr::digital::constellation_8psk::sptr":
        r"""
        make(constellation_8psk_sptr self) -> constellation_8psk_sptr
        Digital constellation for 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_8psk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_8psk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_8psk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_8psk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_8psk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_8psk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_8psk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_8psk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_8psk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_8psk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_8psk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_8psk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_8psk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_8psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_8psk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_8psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_8psk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_8psk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_8psk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_8psk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_8psk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_8psk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_8psk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_8psk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_8psk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_8psk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_8psk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_8psk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_8psk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_8psk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_8psk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_8psk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_8psk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_8psk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_8psk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_8psk_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_8psk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_8psk_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_8psk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_8psk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_8psk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_8psk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_8psk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_8psk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_8psk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_8psk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_8psk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_8psk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_8psk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_8psk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_8psk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_8psk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_8psk_sptr_soft_decision_maker(self, sample)

# Register constellation_8psk_sptr in _digital_swig2:
_digital_swig2.constellation_8psk_sptr_swigregister(constellation_8psk_sptr)

constellation_8psk_sptr.__repr__ = lambda self: "<constellation 8PSK>"
constellation_8psk = constellation_8psk.make;

class constellation_8psk_natural_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_8psk_natural > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_8psk_natural_sptr self) -> constellation_8psk_natural_sptr
        __init__(constellation_8psk_natural_sptr self, constellation_8psk_natural p) -> constellation_8psk_natural_sptr
        """
        _digital_swig2.constellation_8psk_natural_sptr_swiginit(self, _digital_swig2.new_constellation_8psk_natural_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_8psk_natural *":
        r"""__deref__(constellation_8psk_natural_sptr self) -> constellation_8psk_natural"""
        return _digital_swig2.constellation_8psk_natural_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_8psk_natural_sptr

    def make(self) -> "gr::digital::constellation_8psk_natural::sptr":
        r"""
        make(constellation_8psk_natural_sptr self) -> constellation_8psk_natural_sptr
        Digital constellation for natually mapped 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_8psk_natural_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_8psk_natural_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_8psk_natural_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_8psk_natural_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_8psk_natural_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_8psk_natural_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_8psk_natural_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_8psk_natural_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_8psk_natural_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_8psk_natural_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_8psk_natural_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_8psk_natural_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_8psk_natural_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_8psk_natural_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_8psk_natural_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_8psk_natural_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_8psk_natural_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_8psk_natural_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_8psk_natural_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_8psk_natural_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_8psk_natural_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_8psk_natural_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_8psk_natural_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_8psk_natural_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_8psk_natural_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_8psk_natural_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_8psk_natural_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_8psk_natural_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_8psk_natural_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_8psk_natural_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_8psk_natural_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_8psk_natural_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_8psk_natural_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_8psk_natural_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_8psk_natural_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_8psk_natural_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_8psk_natural_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_8psk_natural_sptr_soft_decision_maker(self, sample)

# Register constellation_8psk_natural_sptr in _digital_swig2:
_digital_swig2.constellation_8psk_natural_sptr_swigregister(constellation_8psk_natural_sptr)

constellation_8psk_natural_sptr.__repr__ = lambda self: "<constellation 8PSK_natural>"
constellation_8psk_natural = constellation_8psk_natural.make;

class constellation_16qam_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_16qam > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_16qam_sptr self) -> constellation_16qam_sptr
        __init__(constellation_16qam_sptr self, constellation_16qam p) -> constellation_16qam_sptr
        """
        _digital_swig2.constellation_16qam_sptr_swiginit(self, _digital_swig2.new_constellation_16qam_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_16qam *":
        r"""__deref__(constellation_16qam_sptr self) -> constellation_16qam"""
        return _digital_swig2.constellation_16qam_sptr___deref__(self)
    __swig_destroy__ = _digital_swig2.delete_constellation_16qam_sptr

    def make(self) -> "gr::digital::constellation_16qam::sptr":
        r"""
        make(constellation_16qam_sptr self) -> constellation_16qam_sptr
        Digital constellation for 16qam.

        Constructor Specific Documentation:


        """
        return _digital_swig2.constellation_16qam_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_16qam_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig2.constellation_16qam_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_16qam_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig2.constellation_16qam_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_16qam_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig2.constellation_16qam_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_16qam_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig2.constellation_16qam_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_16qam_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig2.constellation_16qam_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_16qam_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig2.constellation_16qam_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_16qam_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_16qam_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_16qam_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig2.constellation_16qam_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_16qam_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig2.constellation_16qam_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_16qam_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig2.constellation_16qam_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_16qam_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig2.constellation_16qam_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_16qam_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_16qam_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_16qam_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig2.constellation_16qam_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_16qam_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig2.constellation_16qam_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_16qam_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig2.constellation_16qam_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_16qam_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig2.constellation_16qam_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_16qam_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_16qam_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_16qam_sptr self) -> unsigned int"""
        return _digital_swig2.constellation_16qam_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_16qam_sptr self) -> constellation_sptr"""
        return _digital_swig2.constellation_16qam_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_16qam_sptr self) -> swig_pmt_ptr"""
        return _digital_swig2.constellation_16qam_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_16qam_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig2.constellation_16qam_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_16qam_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig2.constellation_16qam_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_16qam_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig2.constellation_16qam_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_16qam_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig2.constellation_16qam_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_16qam_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig2.constellation_16qam_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_16qam_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig2.constellation_16qam_sptr_soft_decision_maker(self, sample)

# Register constellation_16qam_sptr in _digital_swig2:
_digital_swig2.constellation_16qam_sptr_swigregister(constellation_16qam_sptr)

constellation_16qam_sptr.__repr__ = lambda self: "<constellation 16qam>"
constellation_16qam = constellation_16qam.make;


