"""Generated message classes for configdelivery version v1beta.

ConfigDelivery service manages the deployment of Kubernetes configuration to a
fleet of Kubernetes clusters.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'configdelivery'


class AbortRolloutRequest(_messages.Message):
  r"""Message for aborting a rollout.

  Fields:
    reason: Optional. Reason for aborting.
  """

  reason = _messages.StringField(1)


class AllAtOnceStrategy(_messages.Message):
  r"""AllAtOnceStrategy causes all clusters to be updated concurrently."""


class AllAtOnceStrategyInfo(_messages.Message):
  r"""AllAtOnceStrategyInfo represents the status of execution of AllAtOnce
  rollout strategy.

  Fields:
    clusters: Unordered list. Resource bundle's deployment status for all
      targeted clusters.
  """

  clusters = _messages.MessageField('ClusterInfo', 1, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudBuildRepository(_messages.Message):
  r"""CloudBuildRepository contains information about fetching Kubernetes
  configuration from a `CloudBuildRepository`.

  Fields:
    name: Required. Name of the cloud build repository. Format is
      projects/{p}/locations/{l}/connections/{c}/repositories/{r}.
    path: Optional. Path to the directory or file within the repository that
      contains the Kubernetes configuration. If unspecified, path is assumed
      to the top level root directory of the repository.
    serviceAccount: Required. Google service account to use in CloudBuild
      triggers to fetch and store Kubernetes configuration.
    tag: Required. Git tag of the underlying git repository. The git tag must
      be in the semantic version format `vX.Y.Z`.
    variantsPattern: Optional. Glob pattern that will be used to find variants
      in the repository. Examples: `variants/*.yaml`, `us-*`
  """

  name = _messages.StringField(1)
  path = _messages.StringField(2)
  serviceAccount = _messages.StringField(3)
  tag = _messages.StringField(4)
  variantsPattern = _messages.StringField(5)


class ClusterInfo(_messages.Message):
  r"""ClusterInfo represents status of a resource bundle rollout for a
  cluster.

  Enums:
    StateValueValuesEnum: Output only. State of the rollout for the cluster.

  Fields:
    current: Output only. Current state of the resource bundle.
    desired: Output only. Desired state for the resource bundle.
    endTime: Output only. Timestamp when reconciliation ends.
    initial: Output only. Initial state of the resource bundle prior to the
      deployment.
    membership: Output only. gkehub membership of target cluster
    messages: Output only. Unordered list. Messages convey additional
      information related to the deployment.
    startTime: Output only. Timestamp when reconciliation starts.
    state: Output only. State of the rollout for the cluster.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the rollout for the cluster.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      WAITING: Waiting state.
      IN_PROGRESS: In progress state.
      STALLED: Stalled state.
      COMPLETED: Completed state.
      ABORTED: Aborted state. A rollout that was already running was stopped
        because the fleet memberships changed, or the fleet package was
        deleted.
      CANCELLED: Cancelled state. The proposed rollout was deemed invalid or
        impossible to execute from the start due to issues with the package,
        release, or variant configuration.
      ERROR: Error state.
      UNCHANGED: Unchanged state.
      SKIPPED: Skipped state.
    """
    STATE_UNSPECIFIED = 0
    WAITING = 1
    IN_PROGRESS = 2
    STALLED = 3
    COMPLETED = 4
    ABORTED = 5
    CANCELLED = 6
    ERROR = 7
    UNCHANGED = 8
    SKIPPED = 9

  current = _messages.MessageField('ResourceBundleDeploymentInfo', 1)
  desired = _messages.MessageField('ResourceBundleDeploymentInfo', 2)
  endTime = _messages.StringField(3)
  initial = _messages.MessageField('ResourceBundleDeploymentInfo', 4)
  membership = _messages.StringField(5)
  messages = _messages.StringField(6, repeated=True)
  startTime = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)


class ConfigdeliveryProjectsLocationsFleetPackagesCreateRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesCreateRequest object.

  Fields:
    fleetPackage: A FleetPackage resource to be passed as the request body.
    fleetPackageId: Required. Id of the requesting object If auto-generating
      Id server-side, remove this field and fleet_package_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  fleetPackage = _messages.MessageField('FleetPackage', 1)
  fleetPackageId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsFleetPackagesDeleteRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesDeleteRequest object.

  Fields:
    allowMissing: Optional. If set to true, then deleting an already-deleted
      or non-existent FleetPackage will succeed.
    force: Optional. If set to true, any rollouts for this FleetPackage will
      also be deleted. (Otherwise, the request will only work if the fleet
      package has no rollouts.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  allowMissing = _messages.BooleanField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsFleetPackagesGetRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsFleetPackagesListRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListFleetPackagesRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigdeliveryProjectsLocationsFleetPackagesPatchRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesPatchRequest object.

  Fields:
    fleetPackage: A FleetPackage resource to be passed as the request body.
    name: Identifier. Name of the `FleetPackage`. Format is
      `projects/{project}/locations/{location}/fleetPackages/{fleetPackage}`.
      The `fleetPackage` component must match `a-z{0,62}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the FleetPackage resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  fleetPackage = _messages.MessageField('FleetPackage', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsFleetPackagesRolloutsAbortRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesRolloutsAbortRequest
  object.

  Fields:
    abortRolloutRequest: A AbortRolloutRequest resource to be passed as the
      request body.
    name: Required. Name of the Rollout.
  """

  abortRolloutRequest = _messages.MessageField('AbortRolloutRequest', 1)
  name = _messages.StringField(2, required=True)


class ConfigdeliveryProjectsLocationsFleetPackagesRolloutsGetRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesRolloutsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsFleetPackagesRolloutsListRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesRolloutsListRequest
  object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListRolloutsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigdeliveryProjectsLocationsFleetPackagesRolloutsResumeRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesRolloutsResumeRequest
  object.

  Fields:
    name: Required. Name of the Rollout.
    resumeRolloutRequest: A ResumeRolloutRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  resumeRolloutRequest = _messages.MessageField('ResumeRolloutRequest', 2)


class ConfigdeliveryProjectsLocationsFleetPackagesRolloutsSuspendRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsFleetPackagesRolloutsSuspendRequest
  object.

  Fields:
    name: Required. Name of the Rollout.
    suspendRolloutRequest: A SuspendRolloutRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  suspendRolloutRequest = _messages.MessageField('SuspendRolloutRequest', 2)


class ConfigdeliveryProjectsLocationsGetRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsListRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class ConfigdeliveryProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ConfigdeliveryProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class ConfigdeliveryProjectsLocationsResourceBundlesCreateRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    resourceBundle: A ResourceBundle resource to be passed as the request
      body.
    resourceBundleId: Required. Id of the requesting object If auto-generating
      Id server-side, remove this field and resource_bundle_id from the
      method_signature of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  resourceBundle = _messages.MessageField('ResourceBundle', 3)
  resourceBundleId = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsResourceBundlesDeleteRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesDeleteRequest object.

  Fields:
    force: Optional. If set to true, any releases of this resource bundle will
      also be deleted. (Otherwise, the request will only work if the resource
      bundle has no releases.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ConfigdeliveryProjectsLocationsResourceBundlesGetRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsResourceBundlesListRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListResourceBundlesRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigdeliveryProjectsLocationsResourceBundlesPatchRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesPatchRequest object.

  Fields:
    name: Identifier. Name of the `ResourceBundle`. Format is
      `projects/{project}/locations/{location}/resourceBundle /a-z{0,62}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    resourceBundle: A ResourceBundle resource to be passed as the request
      body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the ResourceBundle resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  resourceBundle = _messages.MessageField('ResourceBundle', 3)
  updateMask = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesCreateRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesReleasesCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    release: A Release resource to be passed as the request body.
    releaseId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and release_id from the method_signature
      of Create RPC
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  release = _messages.MessageField('Release', 2)
  releaseId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesDeleteRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesReleasesDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, any variants of this release will also be
      deleted. (Otherwise, the request will only work if the release has no
      variants.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesGetRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesReleasesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesListRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesReleasesListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListReleasesRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesPatchRequest(_messages.Message):
  r"""A ConfigdeliveryProjectsLocationsResourceBundlesReleasesPatchRequest
  object.

  Fields:
    name: Identifier. Name of the Release. Format is `projects/{project}/locat
      ions/location}/resourceBundles/{resource_bundle}/release/a-z{0,62}`.
    release: A Release resource to be passed as the request body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Release resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  release = _messages.MessageField('Release', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsCreateRequest(_messages.Message):
  r"""A
  ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    variant: A Variant resource to be passed as the request body.
    variantId: Required. Id of the requesting object
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  variant = _messages.MessageField('Variant', 3)
  variantId = _messages.StringField(4)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsDeleteRequest(_messages.Message):
  r"""A
  ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsGetRequest(_messages.Message):
  r"""A
  ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsListRequest(_messages.Message):
  r"""A
  ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListVariantsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsPatchRequest(_messages.Message):
  r"""A
  ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsPatchRequest
  object.

  Fields:
    name: Identifier. Name follows format of projects/{project}/locations/{loc
      ation}/resourceBundles/{resource_bundle}/releases/{release}/variants/{va
      riant}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Variant resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
    variant: A Variant resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  updateMask = _messages.StringField(3)
  variant = _messages.MessageField('Variant', 4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Fleet(_messages.Message):
  r"""The fleet where the `FleetPackage` should be deployed.

  Fields:
    project: Required. The host project for the GKE fleet. Format is
      `projects/{project}`.
    selector: Optional. Selector allows targeting a subset of fleet members
      using their labels.
  """

  project = _messages.StringField(1)
  selector = _messages.MessageField('LabelSelector', 2)


class FleetPackage(_messages.Message):
  r"""A `FleetPackage` resource in the Config Delivery API. A `FleetPackage`
  defines a package through which Kubernetes configuration is deployed to a
  fleet of Kubernetes clusters.

  Enums:
    DeletionPropagationPolicyValueValuesEnum: Optional. Information around how
      to handle Kubernetes resources at the target clusters when the
      `FleetPackage` is deleted.
    StateValueValuesEnum: Optional. The desired state of the fleet package.

  Messages:
    LabelsValue: Optional. Labels are attributes that can be set and used by
      both the user and by Config Delivery. Labels must meet the following
      constraints: * Keys and values can contain only lowercase letters,
      numeric characters, underscores, and dashes. * All characters must use
      UTF-8 encoding, and international characters are allowed. * Keys must
      start with a lowercase letter or international character. * Each
      resource is limited to a maximum of 64 labels. Both keys and values are
      additionally constrained to be <= 128 bytes.

  Fields:
    createTime: Output only. Time at which the `FleetPackage` was created.
    deletionPropagationPolicy: Optional. Information around how to handle
      Kubernetes resources at the target clusters when the `FleetPackage` is
      deleted.
    info: Output only. Information containing the rollout status of the
      `FleetPackage` across all the target clusters.
    labels: Optional. Labels are attributes that can be set and used by both
      the user and by Config Delivery. Labels must meet the following
      constraints: * Keys and values can contain only lowercase letters,
      numeric characters, underscores, and dashes. * All characters must use
      UTF-8 encoding, and international characters are allowed. * Keys must
      start with a lowercase letter or international character. * Each
      resource is limited to a maximum of 64 labels. Both keys and values are
      additionally constrained to be <= 128 bytes.
    name: Identifier. Name of the `FleetPackage`. Format is
      `projects/{project}/locations/{location}/fleetPackages/{fleetPackage}`.
      The `fleetPackage` component must match `a-z{0,62}`
    resourceBundleSelector: Required. Information specifying the source of
      Kubernetes configuration to deploy.
    rolloutStrategy: Optional. The strategy to use to deploy Kubernetes
      configuration to clusters.
    state: Optional. The desired state of the fleet package.
    target: Optional. Configuration to select target clusters to deploy
      Kubernetes configuration to.
    updateTime: Output only. Most recent time at which the `FleetPackage` was
      updated.
    variantSelector: Required. Information specifying how to map a
      `ResourceBundle` variant to a target cluster.
  """

  class DeletionPropagationPolicyValueValuesEnum(_messages.Enum):
    r"""Optional. Information around how to handle Kubernetes resources at the
    target clusters when the `FleetPackage` is deleted.

    Values:
      DELETION_PROPAGATION_POLICY_UNSPECIFIED: Unspecified deletion
        propagation policy. Defaults to FOREGROUND.
      FOREGROUND: Foreground deletion propagation policy. Any resources synced
        to the cluster will be deleted.
      ORPHAN: Orphan deletion propagation policy. Any resources synced to the
        cluster will be abandoned.
    """
    DELETION_PROPAGATION_POLICY_UNSPECIFIED = 0
    FOREGROUND = 1
    ORPHAN = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Optional. The desired state of the fleet package.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: `FleetPackage` is intended to be active.
      SUSPENDED: `FleetPackage` is intended to be suspended.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    SUSPENDED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels are attributes that can be set and used by both the
    user and by Config Delivery. Labels must meet the following constraints: *
    Keys and values can contain only lowercase letters, numeric characters,
    underscores, and dashes. * All characters must use UTF-8 encoding, and
    international characters are allowed. * Keys must start with a lowercase
    letter or international character. * Each resource is limited to a maximum
    of 64 labels. Both keys and values are additionally constrained to be <=
    128 bytes.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deletionPropagationPolicy = _messages.EnumField('DeletionPropagationPolicyValueValuesEnum', 2)
  info = _messages.MessageField('FleetPackageInfo', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  resourceBundleSelector = _messages.MessageField('ResourceBundleSelector', 6)
  rolloutStrategy = _messages.MessageField('RolloutStrategy', 7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  target = _messages.MessageField('Target', 9)
  updateTime = _messages.StringField(10)
  variantSelector = _messages.MessageField('VariantSelector', 11)


class FleetPackageError(_messages.Message):
  r"""Information representing an error encountered during rolling out
  configurations.

  Fields:
    errorMessage: Optional. A description of the error.
  """

  errorMessage = _messages.StringField(1)


class FleetPackageInfo(_messages.Message):
  r"""FleetPackageInfo represents the status of the `FleetPackage` across all
  the target clusters.

  Enums:
    StateValueValuesEnum: Optional. Output only. The current state of the
      `FleetPackage`.

  Fields:
    activeRollout: Optional. The active rollout, if any. Format is `projects/{
      project}/locations/{location}/fleetPackages/{fleet_package}/rollouts/{ro
      llout}`.
    errors: Optional. Output only. Errors encountered during configuration
      deployment (if any).
    lastCompletedRollout: Optional. The last completed rollout, if any. Format
      is `projects/{project}/locations/{location}/fleetPackages/{fleet_package
      }/rollouts/{rollout}`.
    state: Optional. Output only. The current state of the `FleetPackage`.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Optional. Output only. The current state of the `FleetPackage`.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: `FleetPackage` is active.
      SUSPENDED: `FleetPackage` is suspended.
      FAILED: `FleetPackage` has failed to reconcile.
      DELETING: `FleetPackage` is being deleted.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    SUSPENDED = 2
    FAILED = 3
    DELETING = 4

  activeRollout = _messages.StringField(1)
  errors = _messages.MessageField('FleetPackageError', 2, repeated=True)
  lastCompletedRollout = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class LabelSelector(_messages.Message):
  r"""A label selector is a label query over a set of resources. An empty
  label selector matches all objects.

  Messages:
    MatchLabelsValue: Optional. Map of {key,value} pairs. Each {key,value}
      pair must match an existing label key and value exactly in order to
      satisfy the match.

  Fields:
    matchLabels: Optional. Map of {key,value} pairs. Each {key,value} pair
      must match an existing label key and value exactly in order to satisfy
      the match.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MatchLabelsValue(_messages.Message):
    r"""Optional. Map of {key,value} pairs. Each {key,value} pair must match
    an existing label key and value exactly in order to satisfy the match.

    Messages:
      AdditionalProperty: An additional property for a MatchLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type MatchLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MatchLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  matchLabels = _messages.MessageField('MatchLabelsValue', 1)


class ListFleetPackagesResponse(_messages.Message):
  r"""Message for response to listing FleetPackage

  Fields:
    fleetPackages: The list of FleetPackage
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  fleetPackages = _messages.MessageField('FleetPackage', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListReleasesResponse(_messages.Message):
  r"""Message for response to listing Releases

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    releases: The list of Releases
    unreachable: Unordered list. Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  releases = _messages.MessageField('Release', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListResourceBundlesResponse(_messages.Message):
  r"""Message for response to listing ResourceBundles.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    resourceBundles: The list of ResourceBundle.
    unreachable: Unordered list. Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  resourceBundles = _messages.MessageField('ResourceBundle', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListRolloutsResponse(_messages.Message):
  r"""Message for response to listing Rollouts

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    rollouts: The list of Rollouts
    unreachable: Unordered list. Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  rollouts = _messages.MessageField('Rollout', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListVariantsResponse(_messages.Message):
  r"""Message for response to listing Variants

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
    variants: The list of Variants
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  variants = _messages.MessageField('Variant', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Release(_messages.Message):
  r"""`Release` represents a versioned release containing Kubernetes
  manifests.

  Enums:
    LifecycleValueValuesEnum: Optional. lifecycle of the `Release`.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. Time `Release` was created.
    info: Optional. `ResourceBundle` Release extra information e.g., artifact
      registry image path.
    labels: Optional. Labels as key value pairs.
    lifecycle: Optional. lifecycle of the `Release`.
    name: Identifier. Name of the Release. Format is `projects/{project}/locat
      ions/location}/resourceBundles/{resource_bundle}/release/a-z{0,62}`.
    publishTime: Output only. Time the `Release` was published.
    updateTime: Output only. Time `Release` was last updated.
    version: Required. Version of the `Release`. This must be v...
  """

  class LifecycleValueValuesEnum(_messages.Enum):
    r"""Optional. lifecycle of the `Release`.

    Values:
      LIFECYCLE_UNSPECIFIED: indicates lifecycle has not been specified.
      DRAFT: indicates that the `Release` is being edited.
      PUBLISHED: indicates that the `Release` is now published (or released)
        and immutable.
    """
    LIFECYCLE_UNSPECIFIED = 0
    DRAFT = 1
    PUBLISHED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  info = _messages.MessageField('ReleaseInfo', 2)
  labels = _messages.MessageField('LabelsValue', 3)
  lifecycle = _messages.EnumField('LifecycleValueValuesEnum', 4)
  name = _messages.StringField(5)
  publishTime = _messages.StringField(6)
  updateTime = _messages.StringField(7)
  version = _messages.StringField(8)


class ReleaseInfo(_messages.Message):
  r"""ReleaseInfo contains extra information about the `ResourceBundle`
  release e.g., link to an artifact registry OCI image.

  Messages:
    VariantOciImagePathsValue: Optional. Per-variant paths to the oci images
      the service uploads on package release creation

  Fields:
    ociImagePath: Output only. Path to the oci image the service uploads to on
      a `Release` creation.
    variantOciImagePaths: Optional. Per-variant paths to the oci images the
      service uploads on package release creation
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class VariantOciImagePathsValue(_messages.Message):
    r"""Optional. Per-variant paths to the oci images the service uploads on
    package release creation

    Messages:
      AdditionalProperty: An additional property for a
        VariantOciImagePathsValue object.

    Fields:
      additionalProperties: Additional properties of type
        VariantOciImagePathsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a VariantOciImagePathsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  ociImagePath = _messages.StringField(1)
  variantOciImagePaths = _messages.MessageField('VariantOciImagePathsValue', 2)


class ResourceBundle(_messages.Message):
  r"""ResourceBundle represent a collection of Kubernetes configuration
  resources.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. Time `ResourceBundle` was created.
    description: Optional. Human readable description of the `ResourceBundle`.
    labels: Optional. Labels as key value pairs.
    name: Identifier. Name of the `ResourceBundle`. Format is
      `projects/{project}/locations/{location}/resourceBundle /a-z{0,62}`.
    updateTime: Output only. Time `ResourceBundle` was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class ResourceBundleDeploymentInfo(_messages.Message):
  r"""ResourceBundleDeploymentInfo represents the status of a resource bundle
  deployment.

  Enums:
    SyncStateValueValuesEnum: Output only. Synchronization state of the
      `ResourceBundle` deployment.

  Fields:
    messages: Output only. Unordered list. Messages contain information
      related to the `ResourceBundle` deployment. For example, in case of an
      error, indicate the reason for the error. In case of a pending
      deployment, messages will contain the reason why the deployment of new
      release is pending.
    release: Output only. Refers to a `ResourceBundle` release.
    syncState: Output only. Synchronization state of the `ResourceBundle`
      deployment.
    variant: Output only. Refers to a variant in a `ResourceBundle` release.
    version: Output only. Refers to a version of the `ResourceBundle` release.
  """

  class SyncStateValueValuesEnum(_messages.Enum):
    r"""Output only. Synchronization state of the `ResourceBundle` deployment.

    Values:
      SYNC_STATE_UNSPECIFIED: Unspecified state.
      RECONCILING: Reconciling state.
      STALLED: Stalled state.
      SYNCED: Synced state.
      PENDING: Pending state.
      ERROR: Error state.
      DELETION_PENDING: Deletion pending state.
      DELETING: Deleting state.
      DELETED: Deleted state.
    """
    SYNC_STATE_UNSPECIFIED = 0
    RECONCILING = 1
    STALLED = 2
    SYNCED = 3
    PENDING = 4
    ERROR = 5
    DELETION_PENDING = 6
    DELETING = 7
    DELETED = 8

  messages = _messages.StringField(1, repeated=True)
  release = _messages.StringField(2)
  syncState = _messages.EnumField('SyncStateValueValuesEnum', 3)
  variant = _messages.StringField(4)
  version = _messages.StringField(5)


class ResourceBundleSelector(_messages.Message):
  r"""Information specifying the source of Kubernetes configuration to deploy.

  Fields:
    cloudBuildRepository: Information specifying `CloudBuildRepository`.
    resourceBundle: Information specifying `ResourceBundle`.
  """

  cloudBuildRepository = _messages.MessageField('CloudBuildRepository', 1)
  resourceBundle = _messages.MessageField('ResourceBundleTag', 2)


class ResourceBundleTag(_messages.Message):
  r"""ResourceBundleTag contains the information to refer to a release for a
  `ResourceBundle`.

  Fields:
    name: Required. Name of the `ResourceBundle`. Format is
      projects/{p}/locations/{l}/resourceBundles/{r}.
    tag: Required. The Git tag for a version of the release in a
      ResourceBundle. The tag must follow the semantic versioning format
      vX.Y.Z.
  """

  name = _messages.StringField(1)
  tag = _messages.StringField(2)


class ResumeRolloutRequest(_messages.Message):
  r"""Message for resuming a rollout.

  Fields:
    reason: Optional. Reason for resuming the rollout.
  """

  reason = _messages.StringField(1)


class RollingStrategy(_messages.Message):
  r"""RollingStrategy causes a specified number of clusters to be updated
  concurrently until all clusters are updated.

  Fields:
    maxConcurrent: Optional. Maximum number of clusters to update the resource
      bundle on concurrently.
  """

  maxConcurrent = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class RollingStrategyInfo(_messages.Message):
  r"""RollingStrategyInfo represents the status of execution of Rolling
  rollout strategy.

  Fields:
    clusters: Unordered list. Resource bundle's deployment status for all
      targeted clusters.
  """

  clusters = _messages.MessageField('ClusterInfo', 1, repeated=True)


class Rollout(_messages.Message):
  r"""Rollout resource represents an instance of `FleetPackage` rollout
  operation across a fleet. This is a system generated resource and will be
  read only for end-users. It will be primarily used by the service to process
  the changes in the `FleetPackage` and other changes in the environment.

  Enums:
    DeletionPropagationPolicyValueValuesEnum: Deletion propagation policy of
      the rollout.

  Fields:
    createTime: Output only. The time the rollout was created.
    deletionPropagationPolicy: Deletion propagation policy of the rollout.
    info: Current details of the rollout.
    name: Identifier. Name of the Rollout. Format is `projects/{project}/locat
      ions/{location}/fleetPackages/{fleet_package}/rollouts/a-z{0,62}`.
    release: Reference to the `Release` being rolled out.
    rolloutStrategy: Rollout strategy for rolling out `FleetPackage` to
      clusters.
    updateTime: Output only. The time the rollout was most recently updated.
  """

  class DeletionPropagationPolicyValueValuesEnum(_messages.Enum):
    r"""Deletion propagation policy of the rollout.

    Values:
      DELETION_PROPAGATION_POLICY_UNSPECIFIED: Unspecified deletion
        propagation policy. Defaults to FOREGROUND.
      FOREGROUND: Foreground deletion propagation policy. Any resources synced
        to the cluster will be deleted.
      ORPHAN: Orphan deletion propagation policy. Any resources synced to the
        cluster will be abandoned.
    """
    DELETION_PROPAGATION_POLICY_UNSPECIFIED = 0
    FOREGROUND = 1
    ORPHAN = 2

  createTime = _messages.StringField(1)
  deletionPropagationPolicy = _messages.EnumField('DeletionPropagationPolicyValueValuesEnum', 2)
  info = _messages.MessageField('RolloutInfo', 3)
  name = _messages.StringField(4)
  release = _messages.StringField(5)
  rolloutStrategy = _messages.MessageField('RolloutStrategy', 6)
  updateTime = _messages.StringField(7)


class RolloutInfo(_messages.Message):
  r"""RolloutInfo represents the state of the `FleetPackage` at all the
  clusters the rollout is targeting.

  Enums:
    StateValueValuesEnum: Output only. State contains the overall status of
      the Rollout.

  Fields:
    endTime: Output only. Time when the rollout completed.
    message: Output only. Message containing additional information related to
      the rollout.
    rolloutStrategyInfo: Output only. Rollout strategy info represents the
      status of execution of rollout strategy.
    startTime: Output only. Time when the rollout started.
    state: Output only. State contains the overall status of the Rollout.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State contains the overall status of the Rollout.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      COMPLETED: Rollout completed.
      SUSPENDED: Rollout suspended.
      ABORTED: Rollout aborted. A rollout that was already running was stopped
        because the fleet memberships changed, or the fleet package was
        deleted.
      IN_PROGRESS: Rollout in progress.
      STALLED: Rollout stalled.
      CANCELLED: Rollout cancelled. The proposed rollout was deemed invalid or
        impossible to execute from the start due to issues with the package,
        release, or variant configuration.
      ABORTING: Rollout aborting.
    """
    STATE_UNSPECIFIED = 0
    COMPLETED = 1
    SUSPENDED = 2
    ABORTED = 3
    IN_PROGRESS = 4
    STALLED = 5
    CANCELLED = 6
    ABORTING = 7

  endTime = _messages.StringField(1)
  message = _messages.StringField(2)
  rolloutStrategyInfo = _messages.MessageField('RolloutStrategyInfo', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class RolloutStrategy(_messages.Message):
  r"""RolloutStrategy defines different ways to rollout a resource bundle
  across a set of clusters.

  Fields:
    allAtOnce: AllAtOnceStrategy causes all clusters to be updated
      concurrently.
    rolling: RollingStrategy causes a specified number of clusters to be
      updated concurrently until all clusters are updated.
  """

  allAtOnce = _messages.MessageField('AllAtOnceStrategy', 1)
  rolling = _messages.MessageField('RollingStrategy', 2)


class RolloutStrategyInfo(_messages.Message):
  r"""RolloutStrategyInfo represents the status of execution of different
  types of rollout strategies. Only the field corresponding to the rollout
  strategy specified at the rollout resource will be populated.

  Fields:
    allAtOnceStrategyInfo: AllAtOnceStrategyInfo represents the status of
      AllAtOnce rollout strategy execution.
    rollingStrategyInfo: RollingStrategyInfo represents the status of Rolling
      rollout strategy execution.
  """

  allAtOnceStrategyInfo = _messages.MessageField('AllAtOnceStrategyInfo', 1)
  rollingStrategyInfo = _messages.MessageField('RollingStrategyInfo', 2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SuspendRolloutRequest(_messages.Message):
  r"""Message for suspending a rollout.

  Fields:
    reason: Optional. Reason for suspension.
  """

  reason = _messages.StringField(1)


class Target(_messages.Message):
  r"""The target defines different ways to target set of Kubernetes clusters.

  Fields:
    fleet: GKE fleet information to target rollout of the FleetPackage.
  """

  fleet = _messages.MessageField('Fleet', 1)


class Variant(_messages.Message):
  r"""Variant represents the content of a `ResourceBundle` variant.

  Messages:
    LabelsValue: Optional. Labels to represent any metadata associated with
      the variant.

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Optional. Labels to represent any metadata associated with the
      variant.
    name: Identifier. Name follows format of projects/{project}/locations/{loc
      ation}/resourceBundles/{resource_bundle}/releases/{release}/variants/{va
      riant}
    resources: Required. Input only. Unordered list. Resources contain the
      Kubernetes manifests (YAMLs) for this variant.
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels to represent any metadata associated with the
    variant.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  resources = _messages.StringField(4, repeated=True)
  updateTime = _messages.StringField(5)


class VariantSelector(_messages.Message):
  r"""VariantSelector contains information for selecting a variant in
  `ResourceBundle` to deploy to a target cluster.

  Fields:
    variantNameTemplate: Required. variant_name_template is a template that
      can refer to variables containing cluster membership metadata such as
      location, name, and labels to generate the name of the variant for a
      target cluster. The variable syntax is similar to the unix shell
      variables. Available variables are `${membership.name}`,
      `${membership.location}`, `${membership.project}` and
      `${membership.labels['label_name']}`. If you want to deploy a specific
      variant, say "default" to all the clusters, you can use "default"
      (string without any variables) as the variant_name_template.
  """

  variantNameTemplate = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
