"""Generated client library for networkmanagement version v1alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.networkmanagement.v1alpha1 import networkmanagement_v1alpha1_messages as messages


class NetworkmanagementV1alpha1(base_api.BaseApiClient):
  """Generated client library for service networkmanagement version v1alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://networkmanagement.googleapis.com/'
  MTLS_BASE_URL = 'https://networkmanagement.mtls.googleapis.com/'

  _PACKAGE = 'networkmanagement'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'NetworkmanagementV1alpha1'
  _URL_VERSION = 'v1alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new networkmanagement handle."""
    url = url or self.BASE_URL
    super(NetworkmanagementV1alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_appliances = self.ProjectsLocationsAppliancesService(self)
    self.projects_locations_deployments = self.ProjectsLocationsDeploymentsService(self)
    self.projects_locations_networkMonitoringProviders_monitoringPoints = self.ProjectsLocationsNetworkMonitoringProvidersMonitoringPointsService(self)
    self.projects_locations_networkMonitoringProviders_networkPaths = self.ProjectsLocationsNetworkMonitoringProvidersNetworkPathsService(self)
    self.projects_locations_networkMonitoringProviders_webPaths = self.ProjectsLocationsNetworkMonitoringProvidersWebPathsService(self)
    self.projects_locations_networkMonitoringProviders = self.ProjectsLocationsNetworkMonitoringProvidersService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_simulations = self.ProjectsLocationsSimulationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsAppliancesService(base_api.BaseApiService):
    """Service class for the projects_locations_appliances resource."""

    _NAME = 'projects_locations_appliances'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsAppliancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a single Appliance.

      Args:
        request: (NetworkmanagementProjectsLocationsAppliancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Appliance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/appliances/{appliancesId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.appliances.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsAppliancesGetRequest',
        response_type_name='Appliance',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists available third party appliance resources.

      Args:
        request: (NetworkmanagementProjectsLocationsAppliancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAppliancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/appliances',
        http_method='GET',
        method_id='networkmanagement.projects.locations.appliances.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/appliances',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsAppliancesListRequest',
        response_type_name='ListAppliancesResponse',
        supports_download=False,
    )

  class ProjectsLocationsDeploymentsService(base_api.BaseApiService):
    """Service class for the projects_locations_deployments resource."""

    _NAME = 'projects_locations_deployments'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a deployment of a third party appliance.

      Args:
        request: (NetworkmanagementProjectsLocationsDeploymentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/deployments',
        http_method='POST',
        method_id='networkmanagement.projects.locations.deployments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['deploymentId'],
        relative_path='v1alpha1/{+parent}/deployments',
        request_field='deployment',
        request_type_name='NetworkmanagementProjectsLocationsDeploymentsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Deployment.

      Args:
        request: (NetworkmanagementProjectsLocationsDeploymentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='DELETE',
        method_id='networkmanagement.projects.locations.deployments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsDeploymentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Deployment.

      Args:
        request: (NetworkmanagementProjectsLocationsDeploymentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Deployment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.deployments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsDeploymentsGetRequest',
        response_type_name='Deployment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists created deployments.

      Args:
        request: (NetworkmanagementProjectsLocationsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/deployments',
        http_method='GET',
        method_id='networkmanagement.projects.locations.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/deployments',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsDeploymentsListRequest',
        response_type_name='ListDeploymentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""This method updates a Deployment.

      Args:
        request: (NetworkmanagementProjectsLocationsDeploymentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/deployments/{deploymentsId}',
        http_method='PATCH',
        method_id='networkmanagement.projects.locations.deployments.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='deployment',
        request_type_name='NetworkmanagementProjectsLocationsDeploymentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsNetworkMonitoringProvidersMonitoringPointsService(base_api.BaseApiService):
    """Service class for the projects_locations_networkMonitoringProviders_monitoringPoints resource."""

    _NAME = 'projects_locations_networkMonitoringProviders_monitoringPoints'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsNetworkMonitoringProvidersMonitoringPointsService, self).__init__(client)
      self._upload_configs = {
          }

    def DownloadInstallScript(self, request, global_params=None):
      r"""Downloads an install script for MonitoringPoints for a given network monitoring provider.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsDownloadInstallScriptRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('DownloadInstallScript')
      return self._RunMethod(
          config, request, global_params=global_params)

    DownloadInstallScript.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/monitoringPoints:downloadInstallScript',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.monitoringPoints.downloadInstallScript',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['_password', 'hostname', 'monitoringPointType', 'ntpServerAddress', 'ntpServerSecondaryAddress', 'staticIpAddress_dnsServerAddress', 'staticIpAddress_dnsServerSecondaryAddress', 'staticIpAddress_domain', 'staticIpAddress_gatewayAddress', 'staticIpAddress_ipAddress', 'staticIpAddress_netmask', 'timeZone_id', 'timeZone_version', 'useDhcp'],
        relative_path='v1alpha1/{+parent}/monitoringPoints:downloadInstallScript',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsDownloadInstallScriptRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

    def DownloadRecreateInstallScript(self, request, global_params=None):
      r"""Downloads an install script for a specific Container MonitoringPoint.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsDownloadRecreateInstallScriptRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('DownloadRecreateInstallScript')
      return self._RunMethod(
          config, request, global_params=global_params)

    DownloadRecreateInstallScript.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/monitoringPoints/{monitoringPointsId}:downloadRecreateInstallScript',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.monitoringPoints.downloadRecreateInstallScript',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['hostname'],
        relative_path='v1alpha1/{+name}:downloadRecreateInstallScript',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsDownloadRecreateInstallScriptRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

    def DownloadServerConnectConfig(self, request, global_params=None):
      r"""Downloads the server connect configuration for a given network monitoring provider.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsDownloadServerConnectConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('DownloadServerConnectConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    DownloadServerConnectConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/monitoringPoints:downloadServerConnectConfig',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.monitoringPoints.downloadServerConnectConfig',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha1/{+parent}/monitoringPoints:downloadServerConnectConfig',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsDownloadServerConnectConfigRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the MonitoringPoint resource.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MonitoringPoint) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/monitoringPoints/{monitoringPointsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.monitoringPoints.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsGetRequest',
        response_type_name='MonitoringPoint',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists MonitoringPoints for a given network monitoring provider.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListMonitoringPointsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/monitoringPoints',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.monitoringPoints.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/monitoringPoints',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersMonitoringPointsListRequest',
        response_type_name='ListMonitoringPointsResponse',
        supports_download=False,
    )

  class ProjectsLocationsNetworkMonitoringProvidersNetworkPathsService(base_api.BaseApiService):
    """Service class for the projects_locations_networkMonitoringProviders_networkPaths resource."""

    _NAME = 'projects_locations_networkMonitoringProviders_networkPaths'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsNetworkMonitoringProvidersNetworkPathsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the NetworkPath resource.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersNetworkPathsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkPath) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/networkPaths/{networkPathsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.networkPaths.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersNetworkPathsGetRequest',
        response_type_name='NetworkPath',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists NetworkPaths for a given network monitoring provider.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersNetworkPathsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNetworkPathsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/networkPaths',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.networkPaths.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/networkPaths',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersNetworkPathsListRequest',
        response_type_name='ListNetworkPathsResponse',
        supports_download=False,
    )

  class ProjectsLocationsNetworkMonitoringProvidersWebPathsService(base_api.BaseApiService):
    """Service class for the projects_locations_networkMonitoringProviders_webPaths resource."""

    _NAME = 'projects_locations_networkMonitoringProviders_webPaths'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsNetworkMonitoringProvidersWebPathsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the WebPath resource.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersWebPathsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (WebPath) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/webPaths/{webPathsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.webPaths.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersWebPathsGetRequest',
        response_type_name='WebPath',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists WebPaths for a given network monitoring provider.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersWebPathsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWebPathsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}/webPaths',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.webPaths.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/webPaths',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersWebPathsListRequest',
        response_type_name='ListWebPathsResponse',
        supports_download=False,
    )

  class ProjectsLocationsNetworkMonitoringProvidersService(base_api.BaseApiService):
    """Service class for the projects_locations_networkMonitoringProviders resource."""

    _NAME = 'projects_locations_networkMonitoringProviders'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsNetworkMonitoringProvidersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a NetworkMonitoringProvider resource.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders',
        http_method='POST',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['networkMonitoringProviderId'],
        relative_path='v1alpha1/{+parent}/networkMonitoringProviders',
        request_field='networkMonitoringProvider',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a NetworkMonitoringProvider resource and all of its child resources.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}',
        http_method='DELETE',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def GenerateProviderAccessToken(self, request, global_params=None):
      r"""Generates a provider access token for a given GCP access token. Provider access token is a short-lived token that is used to access resources in the provider's platform.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersGenerateProviderAccessTokenRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateProviderAccessTokenResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateProviderAccessToken')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateProviderAccessToken.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}:generateProviderAccessToken',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.generateProviderAccessToken',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['gcpAccessToken'],
        relative_path='v1alpha1/{+name}:generateProviderAccessToken',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersGenerateProviderAccessTokenRequest',
        response_type_name='GenerateProviderAccessTokenResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the NetworkMonitoringProvider resource.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkMonitoringProvider) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders/{networkMonitoringProvidersId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersGetRequest',
        response_type_name='NetworkMonitoringProvider',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists NetworkMonitoringProviders for a given project and location.

      Args:
        request: (NetworkmanagementProjectsLocationsNetworkMonitoringProvidersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListNetworkMonitoringProvidersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/networkMonitoringProviders',
        http_method='GET',
        method_id='networkmanagement.projects.locations.networkMonitoringProviders.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/networkMonitoringProviders',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsNetworkMonitoringProvidersListRequest',
        response_type_name='ListNetworkMonitoringProvidersResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (NetworkmanagementProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='networkmanagement.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='NetworkmanagementProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (NetworkmanagementProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='networkmanagement.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (NetworkmanagementProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (NetworkmanagementProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='networkmanagement.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1alpha1/{+name}/operations',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsSimulationsService(base_api.BaseApiService):
    """Service class for the projects_locations_simulations resource."""

    _NAME = 'projects_locations_simulations'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsSimulationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Simulation in a given project and location. After user creates a simulation, the simulation is performed as part of the long running operation.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations',
        http_method='POST',
        method_id='networkmanagement.projects.locations.simulations.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId'],
        relative_path='v1alpha1/{+parent}/simulations',
        request_field='simulation',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Simulation.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations/{simulationsId}',
        http_method='DELETE',
        method_id='networkmanagement.projects.locations.simulations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Simulation.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Simulation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations/{simulationsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.simulations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsGetRequest',
        response_type_name='Simulation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations/{simulationsId}:getIamPolicy',
        http_method='GET',
        method_id='networkmanagement.projects.locations.simulations.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Simulations in a given project and location.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSimulationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations',
        http_method='GET',
        method_id='networkmanagement.projects.locations.simulations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+parent}/simulations',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsListRequest',
        response_type_name='ListSimulationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Simulation.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations/{simulationsId}',
        http_method='PATCH',
        method_id='networkmanagement.projects.locations.simulations.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha1/{+name}',
        request_field='simulation',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations/{simulationsId}:setIamPolicy',
        http_method='POST',
        method_id='networkmanagement.projects.locations.simulations.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (NetworkmanagementProjectsLocationsSimulationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}/simulations/{simulationsId}:testIamPermissions',
        http_method='POST',
        method_id='networkmanagement.projects.locations.simulations.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='NetworkmanagementProjectsLocationsSimulationsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (NetworkmanagementProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='networkmanagement.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha1/{+name}',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (NetworkmanagementProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='networkmanagement.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'includeUnrevealedLocations', 'pageSize', 'pageToken'],
        relative_path='v1alpha1/{+name}/locations',
        request_field='',
        request_type_name='NetworkmanagementProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(NetworkmanagementV1alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
