/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)V", "checkForLocalConflictingFunctions", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n2746#2,3:44\n827#2:47\n855#2,2:48\n*S KotlinDebug\n*F\n+ 1 FirConflictsExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker\n*L\n22#1:44,3\n23#1:47\n23#1:48,2\n*E\n"})
public final class FirConflictsExpressionChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirConflictsExpressionChecker INSTANCE = new FirConflictsExpressionChecker();

    private FirConflictsExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirBlock expression2) {
        List list;
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Iterable $this$none$iv = expression2.getStatements();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirStatement it = (FirStatement)element$iv;
                    boolean bl2 = false;
                    if (!FirDeclarationUtilKt.isDestructuredParameter(it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            list = expression2.getStatements();
        } else {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = expression2.getStatements();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirStatement it = (FirStatement)element$iv$iv;
                boolean bl3 = false;
                if (FirDeclarationUtilKt.isDestructuredParameter(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List elements = list;
        FirConflictsHelpersKt.checkForLocalRedeclarations(context2, reporter, elements);
        this.checkForLocalConflictingFunctions(context2, reporter, expression2);
    }

    private final void checkForLocalConflictingFunctions(CheckerContext context2, DiagnosticReporter reporter, FirBlock expression2) {
        Map<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> conflictingFunctions = FirConflictsHelpersKt.collectConflictingLocalFunctionsFrom(context2, expression2);
        for (Map.Entry<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> entry : conflictingFunctions.entrySet()) {
            FirFunctionSymbol<?> function2 = entry.getKey();
            Set<FirBasedSymbol<?>> otherFunctionsThatConflictWithIt = entry.getValue();
            if (otherFunctionsThatConflictWithIt.isEmpty()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), otherFunctionsThatConflictWithIt, null, 16, null);
        }
    }
}

