/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.Format;
import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.Linter;
import com.github.sbaudoin.yamllint.YamlLintConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Cli {
    public static final Map<String, Format.OutputFormat> OUTPUT_FORMATS = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Format.OutputFormat>("parsable", Format.OutputFormat.PARSABLE), new AbstractMap.SimpleEntry<String, Format.OutputFormat>("standard", Format.OutputFormat.STANDARD), new AbstractMap.SimpleEntry<String, Format.OutputFormat>("colored", Format.OutputFormat.COLORED), new AbstractMap.SimpleEntry<String, Format.OutputFormat>("github", Format.OutputFormat.GITHUB), new AbstractMap.SimpleEntry<String, Format.OutputFormat>("auto", Format.OutputFormat.AUTO)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    public static final String DEFAULT_FORMAT = "auto";
    public static final String APP_NAME = "yamllint";
    public static final String USER_CONF_FILENAME = ".yamllint";
    public static final String XDG_CONFIG_HOME_ENV_VAR = "XDG_CONFIG_HOME";
    public static final String YAMLLINT_CONFIG_FILE_ENV_VAR = "YAMLLINT_CONFIG_FILE";
    private static final String ARG_FILES_OR_DIR = "FILES_OR_DIR";
    private static final String ARG_CONFIG_FILE = "config_file";
    private static final String ARG_CONFIG_DATA = "config_data";
    private static final String ARG_FORMAT = "format";
    private static final String ARG_NO_WARNINGS = "no-warnings";
    private static final String ARG_STRICT = "strict";
    private static final String ARG_VERSION = "version";
    private static final String ARG_HELP = "help";
    private static final String ARG_LIST_FILES = "list-files";
    private OutputStream stdout = System.out;
    private OutputStream errout = System.err;

    public static void main(String[] args) {
        new Cli().run(args);
    }

    public void setStdOutputStream(OutputStream out) {
        this.stdout = out;
    }

    public void setErrOutputStream(OutputStream out) {
        this.errout = out;
    }

    public void run(String[] args) {
        Map<String, Object> arguments = this.getCommandLineArguments(args);
        YamlLintConfig conf = this.getYamlLintConfig(arguments);
        if (Boolean.TRUE.equals(arguments.get(ARG_LIST_FILES))) {
            for (String path : this.findFilesRecursively(conf, (String[])arguments.get(ARG_FILES_OR_DIR))) {
                assert (conf != null);
                if (conf.isFileIgnored(path)) continue;
                this.out(path);
            }
            System.exit(0);
        }
        int maxLevel = 0;
        boolean first = true;
        for (String path : this.findFilesRecursively(conf, (String[])arguments.get(ARG_FILES_OR_DIR))) {
            try (InputStream in = "-".equals(path) ? System.in : new FileInputStream(path);){
                int level;
                File file = new File("-".equals(path) ? "stdin" : path);
                List<LintProblem> problems = Linter.run(in, conf, file).stream().filter(problem -> Boolean.FALSE.equals(arguments.get(ARG_NO_WARNINGS)) || problem.getLevel() == null || "error".equals(problem.getLevel())).collect(Collectors.toList());
                String output = Format.format(file.getPath(), problems, OUTPUT_FORMATS.get(arguments.get(ARG_FORMAT)));
                if (!"".equals(output)) {
                    this.out(output);
                }
                if ((level = problems.stream().mapToInt(problem -> (Integer)Linter.getProblemLevel(problem.getLevel())).max().orElse(0)) > maxLevel) {
                    maxLevel = level;
                }
            }
            catch (IOException e) {
                this.err("Cannot read " + ("-".equals(path) ? "standard input" : "file `" + path + "'") + ", skipping");
            }
            if (!first && OUTPUT_FORMATS.get(arguments.get(ARG_FORMAT)) != Format.OutputFormat.PARSABLE && OUTPUT_FORMATS.get(arguments.get(ARG_FORMAT)) != Format.OutputFormat.GITHUB) {
                this.out("");
            }
            first = false;
        }
        if (maxLevel == (Integer)Linter.getProblemLevel("error")) {
            System.exit(1);
        } else if (maxLevel == (Integer)Linter.getProblemLevel("warning") && Boolean.TRUE.equals(arguments.get(ARG_STRICT))) {
            System.exit(2);
        }
        System.exit(0);
    }

    private Map<String, Object> getCommandLineArguments(String[] args) {
        CommandLine cmdLine = this.parseCommandLine(this.prepareOptions(), args);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(ARG_CONFIG_FILE, cmdLine.getOptionValue('c'));
        arguments.put(ARG_CONFIG_DATA, cmdLine.getOptionValue('d'));
        arguments.put(ARG_FORMAT, cmdLine.getOptionValue('f', DEFAULT_FORMAT));
        arguments.put(ARG_NO_WARNINGS, cmdLine.hasOption(ARG_NO_WARNINGS));
        arguments.put(ARG_LIST_FILES, cmdLine.hasOption(ARG_LIST_FILES));
        arguments.put(ARG_STRICT, cmdLine.hasOption('s'));
        arguments.put(ARG_FILES_OR_DIR, cmdLine.getArgs());
        return arguments;
    }

    private Options prepareOptions() {
        Options options = new Options();
        OptionGroup og = new OptionGroup();
        options.addOption(Option.builder((String)"h").longOpt(ARG_HELP).hasArg(false).argName(ARG_HELP).desc("show this help message and exit").build());
        options.addOption(Option.builder((String)"v").longOpt(ARG_VERSION).hasArg(false).argName(ARG_VERSION).desc("show program's version number and exit").build());
        og.addOption(Option.builder((String)"c").longOpt("config-file").hasArg().argName(ARG_CONFIG_FILE).desc("path to a custom configuration").build());
        og.addOption(Option.builder((String)"d").longOpt("config-data").hasArg().argName(ARG_CONFIG_DATA).desc("custom configuration (as YAML source)").build());
        options.addOptionGroup(og);
        options.addOption(Option.builder((String)"f").longOpt(ARG_FORMAT).hasArg().argName(ARG_FORMAT).desc("format for parsing output: " + OUTPUT_FORMATS.keySet().stream().map(f -> DEFAULT_FORMAT.equals(f) ? "'" + f + "' (default)" : "'" + f + "'").collect(Collectors.joining(", "))).build());
        options.addOption(Option.builder().longOpt(ARG_NO_WARNINGS).hasArg(false).argName(ARG_NO_WARNINGS).desc("output only error level problems").build());
        options.addOption(Option.builder().longOpt(ARG_LIST_FILES).hasArg(false).argName(ARG_LIST_FILES).desc("list files to lint and exit").build());
        options.addOption(Option.builder((String)"s").longOpt(ARG_STRICT).hasArg(false).argName(ARG_STRICT).desc("return non-zero exit code on warnings as well as errors").build());
        return options;
    }

    private CommandLine parseCommandLine(Options options, String[] args) {
        DefaultParser cmdParser = new DefaultParser();
        CommandLine cmdLine = null;
        try {
            String format;
            cmdLine = cmdParser.parse(options, args);
            if (cmdLine.hasOption(ARG_HELP)) {
                this.showHelpAndExit(options, this.stdout, 0);
            }
            if (cmdLine.hasOption(ARG_VERSION)) {
                Properties props = new Properties();
                props.load(Cli.class.getClassLoader().getResourceAsStream("yaml.properties"));
                this.err("yamllint " + props.getProperty(ARG_VERSION));
                System.exit(0);
            }
            if (!OUTPUT_FORMATS.containsKey(format = cmdLine.getOptionValue(ARG_FORMAT, DEFAULT_FORMAT))) {
                this.endOnError(String.format("invalid output format '%1$s'. Supported formats: %2$s", format, OUTPUT_FORMATS.keySet().stream().map(f -> DEFAULT_FORMAT.equals(f) ? "'" + f + "' (default)" : "'" + f + "'").collect(Collectors.joining(", "))), false);
            }
            if (cmdLine.getArgs().length == 0) {
                this.endOnError("FILE_OR_DIR is required", true);
            }
            if (Arrays.stream(cmdLine.getArgs()).anyMatch("-"::equals) && cmdLine.getArgs().length > 1) {
                this.endOnError("If - supplied, it must be the only argument", false);
            }
        }
        catch (AlreadySelectedException e) {
            this.endOnError("options `c' and `d' are mutually exclusive.\n", true);
        }
        catch (IOException | ParseException e) {
            this.endOnError(e.getMessage(), true);
        }
        return cmdLine;
    }

    private YamlLintConfig getYamlLintConfig(Map<String, Object> arguments) {
        Path userGlobalConfig = this.getUserGlobalConfigPath();
        File projectConfigFile = this.findProjectConfigFile();
        try {
            if (arguments.containsKey(ARG_CONFIG_DATA) && arguments.get(ARG_CONFIG_DATA) != null) {
                if (!"".equals(arguments.get(ARG_CONFIG_DATA)) && !((String)arguments.get(ARG_CONFIG_DATA)).contains(":")) {
                    arguments.put(ARG_CONFIG_DATA, "extends: " + arguments.get(ARG_CONFIG_DATA));
                }
                return new YamlLintConfig((String)arguments.get(ARG_CONFIG_DATA));
            }
            if (arguments.containsKey(ARG_CONFIG_FILE) && arguments.get(ARG_CONFIG_FILE) != null) {
                return new YamlLintConfig(new File((String)arguments.get(ARG_CONFIG_FILE)).toURI().toURL());
            }
            if (projectConfigFile != null) {
                return new YamlLintConfig(projectConfigFile.toURI().toURL());
            }
            if (this.fileExists(userGlobalConfig)) {
                return new YamlLintConfig(userGlobalConfig.toUri().toURL());
            }
            return new YamlLintConfig("extends: default");
        }
        catch (Exception e) {
            this.endOnError("cannot get or process configuration: " + e.getMessage(), false);
            return null;
        }
    }

    private Path getUserGlobalConfigPath() {
        Path userGlobalConfig = System.getenv(YAMLLINT_CONFIG_FILE_ENV_VAR) != null ? Paths.get(System.getenv(YAMLLINT_CONFIG_FILE_ENV_VAR), new String[0]) : (System.getenv(XDG_CONFIG_HOME_ENV_VAR) != null ? Paths.get(System.getenv(XDG_CONFIG_HOME_ENV_VAR), APP_NAME, "config") : Paths.get(System.getProperty("user.home"), ".config", APP_NAME, "config"));
        return userGlobalConfig;
    }

    private File findProjectConfigFile() {
        return this.findProjectConfigFile(Paths.get(".", new String[0]));
    }

    private File findProjectConfigFile(Path workingDirectory) {
        for (String extension : Arrays.asList("", ".yaml", ".yml")) {
            if (!this.fileExists(workingDirectory.resolve(USER_CONF_FILENAME + extension))) continue;
            return new File(USER_CONF_FILENAME + extension);
        }
        if (workingDirectory.compareTo(new File(System.getProperty("user.home")).toPath()) == 0 || workingDirectory.getParent() == null) {
            return null;
        }
        return this.findProjectConfigFile(workingDirectory.getParent());
    }

    private List<String> findFilesRecursively(YamlLintConfig conf, String[] items) {
        ArrayList<String> files = new ArrayList<String>();
        for (String item : items) {
            if ("-".equals(item)) {
                files.add("-");
                continue;
            }
            File file = new File(item);
            if (file.isDirectory()) {
                files.addAll(this.findFilesRecursively(conf, Arrays.stream(file.list()).map(name -> file.getPath() + File.separator + name).collect(Collectors.toList()).toArray(new String[0])));
                continue;
            }
            if (!file.isFile() || !conf.isYamlFile(item)) continue;
            files.add(item);
        }
        return files;
    }

    private boolean fileExists(Path path) {
        File file = path.toFile();
        return file.exists() && file.isFile();
    }

    private void showHelpAndExit(Options options, OutputStream output, int exitCode) {
        String syntax = "yamllint [-h] [-v] [-c <config_file> | -d <config_data>] [-f <format>] [--no-warnings] [-s] FILE_OR_DIR ...";
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((o1, o2) -> 1);
        PrintWriter pw = new PrintWriter(output);
        String termWidth = System.getenv().getOrDefault("COLUMNS", "");
        int width = Integer.parseInt("".equals(termWidth) ? "80" : termWidth);
        if (options == null) {
            formatter.printUsage(pw, width, syntax);
        } else {
            formatter.printHelp(pw, width, syntax, "\nA linter for YAML files. yamllint does not only check for syntax validity, but for weirdnesses like key repetition and cosmetic problems such as lines length, trailing spaces, indentation, etc.\n\nPositional arguments:\n FILE_OR_DIR                      the files to check or - to read from the standard input\n\nOptional arguments:", options, 1, 3, null);
        }
        pw.flush();
        System.exit(exitCode);
    }

    private void endOnError(String message, boolean showHelp) {
        this.err("Error: " + message);
        if (showHelp) {
            this.err("");
            this.showHelpAndExit(null, this.errout, 1);
        }
        System.exit(1);
    }

    private void out(String message) {
        try {
            this.stdout.write(message.getBytes());
            this.stdout.write(System.lineSeparator().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(this.errout));
            System.exit(1);
        }
    }

    private void err(String message) {
        try {
            this.errout.write(message.getBytes());
            this.errout.write(System.lineSeparator().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

