/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.Token;

public class Hyphens
extends TokenRule {
    public static final String OPTION_MAX_SPACES_AFTER = "max-spaces-after";
    public static final String OPTION_MIN_SPACES_AFTER = "min-spaces-after";
    public static final String OPTION_CHECK_SCALARS = "check-scalars";

    public Hyphens() {
        this.registerOption(OPTION_MAX_SPACES_AFTER, 1);
        this.registerOption(OPTION_MIN_SPACES_AFTER, -1);
        this.registerOption(OPTION_CHECK_SCALARS, false);
    }

    @Override
    public String validate(Map<String, Object> conf) {
        int maxSpaces = (Integer)conf.get(OPTION_MAX_SPACES_AFTER);
        int minSpaces = (Integer)conf.get(OPTION_MIN_SPACES_AFTER);
        if (maxSpaces == 0) {
            return String.format("\"%s\" cannot be set to 0", OPTION_MAX_SPACES_AFTER);
        }
        if (minSpaces > 0 && minSpaces > maxSpaces) {
            return String.format("\"%s\" cannot be greater than \"%s\"", OPTION_MIN_SPACES_AFTER, OPTION_MAX_SPACES_AFTER);
        }
        return null;
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (token instanceof BlockEntryToken) {
            LintProblem problem;
            if ((Integer)conf.get(OPTION_MAX_SPACES_AFTER) > 0 && (problem = this.spacesAfter(token, next, -1, (int)((Integer)conf.get(OPTION_MAX_SPACES_AFTER)), null, "too many spaces after hyphen")) != null) {
                problems.add(problem);
            }
            if ((Integer)conf.get(OPTION_MIN_SPACES_AFTER) > 0 && (problem = this.spacesAfter(token, next, (int)((Integer)conf.get(OPTION_MIN_SPACES_AFTER)), -1, "too few spaces after hyphen", null)) != null) {
                problems.add(problem);
            }
        }
        if (Boolean.TRUE.equals(conf.get(OPTION_CHECK_SCALARS)) && (Integer)conf.get(OPTION_MIN_SPACES_AFTER) > 0 && token instanceof ScalarToken && ((ScalarToken)token).getValue().startsWith("-")) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getStartMark().getColumn() + 1, "too few spaces after hyphen"));
        }
        return problems;
    }
}

