/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public final class Languages
extends AbstractModelObject<Languages>
implements Domain {
    private static final long serialVersionUID = -3588782616807329125L;
    private final Java java = new Java();
    @JsonIgnore
    private final org.jreleaser.model.api.project.Languages immutable = new org.jreleaser.model.api.project.Languages(){
        private static final long serialVersionUID = -5183387318385144903L;

        public org.jreleaser.model.api.common.Java getJava() {
            return Languages.this.java.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Languages.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.project.Languages asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Languages source) {
        this.setJava(source.java);
    }

    public Java getJava() {
        return this.java;
    }

    public void setJava(Java java) {
        this.java.merge(java);
    }

    public boolean isEnabled() {
        return this.java.isEnabled();
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.java.isEnabled() || full) {
            map.put("java", this.java.asMap(full));
        }
        return map;
    }

    public void fillProperties(TemplateContext props) {
        if (this.java.isEnabled()) {
            props.setAll(this.java.resolvedExtraProperties());
            props.set("projectJavaGroupId", (Object)this.java.getGroupId());
            props.set("projectJavaArtifactId", (Object)this.java.getArtifactId());
            String javaVersion = this.java.getVersion();
            props.set("projectJavaVersion", (Object)javaVersion);
            props.set("projectJavaMainClass", (Object)this.java.getMainClass());
            if (StringUtils.isNotBlank((String)javaVersion)) {
                SemanticVersion jv = SemanticVersion.of((String)javaVersion);
                props.set("projectJavaVersionMajor", (Object)jv.getMajor());
                if (jv.hasMinor()) {
                    props.set("projectJavaVersionMinor", (Object)jv.getMinor());
                }
                if (jv.hasPatch()) {
                    props.set("projectJavaVersionPatch", (Object)jv.getPatch());
                }
                if (jv.hasTag()) {
                    props.set("projectJavaVersionTag", (Object)jv.getTag());
                }
                if (jv.hasBuild()) {
                    props.set("projectJavaVersionBuild", (Object)jv.getBuild());
                }
            }
        }
    }
}

