/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.io.File;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.ArticleAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class ArticleAnnouncerValidator {
    private ArticleAnnouncerValidator() {
    }

    public static void validateArticle(JReleaserContext context, ArticleAnnouncer announcer, Errors errors) {
        File templateDirectoryFile;
        context.getLogger().debug("announce.article");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.article", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = context.getModel().getRelease().getReleaser();
        ArticleAnnouncer.Repository repository = announcer.getRepository();
        Validator.validateCommitAuthor(announcer, service);
        Validator.validateOwner(repository, service);
        if (StringUtils.isBlank((String)repository.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"announce.article.repository.name"}));
        }
        if (StringUtils.isBlank((String)announcer.getRepository().getCommitMessage())) {
            announcer.getRepository().setCommitMessage("{{projectName}} {{tagName}}");
        }
        repository.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.article.repository.username", repository.getBasename() + "." + service.getServiceName() + ".username"}), "announce.article.repository.username", repository.getUsername(), service.getUsername()));
        repository.setToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.article.repository.token", repository.getBasename() + "." + service.getServiceName() + ".token"}), "announce.article.repository.token", repository.getToken(), service.getToken()));
        repository.setBranch(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.article.repository.branch", repository.getBasename() + "." + service.getServiceName() + ".branch"}), "announce.article.repository.branch", repository.getBranch(), "HEAD"));
        repository.setBranchPush(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.article.repository.branch.push", repository.getBasename() + "." + service.getServiceName() + ".branch.push"}), "announce.article.repository.branch.push", repository.getBranchPush(), repository.getBranch()));
        if (StringUtils.isBlank((String)repository.getTagName())) {
            repository.setTagName(service.getTagName());
        }
        if (StringUtils.isBlank((String)announcer.getTemplateDirectory())) {
            announcer.setTemplateDirectory("src/jreleaser/templates/article");
        }
        if (!(templateDirectoryFile = context.getBasedir().resolve(announcer.getTemplateDirectory().trim()).toFile()).exists()) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"announce.article.templateDirectory", announcer.getTemplateDirectory()}));
        }
        if (!templateDirectoryFile.isDirectory()) {
            errors.configuration(RB.$((String)"validation_is_not_a_directory", (Object[])new Object[]{"announce.article.templateDirectory", announcer.getTemplateDirectory()}));
        }
        if (null == templateDirectoryFile.listFiles() || templateDirectoryFile.listFiles().length == 0) {
            errors.configuration(RB.$((String)"validation_directory_is_empty", (Object[])new Object[]{"announce.article.templateDirectory", announcer.getTemplateDirectory()}));
        }
        if (announcer.getFiles().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"announce.article.files"}));
        }
    }
}

