/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SpecPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class SpecPackagerValidator {
    private SpecPackagerValidator() {
    }

    public static void validateSpec(JReleaserContext context, Distribution distribution, SpecPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}." + packager.getType(), new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        SpecPackager parentPackager = model.getPackagers().getSpec();
        Validator.resolveActivatable(context, (Activatable)packager, "distributions." + distribution.getName() + "." + packager.getType(), parentPackager);
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.isEmpty()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
            packager.disable();
            return;
        }
        if (candidateArtifacts.size() > 1) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".spec"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.packager.multiple.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), candidateArtifacts.stream().map(Artifact::getPath).collect(Collectors.toList())}));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getRelease())) {
            packager.setRelease(parentPackager.getRelease());
        }
        if (StringUtils.isBlank((String)packager.getRelease())) {
            packager.setRelease("1");
        }
        try {
            Integer.parseInt(packager.getRelease());
            packager.setRelease(packager.getRelease() + "%{?dist}");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (packager.getRequires().isEmpty()) {
            packager.setRequires(parentPackager.getRequires());
        }
        if (packager.getRequires().isEmpty() && distribution.getType() == Distribution.DistributionType.JAVA_BINARY) {
            packager.setRequires(Collections.singletonList("java"));
        }
        Validator.validateCommitAuthor(packager, parentPackager);
        SpecPackager.SpecRepository repository = packager.getRepository();
        Validator.validateRepository(context, distribution, repository, parentPackager.getRepository(), "spec.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        Validator.validateContinueOnError(packager, parentPackager);
        Validator.validateSkipPublishing(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(distribution, packager, candidateArtifacts, errors);
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(parentPackager.getPackageName());
            if (StringUtils.isBlank((String)packager.getPackageName())) {
                packager.setPackageName(distribution.getName());
            }
        }
        if (errors.hasErrors()) {
            packager.disable();
        }
    }
}

