/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;

public class BufferedIterator
implements IteratingRLW,
Cloneable {
    private IteratingBufferedRunningLengthWord iteratingBrlw;
    private CloneableIterator<EWAHIterator> masterIterator;

    public BufferedIterator(CloneableIterator<EWAHIterator> iterator) {
        this.masterIterator = iterator;
        if (this.masterIterator.hasNext()) {
            this.iteratingBrlw = new IteratingBufferedRunningLengthWord(this.masterIterator.next());
        }
    }

    @Override
    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.iteratingBrlw.getRunningLength() > x) {
                this.iteratingBrlw.discardFirstWords(x);
                return;
            }
            this.iteratingBrlw.discardFirstWords(this.iteratingBrlw.getRunningLength());
            long toDiscard = (x -= this.iteratingBrlw.getRunningLength()) > (long)this.iteratingBrlw.getNumberOfLiteralWords() ? (long)this.iteratingBrlw.getNumberOfLiteralWords() : x;
            this.iteratingBrlw.discardFirstWords(toDiscard);
            if ((x -= toDiscard) <= 0L && this.iteratingBrlw.size() != 0L || this.next()) continue;
            break;
        }
    }

    @Override
    public void discardLiteralWords(long x) {
        this.iteratingBrlw.discardLiteralWords(x);
        if (this.iteratingBrlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    @Override
    public void discardRunningWords() {
        this.iteratingBrlw.discardRunningWords();
        if (this.iteratingBrlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    @Override
    public boolean next() {
        if (!this.iteratingBrlw.next()) {
            if (!this.masterIterator.hasNext()) {
                return false;
            }
            this.iteratingBrlw = new IteratingBufferedRunningLengthWord(this.masterIterator.next());
        }
        return true;
    }

    @Override
    public long getLiteralWordAt(int index) {
        return this.iteratingBrlw.getLiteralWordAt(index);
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.iteratingBrlw.getNumberOfLiteralWords();
    }

    @Override
    public boolean getRunningBit() {
        return this.iteratingBrlw.getRunningBit();
    }

    @Override
    public long getRunningLength() {
        return this.iteratingBrlw.getRunningLength();
    }

    @Override
    public long size() {
        return this.iteratingBrlw.size();
    }

    @Override
    public BufferedIterator clone() throws CloneNotSupportedException {
        BufferedIterator answer = (BufferedIterator)super.clone();
        answer.iteratingBrlw = this.iteratingBrlw.clone();
        answer.masterIterator = this.masterIterator.clone();
        return answer;
    }
}

