/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.logging.JReleaserLogger;

public class Errors
implements Serializable {
    private static final long serialVersionUID = -3601667298659606426L;
    private final Set<Error> assemblyErrors = new LinkedHashSet<Error>();
    private final Set<Error> configurationErrors = new LinkedHashSet<Error>();
    private final Set<Error> warnings = new LinkedHashSet<Error>();

    public Errors merge(Errors other) {
        this.assemblyErrors.addAll(other.assemblyErrors);
        this.configurationErrors.addAll(other.configurationErrors);
        this.warnings.addAll(other.warnings);
        return this;
    }

    public Errors clear() {
        this.assemblyErrors.clear();
        this.configurationErrors.clear();
        this.warnings.clear();
        return this;
    }

    public Errors mergeAsWarnings(Errors other) {
        this.warnings.addAll(other.assemblyErrors);
        this.warnings.addAll(other.configurationErrors);
        this.warnings.addAll(other.warnings);
        return this;
    }

    public boolean hasErrors() {
        return !this.assemblyErrors.isEmpty() || !this.configurationErrors.isEmpty();
    }

    public boolean hasAssemblyErrors() {
        return !this.assemblyErrors.isEmpty();
    }

    public boolean hasConfigurationErrors() {
        return !this.configurationErrors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public void assembly(String message) {
        this.assemblyErrors.add(new Error(Kind.ASSEMBLY, message));
    }

    public void configuration(String message) {
        this.configurationErrors.add(new Error(Kind.CONFIGURATION, message));
    }

    public void warning(String message) {
        this.warnings.add(new Error(Kind.CONFIGURATION, message));
    }

    public void logWarnings(JReleaserLogger logger) {
        this.warnings.forEach(e -> logger.warn(((Error)e).message));
    }

    public void logWarnings(PrintWriter writer) {
        this.warnings.forEach(e -> writer.println(((Error)e).message));
    }

    public void logErrors(JReleaserLogger logger) {
        this.assemblyErrors.forEach(e -> logger.error(((Error)e).message));
        this.configurationErrors.forEach(e -> logger.error(((Error)e).message));
    }

    public void logErrors(PrintWriter writer) {
        this.assemblyErrors.forEach(e -> writer.println(((Error)e).message));
        this.configurationErrors.forEach(e -> writer.println(((Error)e).message));
    }

    public String asString() {
        StringWriter writer = new StringWriter();
        this.logErrors(new PrintWriter(writer));
        return writer.toString();
    }

    public String warningsAsString() {
        StringWriter writer = new StringWriter();
        this.logWarnings(new PrintWriter(writer));
        return writer.toString();
    }

    public void addAll(Errors errors) {
        this.assemblyErrors.addAll(errors.assemblyErrors);
        this.configurationErrors.addAll(errors.configurationErrors);
        this.warnings.addAll(errors.warnings);
    }

    public static class Error
    implements Serializable {
        private static final long serialVersionUID = -9011553489507569322L;
        private final Kind kind;
        private final String message;

        public Error(Kind kind, String message) {
            this.kind = kind;
            this.message = message;
        }

        public Kind getKind() {
            return this.kind;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return this.kind == error.kind && this.message.equals(error.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.message});
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum Kind {
        ASSEMBLY,
        CONFIGURATION,
        WARNING;

    }
}

