/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.api.assemble.ArchiveAssembler;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class ArchiveAssemblerProcessor
extends AbstractAssemblerProcessor<ArchiveAssembler, org.jreleaser.model.internal.assemble.ArchiveAssembler> {
    public ArchiveAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        if (!((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).getMatrix().isEmpty()) {
            List matrix = ((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).getMatrix().resolve();
            for (int i = 0; i < matrix.size(); ++i) {
                Map matrixRow = (Map)matrix.get(i);
                if (matrixRow.containsKey("platform")) {
                    String srcPlatform = (String)matrixRow.get("platform");
                    if (!this.context.isPlatformSelected(srcPlatform, ((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).getPlatform())) continue;
                    this.doAssemble(props, i, matrixRow);
                    continue;
                }
                this.doAssemble(props, i, matrixRow);
            }
        } else {
            this.doAssemble(props, 0, Collections.emptyMap());
        }
    }

    private void doAssemble(TemplateContext props, int itemIndex, Map<String, String> matrix) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        String archiveName = ((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).getResolvedArchiveName(this.context, matrix);
        Path workDirectory = assembleDirectory.resolve("work");
        Path matrixDirectory = workDirectory.resolve("matrix-" + itemIndex);
        Path archiveDirectory = workDirectory.resolve(archiveName);
        if (!matrix.isEmpty()) {
            workDirectory = matrixDirectory;
            archiveDirectory = matrixDirectory.resolve(archiveName);
        }
        try {
            FileUtils.deleteFiles((Path)workDirectory);
            Files.createDirectories(archiveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_archive", (Object[])new Object[]{archiveName}), (Throwable)e);
        }
        this.copyTemplates(this.context, props, archiveDirectory);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(archiveDirectory)});
        this.copyArtifacts(this.context, Matrix.asTemplateContext(matrix), archiveDirectory, PlatformUtils.getCurrentFull(), ((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).isAttachPlatform());
        this.copyFiles(this.context, Matrix.asTemplateContext(matrix), archiveDirectory);
        this.copyFileSets(this.context, Matrix.asTemplateContext(matrix), archiveDirectory);
        this.generateSwidTag(this.context, archiveDirectory);
        for (Archive.Format format : ((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).getFormats()) {
            String skipKey = "skip" + StringUtils.capitalize((String)format.formatted());
            if (((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.getAssembler()).extraPropertyIsTrue(skipKey) || StringUtils.isTrue((Object)matrix.get(skipKey))) continue;
            this.archive(workDirectory, assembleDirectory, archiveName, format);
        }
    }

    private void archive(Path workDirectory, Path assembleDirectory, String archiveName, Archive.Format format) throws AssemblerProcessingException {
        String finalArchiveName = archiveName + "." + format.extension();
        this.context.getLogger().info("- {}", new Object[]{finalArchiveName});
        try {
            Path archiveFile = assembleDirectory.resolve(finalArchiveName);
            FileUtils.deleteFiles((Path)archiveFile);
            FileUtils.packArchive((Path)workDirectory, (Path)archiveFile, (FileUtils.ArchiveOptions)((org.jreleaser.model.internal.assemble.ArchiveAssembler)this.assembler).getOptions().toOptions());
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

