/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.catalogers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.SyftSbomCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.catalog.CatalogProcessingException;
import org.jreleaser.model.spi.catalog.sbom.AbstractSbomCatalogerProcessor;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessor;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.tool.Syft;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.ComparatorUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class SyftSbomCatalogerProcessor
extends AbstractSbomCatalogerProcessor<org.jreleaser.model.api.catalog.sbom.SyftSbomCataloger, SyftSbomCataloger> {
    private SyftSbomCataloger cataloger;

    public SyftSbomCatalogerProcessor(JReleaserContext context) {
        super(context);
    }

    public SyftSbomCataloger getCataloger() {
        return this.cataloger;
    }

    public void setCataloger(SyftSbomCataloger cataloger) {
        this.cataloger = cataloger;
    }

    public String getType() {
        return "syft";
    }

    public SbomCatalogerProcessor.Result catalog() throws CatalogProcessingException {
        Set artifacts = this.collectArtifactsSelf(this.context);
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"catalog.no.artifacts", (Object[])new Object[0]));
            return SbomCatalogerProcessor.Result.NO_ARTIFACTS;
        }
        Syft syft = this.setupSyft(this.context);
        boolean executed = false;
        for (Artifact artifact : artifacts) {
            if (!this.generateSbom(syft, artifact)) continue;
            executed = true;
        }
        Path archivePath = this.cataloger.resolveArchivePath(this.context);
        if (executed || !Files.exists(archivePath, new LinkOption[0])) {
            this.pack(artifacts, archivePath);
        }
        return executed ? SbomCatalogerProcessor.Result.EXECUTED : SbomCatalogerProcessor.Result.UPTODATE;
    }

    private void pack(Set<Artifact> candidates, Path archivePath) throws CatalogProcessingException {
        if (!this.cataloger.getPack().isEnabled()) {
            return;
        }
        this.context.getLogger().info(RB.$((String)"catalog.sbom.pack", (Object[])new Object[]{archivePath.getFileName()}));
        String archiveFileName = StringUtils.getFilename((String)archivePath.getFileName().toString());
        try {
            Path tmp = Files.createTempDirectory(this.getType(), new FileAttribute[0]);
            Path workingDirectory = tmp.resolve(archiveFileName);
            Files.createDirectories(workingDirectory, new FileAttribute[0]);
            for (Artifact artifact : this.doResolveArtifacts(candidates)) {
                Files.copy(artifact.getEffectivePath(), workingDirectory.resolve(artifact.getEffectivePath().getFileName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            FileUtils.zip((Path)workingDirectory, (Path)archivePath);
        }
        catch (IOException e) {
            throw new CatalogProcessingException(RB.$((String)"ERROR_catalog_unexpected_error_packing", (Object[])new Object[]{archivePath.getFileName()}), (Throwable)e);
        }
    }

    private Set<Artifact> doResolveArtifacts(Set<Artifact> candidates) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Path catalogDirectory = this.resolveCatalogDirectory();
        for (SyftSbomCataloger.Format format : this.cataloger.getFormats()) {
            for (Artifact artifact : candidates) {
                String artifactFile = artifact.getEffectivePath().getFileName().toString();
                Path targetPath = catalogDirectory.resolve(artifactFile + format.extension());
                artifacts.add(Artifact.of((Path)targetPath));
            }
        }
        return artifacts;
    }

    private Syft setupSyft(JReleaserContext context) throws CatalogProcessingException {
        Syft syft = new Syft(context.asImmutable(), this.cataloger.getVersion());
        try {
            if (!syft.setup()) {
                throw new CatalogProcessingException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"syft"}));
            }
        }
        catch (ToolException e) {
            throw new CatalogProcessingException(e.getMessage(), (Throwable)e);
        }
        return syft;
    }

    private boolean generateSbom(Syft syft, Artifact artifact) throws CatalogProcessingException {
        Path catalogDirectory = this.resolveCatalogDirectory();
        try {
            Files.createDirectories(catalogDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CatalogProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        Path artifactPath = artifact.getEffectivePath();
        String artifactFile = artifactPath.getFileName().toString();
        SemanticVersion syftVersion = SemanticVersion.of((String)syft.getVersion());
        SemanticVersion syft99 = SemanticVersion.of((String)"0.99.0");
        boolean deprecations = ComparatorUtils.greaterThanOrEqualTo((Comparable)syftVersion, (Comparable)syft99);
        boolean executed = false;
        for (SyftSbomCataloger.Format format : this.cataloger.getFormats()) {
            Path targetPath = catalogDirectory.resolve(artifactFile + format.extension());
            ArrayList<String> args = new ArrayList<String>();
            if (deprecations) {
                args.add("--source-name");
                args.add(artifactFile);
                args.add("--output");
                args.add(format + "=" + targetPath.toAbsolutePath());
            } else {
                args.add("--output");
                args.add(format.toString());
                args.add("--name");
                args.add(artifactFile);
                args.add("--file");
                args.add(targetPath.toAbsolutePath().toString());
            }
            args.add(artifactFile);
            if (!Files.exists(targetPath, new LinkOption[0])) {
                this.context.getLogger().debug(RB.$((String)"catalog.sbom.not.exist", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(targetPath)});
                this.generateSbom(syft, artifactPath.getParent(), targetPath.getFileName(), args);
                executed = true;
                continue;
            }
            if (artifactPath.toFile().lastModified() <= targetPath.toFile().lastModified()) continue;
            this.context.getLogger().debug(RB.$((String)"checksum.file.newer", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(artifactPath), this.context.relativizeToBasedir(targetPath)});
            this.generateSbom(syft, artifactPath.getParent(), targetPath.getFileName(), args);
            executed = true;
        }
        return executed;
    }

    private Path resolveCatalogDirectory() {
        return this.context.getCatalogsDirectory().resolve("sbom").resolve(this.cataloger.getType());
    }

    private void generateSbom(Syft syft, Path executionDirectory, Path filename, List<String> args) throws CatalogProcessingException {
        this.context.getLogger().info(" - {}", new Object[]{filename});
        try {
            syft.invoke(executionDirectory, args);
        }
        catch (CommandException e) {
            throw new CatalogProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

