/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git.release;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.release.ReleaseUtils;

public abstract class AbstractReleaser<A extends Releaser>
implements org.jreleaser.model.spi.release.Releaser<A> {
    private static final long serialVersionUID = 362449254352903201L;
    protected final JReleaserContext context;
    protected final Set<Asset> assets = new TreeSet<Asset>();

    protected AbstractReleaser(JReleaserContext context, Set<Asset> assets) {
        this.context = context;
        this.assets.addAll(assets);
    }

    public final void release() throws ReleaseException {
        BaseReleaser service = this.context.getModel().getRelease().getReleaser();
        if (service.isSkipRelease()) {
            if (service.isSkipTag()) {
                this.context.getLogger().info(RB.$((String)"releaser.tag.and.release.skipped", (Object[])new Object[0]));
            } else {
                this.createTag();
            }
        } else {
            this.createRelease();
        }
    }

    public String generateReleaseNotes() throws IOException {
        try {
            return ChangelogProvider.getChangelog(this.context).trim();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag(this.context);
    }

    protected abstract void createRelease() throws ReleaseException;
}

