/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.Banner;
import org.jreleaser.cli.IO;
import org.jreleaser.cli.internal.ColorizedJReleaserLoggerAdapter;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.util.IoUtils;
import org.jreleaser.util.StringUtils;
import picocli.CommandLine;

public abstract class AbstractLoggingCommand<C extends IO>
extends AbstractCommand<C>
implements Callable<Integer> {
    protected JReleaserLogger logger;
    @CommandLine.Option(names={"-g", "--debug"})
    boolean debug;
    @CommandLine.Option(names={"-i", "--info"})
    boolean info;
    @CommandLine.Option(names={"-w", "--warn"})
    boolean warn;
    @CommandLine.Option(names={"-q", "--quiet"})
    boolean quiet;
    @CommandLine.Option(names={"-b", "--basedir"}, paramLabel="<directory>")
    Path basedir;
    @CommandLine.Option(names={"-od", "--output-directory"}, paramLabel="<directory>")
    Path outputdir;
    protected ColorizedJReleaserLoggerAdapter.Level level = ColorizedJReleaserLoggerAdapter.Level.INFO;

    @Override
    protected void setup() {
        if (this.debug) {
            this.level = ColorizedJReleaserLoggerAdapter.Level.DEBUG;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "debug");
        } else if (this.info) {
            this.level = ColorizedJReleaserLoggerAdapter.Level.INFO;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "info");
        } else if (this.warn) {
            this.level = ColorizedJReleaserLoggerAdapter.Level.WARN;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "warn");
        } else if (this.quiet) {
            this.level = ColorizedJReleaserLoggerAdapter.Level.ERROR;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "error");
            System.setProperty("jreleaser.quiet", "true");
        }
        Banner.display(this.parent().getErr());
    }

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        args.add(new AbstractCommand.DeprecatedArg("-od", "--output-directory", "1.5.0"));
    }

    protected void initLogger() {
        this.logger = new ColorizedJReleaserLoggerAdapter(this.createTracer(), this.parent().getOut(), this.level);
    }

    protected PrintWriter createTracer() {
        try {
            Files.createDirectories(this.getOutputDirectory(), new FileAttribute[0]);
            return IoUtils.newPrintWriter((OutputStream)new FileOutputStream(this.getOutputDirectory().resolve("trace.log").toFile()));
        }
        catch (IOException e) {
            throw new IllegalStateException(this.$("ERROR_trace_file_init", new Object[0]), e);
        }
    }

    protected abstract Path getOutputDirectory();

    protected List<String> collectEntries(String[] input) {
        return this.collectEntries(input, false);
    }

    protected List<String> collectEntries(String[] input, boolean lowerCase) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != input && input.length > 0) {
            for (String s : input) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                if (!s.contains("-") && lowerCase) {
                    s = StringUtils.getHyphenatedName((String)s);
                }
                list.add(lowerCase ? s.toLowerCase(Locale.ENGLISH) : s);
            }
        }
        return list;
    }
}

