/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;

public class CustomDefinition {
    public static final DefinitionType INLINE_DEFINITION = DefinitionType.INLINE;
    public static final AttributeInclusion INCLUDING_ATTRIBUTES = AttributeInclusion.YES;
    public static final AttributeInclusion EXCLUDING_ATTRIBUTES = AttributeInclusion.NO;
    private final ObjectNode value;
    private final DefinitionType definitionType;
    private final AttributeInclusion attributeInclusion;

    public CustomDefinition(ObjectNode value) {
        this(value, DefinitionType.STANDARD, AttributeInclusion.YES);
    }

    public CustomDefinition(ObjectNode value, boolean meantToBeInline) {
        this(value, meantToBeInline ? DefinitionType.INLINE : DefinitionType.STANDARD, AttributeInclusion.YES);
    }

    public CustomDefinition(ObjectNode value, DefinitionType definitionType, AttributeInclusion attributeInclusion) {
        this.value = value;
        this.definitionType = definitionType;
        this.attributeInclusion = attributeInclusion;
    }

    public ObjectNode getValue() {
        return this.value;
    }

    public DefinitionType getDefinitionType() {
        return this.definitionType;
    }

    public final boolean isMeantToBeInline() {
        return this.definitionType == DefinitionType.INLINE;
    }

    public final boolean shouldAlwaysProduceDefinition() {
        return this.definitionType == DefinitionType.ALWAYS_REF;
    }

    public AttributeInclusion getAttributeInclusion() {
        return this.attributeInclusion;
    }

    public boolean shouldIncludeAttributes() {
        return this.attributeInclusion == AttributeInclusion.YES;
    }

    public static enum AttributeInclusion {
        YES,
        NO;

    }

    public static enum DefinitionType {
        INLINE,
        STANDARD,
        ALWAYS_REF;

    }
}

