/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.JlinkAssembler;
import org.jreleaser.model.api.catalog.swid.SwidTag;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractJavaAssembler;
import org.jreleaser.model.internal.catalog.swid.SwidTagAware;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.ArchiveOptions;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.EnabledAware;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class JlinkAssembler
extends AbstractJavaAssembler<JlinkAssembler, org.jreleaser.model.api.assemble.JlinkAssembler>
implements SwidTagAware,
MatrixAware {
    private static final long serialVersionUID = -2723965471823676369L;
    private final Set<org.jreleaser.model.internal.common.Artifact> targetJdks = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final Set<String> moduleNames = new LinkedHashSet<String>();
    private final Set<String> additionalModuleNames = new LinkedHashSet<String>();
    private final List<String> args = new ArrayList<String>();
    private final org.jreleaser.model.internal.common.Artifact jdk = new org.jreleaser.model.internal.common.Artifact();
    private final Jdeps jdeps = new Jdeps();
    private final ArchiveOptions options = new ArchiveOptions();
    private final JavaArchive javaArchive = new JavaArchive();
    private final Matrix matrix = new Matrix();
    private final org.jreleaser.model.internal.common.Artifact targetJdkPattern = new org.jreleaser.model.internal.common.Artifact();
    private String imageName;
    private String imageNameTransform;
    private Archive.Format archiveFormat;
    private Boolean copyJars;
    private Boolean applyDefaultMatrix;
    @JsonIgnore
    private final org.jreleaser.model.api.assemble.JlinkAssembler immutable = new org.jreleaser.model.api.assemble.JlinkAssembler(){
        private static final long serialVersionUID = -1451343134953991242L;
        private Set<? extends Artifact> artifacts;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;
        private List<? extends Glob> jars;
        private List<? extends Glob> files;
        private Set<? extends Artifact> targetJdks;

        public JlinkAssembler.Jdeps getJdeps() {
            return JlinkAssembler.this.jdeps.asImmutable();
        }

        public Artifact getJdk() {
            return JlinkAssembler.this.jdk.asImmutable();
        }

        public String getImageName() {
            return JlinkAssembler.this.imageName;
        }

        public String getImageNameTransform() {
            return JlinkAssembler.this.imageNameTransform;
        }

        public Archive.Format getArchiveFormat() {
            return JlinkAssembler.this.archiveFormat;
        }

        public org.jreleaser.model.api.common.ArchiveOptions getOptions() {
            return JlinkAssembler.this.options.asImmutable();
        }

        public Set<? extends Artifact> getTargetJdks() {
            if (null == this.targetJdks) {
                this.targetJdks = JlinkAssembler.this.targetJdks.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.targetJdks;
        }

        public boolean isApplyDefaultMatrix() {
            return JlinkAssembler.this.isApplyDefaultMatrix();
        }

        public org.jreleaser.model.api.common.Matrix getMatrix() {
            return JlinkAssembler.this.matrix.asImmutable();
        }

        public Artifact getTargetJdkPattern() {
            return JlinkAssembler.this.targetJdkPattern.asImmutable();
        }

        public Set<String> getModuleNames() {
            return Collections.unmodifiableSet(JlinkAssembler.this.moduleNames);
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(JlinkAssembler.this.args);
        }

        public boolean isCopyJars() {
            return JlinkAssembler.this.isCopyJars();
        }

        public JlinkAssembler.JavaArchive getJavaArchive() {
            return JlinkAssembler.this.getJavaArchive().asImmutable();
        }

        public String getExecutable() {
            return JlinkAssembler.this.getExecutable();
        }

        public String getTemplateDirectory() {
            return JlinkAssembler.this.getTemplateDirectory();
        }

        public Set<String> getSkipTemplates() {
            return Collections.unmodifiableSet(JlinkAssembler.this.getSkipTemplates());
        }

        public Java getJava() {
            return JlinkAssembler.this.getJava().asImmutable();
        }

        public Artifact getMainJar() {
            return JlinkAssembler.this.getMainJar().asImmutable();
        }

        public List<? extends Glob> getJars() {
            if (null == this.jars) {
                this.jars = JlinkAssembler.this.getJars().stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.jars;
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = JlinkAssembler.this.getArtifacts().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends Glob> getFiles() {
            if (null == this.files) {
                this.files = JlinkAssembler.this.getFiles().stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Platform getPlatform() {
            return JlinkAssembler.this.getPlatform().asImmutable();
        }

        public SwidTag getSwid() {
            return JlinkAssembler.this.getSwid().asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return JlinkAssembler.this.getDistributionType();
        }

        public String getType() {
            return JlinkAssembler.this.getType();
        }

        public Stereotype getStereotype() {
            return JlinkAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return JlinkAssembler.this.isExported();
        }

        public String getName() {
            return JlinkAssembler.this.getName();
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = JlinkAssembler.this.getFileSets().stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = JlinkAssembler.this.getOutputs().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return JlinkAssembler.this.getActive();
        }

        public boolean isEnabled() {
            return JlinkAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JlinkAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return JlinkAssembler.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(JlinkAssembler.this.getExtraProperties());
        }
    };

    public JlinkAssembler() {
        super("jlink");
    }

    @Override
    public org.jreleaser.model.api.assemble.JlinkAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.JLINK;
    }

    @Override
    public void merge(JlinkAssembler source) {
        super.merge(source);
        this.imageName = this.merge(this.imageName, source.imageName);
        this.imageNameTransform = this.merge(this.imageNameTransform, source.imageNameTransform);
        this.archiveFormat = this.merge(this.archiveFormat, source.archiveFormat);
        this.copyJars = this.merge(this.copyJars, source.copyJars);
        this.applyDefaultMatrix = this.merge(this.applyDefaultMatrix, source.applyDefaultMatrix);
        this.setJavaArchive(source.javaArchive);
        this.setOptions(source.options);
        this.setJdeps(source.jdeps);
        this.setJdk(source.jdk);
        this.setTargetJdks(this.merge(this.targetJdks, source.targetJdks));
        this.setModuleNames(this.merge(this.moduleNames, source.moduleNames));
        this.setAdditionalModuleNames(this.merge(this.additionalModuleNames, source.additionalModuleNames));
        this.setArgs(this.merge(this.args, source.args));
        this.setMatrix(source.matrix);
        this.setTargetJdkPattern(source.targetJdkPattern);
    }

    public String getResolvedImageName(JReleaserContext context) {
        TemplateContext props = context.getModel().props(context);
        props.setAll(this.props(context));
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.imageName, (TemplateContext)props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        TemplateContext props = context.getModel().props(context);
        props.setAll(this.props(context));
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.imageNameTransform, (TemplateContext)props);
    }

    public Jdeps getJdeps() {
        return this.jdeps;
    }

    public void setJdeps(Jdeps jdeps) {
        this.jdeps.merge(jdeps);
    }

    public org.jreleaser.model.internal.common.Artifact getJdk() {
        return this.jdk;
    }

    public void setJdk(org.jreleaser.model.internal.common.Artifact jdk) {
        this.jdk.merge(jdk);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Archive.Format getArchiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(Archive.Format archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = Archive.Format.of((String)archiveFormat);
    }

    public ArchiveOptions getOptions() {
        return this.options;
    }

    public void setOptions(ArchiveOptions options) {
        this.options.merge(options);
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getTargetJdks() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.targetJdks);
    }

    public void setTargetJdks(Set<org.jreleaser.model.internal.common.Artifact> targetJdks) {
        this.targetJdks.clear();
        this.targetJdks.addAll(targetJdks);
    }

    public void addTargetJdk(org.jreleaser.model.internal.common.Artifact jdk) {
        if (null != jdk) {
            this.targetJdks.add(jdk);
        }
    }

    @Override
    public boolean isApplyDefaultMatrixSet() {
        return null != this.applyDefaultMatrix;
    }

    @Override
    public boolean isApplyDefaultMatrix() {
        return null != this.applyDefaultMatrix && this.applyDefaultMatrix != false;
    }

    @Override
    public void setApplyDefaultMatrix(Boolean applyDefaultMatrix) {
        this.applyDefaultMatrix = applyDefaultMatrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix.merge(matrix);
    }

    public org.jreleaser.model.internal.common.Artifact getTargetJdkPattern() {
        return this.targetJdkPattern;
    }

    public void setTargetJdkPattern(org.jreleaser.model.internal.common.Artifact artifactPattern) {
        this.targetJdkPattern.merge(artifactPattern);
    }

    public Set<String> getModuleNames() {
        return this.moduleNames;
    }

    public void setModuleNames(Set<String> moduleNames) {
        this.moduleNames.clear();
        this.moduleNames.addAll(moduleNames);
    }

    public Set<String> getAdditionalModuleNames() {
        return this.additionalModuleNames;
    }

    public void setAdditionalModuleNames(Set<String> additionalModuleNames) {
        this.additionalModuleNames.clear();
        this.additionalModuleNames.addAll(additionalModuleNames);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public boolean isCopyJars() {
        return null == this.copyJars || this.copyJars != false;
    }

    public void setCopyJars(Boolean copyJars) {
        this.copyJars = copyJars;
    }

    public boolean isCopyJarsSet() {
        return null != this.copyJars;
    }

    public JavaArchive getJavaArchive() {
        return this.javaArchive;
    }

    public void setJavaArchive(JavaArchive javaArchive) {
        this.javaArchive.merge(javaArchive);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("archiveFormat", this.archiveFormat);
        props.put("options", this.options.asMap(full));
        props.put("moduleNames", this.moduleNames);
        props.put("additionalModuleNames", this.additionalModuleNames);
        props.put("args", this.args);
        props.put("jdeps", this.jdeps.asMap(full));
        if (this.javaArchive.isSet()) {
            props.put("javaArchive", this.javaArchive.asMap(full));
        }
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact targetJdk : this.getTargetJdks()) {
            mappedJdks.put("jdk " + i++, targetJdk.asMap(full));
        }
        props.put("applyDefaultMatrix", this.isApplyDefaultMatrix());
        this.matrix.asMap(props);
        props.put("targetJdkPattern", this.targetJdkPattern.asMap(full));
        props.put("jdk", this.jdk.asMap(full));
        props.put("targetJdks", mappedJdks);
        props.put("copyJars", this.isCopyJars());
    }

    public static final class Jdeps
    extends AbstractModelObject<Jdeps>
    implements Domain,
    EnabledAware {
        private static final long serialVersionUID = 2752412877591717403L;
        private final Set<String> targets = new LinkedHashSet<String>();
        private String multiRelease;
        private Boolean ignoreMissingDeps;
        private Boolean useWildcardInPath;
        private Boolean enabled;
        @JsonIgnore
        private final JlinkAssembler.Jdeps immutable = new JlinkAssembler.Jdeps(){
            private static final long serialVersionUID = -6727485936574423582L;

            public String getMultiRelease() {
                return multiRelease;
            }

            public boolean isIgnoreMissingDeps() {
                return this.isIgnoreMissingDeps();
            }

            public boolean isUseWildcardInPath() {
                return this.isUseWildcardInPath();
            }

            public Set<String> getTargets() {
                return Collections.unmodifiableSet(targets);
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }
        };

        public JlinkAssembler.Jdeps asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Jdeps source) {
            this.multiRelease = this.merge(this.multiRelease, source.multiRelease);
            this.ignoreMissingDeps = this.merge(this.ignoreMissingDeps, source.ignoreMissingDeps);
            this.useWildcardInPath = this.merge(this.useWildcardInPath, source.useWildcardInPath);
            this.enabled = this.merge(this.enabled, source.enabled);
            this.setTargets(this.merge(this.targets, source.targets));
        }

        public String getMultiRelease() {
            return this.multiRelease;
        }

        public void setMultiRelease(String multiRelease) {
            this.multiRelease = multiRelease;
        }

        public boolean isIgnoreMissingDeps() {
            return null != this.ignoreMissingDeps && this.ignoreMissingDeps != false;
        }

        public void setIgnoreMissingDeps(Boolean ignoreMissingDeps) {
            this.ignoreMissingDeps = ignoreMissingDeps;
        }

        public boolean isIgnoreMissingDepsSet() {
            return null != this.ignoreMissingDeps;
        }

        public boolean isUseWildcardInPath() {
            return null == this.useWildcardInPath || this.useWildcardInPath != false;
        }

        public void setUseWildcardInPath(Boolean useWildcardInPath) {
            this.useWildcardInPath = useWildcardInPath;
        }

        public boolean isUseWildcardInPathSet() {
            return null != this.useWildcardInPath;
        }

        public Set<String> getTargets() {
            return this.targets;
        }

        public void setTargets(Set<String> targets) {
            this.targets.clear();
            this.targets.addAll(targets);
        }

        @Override
        public boolean isEnabled() {
            return null != this.enabled && this.enabled != false;
        }

        @Override
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean isEnabledSet() {
            return null != this.enabled;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("multiRelease", this.multiRelease);
            props.put("ignoreMissingDeps", this.isIgnoreMissingDeps());
            props.put("useWildcardInPath", this.isUseWildcardInPath());
            props.put("targets", this.targets);
            return props;
        }
    }

    public static final class JavaArchive
    extends AbstractModelObject<JavaArchive>
    implements Domain {
        private static final long serialVersionUID = -9036487748517901046L;
        private String path;
        private String mainJarName;
        private String libDirectoryName;
        @JsonIgnore
        private final JlinkAssembler.JavaArchive immutable = new JlinkAssembler.JavaArchive(){
            private static final long serialVersionUID = 2914047534822441167L;

            public String getPath() {
                return path;
            }

            public String getMainJarName() {
                return mainJarName;
            }

            public String getLibDirectoryName() {
                return libDirectoryName;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public JlinkAssembler.JavaArchive asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(JavaArchive source) {
            this.path = this.merge(this.path, source.path);
            this.mainJarName = this.merge(this.mainJarName, source.mainJarName);
            this.libDirectoryName = this.merge(this.libDirectoryName, source.libDirectoryName);
        }

        public boolean isSet() {
            return StringUtils.isNotBlank((String)this.path);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getMainJarName() {
            return this.mainJarName;
        }

        public void setMainJarName(String mainJarName) {
            this.mainJarName = mainJarName;
        }

        public String getLibDirectoryName() {
            return this.libDirectoryName;
        }

        public void setLibDirectoryName(String libDirectoryName) {
            this.libDirectoryName = libDirectoryName;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("path", this.path);
            props.put("mainJarName", this.mainJarName);
            props.put("libDirectoryName", this.libDirectoryName);
            return props;
        }
    }
}

