/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.common;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Http;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Http;
import org.jreleaser.util.StringUtils;

public final class HttpDelegate
extends AbstractModelObject<HttpDelegate>
implements Http,
Serializable {
    private static final long serialVersionUID = 4594339452100983408L;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String username;
    private String password;
    private Http.Method method;
    private Http.Authorization authorization;

    @Override
    public void merge(HttpDelegate source) {
        this.username = this.merge(this.username, source.getUsername());
        this.password = this.merge(this.password, source.getPassword());
        this.authorization = this.merge(this.authorization, source.getAuthorization());
        this.method = this.merge(this.method, source.getMethod());
        this.setHeaders(this.merge(this.headers, source.headers));
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public Http.Method getMethod() {
        return this.method;
    }

    public void setMethod(Http.Method method) {
        this.method = method;
    }

    public void setMethod(String method) {
        this.method = Http.Method.of((String)method);
    }

    public Http.Authorization getAuthorization() {
        return this.authorization;
    }

    @Override
    public void setAuthorization(Http.Authorization authorization) {
        this.authorization = authorization;
    }

    @Override
    public void setAuthorization(String authorization) {
        this.authorization = Http.Authorization.of((String)authorization);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public void asMap(Map<String, Object> props) {
        props.put("authorization", this.authorization);
        props.put("username", StringUtils.isNotBlank((String)this.username) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        props.put("method", this.method);
        props.put("headers", this.headers);
    }

    @Override
    public Http.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = Http.Authorization.NONE;
        }
        return this.authorization;
    }
}

