/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.GoogleChatAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GoogleChatAnnouncerValidator {
    private static final String DEFAULT_GOOGLE_CHAT_TPL = "src/jreleaser/templates/googleChat.tpl";

    private GoogleChatAnnouncerValidator() {
    }

    public static void validateGoogleChat(JReleaserContext context, GoogleChatAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.googleChat");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.google.chat", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.google.chat.webhook", "GOOGLE_CHAT_WEBHOOK"}), "announce.googleChat.webhook", announcer.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_GOOGLE_CHAT_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_GOOGLE_CHAT_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"googleChat.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

