/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.S3Uploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class S3UploaderValidator {
    private S3UploaderValidator() {
    }

    public static void validateS3(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, S3Uploader> s3 = context.getModel().getUpload().getS3();
        if (!s3.isEmpty()) {
            context.getLogger().debug("upload.s3");
        }
        for (Map.Entry<String, S3Uploader> e : s3.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            Errors incoming = new Errors();
            S3UploaderValidator.validateS3(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }

    private static void validateS3(JReleaserContext context, S3Uploader uploader, Errors errors) {
        context.getLogger().debug("upload.s3.{}", new Object[]{uploader.getName()});
        Validator.resolveActivatable(context, (Activatable)uploader, CollectionUtils.listOf((Object[])new String[]{"upload.s3." + uploader.getName(), "upload.s3"}), "NEVER");
        if (!uploader.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(uploader.isArtifacts() || uploader.isFiles() || uploader.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{uploader.getType(), uploader.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            uploader.disable();
            return;
        }
        String baseKey1 = "upload.s3." + uploader.getName();
        String baseKey2 = "upload.s3";
        String baseKey3 = "s3." + uploader.getName();
        String baseKey4 = "s3";
        uploader.setRegion(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".region", baseKey2 + ".region", baseKey3 + ".region", baseKey4 + ".region"}), baseKey1 + ".region", uploader.getRegion(), errors));
        uploader.setBucket(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".bucket", baseKey2 + ".bucket", baseKey3 + ".bucket", baseKey4 + ".bucket"}), baseKey1 + ".bucket", uploader.getBucket(), errors));
        uploader.setAccessKeyId(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".access.key.id", baseKey2 + ".access.key.id", baseKey3 + ".access.key.id", baseKey4 + ".access.key.id"}), baseKey1 + ".accessKeyId", uploader.getAccessKeyId(), uploader.getAccessKeyId()));
        uploader.setSecretKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".secret.key", baseKey2 + ".secret.key", baseKey3 + ".secret.key", baseKey4 + ".secret.key"}), baseKey1 + ".secretKey", uploader.getSecretKey(), uploader.getSecretKey()));
        uploader.setSessionToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".session.token", baseKey2 + ".session.token", baseKey3 + ".session.token", baseKey4 + ".session.token"}), baseKey1 + ".sessionToken", uploader.getSessionToken(), uploader.getSessionToken()));
        uploader.setPath(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".path", baseKey2 + ".path", baseKey3 + ".path", baseKey4 + ".path"}), baseKey1 + ".path", uploader.getPath(), "{{projectName}}/{{tagName}}/{{artifactFile}}"));
        uploader.setDownloadUrl(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".download.url", baseKey2 + ".download.url", baseKey3 + ".download.url", baseKey4 + ".download.url"}), baseKey1 + ".downloadUrl", uploader.getDownloadUrl(), uploader.getDownloadUrl()));
        uploader.setEndpoint(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".endpoint", baseKey2 + ".endpoint", baseKey3 + ".endpoint", baseKey4 + ".endpoint"}), baseKey1 + "endpoint", uploader.getEndpoint(), ""));
        if (StringUtils.isNotBlank((String)uploader.getEndpoint()) && StringUtils.isBlank((String)uploader.getDownloadUrl())) {
            errors.configuration(RB.$((String)"validation_s3_missing_download_url", (Object[])new Object[]{baseKey1}));
        }
        Validator.validateTimeout(uploader);
    }
}

