/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="assemble")
public class Assemble
extends AbstractPlatformAwareModelCommand<Main> {
    @CommandLine.ArgGroup
    Composite composite;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-s", "--assembler", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xs", "--exclude-assembler", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-d", "--distribution", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xd", "--exclude-distribution", "1.5.0"));
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        if (null != this.composite) {
            context.setIncludedAssemblers(this.collectEntries(this.composite.includedAssemblers(), true));
            context.setIncludedDistributions(this.collectEntries(this.composite.includedDistributions()));
            context.setExcludedAssemblers(this.collectEntries(this.composite.excludedAssemblers(), true));
            context.setExcludedDistributions(this.collectEntries(this.composite.excludedDistributions()));
        }
        Workflows.assemble((JReleaserContext)context).execute();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        return JReleaserContext.Mode.ASSEMBLE;
    }

    @Override
    protected JReleaserCommand getCommand() {
        return JReleaserCommand.ASSEMBLE;
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="include.filter.header")
        Include include;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="exclude.filter.header")
        Exclude exclude;

        Composite() {
        }

        String[] includedAssemblers() {
            return null != this.include ? this.include.includedAssemblers : null;
        }

        String[] includedDistributions() {
            return null != this.include ? this.include.includedDistributions : null;
        }

        String[] excludedAssemblers() {
            return null != this.exclude ? this.exclude.excludedAssemblers : null;
        }

        String[] excludedDistributions() {
            return null != this.exclude ? this.exclude.excludedDistributions : null;
        }
    }

    static class Exclude {
        @CommandLine.Option(names={"-xs", "--exclude-assembler"}, paramLabel="<assembler>")
        String[] excludedAssemblers;
        @CommandLine.Option(names={"-xd", "--exclude-distribution"}, paramLabel="<distribution>")
        String[] excludedDistributions;

        Exclude() {
        }
    }

    static class Include {
        @CommandLine.Option(names={"-s", "--assembler"}, paramLabel="<assembler>")
        String[] includedAssemblers;
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>")
        String[] includedDistributions;

        Include() {
        }
    }
}

